var parobj = window.parent;
var neid = parobj.neid;
var serviceIndex = parobj.serviceIndex;
var serviceTag = parobj.serviceTag;
var confporttab;
var btnRightArr = new Object();
var applybtnRight = TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_UNI;
var querybtnRight = TECMDCODE_IPPTN_ETHSRV_GET_ELAN_V_UNI;
var unibtnRight = TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_UNI;
var nnibtnRight = TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_NNI;
var createFlag = true;
var getporttype;
var orgPorts = "";
var orgportArr = new Array();

/**********************************
 * init the page
************************************/
function init()
{
	serviceIndex = parobj.serviceIndex;
	serviceTag = parobj.serviceTag;

	initTable();
  initButtonInfo();
  handleButtonStatus();
  $("totalrow").innerHTML = RESOURCE["totalrow"];
  $("selrow").innerHTML = RESOURCE["selectedrow"];
}

function tabSelectHandler()
{
	if(btnRightArr.querybtn.right && parobj.selectedRows && parobj.selectedRows.length > 0)
	{
		query();
	}
	else
	{
		adjustTableLayout(confporttab, window.tableconf[0]);
	}
}

/**********************************
 * button status depends on parobj
************************************/
function handleButtonStatus()
{
	if(parobj.st.getSelectedRowCount()==0)
	{
		$("unibtn").disabled = true;
		$("nnibtn").disabled = true;
		$("querybtn").disabled = true;
		$("applybtn").disabled = true;
	}
	else
	{
		$("unibtn").disabled = false;
		$("querybtn").disabled = false;
	}
}

/**********************************
 * init the table
************************************/
function initTable()
{
	confporttab = new SortTable();
  confporttab.head.setAttribute("id", "htmlTable_STHead_frameElanMain");
  confporttab.body.setAttribute("id", "htmlTable_STBody_frameElanMain");
  confporttab.setImage("../../../../../../images/");
  confporttab.isUsedForSelectList = true;
  createTableHead(confporttab, window.tableconf[0]);
  confporttab.setBodyHeight("170px");
  confporttab.setOnRowSelectHandler(rowSelectHandler);
  confporttab.setOnCellEditHandler(cellEditHandler);
  $("confporttable").appendChild(confporttab.getTable());
  $("confporttable").oncontextmenu=popupMenuHandler;
}

function cellEditHandler(param)
{
	var editRow = param.rowindex;
    var colid = param.colid;
	if(colid == "encapType" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var slotid = confporttab.getCellStoreValue(editRow,"slotid","slotid");
		var encapTypeEdit = confporttab.getCellEdit(editRow, "encapType");
		if(slotid == "65535")
		{
			encapTypeEdit.clearOptions();
			encapTypeEdit.addOption(encaptype[1], "1");
			encapTypeEdit.addOption(encaptype[2], "2");
		}
		else if(encapTypeEdit.element.options.length < 3)
		{
			encapTypeEdit.clearOptions();
			encapTypeEdit.addOption(encaptype[0], "0");
			encapTypeEdit.addOption(encaptype[1], "1");
			encapTypeEdit.addOption(encaptype[2], "2");
		}
	}
	if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function rowSelectHandler()
{
	selectedRows = confporttab.getSelectedRows();
	if (selectedRows.length <= 0)
  {
    $("selrownum").innerHTML = 0;
    return;
  }
  $("selrownum").innerHTML = selectedRows.length;	
}

/**********************************
 * init the button info
************************************/
function initButtonInfo()
{
  $("unibtn").value = RESOURCE["getuniport"];
  $("nnibtn").value = RESOURCE["getnniport"];
  $("querybtn").value = RESOURCE["querybtn"];
  $("applybtn").value = RESOURCE["applybtn"];
	$("nnibtn").disabled = true;
	       
  if(serviceTag == tagType_SAwared)
  {
    $("nnibtn").disabled = false;
    btnRightArr.nnibtn = new BtnRightObj("nnibtn",nnibtnRight);
  }
  else
  {
  	$("nnibtn").disabled = true;
  }       	
  
  btnRightArr.unibtn = new BtnRightObj("unibtn",unibtnRight);    
  btnRightArr.querybtn = new BtnRightObj("querybtn",querybtnRight);
  btnRightArr.applybtn = new BtnRightObj("applybtn",applybtnRight);
      
  getRightInfo(parobj, btnRightArr);
  initrightbtn(btnRightArr);
}

/*********************************************************
 * query the service uni/nni info and the port attribute
**********************************************************/
function query()
{
	if (!parobj.st || parobj.st.getDataRowLength().lengh <= 0 || undefined == neid)
	{
		if(parobj != null &&  parobj.removeWaitStatus != undefined )
		{
		   parobj.removeWaitStatus();
		}
		confporttab.clearTableData();
		return;
	}
	
	serviceIndex = parobj.serviceIndex;
    serviceTag = parobj.serviceTag;
	
  var xml = createQueryXML();
  $("querybtn").disabled = true;
  $("applybtn").disabled = true;
  if(isDemo)
	{
  	loadXMLdoc("vuni.xml", "POST", false, queryHandBack, null);
  }
  else
  {
    var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETHSRV_GET_ELAN_V_UNI+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+parobj.obj["nmUser"];
    loadXMLdoc(URL,"POST",false,queryHandBack,null,"inputdata="+xml);
  }
}

function createQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = new tagElement("row-params");
    var param = new tagElement("param");    
    param.setAttribute("name", "block");
    param.setAttribute("value", "queryRes");
    secondlevel.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    secondlevel.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name", "ethType");
    param.setAttribute("value", "2");//(1:e-line 2:e-lan)
    secondlevel.appendChild(param);
    firstlevel.appendChild(secondlevel);
    
    createVuniXML(firstlevel);
    createVnniXML(firstlevel);
    if(serviceTag == tagType_SAwared)
    {
    	createPBVuniXML(firstlevel);
    }
    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function createVuniXML(firstlevel)
{
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
      
    thirdlevel.setAttribute("name", "block");
    thirdlevel.setAttribute("value", "NSCMD_SERVICE_GET_ETHVUNI_EX");
    secondlevel.appendChild(thirdlevel);   
    
    thirdlevel = new tagElement("param");    
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","ethType");
    thirdlevel.setAttribute("value","2");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","serviceIndex");
    thirdlevel.setAttribute("value",parobj.serviceIndex);
    secondlevel.appendChild(thirdlevel);
        
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","vuniID");
    thirdlevel.setAttribute("value","0");
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
}

function createVnniXML(firstlevel)
{
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
      
    thirdlevel.setAttribute("name", "block");
    thirdlevel.setAttribute("value", "NSCMD_SERVICE_GET_EVNNI_EX");
    secondlevel.appendChild(thirdlevel);   
    
    thirdlevel = new tagElement("param");    
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","ethType");
    thirdlevel.setAttribute("value","2");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","serviceIndex");
    thirdlevel.setAttribute("value",parobj.serviceIndex);
    secondlevel.appendChild(thirdlevel);
        
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","vnniID");
    thirdlevel.setAttribute("value","0");
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
}

function createPBVuniXML(firstlevel)
{
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
    
    thirdlevel.setAttribute("name", "block");
    thirdlevel.setAttribute("value", "NSCMD_CFG_SERVICE_GET_ETHPBVUNI_EX");
    secondlevel.appendChild(thirdlevel);
  
    thirdlevel = new tagElement("param");    
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","ethType");
    thirdlevel.setAttribute("value","2");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","serviceIndex");
    thirdlevel.setAttribute("value",parobj.serviceIndex);
    secondlevel.appendChild(thirdlevel);
        
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","vuniID");
    thirdlevel.setAttribute("value","0");
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
}

function queryHandBack(doc)
{
	if(parobj != null &&  parobj.removeWaitStatus != undefined)
	{
		parobj.removeWaitStatus();
	}
	
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("applybtn").disabled = true;
    var data = EncapsulateData(doc);
    showErrorDialog(data);    
    if (data.getSErrorCode() < 2) 
    {       
    	initTableCol(data); 
    }
    
    for (var i=0,len=confporttab.getDataRowLength();i<len;i++)
    {
    	var tag = confporttab.getCellStoreValue(i,"tag","tag");
    	if (tag == "255")
    	{
    		confporttab.setCellIsEdit(confporttab.getCell(i,"tag"),"0");
    	}
		if (tag == "1")
		{
			var cell = confporttab.getCell(i, "vlanID");
			confporttab.setCellIsEdit(cell, 0);
			confporttab.setCellValue(cell, "vlanID", "-");
			cell.element.showElement.element.innerHTML = "-";
		}

		var slotID = confporttab.getCellStoreValue(i, "portname", "slotid");
		var portID = confporttab.getCellStoreValue(i, "portid", "portid");
		if( slotID == "65535" )	//      
		{
			var cellShow = confporttab.getCellShow(i, "portname");
			cellShow.setValue("NMS-1");
			confporttab.setCellIsEdit(confporttab.getCell(i, "tag"), 0);
		}
		
		if( confporttab.getCellStoreValue(i, "portEnable", "portEnable") == null || confporttab.getCellStoreValue(i, "portEnable", "portEnable") == "" )
		{
			confporttab.setCellEdit(i, "portEnable", false);
			confporttab.getCellShow(i, "portEnable").setValue("-");
		}
		
		if( confporttab.getCellStoreValue(i, "workMode", "workMode") == null || confporttab.getCellStoreValue(i, "workMode", "workMode") == "" )
		{
			confporttab.setCellEdit(i, "workMode", false);
			confporttab.getCellShow(i, "workMode").setValue("-");
		}
    }
    
    handleButtonStatus();
}

/*********************************************************
 * modify the service uni/nni info and the port attribute
**********************************************************/
function apply()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
        
    createModVuniXML(bussinessNode);
    root.getRoot().appendChild(bussinessNode);
    var xml = root.toString();
    if (null == xml) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&timestamp="+new Date().getTime()+"&nmUser="+parobj.obj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackApply, null, "inputdata=" + xml);
}

function createModVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");    
    var cmdcode;  
    var rowindx = 0;  
    for(var i = 0,len = confporttab.getDataRowLength();i<len;i++)
    {   
    	if(confporttab.getModify(i))
    	{
	    	
	    	
	        rowParams = new tagElement("row-params");         
	        var param = null;
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "neid");
	        param.setAttribute("value", neid);
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "slotid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"slotid","slotid"));
	        rowParams.appendChild(param);
	       
	        param = new tagElement("param");
	        param.setAttribute("name", "subslotid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"subslotid","subslotid"));
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "portid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"portid","portid"));
	        rowParams.appendChild(param);
	        
			param = new tagElement("param");
	        param.setAttribute("name", "port");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"portid","portid"));
	        rowParams.appendChild(param);
	        
	        
	        if(confporttab.getCellModify(i,"workMode"))
	        {
	          param = new tagElement("param");
	          param.setAttribute("name", "workMode");
	          param.setAttribute("value", confporttab.getCellStoreValue(i,"workMode","workMode"));
	          rowParams.appendChild(param);   
	        }
	        
	        if(confporttab.getCellModify(i,"encapType"))
	        {
	          param = new tagElement("param");
	          param.setAttribute("name", "encapType");
	          param.setAttribute("value", confporttab.getCellStoreValue(i,"encapType","encapType"));
	          rowParams.appendChild(param);  
	        }
	        if(confporttab.getCellModify(i,"tag"))
	        {
	          param = new tagElement("param");
	          param.setAttribute("name", "tag");
	          param.setAttribute("value", confporttab.getCellStoreValue(i,"tag","tag"));
	          rowParams.appendChild(param);
	        }
			var vlanID = confporttab.getCellStoreValue(i, "vlanID", "vlanID");
            if (confporttab.getCellModify(i, "vlanID") && vlanID != "-") 
            {
                param = new tagElement("param");
                param.setAttribute("name", "vlanID");
                param.setAttribute("value", vlanID);
                rowParams.appendChild(param);
				
                param = new tagElement("param");
                param.setAttribute("name", "vlanPri");
				var vlanPri = confporttab.getCellStoreValue(i, "vlanPri", "vlanPri");
				if(isNaN(vlanPri))
				{
					vlanPri = 0;//Vlan      0 
				}
                param.setAttribute("value", vlanPri);
                rowParams.appendChild(param);
            }
	        bussinessNode.appendChild(rowParams);
	        
    	}
    }  
}


function createModPBVUniXML(bussinessNode)
{
	var rowParams = new tagElement("row-params");    
    var cmdcode;  
    var rowindx = 0;  
    for(var i = 0,len = confporttab.getDataRowLength();i<len;i++)
    {   
    	if(confporttab.getModify(i))
    	{  
	    	var porttype = confporttab.getCellStoreValue(i,"porttype","porttype");
	    	if(!(porttype == portType_Pbuni || porttype == portType_Pbsuni))
			{
				 continue;
			}
	    	
	        rowParams = new tagElement("row-params");         
	        var param = null;
	        if(rowindx == 0)
	        {       
	        	cmdcode = "NSCMD_CFG_SERVICE_ADD_ETHPBVUNI_EX";
			    param = new tagElement("param");
			    param.setAttribute("name", "block");
			    param.setAttribute("value", cmdcode); 
			    rowParams.appendChild(param);
	        }
	        rowindx++;
	        param = new tagElement("param");
	        param.setAttribute("name", "autoServiceIndex");
	        param.setAttribute("value", "0");
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "serviceIndex");
	        param.setAttribute("value", parobj.serviceIndex);
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "autoVuniID");
	        param.setAttribute("value", "0");
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "vuniID");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"vuniID","vuniID"));
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "role");
	        param.setAttribute("value","1");
	        rowParams.appendChild(param);
	       
	        param = new tagElement("param");
	        param.setAttribute("name", "slotid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"slotid","slotid"));
	        rowParams.appendChild(param);
	       
	        param = new tagElement("param");
	        param.setAttribute("name", "subslotid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"subslotid","subslotid"));
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "portid");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"portid","portid"));
	        rowParams.appendChild(param);
	       
	        var svlan = confporttab.getCellStoreValue(i,"svlan","svlan");
	        param = new tagElement("param");
	        param.setAttribute("name", "svlan");
	        param.setAttribute("value", svlan == undefined ? 0 : svlan);
	        rowParams.appendChild(param);
	       
	        var tagNum,tagID;
	        if(confporttab.getCellStoreValue(i,"tagID","tagID") != undefined)
	        {
	        	tagNum = confporttab.getCellStoreValue(i,"tagID","tagID").split(",").length;
	        	tagID = confporttab.getCellStoreValue(i,"tagID","tagID");
	        }
	        else
	        {
	        	tagNum = 0;
	        	tagID = 0;
	        }
	        param = new tagElement("param");
	        param.setAttribute("name", "tagNum");
	        param.setAttribute("value", tagNum);
	        rowParams.appendChild(param);           
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "tagID");
	        param.setAttribute("value", tagID);
	        rowParams.appendChild(param);     
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "portEnable");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"portEnable","portEnable"));
	        rowParams.appendChild(param);   
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "workMode");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"workMode","workMode"));
	        rowParams.appendChild(param);   
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "encapType");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"encapType","encapType"));
	        rowParams.appendChild(param);  
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "tag");
	        param.setAttribute("value", confporttab.getCellStoreValue(i,"tag","tag"));
            rowParams.appendChild(param);
			
			var vlanID = confporttab.getCellStoreValue(i, "vlanID", "vlanID");
			if (vlanID != "-")
			{
				param = new tagElement("param");
            	param.setAttribute("name", "vlanID");
            	param.setAttribute("value", vlanID);
            	rowParams.appendChild(param);
				
				param = new tagElement("param");
            	param.setAttribute("name", "vlanPri");
            	param.setAttribute("value", confporttab.getCellStoreValue(i, "vlanPri", "vlanPri"));
            	rowParams.appendChild(param);
			}
	        
	       bussinessNode.appendChild(rowParams);
    	}
    }    
}

function handleBackApply(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode()< 2) 
    {        
        refreshTableState(confporttab, window.tableconf[0], data);
    }
    else
    {
    	$("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

/*********************************************
 * open the page for config service uni port 
**********************************************/
function configuni()
{
		getporttype = "uni";
    xshowModalDialog("../elan/portselect.html?title=getuniport", RESOURCE["portselect"], 750, 450, "../../../../../images/");	
}

/*********************************************
 * open the page for config service uni port 
**********************************************/
function confignni()
{
    getporttype = "nni";
    xshowModalDialog("../elan/portselect.html?title=getnniport", RESOURCE["portselect"], 750, 450, "../../../../../images/");
}

/*********************************************
 * adjust table layout by service tagtype 
**********************************************/
function initTableCol(data)
{
	serviceTag = parobj.serviceTag;
    if(serviceTag == tagType_SAwared)
    {
        window.tableconf[0].colArray[9].width = "10%";
        confporttab.clearTableData();
        confporttab.deleteHeadRow();
        createTableHead(confporttab, window.tableconf[0]);        
        confporttab.getHeadCell("svlan").setValue("S-VLAN");
	    confporttab.getHeadCell("tagID").setValue("C-VLAN");
	    $("nnibtn").disabled = false;      
	    
	    var indexArray = getBlockDataIndex(data,"NSCMD_SERVICE_GET_ETHVUNI_EX");
	    for(var i=0,size=indexArray.length;i<size;i++)
	    {
	    	data.rows[indexArray[i]].svlan = data.rows[indexArray[i]].tagID;
	    	data.rows[indexArray[i]].porttype.value = "5";
	    }  
    }
    else
    {
    	window.tableconf[0].colArray[9].width = 0;
    	confporttab.clearTableData();
        confporttab.deleteHeadRow();
        createTableHead(confporttab, window.tableconf[0]);
	    confporttab.getHeadCell("tagID").setValue("VLAN");
	    $("nnibtn").disabled = true;
    }
    createTableBody(confporttab, window.tableconf[0], data, RESOURCE);
    initportparas();
    $("totalrownum").innerHTML = confporttab.getDataRowLength();
    $("selrownum").innerHTML = 0;
}

/*********************************************
 * adjust table layout by service tagtype 
**********************************************/
function initportparas()
{
    var portObj,logicInf,logportid,portid,port,cvlan,svlan,porttype,boardname;
	parobj.curselportlist.length = 0;
    for(var i = 0,len = confporttab.getDataRowLength();i<len;i++)
    {
    	 logportid = confporttab.getCellStoreValue(i,"vuniID","vuniID");
	     portid = confporttab.getCellStoreValue(i,"portid","portid");
	     port = confporttab.element.datarows[i].element.cols["portname"].element.innerText; 
	     cvlan = confporttab.getCellStoreValue(i,"tagID","tagID"); 
	     svlan = confporttab.getCellStoreValue(i,"svlan","svlan"); 
	     porttype = confporttab.getCellStoreValue(i,"porttype","porttype");
	     slotid = confporttab.getCellStoreValue(i,"slotid","slotid");
	     boardname = slotid+"-"+ confporttab.getCellStoreValue(i,"boardName","boardName");
        revertEncapType(confporttab, i);
        confporttab.getCellEdit(i, "encapType").element.onchange = encapTypeEvent;
		confporttab.getCellEdit(i, "tag").element.onchange = changeTag;
		textCheck(confporttab.getCellEdit(i, "vlanID").element, "1", "4094");
        if (boardname.indexOf("IF") >= 0 || boardname.indexOf("EFP8") >= 0
        	|| boardname.indexOf("EMS6") >= 0|| boardname.indexOf("IS") >= 0
			|| SpecialAttrMgr.isCPSupport(neid,slotid,"TE_FUNC_MSTP_CFG_ETHER_ELAN","ELAN_ATTR_NOTSUPPORT_PORTENABLEWORKMODE")) 
        {
            var cell = confporttab.getCell(i, "portEnable");
            confporttab.setCellValue(cell, i, "-");
            cell.element.ondblclick = null;
            confporttab.setAtomValue(cell.element.showElement, "-");
            cell.element.style.backgroundColor = "";
            cell.element.modify = false;
            
            cell = confporttab.getCell(i, "workMode");
            confporttab.setCellValue(cell, i, "-");
            cell.element.ondblclick = null;
            confporttab.setAtomValue(cell.element.showElement, "-");
            cell.element.style.backgroundColor = "";
            cell.element.modify = false;
        }
        
 		 var tmpPortName = port;

 		 if( cvlan == null && svlan == null )
 		 {
 			tmpPortName = port;
 		 }
 		 else if( cvlan == null && svlan != null )
 		 {
 			tmpPortName = port + "[" + svlan + "]";
 		 }
 		 else if( cvlan != null && svlan == null )
 		 {
 			tmpPortName = port + "[" + cvlan + "]"; 
 		 }
 		 else if( cvlan != null && svlan != null )
 		 {
 			tmpPortName = port + "[" + svlan + "]"; 
 		 }
 		 
	     portObj = new portAttr(logportid,portid,tmpPortName,porttype,cvlan,svlan,boardname,slotid);
	     parobj.curselportlist.push(portObj);
	     logicInf = new VlanLogicInf();
        logicInf.slotid = logportid;
        logicInf.portid = portid;
	     orgportArr.push(logicInf);
	     if(i == 0)
         { 
        	orgPorts = logportid;
         }
         else
         {
        	orgPorts = orgPorts + "|" + logportid;
         }
         var tagidCell = confporttab.getCell(i,"tagID","tagID")
         var svlanCell = confporttab.getCell(i,"svlan","svlan")
         confporttab.setCellIsEdit(tagidCell,0);
         confporttab.setCellIsEdit(svlanCell,0);
         
         if(confporttab.getCellStoreValue(i,"porttype","porttype")==portType_Pbuni
            || confporttab.getCellStoreValue(i,"porttype","porttype")==portType_Pbnni)
         {
                	confporttab.getCellShow(i,"tagID").setValue("-")
         }
         if(serviceTag == tagType_TagTrans)
         {
         	confporttab.getCellShow(i,"tagID").setValue("-");
         }
   }   
   
}
function clearTableDataFunc()
{
	if(confporttab != null)
	{
		confporttab.clearTableData();
	}
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = di.getBErrLength(); i < len; i++)
      {
    	   errorObj = di.getError().rowErrors[i].errorObj;
    	   errorObj["operationObj"] = RESOURCE["serviceID"]+":"+parobj.serviceID;
      }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}  


function encapTypeEvent()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    revertEncapType(confporttab, rowindex, this.value);
}

function revertEncapType(st, rowindex, value)
{
    var encapType = st.getCellStoreValue(rowindex, "encapType", "encapType");
    if (typeof(value) != "undefined" && value != null) 
    {
        encapType = value;
    }
    
    var tagidCell = st.getCell(rowindex, "tag");
	var vlanIDCell = st.getCell(rowindex, "vlanID");
    if (encapType == "1")//802.1Q
    {
        if (tagidCell.element.isEdit != "1") 
        {
            st.setCellIsEdit(tagidCell, "1");
            st.setCellValue(tagidCell, "tag", "1");
            st.getCellShow(rowindex, "tag").setValue("Tag Aware");
			
			st.setCellIsEdit(vlanIDCell, "0");
            st.setCellValue(vlanIDCell, "vlanID", "-");
            st.getCellShow(rowindex, "vlanID").setValue("-");
        }
    }
    else if (encapType == "0")//none
    {
        if (tagidCell.element.isEdit != "0") 
        {
            st.setCellIsEdit(tagidCell, "0");
        }
        st.setCellValue(tagidCell, "-");
        st.getCellShow(rowindex, "tag").setValue("-");
			
		st.setCellIsEdit(vlanIDCell, "0");
        st.setCellValue(vlanIDCell, "vlanID", "-");
        st.getCellShow(rowindex, "vlanID").setValue("-");
    }
    else 
    {
        if (tagidCell.element.isEdit != "0") 
        {
            st.setCellIsEdit(tagidCell, "0");
        }
        st.setCellValue(tagidCell, "1");
        st.getCellShow(rowindex, "tag").setValue("Tag Aware");
			
		st.setCellIsEdit(vlanIDCell, "0");
        st.setCellValue(vlanIDCell, "vlanID", "-");
        st.getCellShow(rowindex, "vlanID").setValue("-");
    }
}

function changeTag()
{
	var rowindex = this.parentNode.parentNode.rowIndex;
	var vlanIDCell = confporttab.getCell(rowindex, "vlanID");
	if (this.value == "1")
	{
		confporttab.setCellIsEdit(vlanIDCell, "0");
        confporttab.setCellValue(vlanIDCell, "vlanID", "-");
        confporttab.getCellShow(rowindex, "vlanID").setValue("-");
	}
	else
	{
		if (vlanIDCell.element.isEdit == "0")
		{
			confporttab.setCellIsEdit(vlanIDCell, "1");
        	confporttab.setCellValue(vlanIDCell, "vlanID", "1");
        	confporttab.getCellShow(rowindex, "vlanID").setValue("1");
		}
	}
}

function getExsitBoardPort(type)
{
    var exicstBoardport = [];
    for (var i = 0, size = confporttab.getDataRowLength(); i < size; i++) 
    {
        var porttype = confporttab.getCellStoreValue(i, "porttype", "porttype");
        var slotid = confporttab.getCellStoreValue(i, "slotid", "slotid");
        var portid = confporttab.getCellStoreValue(i, "portid", "portid");
        var portname = confporttab.getCellStoreValue(i, "portname", "portname");
        if ((type == "nni" && porttype != "5") ||
        (type == "uni" && porttype == "5")) 
        {
            exicstBoardport[exicstBoardport.length] = new exicstBoardPort(slotid, portid, portname);
        }
    }
    return exicstBoardport;
}

function exicstBoardPort(slot, port, pname)
{
    this.slotid = slot;
    this.portid = port;
    this.portname = pname;
}
