
var parobj = getParentWindow();
var neid = parobj.neid;
var elanattrTable;
var portTab, qosTab, splitTab;
var uniPorts;
var createFlag;
var serviceTag, getporttype;
var servIDAutoFlag, serviceID, serviceName, bpduVal, macEnable, macLearnMode;
var serviceIndex = 60000;
var curselportlist = new Array();
var selportlist = new Array(), portreslist = new Array();
var bIsValidateVlanID = true;

var MAX_TAG_NUM = 1024;

var PORTTYPE_NNI = "5";
var InvalidParam = -1;
/**********************************
 * init the page
 ************************************/
function init()
{
    initTabs();
    initAttrTable();
    initParasTable();
    initBtn();
}

/**********************************
 * init the guide page
 ************************************/
function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("firststep", RESOURCE["firststep"], $("firststep"));
    tab.addEmbedTab("secondstep", RESOURCE["secondtstep"], $("secondstep"));
    
    setSelectedEmbedTab("firststep");
    $("embedtab").appendChild(tab.getEmbedTabs());
}
/*
function embedTabSelectHandler(id)
{
	if("secondstep" == id)
	{
	}
}
*/

function refreshSplit()
{
    var selRows = splitTab.getDataRowLength();
	if (splitTab.getDataRowLength() <= 0) 
    {
        $("deletebtn").disabled = true;
		return;
    }
    for (var i = 0; i < selRows; i++) 
    {
        splitTab.deleteRow(i);
    }
    splitTab.adjustDataRows();
}

/**********************************
 * init the guide function
 ************************************/
function abortFunc()
{
    window.close();
}

/**********************************
 * init the guide function
 ************************************/
function nextFunc()
{
    serviceID = elanattrTable.getAttrValue("serviceId");
    serviceName = elanattrTable.getAttrValue("serviceName");
    serviceTag = elanattrTable.getAttrValue("tagType");
    bpduVal = elanattrTable.getAttrValue("bpdu");
    macEnable = elanattrTable.getAttrValue("selfLearnMac");
    macLearnMode = elanattrTable.getAttrValue("selfLearnMode");
    
    if (checkboxElem.checked) 
    {
        servIDAutoFlag = "0";
    }
    return true;
}

/**********************************
 * init the guide function
 ************************************/
function finishFunc()
{
    doCreateElan();
}

/**********************************
 * init service attribute table
 ************************************/
function initAttrTable()
{
    elanattrTable = new CTable();
    elanattrTable.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_serviceIdElanCreate");
    checkText(atom.element, "1", "4294967294");
    elanattrTable.addAttrRow("serviceId", RESOURCE["serviceID"], atom);
    elanattrTable.setAttrValue("serviceId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    checkboxElem.disabled = "disabled";
    checkboxElem.style.display = "none"; //     AUTO,  ,       
    elanattrTable.getAtom("serviceId").element.style.width = "50%";
    elanattrTable.getAtom("serviceId").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    span.style.display = "none";//     AUTO,  ,       
    elanattrTable.getAtom("serviceId").element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_serviceNameElanCreate");
    atom.element.onkeydown = function()
    {
        calStrSinoLen(this, 64);
    }
    elanattrTable.addAttrRow("serviceName", RESOURCE["serviceName"], atom);
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_bpduCreate");
    elanattrTable.addAttrRow("bpdu", "BPDU", atom);
    atom.element.options.add(new Option(RESOURCE["nottransparent"], "0"));
    atom.element.options.add(new Option(RESOURCE["transparentbpdu"], "1"));
    atom.element.disabled = true;
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_tagTypeElanCreate");
    elanattrTable.addAttrRow("tagType", RESOURCE["tagType"], atom);
    atom.element.options.add(new Option("C-Awared", "1"));
    atom.element.options.add(new Option("S-Awared", "2"));
    atom.element.options.add(new Option("Tag-Transparent", "0"));
    $("getnnibtn").disabled = true;
    serviceTag = tagType_CAwared;
    
    atom.element["onchange"] = function()
    {
        if (portTab.getDataRowLength() > 0) 
        {
            var confirmed = confirm(RESOURCE["changTagType"]);
            if (!confirmed) 
            {
                this.value = serviceTag;
                return;
            }
        }
        var selectvalue = this.value;
        portTab.clearTableData();
        portTab.deleteHeadRow();
        
        var macElm = elanattrTable.getAtom("selfLearnMode").element;
        if (selectvalue == tagType_SAwared || selectvalue == tagType_CAwared) 
        {
            macElm.selectedIndex = 0;
        }
        else 
        {
            macElm.selectedIndex = 1;
        }
        
        if (selectvalue == tagType_SAwared) 
        {
            window.tableconf[0].colArray[9].width = "10%";
            createTableHead(portTab, window.tableconf[0]);
            portTab.getHeadCell("svlan").setValue("S-VLAN");
            portTab.getHeadCell("tagID").setValue("C-VLAN");
            /*
             elanattrTable.getAtom("selfLearnMac").element.options.add(new Option("-", "255"));
             elanattrTable.getAtom("selfLearnMac").element.disabled = true;
             elanattrTable.setAttrValue("selfLearnMac", "255");
             
             elanattrTable.getAtom("selfLearnMode").element.options.add(new Option("-", "255"));
             elanattrTable.getAtom("selfLearnMode").element.disabled = true;
             elanattrTable.setAttrValue("selfLearnMode", "255");
             */
            $("getnnibtn").disabled = false;
        }
        else 
        {
            $("getnnibtn").disabled = true;
            
            window.tableconf[0].colArray[9].width = 0;
            createTableHead(portTab, window.tableconf[0]);
            portTab.getHeadCell("tagID").setValue("VLAN");
            
            /*
             removeItemFromSelct(elanattrTable.getAtom("selfLearnMac").element,"255");
             removeItemFromSelct(elanattrTable.getAtom("selfLearnMode").element,"255");
             
             if(selectvalue == tagType_CAwared)
             {
             elanattrTable.getAtom("selfLearnMac").element.disabled = false;
             elanattrTable.getAtom("selfLearnMode").element.disabled = false;
             elanattrTable.setAttrValue("selfLearnMac", "1");
             elanattrTable.setAttrValue("selfLearnMode", "2");
             }
             else
             {
             elanattrTable.getAtom("selfLearnMac").element.disabled = false;
             elanattrTable.getAtom("selfLearnMode").element.disabled = false;
             elanattrTable.setAttrValue("selfLearnMac", "0");
             elanattrTable.setAttrValue("selfLearnMode", "1");
             }*/
        }
        serviceTag = selectvalue;
    }
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_selfLearnMacElanCreate");
    elanattrTable.addAttrRow("selfLearnMac", RESOURCE["selfLearnMac"], atom);
    atom.element.options.add(new Option(RESOURCE["Enabled"], "1"));
    atom.element.options.add(new Option(RESOURCE["Disabled"], "0"));
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_selfLearnModeElanCreate");
    elanattrTable.addAttrRow("selfLearnMode", RESOURCE["selfLearnMode"], atom);
    atom.element.options.add(new Option("IVL", "2"));
    atom.element.options.add(new Option("SVL", "1"));
    atom.element.disabled = true;
    $("ethattrcontainer").appendChild(elanattrTable.getTable());
}

function handleCheckbox()
{
    var atomserviceId = elanattrTable.getAtom("serviceId").element;
    if (checkboxElem.checked) 
    {
        atomserviceId.disabled = true;
        atomserviceId.value = "";
    }
    else 
    {
        atomserviceId.disabled = false;
        atomserviceId.value = "1";
    }
}

/****************
 * init tabs
 *****************/
function initParasTable()
{
    portTab = new SortTable();
    portTab.head.setAttribute("id", "htmlTable_STHead_portattrElanCreate");
    portTab.body.setAttribute("id", "htmlTable_STBody_portattrElanCreate");
    portTab.setImage("../../../../../../images/");
    portTab.isUsedForSelectList = true;
    window.tableconf[0].colArray[9].width = 0;
    createTableHead(portTab, window.tableconf[0]);
    portTab.setOnCellEditHandler(cellEditHandler);
    portTab.setBodyHeight("190px");
    $("portattrtable").appendChild(portTab.getTable());
    $("portattrtable").oncontextmenu = popupMenuHandler;
    
    $(splithgroup).innerText = RESOURCE["crtsplit"];
    splitTab = new SortTable();
    splitTab.head.setAttribute("id", "htmlTable_STHead_splitElanCreate");
    splitTab.body.setAttribute("id", "htmlTable_STBody_splitElanCreate");
    splitTab.setImage("../../../../../../images/");
    splitTab.isUsedForSelectList = true;
    createTableHead(splitTab, window.tableconf[1]);
    splitTab.setBodyHeight("120px");
    splitTab.setOnRowSelectHandler(rowSelectHandler);
    $("splitTab").appendChild(splitTab.getTable());
    $("splitTab").disabled = true;
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    
    $(qosconfig).innerText = RESOURCE["qosconf"];
    qosTab = new SortTable();
    qosTab.head.setAttribute("id", "htmlTable_STHead_qosElanCreate");
    qosTab.body.setAttribute("id", "htmlTable_STBody_qosElanCreate");
    qosTab.setImage("../../../../../images/");
    qosTab.isUsedForSelectList = true;
    createTableHead(qosTab, window.tableconf[2]);
    qosTab.setBodyHeight("120px");
    $("qostable").appendChild(qosTab.getTable());
    $("qostable").disabled = true;
}

function cellEditHandler(param)
{
    var editRow = param.rowindex;
    var colid = param.colid;
    var portType = portTab.getCellStoreValue(editRow, "porttype", "porttype");
    var svlanEditElement = portTab.getCellEdit(editRow, "svlan").element;
    if (portType == PORTTYPE_NNI) 
    {
        svlanEditElement["onblur"] = cellonblur;
        svlanEditElement["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        }
    }
    else 
    {
        textCheck(svlanEditElement, MIN_VLANID, MAX_VLANID);
    }
}

function rowSelectHandler()
{
    selectedRows = splitTab.getSelectedRows();
    if (selectedRows.length <= 0) 
    {
        $("deletebtn").disabled = true;
        return;
    }
    $("deletebtn").disabled = false;
}

/**********************************
 * init button info
 ************************************/
function initBtn()
{
    $("splithgroup").innerText = RESOURCE["splitgroupcfg"];
    $("qosconfig").innerText = RESOURCE["qoscfg"];
    $("getunibtn").value = RESOURCE["getuniport"];
    $("getnnibtn").value = RESOURCE["getnniport"];
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("getunibtn").disable = true;
    $("getnnibtn").disable = true;
}

/******************************************
 * control the split horizen group action
 *******************************************/
function selectSplitCheckBox()
{
    var element = $("splithgid");
    if (element.checked) 
    {
        $("createbtn").disabled = false;
        $("splitTab").disabled = false
        if (splitTab.getDataRowLength() > 0) 
        {
            $("deletebtn").disabled = false;
        }
    }
    else 
    {
        $("splitTab").disabled = true;
        $("createbtn").disabled = true;
    }
}

/**********************************
 *  control the qos action
 ************************************/
function selectQoscfgCheckBox()
{
    var element = $("qosconfigid");
    if (element.checked) 
    {
        $("qostable").style.disable = false;
        initQoSTable();
    }
    else 
    {
        $("qostable").style.disable = true;
    }
}

/*********************************************
 * open the page for seting service uni port
 **********************************************/
function getUniPort()
{
    createFlag = false;
    getporttype = "uni";
    xshowModalDialog("../elan/portselect.html?title=getuniport", RESOURCE["portselect"], 750, 450, "../../../../../images/");
}

/*********************************************
 * open the page for seting service nni port
 **********************************************/
function getNniPort()
{
    createFlag = false;
    getporttype = "nni";
    xshowModalDialog("../elan/portselect.html?title=getnniport", RESOURCE["portselect"], 750, 450, "../../../../../images/");
}

/*********************************************
 * open the page for seting service nni port
 **********************************************/
function initportparas()
{
    var portObj, logportid, portid, port, cvlan, svlan, porttype, boardname;
    curselportlist.length = 0;
    for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
    {
        logportid = portTab.getCellStoreValue(i, "vuniID", "vuniID");
        portid = portTab.getCellStoreValue(i, "portid", "portid");
        port = portTab.element.datarows[i].element.cols["portname"].element.innerText;
        cvlan = portTab.getCellStoreValue(i, "tagID", "tagID");
        svlan = portTab.getCellStoreValue(i, "svlan", "svlan");
        porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
        boardname = portTab.getCellStoreValue(i, "slotid", "slotid") + "-" + portTab.getCellStoreValue(i, "boardName", "boardName");
        
        /*
         * IF and EFP8 NOT support
         */
        if (!isSupportWorkModeBoard(boardname)) 
        {
            var cell = portTab.getCell(i, "portEnable");
            portTab.setCellValue(cell, i, "-");
            cell.element.ondblclick = null;
            portTab.setAtomValue(cell.element.showElement, "-");
            cell.element.style.backgroundColor = "";
            cell.element.modify = false;
            
            cell = portTab.getCell(i, "workMode");
            portTab.setCellValue(cell, i, "-");
            cell.element.ondblclick = null;
            portTab.setAtomValue(cell.element.showElement, "-");
            cell.element.style.backgroundColor = "";
            cell.element.modify = false;
        }
        portObj = new portAttr(logportid, portid, port, porttype, cvlan, svlan, boardname);
        curselportlist.push(portObj);
    }
}

function adjustTableEnable()
{
    for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
    {
        if (portTab.getCellStoreValue(i, "workMode", "workMode") == "-") 
        {
            portTab.setCellIsEdit(portTab.getCell(i, "workMode"), "0");
        }
    }
}

/*********************************************
 * init port res
 **********************************************/
function setPortResList()
{
    var tempstr;
    var flag = true;
    for (var j = 0, unilen = curselportlist.length; j < unilen; j++) 
    {
        flag = true;
        tempstr = curselportlist[j];
        for (var l = 0, sellen = selportlist.length; l < sellen; l++) 
        {
            if (tempstr.logicportid == selportlist[l].logicportid) 
            {
                flag = false;
                break;
            }
        }
        if (flag) 
        {
            portreslist.push(tempstr);
        }
    }
}

function processportdata()
{
    var portObj, aport, porttype, logportid;
    selportlist = new Array();
    
    for (var k = 0, len = splitTab.getDataRowLength(); k < len; k++) 
    {
        var portdata = splitTab.getCellStoreValue(k, "portdata", "portdata");
        
        var portdatas = portdata.split("|");
        portdisatr = "";
        for (var j = 0; j < portdatas.length; j++) 
        {
            if (portdatas[j] == "") 
            {
                continue;
            }
            var aport = portdatas[j].split(",");
            var porttype = aport[1];
            var logportid = aport[2];
            for (var i = 0; i < curselportlist.length; i++) 
            {
                if (curselportlist[i].logicportid == logportid) 
                {
                    portObj = curselportlist[i];
                    portdisatr = portdisatr + "," + curselportlist[i].portname;
                    break;
                }
            }
            selportlist.push(portObj);
        }
    }
}

/***********************************************
 * open the page for create split horizen group
 ************************************************/
function createSplit()
{
    createFlag = false;
    portreslist = new Array();
    processportdata();
    setPortResList();
    xshowModalDialog("../elan/splitcreate.html", 450, 650, "../../../../../../images/");
}

function deleteSplit()
{
    var selRows = splitTab.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        splitTab.deleteRow(selRows[i]);
    }
    splitTab.adjustDataRows();
    
    if (splitTab.getDataRowLength() <= 0) 
    {
        $("deletebtn").disabled = true;
    }
}

/***********************************************
 * init qos, not support
 ************************************************/
function initQoSTable()
{
    var len = portTab.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (portTab.getCellStoreValue(i, "porttype", "porttype") == "1")//v-uni
        {
        }
    }
}

/**
 *          
 */
function validateInputParma()
{
    if (servIDAutoFlag != 0) 
    {
        var serviceid = elanattrTable.getAttrValue("serviceId");
        if (typeof(serviceid) == "undefined" || serviceid == "") 
        {
            alert(RESOURCE["inputserviceid"]);
            return InvalidParam;
        }
    }
    var serviceName = elanattrTable.getAttrValue("serviceName");
    if (typeof(serviceName) == "undefined" || serviceName == "") 
    {
        alert(RESOURCE["inputServiceName"]);
        return InvalidParam;
    }
    
}

/**
 *      TRANSV1R5-1152 
 *     f00177546
 *         SAwared    UNI   CVlan   vlan      NNI         1024 
 *                 
 * @return
 */
function validateVlans()
{
	var tagNum = 0;
	 for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
	  {
	        var porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
	        if (serviceTag == tagType_SAwared) 
	        {
	        	var cvlan = portTab.getCellStoreValue(i, "tagID", "tagID");
	            if (porttype == portType_Pbsuni) 
	            {	            	
	            	var tagList = getTagListData(cvlan);	            	
	            	tagNum += tagList[0] ;
	            }
	            else
	            {
	            	tagNum += 1 ;
	            }
	        }	        
	      
	   }	
	return (tagNum > MAX_TAG_NUM) ? false : true;
}

/***********************************************
 * create elan service
 ************************************************/
function doCreateElan()
{
    if (!nextFunc()) 
    {
        setSelectedEmbedTab("firststep");
        return;
    }
    
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    bIsValidateVlanID = true;
    if (validateInputParma() == InvalidParam) 
    {
        return;
    }
    createEthXML(bussinessNode);
    createEthMACXML(bussinessNode);
    createVuniXML(bussinessNode);
    
    if (serviceTag == tagType_SAwared) 
    {
        createPBVUniXML(bussinessNode);
    }
    if (!bIsValidateVlanID) 
    {
        return;
    }
    createSplitXML(bussinessNode);
    createQosXML(bussinessNode);
    root.getRoot().appendChild(bussinessNode);
    var xml = root.toString();
    
    var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_CREATE_ELAN + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(URL, "POST", false, createHandBack, null, "inputdata=" + xml);
}

function createHandBack(doc)
{
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    if (0 == errorCode) 
    {
        splitTab.clearTableData();
        if (elanattrTable.getAttrValue("tagType") == "2") 
        {
            window.setTimeout(delayQueryService, 2000);
        }
        else 
        {
            window.setTimeout(delayQueryService, 500);
        }
        
    }
    else 
    {
        showErrorDialog(data);
        return;
    }
}

function delayQueryService()
{
    parobj.queryService(fillPortTable());
    window.close();
}

/**
 *               
 */
function fillPortTable()
{
    var dataInterface = new DataInterface();
    var ptag = null;
    var obj = null;
    
    for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
    {
        obj = new Object();
        
        var boardName = portTab.getCellStoreValue(i, "slotid", "slotid") + "-" +
        portTab.getCellStoreValue(i, "boardName", "boardName") +
        "-" +
        portTab.getCellStoreValue(i, "portname", "portname");
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "boardName", "boardName");
        obj["boardName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "portname", "portname");
        obj["portname"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "slotid", "slotid");
        obj["slotid"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = "255";
        obj["subslotid"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "portid", "portid");
        obj["portid"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "porttype", "porttype");
        obj["porttype"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "tagID", "tagID");
        obj["tagID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "svlan", "svlan");
        obj["svlan"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "portEnable", "portEnable");
        obj["portEnable"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "workMode", "workMode");
        obj["workMode"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "encapType", "encapType");
        obj["encapType"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portTab.getCellStoreValue(i, "tag", "tag");
        obj["tag"] = ptag;
        
        dataInterface.rows.append(obj);
    }
    
    return dataInterface;
}

function createEthXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "NSCMD_SERVICE_CRT_ETHSERV");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "autoServiceIndex");
    param.setAttribute("value", "1");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceIndex");
    param.setAttribute("value", serviceIndex);
    rowParams.appendChild(param);
    
    var serviceID = elanattrTable.getAttrValue("serviceId");
    if (servIDAutoFlag == "0") 
    {
        serviceID = 0;
    }
    param = new tagElement("param");
    param.setAttribute("name", "serviceID");
    param.setAttribute("value", serviceID);
    rowParams.appendChild(param);
    
    var serviceName = elanattrTable.getAttrValue("serviceName");
    param = new tagElement("param");
    param.setAttribute("name", "serviceName");
    param.setAttribute("value", serviceName);
    rowParams.appendChild(param);
    
    var bpdu = elanattrTable.getAttrValue("bpdu");
    param = new tagElement("param");
    param.setAttribute("name", "bpdu");
    param.setAttribute("value", bpdu);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ethType");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    var ethtagType = elanattrTable.getAttrValue("tagType");
    param = new tagElement("param");
    param.setAttribute("name", "tagtype");
    param.setAttribute("value", ethtagType);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
}


function createEthMACXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "NSCMD_SERVICE_SET_ELANMACLRNPARA");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "autoServiceIndex");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceIndex");
    param.setAttribute("value", serviceIndex);
    rowParams.appendChild(param);
    
    var ethtagType = elanattrTable.getAttrValue("tagType");
    param = new tagElement("param");
    param.setAttribute("name", "tagtype");
    param.setAttribute("value", ethtagType);
    rowParams.appendChild(param);
    
    var macenable = elanattrTable.getAttrValue("selfLearnMac");
    param = new tagElement("param");
    param.setAttribute("name", "macsfln");
    if (macenable == "255") 
    {
        macenable = "1"//Default Value:Enable
    }
    param.setAttribute("value", macenable);
    rowParams.appendChild(param);
    
    var macLearnMode = elanattrTable.getAttrValue("selfLearnMode");
    param = new tagElement("param");
    param.setAttribute("name", "macsflntype");
    if (macLearnMode == "255") 
    {
        macLearnMode = "2"//Default Value:IVL
    }
    param.setAttribute("value", macLearnMode);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
}

/***********************************************
 * PB elan nni port and common elan uni port
 ************************************************/
function createVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
    for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
    {
        var porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
        var boardname = portTab.getCellStoreValue(i, "boardName", "boardName");
        var workMode = portTab.getCellStoreValue(i, "workMode", "workMode");
        var portEnable = portTab.getCellStoreValue(i, "portEnable", "portEnable");
        if (!isSupportWorkModeBoard(boardname)) 
        {
            workMode = "-";
            portEnable = "-";
        }
        
        if (serviceTag == tagType_SAwared) 
        {
            if (porttype != portType_Pbnni) 
            {
                continue;
            }
        }
        else 
        {
            if (porttype != portType_Uni) 
            {
                continue;
            }
        }
        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_ADD_ETHVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "2");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", portTab.getCellStoreValue(i, "vuniID", "vuniID"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "slotid", "slotid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "subslotid", "subslotid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "portid", "portid"));
        rowParams.appendChild(param);
        
		param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portTab.getCellStoreValue(i, "portid", "portid"));
        rowParams.appendChild(param);
		
        var tagNum, tagID;
        if (serviceTag == tagType_SAwared) 
        {
            tagID = portTab.getCellStoreValue(i, "svlan", "svlan");
        }
        else 
        {
            tagID = portTab.getCellStoreValue(i, "tagID", "tagID");
        }
        
        if (tagID == undefined) 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        var tagIDDataArr = getTagListData(tagID);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portEnable");
        param.setAttribute("value", portEnable);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "workMode");
        param.setAttribute("value", workMode);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "encapType");
        param.setAttribute("value", portTab.getCellStoreValue(i, "encapType", "encapType"));
        rowParams.appendChild(param);
        
        if( portTab.getCellStoreValue(i, "slotid", "slotid") != "65535" )
        {
	        param = new tagElement("param");
	        param.setAttribute("name", "tag");
	        param.setAttribute("value", portTab.getCellStoreValue(i, "tag", "tag"));
	        rowParams.appendChild(param);
        }
        
        var vlanID = portTab.getCellStoreValue(i, "vlanID", "vlanID");
        if (vlanID != "-") 
        {
            param = new tagElement("param");
            param.setAttribute("name", "vlanID");
            param.setAttribute("value", vlanID);
            rowParams.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "vlanPri");
			var vlanPri = isNaN(portTab.getCellStoreValue(i, "vlanPri", "vlanPri"))?"0":portTab.getCellStoreValue(i, "vlanPri", "vlanPri");
            param.setAttribute("value", vlanPri);
            rowParams.appendChild(param);
        }
        bussinessNode.appendChild(rowParams);
    }
}

/***********************************************
 * PB elan uni port
 ************************************************/
function createPBVUniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
    for (var i = 0, len = portTab.getDataRowLength(); i < len; i++) 
    {
        var porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
        if (!(porttype == portType_Pbuni || porttype == portType_Pbsuni)) 
        {
            continue;
        }
        var boardname = portTab.getCellStoreValue(i, "boardName", "boardName");
        var workMode = portTab.getCellStoreValue(i, "workMode", "workMode");
        var portEnable = portTab.getCellStoreValue(i, "portEnable", "portEnable");
        if (!isSupportWorkModeBoard(boardname)) 
        {
            workMode = "-";
            portEnable = "-";
        }
        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_CFG_SERVICE_ADD_ETHPBVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "2");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", portTab.getCellStoreValue(i, "vuniID", "vuniID"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "slotid", "slotid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "subslotid", "subslotid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", portTab.getCellStoreValue(i, "portid", "portid"));
        rowParams.appendChild(param);
        
        /**
         *     f00177546
         *                                   
         *  
         */
		param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portTab.getCellStoreValue(i, "portid", "portid"));
        rowParams.appendChild(param);
        
        var svlan = portTab.getCellStoreValue(i, "svlan", "svlan");
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", svlan == undefined ? 0 : svlan);
        rowParams.appendChild(param);
        
        var tagNum, tagID;
        if (portTab.getCellStoreValue(i, "tagID", "tagID") != undefined &&
        portTab.getCellStoreValue(i, "tagID", "tagID") != "-" &&
        portTab.getCellStoreValue(i, "tagID", "tagID") != "") 
        {
            tagNum = portTab.getCellStoreValue(i, "tagID", "tagID").split(",").length;
            tagID = portTab.getCellStoreValue(i, "tagID", "tagID");
        }
        else 
        {
            tagNum = 0;
            tagID = 0;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        var tagIDDataArr = getTagListData(tagID);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portEnable");
        param.setAttribute("value", portEnable);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "workMode");
        param.setAttribute("value", workMode);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "encapType");
        param.setAttribute("value", portTab.getCellStoreValue(i, "encapType", "encapType"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", portTab.getCellStoreValue(i, "tag", "tag"));
        rowParams.appendChild(param);
        
        var vlanID = portTab.getCellStoreValue(i, "vlanID", "vlanID");
        if (vlanID != "-") 
        {
            param = new tagElement("param");
            param.setAttribute("name", "vlanID");
            param.setAttribute("value", vlanID);
            rowParams.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "vlanPri");
            param.setAttribute("value", portTab.getCellStoreValue(i, "vlanPri", "vlanPri"));
            rowParams.appendChild(param);
        }
        
        bussinessNode.appendChild(rowParams);
    }
}

function createSplitXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
	var length =  splitTab.getDataRowLength();
	var element = document.getElementById("splithgid");
	if(!element.checked)
	{
		length =0;
	}
	        
    for(var i = 0,len = length;i<len;i++)
    {
        rowParams = new tagElement("row-params");
        var param = null;
        
        if (i == 0) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", "NSCMD_SERVICE_CRT_ELANSPLITHRIGRP");
            rowParams.appendChild(param);
        }
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "2");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "splitidflag");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "splitid");
        param.setAttribute("value", splitTab.getCellStoreValue(i, "splitid", "splitid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portNumber");
        param.setAttribute("value", splitTab.getCellStoreValue(i, "portNumber", "portNumber"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portdata");
        param.setAttribute("value", splitTab.getCellStoreValue(i, "portdata", "portdata"));
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
}

/***********************************************
 * not support this version
 ************************************************/
function createQosXML(bussinessNode)
{

}

function createTableFunc(dinterface)
{
    for (var i = 0; i < portTab.getDataRowLength(); i++) 
    {
        if (serviceTag == tagType_SAwared) 
        {
            if (getporttype == "uni") 
            {
                if (portTab.getCellStoreValue(i, "porttype", "porttype") == "3" || portTab.getCellStoreValue(i, "porttype", "porttype") == "4") 
                {
                    portTab.deleteRow(i);
                }
            }
            else 
            {
                if (portTab.getCellStoreValue(i, "porttype", "porttype") == "5") 
                {
                    portTab.deleteRow(i);
                }
            }
        }
        else 
        {
            if (portTab.getCellStoreValue(i, "porttype", "porttype") == "1") 
            {
                portTab.deleteRow(i);
            }
        }
    }
    portTab.adjustDataRows();
    createTableBody(portTab, window.tableconf[0], dinterface, RESOURCE);
    
    for (var i = 0, size = portTab.getDataRowLength(); i < size; i++) 
    {
    	var tSlotID = portTab.getCellStoreValue(i, "slotid", "slotid");
        var porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
        var cvlancell = portTab.getCell(i, "tagID");
        var encaptypecell = portTab.getCell(i, "encapType");
        revertEncapType(portTab, i);
        tagEvent(i, portTab.getCellStoreValue(i, "tag", "tag"));
        portTab.getCellEdit(i, "encapType").element.onchange = encapTypeEvent;
        portTab.getCellEdit(i, "tag").element.onchange = changeTag;
        textCheck(portTab.getCellEdit(i, "vlanID").element, "1", "4094");
        if (serviceTag == tagType_SAwared) 
        {
            if (porttype == portType_Pbuni || porttype == portType_Pbnni) 
            {
                portTab.setCellIsEdit(cvlancell, 0);
            }
        }
        
        cell = portTab.getCell(i, "tagID");
        cell.element.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        }
        
        cell = portTab.getCell(i, "svlan");
        textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
        
        if (serviceTag == tagType_TagTrans) 
        {
            portTab.setCellIsEdit(cvlancell, 0);
        }
        
        if( tSlotID == "65535" )
        {
        	portTab.setCellIsEdit( portTab.getCell(i, "tagID"), false);
        	portTab.getCellShow(i, "tagID").setValue("-");
        	portTab.getCellShow(i, "portname").setValue("NMS-1");
        }
    }
}

function removeItemFromSelct(objSelect, objItemValue)
{
    for (var i = 0; i < objSelect.options.length; i++) 
    {
        if (objSelect.options[i].value == objItemValue) 
        {
            objSelect.options.remove(i);
            break;
        }
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = errorObj["nename"];
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}

function encapTypeEvent()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    revertEncapType(portTab, rowindex, this.value);
}

function revertEncapType(st, rowindex, value)
{
    var encapType = st.getCellStoreValue(rowindex, "encapType", "encapType");
    if (typeof(value) != "undefined" && value != null) 
    {
        encapType = value;
    }
    
    var tagidCell = st.getCell(rowindex, "tag");
    var vlanIDCell = st.getCell(rowindex, "vlanID");
    if (encapType == "1")//802.1Q
    {
        if (tagidCell.element.isEdit != "1") 
        {
            st.setCellIsEdit(tagidCell, "1");
            st.setCellValue(tagidCell, "tag", "1");
            st.getCellShow(rowindex, "tag").setValue("Tag Aware");
            
            st.setCellIsEdit(vlanIDCell, "0");
            st.setCellValue(vlanIDCell, "vlanID", "-");
            st.getCellShow(rowindex, "vlanID").setValue("-");
        }
    }
    else if (encapType == "0")//none
    {
        if (tagidCell.element.isEdit != "0") 
        {
            st.setCellIsEdit(tagidCell, "0");
        }
        st.setCellValue(tagidCell, "tag", "-");
        st.getCellShow(rowindex, "tag").setValue("-");
        
        st.setCellIsEdit(vlanIDCell, "0");
        st.setCellValue(vlanIDCell, "vlanID", "-");
        st.getCellShow(rowindex, "vlanID").setValue("-");
    }
    else 
    {
        if (tagidCell.element.isEdit != "0") 
        {
            st.setCellIsEdit(tagidCell, "0");
        }
        st.setCellValue(tagidCell, "tag", "1");
        st.getCellShow(rowindex, "tag").setValue("Tag Aware");
        
        st.setCellIsEdit(vlanIDCell, "0");
        st.setCellValue(vlanIDCell, "vlanID", "-");
        st.getCellShow(rowindex, "vlanID").setValue("-");
    }
}

function changeTag()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    tagEvent(rowindex, this.value);
}

function tagEvent(rowindex, value)
{
    var vlanIDCell = portTab.getCell(rowindex, "vlanID");
    if (value == "0" || value == "2") 
    {
        if (vlanIDCell.element.isEdit == "0") 
        {
            portTab.setCellIsEdit(vlanIDCell, "1");
            portTab.setCellValue(vlanIDCell, "vlanID", "1");
            portTab.getCellShow(rowindex, "vlanID").setValue("1");
        }
    }
    else 
    {
        portTab.setCellIsEdit(vlanIDCell, "0");
        portTab.setCellValue(vlanIDCell, "vlanID", "-");
        portTab.getCellShow(rowindex, "vlanID").setValue("-");
    }
}

function getExsitBoardPort(type)
{
    var exicstBoardport = [];
    for (var i = 0, size = portTab.getDataRowLength(); i < size; i++) 
    {
        var porttype = portTab.getCellStoreValue(i, "porttype", "porttype");
        var slotid = portTab.getCellStoreValue(i, "slotid", "slotid");
        var portid = portTab.getCellStoreValue(i, "portid", "portid");
        var portname = portTab.getCellStoreValue(i, "portname", "portname");
        if ((type == "nni" && porttype != PORTTYPE_NNI) ||
        (type == "uni" && porttype == PORTTYPE_NNI)) 
        {
            exicstBoardport[exicstBoardport.length] = new exicstBoardPort(slotid, portid, portname);
        }
    }
    return exicstBoardport;
}

function exicstBoardPort(slot, port, pname)
{
    this.slotid = slot;
    this.portid = port;
    this.portname = pname;
}

/**
 * IF and EFP8 and isx2 and isu2 NOT support
 * @param {Object} boardname
 */
function isSupportWorkModeBoard(boardname)
{
    if (boardname.indexOf("IF") >= 0 ||
    boardname.indexOf("EFP8") >= 0 ||
    boardname.indexOf("EMS6") >= 0 ||
    boardname.indexOf("ISX2") >= 0 ||
    boardname.indexOf("ISU2") >= 0 ||
    boardname.indexOf("ISV3") >= 0 ||
    boardname.indexOf("ISU3") >= 0 ||
    boardname.indexOf("NMS") >= 0 ) 
    {
        return false
    }
    return true;
}
