var MACARRAYLEN = 6;
var MACLEN = 2;
var portlist;
var tagType_CAwared = "1";
var tagType_SAwared = "2";
var tagType_TagTrans = "0";

var portType_Uni = "1";
var portType_Nni = "2";
var portType_Pbuni = "3";
var portType_Pbsuni = "4";
var portType_Pbnni = "5";

var macsflntype_SVL = "1";
var macsflntype_IVL = "2";

isDemo = false;

var MIN_VLANID = "1";
var MAX_VLANID = "4094";
var MIN_AGETIME = "1";//E-LAN min agetime(min)
var MAX_AGETIME = "640";//E-LAN max agetime(max)
var MIN_CAPACITY = "0";//E-LAN min Address Table Specifiled Capacity(min)
var MAX_CAPACITY = "66534";//E-LAN max Address Table Specifiled Capacity(max)
var MIN_UPPERTHRD = "80";//E-LAN min Address Detection Upper Threshold(min)
var MAX_UPPERTHRD = "100";//E-LAN max Address Detection Upper Threshold(max)
var MIN_LOWERTHRD = "60";//E-LAN min Address Detection Lower Threshold(min)
var MAX_LOWERTHRD = "100";//E-LAN max Address Detection Lower Threshold(max)

var tagtype = new Object();
tagtype["0"] = "Tag-Transparent";
tagtype["1"] = "C-Awared";
tagtype["2"] = "S-Awared";

var enable = new Object();
enable["0"] = "Disabled";
enable["1"] = "Enabled";

var macsflntype = new Object();
macsflntype["1"] = "SVL";
macsflntype["2"] = "IVL";

var bpdu = new Object();
bpdu["0"] = "nottransparent";
bpdu["1"] = "transparentbpdu";

var porttype = new Object();
porttype["1"] = "UNI";
porttype["2"] = "NNI";
porttype["3"] = "UNI(Port+S-VLAN)";
porttype["4"] = "UNI(Port+C-VLAN+S-VLAN)";
porttype["5"] = "NNI";

var portworkmode = new Object();
portworkmode[0] = "autonegotiation";
portworkmode[1] = "HalfDuplex10M";
portworkmode[2] = "FullDuplex10M";
portworkmode[3] = "HalfDuplex100M";
portworkmode[4] = "FullDuplex100M";
portworkmode[5] = "HalfDuplex1000M";
portworkmode[6] = "FullDuplex1000M";
portworkmode[7] = "FullDuplexLAN10G";
portworkmode[8] = "FullDuplexWAN10G";

var encaptype = new Object();
encaptype[0] = "Null";
encaptype[1] = "802.1Q";
encaptype[2] = "QinQ";

var porttagtype = new Object();
porttagtype[0] = "Access";
porttagtype[1] = "Tag Aware";
porttagtype[2] = "Hybrid";
porttagtype[255] = "-";

var LOAD_TYPE_PW = 1; // PW
var LOAD_TYPE_PHYPORT = 3; // PHY PORT
var INVALID_LABEL_VALUE_1 = 0; //    label 
var INVALID_LABEL_VALUE_2 = 0xFFFFFFFF; //    label 

/***************************
 * portattribute object
 ***************************/
function portAttr(logicportid,portid,portname,porttype,cvlan,svlan,boardname,slotid)
{
   this.logicportid = logicportid;
   this.portid = portid;
   this.portname = portname;
   this.porttype = porttype;
   this.cvlan = cvlan;
   this.svlan = svlan;
   this.boardname = boardname;
   this.slotid = slotid;
}

/**
 * pw       
 * @param nniID
 * @param pwIndex
 * @param pwID
 * @param serviceType
 * @param tmpPortName
 * @param porttype
 * @return
 */
function pwPortAttr(logicportid,pwIndex,pwID,serviceType,portname,porttype)
{
   this.logicportid = logicportid;
   this.pwIndex = pwIndex;
   this.pwID = pwID;
   this.serviceType = serviceType;
   this.portname = portname;
   this.porttype = porttype;
}
/***************************
 * handle select to right 
 ***************************/
function fnSelectToRight(field1, field2, button)
{
    var value = new Array();
    var text = new Array();
    for(var i = field1.options.length - 1, j = 0; i >= 0; i--)
    {
        if(field1.options[i].selected)
        {
             value[j]=field1.options[i].value;
             text[j]=field1.options[i].text;
             field1.remove(i);
             
             var tempStr = text[j];
             if (!deletePortsArr.contains(tempStr))
             {
             	  addPortsArr[addPortsArr.length] = tempStr;
             }
             else
             {
             	  deletePortsArr.remove(tempStr);
             }
             
             j++;
        }    
     }
        	
     for(k = value.length - 1; k >= 0; k--)
     {
         var oOption = document.createElement("OPTION");
         oOption.text = text[k];
         oOption.value = value[k];
         
         field2.options.add(oOption);
     }
      
     document.getElementById("applybtn").disabled = false; 	
}

/***************************
 * handle select to left 
 ***************************/
function fnSelectToLeft(field1, field2, button)
{
    var value = new Array();
    var text = new Array();
    for(var i = field1.options.length - 1, j = 0; i >= 0; i--)
    { 
         if(field1.options[i].selected)
         {
             value[j]=field1.options[i].value;
             text[j]=field1.options[i].text;
             field1.remove(i);
             
             var tempStr = text[j];
             if (!addPortsArr.contains(tempStr))
             {
             	  deletePortsArr[deletePortsArr.length] = tempStr;
             }
             else
             {
             	  addPortsArr.remove(tempStr);
             }
             
             j++;
         }
    }  
      
    for(k = value.length - 1; k >= 0; k--)
    {	   	   	  
        var oOption = document.createElement("OPTION");
        oOption.text = text[k];
        oOption.value = value[k];
            
        field2.options.add(oOption);
    } 
	   		  
    document.getElementById("applybtn").disabled = false; 
}


function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = di.getBErrLength(); i < len; i++)
      {
    	   errorObj = di.getError().rowErrors[i].errorObj;
    	   errorObj["operationObj"] = errorObj["serviceID"]+"-"+errorObj["serviceName"];
      }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}

function VlanLogicInf()
{
   this.slotid;
   this.subslotid;
   this.portid;
   this.boardName;
   this.subslotname;
   this.vuniID;
   this.portname;
   this.porttype;
   this.tagID;
   this.svlan;
   this.portEnable;
   this.workMode;
   this.encapType;
   this.tag;
}

function textCheckWithNull(obj, MIN_VLANID, MAX_VLANID)
{
	checkText(obj, MIN_VLANID, MAX_VLANID);
	obj.onblur = function()
	{
		if("" == obj.value.trim())
		{
			lostFocus(obj);
			return false;
		}
		numCellOnBlur(obj, MIN_VLANID, MAX_VLANID);
	}
}

function lostFocus(obj)
{
	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);

	var pnode = obj.parentNode;

	if (pnode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == obj.parentNode.showElement.type)
			{
				pnode.showElement.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				pnode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}

			obj.parentNode.parent.setTdCellValue(obj.parentNode,
					hc.element.keys[0], obj.options[obj.selectedIndex].value);
		}
	}
	else
	{

		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = obj.parentNode.offsetWidth;
		var rows = obj.parentNode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}
			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);

	pnode.showElement.element.style.display = "";

	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);	
}




function pathsToUni(pathsList)
 {      
 	 var len = pathsList.length - 1;
 	 var firstNum = -1 ;
 	 var nextNum = -1 ;
 	 var conNumStart = -1 ;
 	 var conNumEnd = -1 ;
 	 var numToStr = "" ;
 	 if (pathsList.length == 1)//        
 	 {
 	 	return pathsList[0];
   }
   for(var i = 0 ;i < len ;i++)
   {    
    	    firstNum = parseInt(pathsList[i],10);//      serverNo     
    		nextNum =  parseInt(pathsList[i+1],10);
    		if((firstNum + 1) == nextNum )//             
    		{
    		   if(-1 != conNumStart)
    		   {
    			   conNumEnd = nextNum ;
    		   }
    		   else
    		   {
    			   conNumStart = firstNum ;
    			   conNumEnd = nextNum ;
    		   }
    		}
    		else
    		{
    			if(-1 == conNumStart)
    			{
    				numToStr += "," + firstNum ;
    				
    			}
    			else
    			{
    				numToStr += "," + conNumStart + "-" + conNumEnd ;
    				conNumStart = -1 ;
    				conNumEnd = -1 ;
    			}
    		}
    		if(len == i + 1)//        
    		{
    			if(-1 == conNumStart)
    			{
    				numToStr += "," + nextNum;  				
    			}
    			else
    			{
    				numToStr += "," + conNumStart + "-" + conNumEnd ;
    				conNumStart = -1 ;
    				conNumEnd = -1 ;
    			}
    		}
    		
    	}
        return numToStr.substring(1);
 }


function getStringArray(resultObject,str,maxVlan)
{
    if ("" == str || "-" == str)
    {
    	  return resultObject;
    }
    
    var str = str.split(",");
    for(var i = 0, len = str.length ; i < len; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
            if(maxVlan!= null && rangeEnd > maxVlan)
            {
            	return false;
            }
            for(var j=rangeStart; j<=rangeEnd;j++)
            {
                if(!(resultObject[j]==1))
                {
                	resultObject[j]=1;
                }
            }
        }
        else
        {
            var stri = str[i];
            if(!(resultObject[stri]==1))
            {
            	resultObject[stri]=1;
            }
        }
    }
    
    return true;

}

function limitVlanInput(obj, minValue, maxValue)
{
    var minvalue = minValue;
    var maxvalue = maxValue;
    
    obj.value = "";
    obj.style.imeMode = "disabled";
    obj.onkeypress = function()
    {
        var evt = window.event;
        return restrictVlan(obj, evt, minvalue, maxvalue);
    };
    obj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = obj.value + pasteText;
        return vlanTextCheck(pasteText, minvalue, maxvalue);
        
    };
}

function restrictVlan(field, event, minvalue, maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' ||
    keychar == '[' ||
    keychar == ']' ||
    keychar == '\\' ||
    keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') ||
            (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function vlanTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}

