var parobj = getParentWindow();
var neid = parobj.neid;
var macTable;
var DEFAULT_VLANID = 1;
var serviceIndex = parobj.serviceIndex;
var tagtype = parobj.tagtype;  //          
var macbox;
/******************
 * init the page
*******************/
function init()
{	
	initCacheValue();
    initAttrTable();   	
    initButtonText();
}
/**********************************
 *        
************************************/
function initCacheValue()
{
	/**
	 *   FO                            
	 */
	var rows = parobj.parobj.st.getSelectedRows();
	if(rows.length > 0)
	{
		tagtype = parobj.parobj.st.getCellStoreValue(rows[0], 'tagtype', 'tagtype');
	}
	else
	{
		tagtype = parobj.parobj.st.getCellStoreValue(0, 'tagtype', 'tagtype');
	}	
}
/***********************
 * init attribute table
************************/
function initAttrTable()
{
    macTable = new CTable();
    macTable.addHead(RESOURCE["property"],RESOURCE["value"]);
    
    var atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_vlanIDaddmemport");
    atom.setValue(DEFAULT_VLANID);
    var atomEle = atom.element; 
    atomEle.disabled = false;
    checkText(atomEle,MIN_VLANID + "",MAX_VLANID + "");
    atomEle.style.imeMode = "disabled"; 	
    macTable.addAttrRow("vlanID", "VLAN ID", atom); 
    atom.element["onchange"] = function()
    {	     
        $("applyBtn").disabled = false;
    }   
    
     if(tagtype == tagType_TagTrans) //          
    {
        atomEle.disabled = true;
        atomEle.value = '-';
    }

    atom = new Atom("span");
	macbox=new MacBox("macbox");
	atom.element.innerHTML=macbox;
    macTable.addAttrRow("macAdd", "MAC Address", atom); 
    
    atom.element["onchange"] = function()
    {	     
        $("applyBtn").disabled = false;
    }   
       
    $("dismactab").appendChild(macTable.getTable());
}

/************************************
 * check if the input is mac address
*************************************/
function checkMAC(strparam)
{
    var ipAddressArray = strparam.split("-");
    
    if (MACARRAYLEN != ipAddressArray.length)
    {
    	alert(RESOURCE["wrongMAC"]);
		return false;
    }
    
    for(var i = 0, len = ipAddressArray.length; i < len; i++)
    {
    	  if (MACLEN != ipAddressArray[i].length)
    	  {
    	  	 alert(RESOURCE["wrongMAC"]);
	  	     return false;
    	  }
    }
    return true;
}

/************************************
 * init button info
*************************************/
function initButtonText()
{  
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];	
    $("applybtn").value = RESOURCE["applybtn"];	
    
     if(tagtype == tagType_TagTrans)//          
    {
        $("applybtn").disabled = false;
    }
}
     
/************************************
 * create disable mac address
*************************************/ 
function doCreate(buttonFlag)
{
    if (serviceIndex == "")
    {
         alert(RESOURCE["selecteService"]);
         return;
    }

    if ("" == macbox.getValue())
    {
        alert(parobj.RESOURCE["inputVlan"]);
        return;
    }
	    okFlag = buttonFlag;
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
    
    var xmlstr = createXML();
    urlreq ="../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_ELAN_ADD_MACENABLE+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+parobj.parobj.obj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}  
      
function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","autoServiceIndex");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","serviceIndex");
    param.setAttribute("value",serviceIndex);
    row.appendChild(param);

    if(parobj.parobj.serviceID!=null&&parobj.parobj.serviceID!=undefined)
    {
    	param = new tagElement("param");
    	param.setAttribute("name","serviceID");
    	param.setAttribute("value",parobj.parobj.serviceID);
    	row.appendChild(param);
    }
    if(parobj.parobj.activateState!=null&&parobj.parobj.activateState!=undefined)
    {
    	param = new tagElement("param");
    	param.setAttribute("name","activateState");
    	param.setAttribute("value",parobj.parobj.activateState);
    	row.appendChild(param);
    }
    
    param = new tagElement("param");    
    param.setAttribute("name","vlanID");
    if(tagtype == tagType_TagTrans) //          
    {
        param.setAttribute("value",'65534');
    } else {
        param.setAttribute("value",macTable.getAttrValue("vlanID"));
    }
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","macAddr");

    param.setAttribute("value",macbox.getValue());
    row.appendChild(param);
  
    bussiness.appendChild(row);   	  
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("cancelbtn").disabled=false;
	  
    var data = EncapsulateData(doc);  
    showErrorDialog(data);  
    if(data.getSErrorCode() < 2) 
    {	 
         parobj.queryDisMac();
         if (okFlag)
         {
             xcloseDialog();
         }
    } 
    $("applybtn").disabled=false;
}    

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = di.getBErrLength(); i < len; i++)
      {
    	   errorObj = di.getError().rowErrors[i].errorObj;
    	   errorObj["operationObj"] = RESOURCE["serviceID"]+":"+parobj.parobj.serviceID;
      }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}       
