/**
 * 
 * TRANSV1R8C00-2761 
 *     OAM        weblct
 *    OAM MA                    MEG ID
 *        ICC  /              
 *       ICC    MEG ID                   MEG ID     
 *      RTN905/910/950/980/950A/905 1C
 *     RTN900V1R5C01
 * NSCMD_ETHN_SET_ETHSRVOAM_STANDARD
 * NSCMD_ETHN_GET_ETHSRVOAM_STANDARD
 *
 */
var MEGID_MAX_LENGTH = 45;//MEGID    
var ICC_MODEL = 2;
var protocolStandardConvert = [];
protocolStandardConvert[1]="802.1ag";
protocolStandardConvert[2]="Y.1731";

function createApplyMAXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isNoLog");
    param.setAttribute("value", "1");
    row.appendChild(param);
    bussiness.appendChild(row);
    
    for (var i = 0, len = mtunionTable.getDataRowLength(); i < len; i++) 
    {
    	
    	if(!mtunionTable.getModify(i))
    	{
    		continue;
    	}

    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "auto1");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "mdid");
    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "mdid", "mdid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "auto2");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "maid");
    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "maid", "maid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ccperiod");
    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "ccperiod", "ccperiod"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "modifyMA");
    row.appendChild(param);

	var megidtype = mtunionTable.getCellStoreValue(i, "megidtype", "megidtype");		
    param = new tagElement("param");
    param.setAttribute("name","megidtype");
    param.setAttribute("value", megidtype);
    row.appendChild(param);		
	
    param = new tagElement("param");
    param.setAttribute("name","megid");
	if(ICC_MODEL == megidtype)
	{
		param.setAttribute("value", mtunionTable.getCellStoreValue(i, "megid", "megid"));
	}
	else
	{
		param.setAttribute("value", "");
	}
	row.appendChild(param);	
    
    bussiness.appendChild(row);
  }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function addCellListener()
{
	for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "serviceName");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
		st.getCellShow(i, "mtu").element.innerHTML = "-";
        
        if (st.getCellStoreValue(i, "serviceTagRole", "serviceTagRole") == null) 
        {
            st.getCellShow(i, "serviceTagRole").element.innerHTML = "-";
        }
    }
	
    for (var i = 0, m = mtunionTable.getDataRowLength(); i < m; i++) 
    {
        var cell = mtunionTable.getCell(i, "megid");
		cell.element.editElement.element.maxLength = MEGID_MAX_LENGTH;
		/**
		 * 802.1ag   megid    
		 */
		if(mtunionTable.getCellStoreValue(i, "megidtype", "megidtype") != ICC_MODEL)
		{
			setInvalidValue(i, "megid",mtunionTable);
		}
		
		var megtypeCellEditor = mtunionTable.getCellEdit(i, "megidtype");
		if (null != megtypeCellEditor) 
		{
			megtypeCellEditor.element.onchange = function()
			{
				var rowIndex = this.parentNode.parentNode.rowIndex;
	            var megidtypeValue = parseInt(this.value);
				/**
	 			 *       802.1ag    MEG ID                   MEG ID     
				 */
				if (ICC_MODEL == megidtypeValue) 
				{
					var megidCellShow = mtunionTable.getCellShow(rowIndex, "megid");
					megidCellShow.setValue("");
					mtunionTable.setCellIsEdit(mtunionTable.getCellElement(rowIndex, "megid"), true);
				}
				else
				{
					setInvalidValue(rowIndex, "megid",mtunionTable);
				}
			}
		}
    }
}

function setInvalidValue(index, colid,st)
{
    var cell = st.getCellShow(index, colid).element;
    cell.innerHTML = "-";
	st.setCellIsEdit(st.getCellElement(index, colid), false);
}

function createMA(key)
{
    hideMenu();
    var mdid, mdname, maid, maname;
    var diaWidth = 300;
    var diaHeight = 150;
    
    var selectedRows = st.getSelectedRows();
    var serviceIndex = st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex")
    
    if (key == "MA") 
    {
        diaWidth = 450;
        diaHeight = 200;
        xshowModalDialog("../eaggr_u2kv1r8c00/createma.html?serviceIndex=" + serviceIndex, RESOURCE["createMA"], diaWidth, diaHeight, "../../../../../../images/");
    }
}

function megidConvert(value)
{
	if( value == null || value == 'undefined' )
	{
		return "";
	}
	else
	{
		return value;
	}
}
