/**
 * 
 * <!--       TRANSU2000V1R7C00-3881-->
 * <!--      :OP201204190004:TDR5       PW               VCCV             -WEBLCT-->
 * <!--NSCMD_PTN_MPLS_PW_SET_CW_VCCV              NSCMD_PTN_MPLS_PW_SET_CW  NSCMD_PTN_MPLS_PW_SET_VCCV              -->
 * 
 */
function initAdvancedTable()
{
    act = new CTable();
    act.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    /**
     * U2000R7C00    WebLCT        pw ping        
     */

    var atom = new Atom("select");
    atom.addOption(RESOURCE["nouse"], 1);
    atom.addOption(RESOURCE["usedfirst"], 2);
    act.addAttrRow("controlword", RESOURCE["controlword"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Alert Label", "2");
    atom.element.options.selectedIndex = 2;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom);

    var crlword = act.getAtom("controlword");
    
    crlword.element.onchange = function()
    {
    	var value = this.value;
    	var channeltype = act.getAtom("controlchanneltype");
    	channeltype.removeAllOptions();
    	if(value == "1")
    	{
    		channeltype.addOption("None", "0");
    		channeltype.addOption("Alert Label", "2");
    	}
    	else
    	{
    		channeltype.addOption("None", "0");
    		channeltype.addOption("CW", "1");
    		channeltype.addOption("Alert Label", "2");
    	}
    }
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Ping", "1");
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "4094");
    act.addAttrRow("requestvlan", RESOURCE["requestvlan"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "65535");
    act.addAttrRow("tpid", "TPID", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    $("advance").appendChild(act.getTable());
}
