var mtunionTable = null;
var mepTable = null;

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("eaggrtbl").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("eaggrtbl"), 10) + "px");
    $("eaggrtbl").oncontextmenu = popupMenuHandler;
    
    unist = new SortTable();
    unitc = window.tableconf[1];
    unist.setImage("../../../../../../images/");
    createTableHead(unist, unitc);
    $("unitbl").appendChild(unist.getTable());
    unist.setBodyHeight(getComponetHeight($("unitbl"), 180) + "px");
    
    nnipwst = new SortTable();
    nnipwtc = window.tableconf[2];
    nnipwst.setImage("../../../../../../images/");
    nnipwst.setOnRowSelectHandler(rowSelectHandler_NNIPW);
    createTableHead(nnipwst, nnipwtc);
    $("pwtbl").appendChild(nnipwst.getTable());
    nnipwst.setBodyHeight(getComponetHeight($("pwtbl"), 180) + "px");
    $("pwtbl").oncontextmenu = popupMenuHandler_NNIPW;
    
    nniportst = new SortTable();
    nniporttc = window.tableconf[3];
    nniportst.setImage("../../../../../../images/");
    createTableHead(nniportst, nniporttc);
    $("porttbl").appendChild(nniportst.getTable());
    nniportst.setBodyHeight(getComponetHeight($("porttbl"), 180) + "px");
    
    qosunist = new SortTable();
    qosunist.setImage("../../../../../../images/");
    qosunist.setOnRowSelectHandler(rowSelectHandler_QoS);
    qosunist.isUsedForSelectList = true;
    qosunist.setOnCellEditHandler(cellEditHandler_QoS);
    createTableHead(qosunist, window.tableconf[4]);
    $("qosunitbl").appendChild(qosunist.getTable());
    qosunist.setBodyHeight(getComponetHeight($("qosunitbl"), 180) + "px");
    $("qosunitbl").oncontextmenu = popupMenuHandler_QoS;
    
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    qospwst.setOnRowSelectHandler(rowSelectHandler_QoS);
    qospwst.isUsedForSelectList = true;
    qospwst.setOnCellEditHandler(cellEditHandler_QoS);
    createTableHead(qospwst, window.tableconf[5]);
    $("qospwtbl").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("qospwtbl"), 180) + "px");
    $("qospwtbl").oncontextmenu = popupMenuHandler_QoS;
    
    portattrst = new SortTable();
    portattrst.setImage("../../../../../../images/");
    createTableHead(portattrst, window.tableconf[6]);
    $("portattrtbl").appendChild(portattrst.getTable());
    portattrst.setBodyHeight(getComponetHeight($("portattrtbl"), 180) + "px");
    
    vlanst = new SortTable();
    vlanst.setImage("../../../../../../images/");
    vlanst.setOnRowSelectHandler(rowSelectHandler_VLAN);
    createTableHead(vlanst, window.tableconf[7]);
    $("vlantbl").appendChild(vlanst.getTable());
    vlanst.setBodyHeight(getComponetHeight($("vlantbl"), 180) + "px");
    
    mtunionTable = new SortTable();
    mtunionTable.setImage("../../../../../../images/");
    createTableHead(mtunionTable, window.tableconf[8]);
    mtunionTable.setBodyHeight(getComponetHeight($("mtunionContainer"), 180) + "px");
    mtunionTable.setOnCellEditHandler(cellEditHandler_MA);
    mtunionTable.setOnRowSelectHandler(rowSelected_MA);
    $("mtunionContainer").appendChild(mtunionTable.getTable());
    
    mepTable = new SortTable();
    mepTable.setImage("../../../../../../images/");
    createTableHead(mepTable, window.tableconf[9]);
    mepTable.setBodyHeight(getComponetHeight($("mepContainer"), 180) + "px");
    $("mepContainer").appendChild(mepTable.getTable());
    mepTable.setOnRowSelectHandler(rowSelected_MP);
    mepTable.setOnCellEditHandler(cellEditHandler_MP);
}

function rowSelected_MP()
{
    var arr = mepTable.getSelectedRows();
    if (arr.length > 0) {
        $("delMPBtn").disabled = false;
        $("oamMPBtn").disabled = false;
    }
}

function cellEditHandler_MP()
{
   $("applyMPBtn").disabled = false;	
}

function cellEditHandler_MA()
{
    $("applyMABtn").disabled = false;
}

function rowSelected_MA()
{
    var arr = mtunionTable.getSelectedRows();
    if (arr.length <= 0) {
        $("delMABtn").disabled = true;
    }
    else
    {
    	$("delMABtn").disabled = false;
    }
    
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", "UNI", $("tab1div"));
    tab.addEmbedTab("tab2div", "NNI", $("tab2div"));
    tab.addEmbedTab("tab3div", "QoS", $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["portattr"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["vlanforwardtableitem"], $("tab5div"));
    tab.addEmbedTab("tab6div", RESOURCE["mtunion"], $("tab6div"));
    tab.addEmbedTab("tab7div", RESOURCE["mep"], $("tab7div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("cfgunibtn").disabled = !btnRightArr.newbtn.right;
        $("querypwbtn").disabled = !btnRightArr.querybtn.right;
        $("newpwbtn").disabled = !btnRightArr.newbtn.right;
        $("cfgnnibtn").disabled = !btnRightArr.newbtn.right;
        $("queryqosbtn").disabled = !btnRightArr.querybtn.right;
        $("queryportattrbtn").disabled = !btnRightArr.querybtn.right;
        $("queryvlanbtn").disabled = !btnRightArr.querybtn.right;
        $("newvlanbtn").disabled = !btnRightArr.newbtn.right;
        embedTabSelectHandler(tab.getSelectEmbedTab());
    }
    else 
    {
        $("deletebtn").disabled = true;
        $("cfgunibtn").disabled = true;
        $("querypwbtn").disabled = true;
        $("newpwbtn").disabled = true;
        $("cfgnnibtn").disabled = true;
        $("queryqosbtn").disabled = true;
        $("querypolicybtn").disabled = true;
        $("queryportattrbtn").disabled = true;
        $("queryvlanbtn").disabled = true;
        $("newvlanbtn").disabled = true;
        
        unist.clearTableData();
        nnipwst.clearTableData();
        nniportst.clearTableData();
        qosunist.clearTableData();
        qospwst.clearTableData();
        portattrst.clearTableData();
        vlanst.clearTableData();
        mtunionTable.clearTableData();
        mepTable.clearTableData();
    }
}
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("printbtn").value = RESOURCE["printbutton"];
    
    $("cfgunibtn").value = RESOURCE["configbtn"];
    $("applyunibtn").value = RESOURCE["applybutton"];
    
    $("querypwbtn").value = RESOURCE["querybutton"];
    $("newpwbtn").value = RESOURCE["newbutton"];
    $("deletepwbtn").value = RESOURCE["deletebutton"];
    $("applypwbtn").value = RESOURCE["applybutton"];
    $("cfgnnibtn").value = RESOURCE["configbtn"];
    $("applynnibtn").value = RESOURCE["applybutton"];
    
    $("queryqosbtn").value = RESOURCE["querybutton"];
    $("querypolicybtn").value = RESOURCE["querypolicybtn"];
    $("applyqosbtn").value = RESOURCE["applybutton"];
    
    $("queryportattrbtn").value = RESOURCE["querybutton"];
    
    $("queryvlanbtn").value = RESOURCE["querybutton"];
    $("newvlanbtn").value = RESOURCE["newbutton"];
    $("deletevlanbtn").value = RESOURCE["deletebutton"];
    
    $("queryMABtn").value = RESOURCE["querybutton"];
    $("createMABtn").value = RESOURCE["newbutton"];
    $("delMABtn").value = RESOURCE["deletebutton"];
    $("applyMABtn").value = RESOURCE["applybutton"];
    changeBtnStatusMA(true);
    
    $("queryMPBtn").value = RESOURCE["querybutton"];
    $("createMPBtn").value = RESOURCE["newbutton"];
    $("delMPBtn").value = RESOURCE["deletebutton"];
    $("oamMPBtn").value = RESOURCE["oambutton"];
    $("applyMPBtn").value = RESOURCE["applybutton"];
    changeBtnStatusMP(true);
}

function changeBtnStatusMA(status)
{

    $("queryMABtn").disabled = status;
    $("createMABtn").disabled = status;
    $("delMABtn").disabled = status;
    
    var arr = mtunionTable.getSelectedRows();
    if (arr.length <= 0) 
    {
        $("delMABtn").disabled = true;
    }
}

function createjsDOMenu(elem)
{
    removejsDOMmenu();
    var menuWidth = 140;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        menuWidth = 230;
    }
    var cursorMenu = new jsDOMenu(menuWidth);
    
    var arr = mepTable.getSelectedRows();
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["activecc"], "", setCC, 1, true));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["inactivecc"], "", setCC, 0, true));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["startlbbutton"], "", start, 1, true && (arr.length == 1)));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["startltbutton"], "", start, 2, true && (arr.length == 1)));
    
    
    setPopUpMenu(cursorMenu);
}

function openDialog_QoS()
{
    var policyType = PW_POLICY;
    var tmpst = qospwst;
    if ($("qosunitbl").style.display != "none") 
    {
        policyType = VUNI_INGRESS_POLICY;
        tmpst = qosunist;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    
    if (tmpst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var index = tmpst.getSelectedRows()[0];
    var direction = st.getCellStoreValue(index, "direction", "direction");
    
    var url = "../eaggr/policyselect.html?policyType=" + policyType + "&direction=" + direction;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function doCfgUNI()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    xshowModalDialog("../eaggr/configureuniport.html?serviceIndex=" + serviceIndex, RESOURCE["configureport"], 600, 420, "../../../../../../images/");
}

function doCfgNNI()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    xshowModalDialog("../eaggr/configurenniport.html?serviceIndex=" + serviceIndex, RESOURCE["configureport"], 600, 420, "../../../../../../images/");
}

function doQueryPolicy()
{
    var tmpst = qospwst;
    var policyType = PW_POLICY;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        policyType = VUNI_INGRESS_POLICY;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    
    var tmpIndex = tmpst.getSelectedRows()[0];
    var policy = tmpst.getCellStoreValue(tmpIndex, "policy", "policy");
    if (typeof(policy) == "undefined" || null == policy || "" == policy) 
    {
        alert(RESOURCE["selectpolicy"]);
        return;
    }
    var url = "../ethcommon/policyinfo.html?policyType=" + policyType + "&policyId=" + policy.substring(0, policy.indexOf("("));
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 580, 420, "../../../../../../images/");
}

function queryResCallBack(doc, arg)
{
    resources = [];
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var resource = new Object();
            resource.iftype = data.getDataRowParam(i, "iftype");
            resource.ifid = data.getDataRowParam(i, "ifid");
            resource.role = data.getDataRowParam(i, "role");
            resource.name = data.getDataRowParam(i, "name");
            resources.push(resource);
        }
        xshowModalDialog("../eaggr/createvlantable.html?serviceIndex=" + arg, RESOURCE["createvlantable"], 400, 255, "../../../../../../images/");
    }
}

function createApplyNNIXml()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = delNNIs.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
        rowparams.appendChild(createTagElement("delvnni", delNNIs[i]));
        bussiness.appendChild(rowparams);
    }
    
    for (var j = 0, n = delPWs.length; j < n; j++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("delpw", delPWs[j]));
        bussiness.appendChild(rowparams);
    }
    
    var tmpst = nnipwst;
    var carrierType = LOAD_TYPE_PW;
    if ($("porttbl").style.display != "none") 
    {
        tmpst = nniportst;
        carrierType = LOAD_TYPE_PHY_PORT;
    }
    
    for (var k = 0, mn = tmpst.getDataRowLength(); k < mn; k++) 
    {
        var vnniId = tmpst.getCellStoreValue(k, "vnniId", "vnniId");
        var role = tmpst.getCellStoreValue(k, "role", "role");
        
        if (typeof(vnniId) == "undefined" || vnniId == "" || vnniId == null || vnniId == "-") 
        {
            var rowparams = new tagElement("row-params");
            rowparams.appendChild(createTagElement("neid", neid));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("vnniID", 0));
            rowparams.appendChild(createTagElement("role", role));
            rowparams.appendChild(createTagElement("carrierType", carrierType));
            
            if (LOAD_TYPE_PW == carrierType) 
            {
                rowparams.appendChild(createTagElement("carrierID1", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID3", INVALID_LABEL_VALUE_2));
                
                rowparams.appendChild(createTagElement("pwSignalType", tmpst.getCellStoreValue(k, "pwSignalType", "pwSignalType")));
                rowparams.appendChild(createTagElement("pwType", tmpst.getCellStoreValue(k, "serviceType", "serviceType")));
                rowparams.appendChild(createTagElement("pwID", tmpst.getCellStoreValue(k, "pwID", "pwID")));
                rowparams.appendChild(createTagElement("direction", tmpst.getCellStoreValue(k, "direction", "direction")));
                rowparams.appendChild(createTagElement("pwIngressLabel", tmpst.getCellStoreValue(k, "pwIngressLabel", "pwIngressLabel")));
                rowparams.appendChild(createTagElement("pwEgressLabel", tmpst.getCellStoreValue(k, "pwEgressLabel", "pwEgressLabel")));
                rowparams.appendChild(createTagElement("oppositeLsrID", tmpst.getCellStoreValue(k, "oppositeLsrID", "oppositeLsrID")));
                var tunnelIndexHex = tenToHex(tmpst.getCellStoreValue(k, "tunnelindex", "tunnelindex"));
                for (var i = tunnelIndexHex.length; i < 8; i++) 
                {
                    tunnelIndexHex = "0" + tunnelIndexHex;
                }
                rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
                
                var tunnelid  = tmpst.getCellStoreValue(k, "tunnelid_e", "tunnelid_e");
			    var ingressid = tmpst.getCellStoreValue(k, "ingressid", "ingressid");
			    var egressid  = tmpst.getCellStoreValue(k, "egressid", "egressid");
			    rowparams.appendChild(createTagElement("ingressid", ingressid)); 
			    rowparams.appendChild(createTagElement("egressid", egressid)); 
			    rowparams.appendChild(createTagElement("tunnelid", tunnelid));  //tunnelid:PW  Egress  
                
                rowparams.appendChild(createTagElement("pwEncapsType", tmpst.getCellStoreValue(k, "pwEncapsType", "pwEncapsType")));
                rowparams.appendChild(createTagElement("enableState", tmpst.getCellStoreValue(k, "enableState", "enableState")));
                rowparams.appendChild(createTagElement("controlWord", tmpst.getCellStoreValue(k, "controlWord", "controlWord")));
                rowparams.appendChild(createTagElement("ctrlChanType", tmpst.getCellStoreValue(k, "ctrlChanType", "ctrlChanType")));
                rowparams.appendChild(createTagElement("vccv", tmpst.getCellStoreValue(k, "vccv", "vccv")));
                var v = tmpst.getCellStoreValue(k, "requestVLAN", "requestVLAN");
                if (v != "" && v != "-") 
                {
                    rowparams.appendChild(createTagElement("requestVLAN", v));
                }
                v = tmpst.getCellStoreValue(k, "tpID", "tpID");
                if (v != "" && v != "-") 
                {
                    rowparams.appendChild(createTagElement("tpID", v));
                }
            }
            else 
            {
                rowparams.appendChild(createTagElement("carrierID1", tmpst.getCellStoreValue(k, "port", "slotid")));
                rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID3", tmpst.getCellStoreValue(k, "portid", "port")));
            }
            bussiness.appendChild(rowparams);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function queryQoSCallBack(doc, arg)
{
    var tmpst = qosunist;
    var tmptc = window.tableconf[4];
    if (arg == LOAD_TYPE_PW) 
    {
        tmpst = qospwst;
        tmptc = window.tableconf[5];
    }
    tmpst.clearTableData();
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(tmpst, tmptc, data, RESOURCE);
    
    var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
        var direction = parseInt(tmpst.getCellStoreValue(i, "direction", "direction"));
        handleTableQos(tmpst,i,arg);
        if (arg == LOAD_TYPE_PHY_PORT) 
        {
        	cell = tmpst.getCell(i, "cbs");
        	tmpst.setCellIsEdit(cell, 0);
        	tmpst.getCellShow(i, "cbs").element.innerHTML = "-";
    		cell = tmpst.getCell(i, "pbs");
    		tmpst.setCellIsEdit(cell, 0);
    		tmpst.getCellShow(i, "pbs").element.innerHTML = "-";
            cell = tmpst.getCell(i, "policy");
            cell.element.ondblclick = openDialog_QoS;
			if(!isSupportIngressColor || direction != INGRESS)
			{
				cell = tmpst.getCell(i, "cos");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tmpst.getCell(i, "color");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
			}
            if (direction != INGRESS) 
            {
				if(!isSupportEngressQos)
				{
					tmpst.setCellIsEdit(tmpst.getCell(i,"policy"),0);
				}
            }
			else
			{
				if(!isSupportIngressQos)
				{
					tmpst.setCellIsEdit(tmpst.getCell(i,"policy"),0);
				}
			}
        }
        else 
        {
            if (direction == INGRESS) 
            {
                cell = tmpst.getCell(i, "bandwidthlimit");
            	tmpst.setCellIsEdit(cell, 1);
                cell = tmpst.getCell(i, "policy");
                cell.element.ondblclick = openDialog_QoS;
            }
            else 
            {
                cell = tmpst.getCell(i, "bandwidthlimit");
            	tmpst.setCellIsEdit(cell, 0);
                cell = tmpst.getCell(i, "policy");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
            }
            
            cell = tmpst.getCell(i, "lspmode");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            
            cell = tmpst.getCell(i, "exp");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
        }
    }
}

function cellEditHandler_QoS(param)
{
    $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
}

function createApplyQoSXml(arg0, arg1)
{
    var index = st.getSelectedRows()[0];
    var serviceIndex = st.getCellStoreValue(index, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = arg0.getDataRowLength(); i < m; i++) 
    {
        if (!arg0.getModify(i)) 
        {
            continue;
        }
        
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("qostype", arg1));
        if (arg1 == LOAD_TYPE_PHY_PORT) 
        {
            rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("autoVuniId", "0"));
            rowparams.appendChild(createTagElement("vuniId", arg0.getCellStoreValue(i, "vuniId", "vuniId")));
            rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
            
            if (arg0.getCellModify(i, "policy")) 
            {
                rowparams.appendChild(createTagElement("autoPolicy", "0"));
                var policy = arg0.getCellStoreValue(i, "policy", "policy");
                var policyInfo = policy;
                if (typeof(policy) == "undefined" || policy == "") 
                {
                    policy = INVALID_LABEL_VALUE_2;
                    policyInfo = "";
                }
                else 
                {
                    policy = policy.substring(0, policy.indexOf("("));
                }
                rowparams.appendChild(createTagElement("policyinfo", policyInfo));
                rowparams.appendChild(createTagElement("policy", policy));
            }
            
            if (arg0.getCellModify(i, "cos") || arg0.getCellModify(i, "color")) 
            {
                rowparams.appendChild(createTagElement("cos", arg0.getCellStoreValue(i, "cos", "cos")));
                rowparams.appendChild(createTagElement("color", arg0.getCellStoreValue(i, "color", "color")));
            }
        }
        else 
        {
            rowparams.appendChild(createTagElement("auto", "0"));
            rowparams.appendChild(createTagElement("pwIndex", arg0.getCellStoreValue(i, "pwIndex", "pwIndex")));
            rowparams.appendChild(createTagElement("pwID", arg0.getCellStoreValue(i, "pwID", "pwID")));
            rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
            
			if (arg0.getCellModify(i, "policy")) 
            {
                rowparams.appendChild(createTagElement("autoPolicy", "0"));
                var policy = arg0.getCellStoreValue(i, "policy", "policy");
                var policyInfo = policy;
                if (typeof(policy) == "undefined" || policy == "") 
                {
                    policy = INVALID_LABEL_VALUE_2;
                    policyInfo = "";
                }
                else 
                {
                    policy = policy.substring(0, policy.indexOf("("));
                }
                rowparams.appendChild(createTagElement("policyinfo", policyInfo));
                rowparams.appendChild(createTagElement("policy", policy));
                rowparams.appendChild(createTagElement("policyid", policy));
            }
            if (arg0.getCellModify(i, "exp")) 
            {
                rowparams.appendChild(createTagElement("exp", arg0.getCellStoreValue(i, "exp", "exp")));
            }
            
            if (arg0.getCellModify(i, "lspmode")) 
            {
                rowparams.appendChild(createTagElement("lspmode", arg0.getCellStoreValue(i, "lspmode", "lspmode")));
            }
        }

    	var bdwLimit = arg0.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit");
    	var oldbdwLimit = arg0.getCellStoreValue(i, "oldBandwidthlimit", "oldBandwidthlimit");

    	if ("1" == bdwLimit)
   		{
    		if(bdwLimit != oldbdwLimit)
    		{
        		rowparams.appendChild(createTagElement("QosFlag", "1"));
    		}
    		else if(arg0.getCellModify(i, "cir") || arg0.getCellModify(i, "cbs") 
    	        	|| arg0.getCellModify(i, "pir") || arg0.getCellModify(i, "pbs") 
    	        	|| arg0.getCellModify(i, "policy"))
    		{
    			rowparams.appendChild(createTagElement("QosFlag", "2"));
    		}
    		if ((bdwLimit != oldbdwLimit) || (arg0.getCellModify(i, "cir") || arg0.getCellModify(i, "cbs") 
    	        	|| arg0.getCellModify(i, "pir") || arg0.getCellModify(i, "pbs")))
    	    {
            	rowparams.appendChild(createTagElement("cir", arg0.getCellStoreValue(i, "cir", "cir")));
        		rowparams.appendChild(createTagElement("cbs", arg0.getCellStoreValue(i, "cbs", "cbs")));
        		rowparams.appendChild(createTagElement("pir", arg0.getCellStoreValue(i, "pir", "pir")));
        		rowparams.appendChild(createTagElement("pbs", arg0.getCellStoreValue(i, "pbs", "pbs")));
    	    }
    	}
    	else if ("0" == bdwLimit)
    	{
    		rowparams.appendChild(createTagElement("QosFlag", "0"));
    	}

        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApplyQoS()
{
	var tmpst = qospwst;
    var qosType = LOAD_TYPE_PW;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        qosType = LOAD_TYPE_PHY_PORT;
    }
    
	for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
    	if (tmpst.getCellModify(i, "cir") || tmpst.getCellModify(i, "cbs") 
            	|| tmpst.getCellModify(i, "pir") || tmpst.getCellModify(i, "pbs"))
        {
        	var tmpcir = tmpst.getCellStoreValue(i, "cir", "cir");
        	if (tmpcir == null || tmpcir == "")
        	{
        		alert(RESOURCE["ciralert"])
        		return;
        	}
        	var tmpcbs = tmpst.getCellStoreValue(i, "cbs", "cbs");
        	if (tmpcbs == null || tmpcbs == "")
        	{
        		alert(RESOURCE["cbsalert"])
        		return;
        	}
        	var tmppir = tmpst.getCellStoreValue(i, "pir", "pir");
        	if (tmppir == null || tmppir == "")
        	{
        		alert(RESOURCE["piralert"])
        		return;
        	}
        	var tmppbs = tmpst.getCellStoreValue(i, "pbs", "pbs");
        	if (tmppbs == null || tmppbs == "")
        	{
        		alert(RESOURCE["pbsalert"])
        		return;
        	}
        }
    }
    
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("applyqosbtn").disabled = true;
    
    var xml = createApplyQoSXml(tmpst, qosType);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_SET_QOS_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyQoSCallBack, null, "inputdata=" + xml);
}

function applyQoSCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var tmpst = qospwst;
    var tmptc = window.tableconf[5];
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        tmptc = window.tableconf[4];
    }
    refreshTableState(tmpst, tmptc, data);
    
    if (data.getSErrorCode() == 0)
    {
    	for (var i = 0; i < tmpst.getDataRowLength(); i++)
    	{
    		var cell = tmpst.getCell(i, "oldBandwidthlimit");
    		var cellvar = tmpst.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit");
    		tmpst.setCellValue(cell, "oldBandwidthlimit", cellvar);
    	}
    }
    
    if (data.getSErrorCode() != 0) 
    {
        $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
    }
}

function createMA(key)
{
    hideMenu();
    var mdid, mdname, maid, maname;
    var diaWidth = 300;
    var diaHeight = 150;
    
    var selectedRows = st.getSelectedRows();
    var serviceIndex = st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex")
    
    if (key == "MA") 
    {
        diaWidth = 450;
        diaHeight = 200;
        xshowModalDialog("createma.html?serviceIndex=" + serviceIndex, RESOURCE["createMA"], diaWidth, diaHeight, "../../../../../../images/");
    }
}

function doQueryMA()
{
    var xmlstr = createQueryMAXML(1);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_GET_MDELEMENT + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQueryMA, 1, "inputdata=" + xmlstr);
}

function createQueryMAXML(flg)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "mdid");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "queryFlg");
    param.setAttribute("value", flg);
    row.appendChild(param);
    
    var maid = 0;
    if (flg == "2") 
    {
        param = new tagElement("param");
        param.setAttribute("name", "servicetype");
        param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "servicetype", "servicetype"));
        row.appendChild(param);
        
        maid = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maid", "maid");
        
        param = new tagElement("param");
        param.setAttribute("name", "mepid");
        param.setAttribute("value", "0");
        row.appendChild(param);
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "maid");
    param.setAttribute("value", maid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryMA(doc, flg)
{
    mtunionTable.clearTableData();
    var selectedRows = st.getSelectedRows();
    
    var data = EncapsulateData(doc);
    if (0 == data.getError().getGlobleECode()) 
    {
        for (var i = data.getDataRowLength() - 1; i >= 0; i--) 
        {
            var serviceid = data.getDataRowParam(i, "serviceid1");
            var servicetype = data.getDataRowParam(i, "servicetype");
            if (servicetype != 4 || serviceid != st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID")) 
            {
                data.removeDataRowAt(i);
            }
        }
        $("applyMABtn").disabled = true;
        createTableBody(mtunionTable, window.tableconf[8], data, RESOURCE);
        addCellListener();
    }
    else 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../../page/", data.getError(), errArr);
    }
    changeBtnStatusMA(false);
    
}

function embedTabSelectHandler(id)
{
    if (id == "tab1div") 
    {
        doQueryUNI();
    }
    else if (id == "tab2div") 
    {
        if ($("pwtbl").style.display != "none") 
        {
            doQueryNNI(LOAD_TYPE_PW);
        }
        else 
        {
            doQueryNNI(LOAD_TYPE_PHY_PORT);
        }
    }
    else if (id == "tab3div") 
    {
        doQueryQoS();
    }
    else if (id == "tab4div") 
    {
        doQueryPortAttr();
    }
    else if (id == "tab6div") 
    {
    	doQueryMA();
    }
    else if (id == "tab7div") 
    {
    	doQueryMP();
    }
    else 
    {
        doQueryVlan();
    }
}

function applyMA()
{
    $("applyMABtn").disabled = true;
    
    var xml = createApplyMAXml();
    
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_SET_MA_PARA + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, applyMACallBack, null, "inputdata=" + xml);
}

function applyMACallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(mtunionTable, window.tableconf[8], data);
    
    if (0 != data.getSErrorCode()) 
    {
        $("applyMABtn").disabled = false;
    }
    else {
        $("applyMABtn").disabled = true;
    }
}

function createApplyMAXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isNoLog");
    param.setAttribute("value", "1");
    row.appendChild(param);
    bussiness.appendChild(row);
    
    for (var i = 0, len = mtunionTable.getDataRowLength(); i < len; i++) 
    {
    	if(!mtunionTable.getModify(i))
    	{
    		continue;
    	}

	    row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", neid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "auto1");
	    param.setAttribute("value", "0");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "mdid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "mdid", "mdid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "auto2");
	    param.setAttribute("value", "0");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "maid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "maid", "maid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "ccperiod");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "ccperiod", "ccperiod"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "block");
	    param.setAttribute("value", "modifyMA");
	    row.appendChild(param);
    
   	 	bussiness.appendChild(row);
  	}
  	
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function delMA(key)
{
	if (!confirm(RESOURCE["SERICE_DELETE_OAM_WARN"])) 
    {
        return;
    }
    var xml = createDelMAXML(key);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + delCmd + "&nmUser=" + nmUser;
    
    loadXMLdoc(urlreq, "POST", false, delMAOperBack, key, "inputdata=" + xml);
}

function delMAOperBack(doc, key)
{
    var data = EncapsulateData(doc);
    if (data.getError().getGlobleECode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../../page/", data.getError(), errArr);
        return;
    }
    else {
    
        while (mtunionTable.getSelectedRows().length > 0) 
        {
            var index = mtunionTable.getSelectedRows()[0];
            mtunionTable.deleteRow(index);
            mtunionTable.element.datarows.removeAt(index);
        }
        
        $("delMABtn").disabled = true;
        $("applyMABtn").disabled = true;
    }
}

function createDelMAXML(key)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var selectedRows = mtunionTable.getSelectedRows();
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    delCmd = TECMDCODE_IPPTN_ETH_OAM_DELETE_MA;
    
    for (var i = 0, len = selectedRows.length; i < len; i++) 
    {
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "mdid");
        param.setAttribute("value", mtunionTable.getCellStoreValue(selectedRows[i], "mdid", "mdid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maid");
        param.setAttribute("value", mtunionTable.getCellStoreValue(selectedRows[i], "maid", "maid"));
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createMP()
{
    hideMenu();
    var mdid, mdname, maid, maname;
    var diaWidth = 400;
    var diaHeight = 300;
    
    var selectedRows = st.getSelectedRows();
    var serviceIndex = st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex")
    
    
    xshowModalDialog("createmp.html?serviceIndex=" + serviceIndex, RESOURCE["createMP"], diaWidth, diaHeight, "../../../../../../images/");
    
}

function doQueryMP()
{
    var xmlstr = createQueryMPXML(2);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_GET_MDELEMENT + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQueryMP, 2, "inputdata=" + xmlstr);
}

function handleBackQueryMP(doc, flg)
{
    mepTable.clearTableData();
    var selectedRows = st.getSelectedRows();
    
    var data = EncapsulateData(doc);
    if (0 == data.getError().getGlobleECode()) 
    {
        for (var i = data.getDataRowLength() - 1; i >= 0; i--) 
        {
            var serviceid = data.getDataRowParam(i, "serviceid1");
            var servicetype = data.getDataRowParam(i, "servicetype");
            if (servicetype != 4 || serviceid != st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID")) 
            {
                data.removeDataRowAt(i);
            }
        }
        
        createTableBody(mepTable, window.tableconf[9], data, RESOURCE);
        $("applyMPBtn").disabled = true;
    }
    else 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../../page/", data.getError(), errArr);
    }
    
    changeBtnStatusMP(false);
}

function createQueryMPXML(flg)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "mdid");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "queryFlg");
    param.setAttribute("value", flg);
    row.appendChild(param);
    
    var maid = 0;
    if (flg == "2") 
    {
        param = new tagElement("param");
        param.setAttribute("name", "servicetype");
        param.setAttribute("value", "4");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "mepid");
        param.setAttribute("value", "0");
        row.appendChild(param);
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "maid");
    param.setAttribute("value", maid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function changeBtnStatusMP(status)
{
    $("queryMPBtn").disabled = status;
    $("createMPBtn").disabled = status;
    
    var arr = mepTable.getSelectedRows();
    if (arr.length <= 0) 
    {
        $("delMPBtn").disabled = true;
        $("oamMPBtn").disabled = true;
    }
}

function applyMP()
{
	$("applyMPBtn").disabled = true;
	
	var xml = createApplyMPXml();

	var urlreq ="../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_SET_MA_PARA + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, applyMPCallBack, null, "inputdata=" + xml);
}

function applyMPCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);

    refreshTableState(mepTable, window.tableconf[9], data);
    
    if(0 != data.getSErrorCode()) 
    {
        $("applyMPBtn").disabled = false;
    }
    else
    {    
    	$("applyMPBtn").disabled = true;
    }
}

function createApplyMPXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");    
  	param.setAttribute("name", "neid");
  	param.setAttribute("value", neid);
  	row.appendChild(param);
  
  	param = new tagElement("param");
 	param.setAttribute("name", "isNoLog");
 	param.setAttribute("value", "1");
  	row.appendChild(param);
  	bussiness.appendChild(row);
  
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","auto1");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","mdid");
    param.setAttribute("value",mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'mdid', 'mdid'));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","auto2");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","maid");
    param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'maid', 'maid'));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","ccperiod");
    param.setAttribute("value", "-1");
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","block");
    param.setAttribute("value","");
    row.appendChild(param);
 
    if(mepTable.getModify(0))
    {
        param = new tagElement("param");
        param.setAttribute("name","blockMEP");
        param.setAttribute("value","modifyMEP");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","mepid");
        param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'mepid', 'mepid'));
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name","ccstatus");
        param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'ccstatus', 'ccstatus'));
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name","aisstatus");
        param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'aisstatus', 'aisstatus'));
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name","clientlevel");
        param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'clientlevel', 'clientlevel'));
        row.appendChild(param);
		
		param = new tagElement("param");
        param.setAttribute("name","aisperiod");
        param.setAttribute("value", mepTable.getCellStoreValue(mepTable.getSelectedRows()[0], 'aisperiod', 'aisperiod'));
        row.appendChild(param);
    }

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function delMP(key)
{
	if (!confirm(RESOURCE["SERICE_DELETE_OAM_WARN"])) 
    {
        return;
    }
    var xml = createDelMPXML(key);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + delCmd + "&nmUser=" + nmUser;
    
    loadXMLdoc(urlreq, "POST", false, delOperMPBack, key, "inputdata=" + xml);
}

function delOperMPBack(doc, key)
{
    var data = EncapsulateData(doc);
    if (data.getError().getGlobleECode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../../page/", data.getError(), errArr);
        return;
    }
    else 
    {
        while (mepTable.getSelectedRows().length > 0) 
        {
            var index = mepTable.getSelectedRows()[0];
            mepTable.deleteRow(index);
            mepTable.element.datarows.removeAt(index);
        }
        
        $("delMPBtn").disabled = true;
        $("oamMPBtn").disabled = true;
    }
}

function createDelMPXML(key)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var selectedRows = mepTable.getSelectedRows();
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    delCmd = TECMDCODE_IPPTN_ETH_OAM_DELETE_MEP;
    
    for (var i = 0, len = selectedRows.length; i < len; i++) 
    {
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "mdid");
        param.setAttribute("value", mepTable.getCellStoreValue(selectedRows[i], "mdid", "mdid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maid");
        param.setAttribute("value", mepTable.getCellStoreValue(selectedRows[i], "maid", "maid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "mepid");
        param.setAttribute("value", mepTable.getCellStoreValue(selectedRows[i], "mepid", "mepid"));
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function setCC(status)
{
    var xml = createSetCcXML(status);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_SET_CCSTATUS + "&nmUser=" + nmUser;
    
    loadXMLdoc(urlreq, "POST", false, setCCBackHandler, status, "inputdata=" + xml);
}

function createSetCcXML(status)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var mepids = getSelectRows(mepTable, "mepid", "mepid");
    for (var i = 0, len = mepids.length; i < len; i++) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "auto1");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "mdid");
        param.setAttribute("value", mepTable.getCellStoreValue(i, "mdid", "mdid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "auto2");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maid");
        param.setAttribute("value", mepTable.getCellStoreValue(i, "maid", "maid"));
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "mepid");
        param.setAttribute("value", mepids[i]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ccstatus");
        param.setAttribute("value", status);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function setCCBackHandler(doc, status)
{
    var data = EncapsulateData(doc);
    if (data.getError().getGlobleECode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../../page/", data.getError(), errArr);
        return;
    }
    else 
    {
        status = RESOURCE[ccstatus[status]];
        var selRows = mepTable.getSelectedRows();
        for (var i = 0, len = selRows.length; i < len; i++) 
        {
            mepTable.setCellValue(mepTable.getCell(selRows[i], "ccstatus"), "ccstatus", status);
            mepTable.getCellShow(selRows[i], "ccstatus").setValue(status);
        }
    }
}

function start(val)
{
    hideMenu();
    switch (parseInt(val)) 
    {
        case 1:
            var dialogHeight = SYSTEMCONF.getLanguage() == "en" ? 666 : 540;
            xshowModalDialog("../../../page/ethservice/ethcommon/lbtest.html?isEaggrOpen=1", RESOURCE["lbtesttitle"], 630, dialogHeight, "../../../../../../images/");
            break;
        case 2:
            var dialogHeight = SYSTEMCONF.getLanguage() == "en" ? 550 : 500;
            xshowModalDialog("../../../page/ethservice/ethcommon/lttest.html?isEaggrOpen=1", RESOURCE["lttesttitle"], 630, dialogHeight, "../../../../../../images/");
            break;
        case 3:
            xshowModalDialog("sinkmep.html", RESOURCE["sinkmep"], 630, 470, "../../../../../../images/");
            break;
        default:
            break;
    }
}

function getSelectRows(tab, attrid)
{
    var selRows = tab.getSelectedRows();
    var arr = new Array();
    for (var i = 0, len = selRows.length; i < len; i++) 
    {
        arr.push(tab.getCellStoreValue(selRows[i], attrid, attrid));
    }
    
    return arr;
}
