var pwct = null;

function initGeneralTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    $("general").appendChild(ct.getTable());
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["source"], 2);
    atom.addOption(RESOURCE["sink"], 1);
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("location", RESOURCE["location"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwid", RESOURCE["pwid"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["static"], "1");
    atom.element.onchange = changeSignalType;
    ct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ethernet"], "5");
    atom.element.onchange = changePWType;
    ct.addAttrRow("pwtype", RESOURCE["pwtype"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["bidirectional"], "1");
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", 1);
    atom.element.onchange = changeEncapType;
    ct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["manually"], "0");
    ct.addAttrRow("tunnelmode", RESOURCE["tunnelmode"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.element.onchange = changeTunnelType;
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("tunnel", RESOURCE["ingresst"], atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel0";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("hadtunnel0").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["createbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel0";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("newtunnel0").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["usehad"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel0";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex0";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "ingressid0";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "egressid0";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.name = "0";
    elem.id = "tunnelBtn0";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom);
    
    
    /***************************************************************/
    atom = new Atom("span");
    ct.addAttrRow("tunnel_egress", RESOURCE["egresst"], atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel2";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("hadtunnel2").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["createbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel2";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("newtunnel2").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["usehad"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel2";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex2";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "ingressid2";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "egressid2";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.name = "2";
    elem.id = "tunnelBtn2";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    /***************************************************************/
    
    pwct = ct;
}

function initAdvancedTable()
{
    act = new CTable();
    act.addHead(RESOURCE["attribute"], RESOURCE["value"]);

    var atom = new Atom("select");
    atom.addOption(RESOURCE["nouse"], 1);
    atom.addOption(RESOURCE["usedfirst"], 2);
    act.addAttrRow("controlword", RESOURCE["controlword"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("CW", "1");
    atom.addOption("Alert Label", "2");
    atom.element.options.selectedIndex = 2;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Ping", "1");
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "4094");
    act.addAttrRow("requestvlan", RESOURCE["requestvlan"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "65535");
    act.addAttrRow("tpid", "TPID", atom);
    
    $("advance").appendChild(act.getTable());
}

function doSelectTunnel()
{
    
    
    var buttonIndex = this.name;
    
    var tunnelType = ct.getAtom("tunneltype").getValue();
    var nodetype = -1;
    
    if (buttonIndex == 0)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    
    
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 680, 450, "../../../../../../images/");
        }
    }
}

function validate()
{
    var msgArr = new Array();
    var notEntered = RESOURCE["notentered"];
    if (ct.getAtom("pwid").getValue() == "") 
    {
        msgArr[msgArr.length] = "PW ID" + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var pwEncapType = parseInt(ct.getAtom("pwencaptype").getValue());
    if (pwEncapType == 2) // UDP
    {
        labelRange = "49153~50176";
    }
    var v = ct.getAtom("pwinlabel").getValue();
    if (v != "-" && v == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    v = ct.getAtom("pwoutlabel").getValue();
    if (v != "-" && v == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    if ($("selectedtunnel0").value == "") 
    {
        msgArr[msgArr.length] = "Ingress Tunnel"
    }
    if ($("selectedtunnel2").value == "") 
    {
        msgArr[msgArr.length] = "Egress Tunnel"
    }
    v = ct.getAtom("oppsitelsrid").getValue();
    var arr = v.split(".");
    var fIp = parseInt(arr[0]);
    var tIp = parseInt(arr[3]);
    if (fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
    {
        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    
    return true;
}

function doCreate(param)
{
	if (param && $("applybtn").disabled)
	{
		xcloseDialog();
	}
	
    if (!validate()) 
    {
        return;
    }
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    rowParams.appendChild(createParamElement("vnniId", win.vnniID != null ? win.vnniID++ : "-"));
    rowParams.appendChild(createParamElement("role", ct.getAtom("location").getValue()));
    rowParams.appendChild(createParamElement("pwID", ct.getAtom("pwid").getValue()));
    rowParams.appendChild(createParamElement("pwIndex", 0));
    rowParams.appendChild(createParamElement("enableState", 1));
    var pwSignalType = parseInt(ct.getAtom("pwsignaltype").getValue());
    rowParams.appendChild(createParamElement("pwSignalType", pwSignalType));
    rowParams.appendChild(createParamElement("serviceType", ct.getAtom("pwtype").getValue()));
    rowParams.appendChild(createParamElement("direction", ct.getAtom("direction").getValue()));
    rowParams.appendChild(createParamElement("pwEncapsType", ct.getAtom("pwencaptype").getValue()));
    rowParams.appendChild(createParamElement("pwIngressLabel", ct.getAtom("pwinlabel").getValue()));
    rowParams.appendChild(createParamElement("pwEgressLabel", ct.getAtom("pwoutlabel").getValue()));
    rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(ct.getAtom("oppsitelsrid").getValue())));
    rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[ct.getAtom("tunneltype").getValue()]));
    rowParams.appendChild(createParamElement("tunnelindex", $("tunnelindex0").value));
    rowParams.appendChild(createParamElement("tunnelid", $("selectedtunnel0").value));
    
    rowParams.appendChild(createParamElement("ingressid", $("ingressid2").value)); 
    rowParams.appendChild(createParamElement("egressid", $("egressid2").value));
    rowParams.appendChild(createParamElement("tunnelid_e", $("tunnelindex2").value));
    
    rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword").getValue()));
    rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
    rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode").getValue()));
    rowParams.appendChild(createParamElement("requestVLAN", act.getAtom("requestvlan").getValue()));
    rowParams.appendChild(createParamElement("tpID", act.getAtom("tpid").getValue()));
    rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
    rowParams.appendChild(createParamElement("localWorkingStat", 0));
    rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
    rowParams.appendChild(createParamElement("compWorkingStat", 0));
    rowParams.appendChild(createParamElement("isApplyed", 0));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    createTableBody(win.nnipwst, win.nnipwtc, EncapsulateData(di), RESOURCE);
    
    win.needCreateNum++;
    
    win.addCellListener();
    var index = win.nnipwst.getDataRowLength() - 1;
    if (pwSignalType == 1) 
    {
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwIngressLabel"), 1);
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwEgressLabel"), 1);
    }
    
    if (win.$("applypwbtn")) 
    {
        win.$("applypwbtn").disabled = !win.btnRightArr.applybtn.right;
    }
    clearInputParam();
    /**
     * TRANSV1R8C00-3691 
     *           
     */
    if (!getNeProperty(self).isfromcrt)
    {
    	alert(RESOURCE["applyOprAlert"]);
    }
    
    if (param) 
    {
        xcloseDialog();
    }
    else 
    {
        $("applybtn").disabled = true;
    }
}
