var st = null;
var unist = null;
var nnipwst = null;
var nniportst = null;
var qosunist = null;
var qospwst = null;
var portattrst = null;
var vlanst = null;

var unitc = null;
var nnipwtc = null;
var nniporttc = null;

var tab = null;
var countObj = null;

var delUNIs = [];
var delNNIs = [];
var delPWs = [];

var winobj = getNeProperty(self);
var neid = winobj["neid"];
var nmUser = winobj["nmUser"];

var btnRightArr = new Object();

var resources = null;//  VLAN          

var needCreateNum = 0;
var isSupportEngressQos = false;
var isSupportEgressQos = false;
var isSupportIngressColor = false;
window.onload = function()
{
    initTable();
    initCountObj();
    initTabs();
    initButton();
    initText();
    
    swicthTab("pwlabel");
    isSupportEngressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIEGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIEGRESSPOLICY");
	isSupportIngressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSPOLICY");
	isSupportIngressColor = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSCOSCOLOR");
    if(!isSupportEngressQos && !isSupportIngressQos)
    {
    	$("qosunilabel").style.display = "none" ;
    	swicthTab("qospwlabel");
        /**
    	 *       DTS2011121000433 
    	 *      f00177546
    	 *             Qos                    UNI QOS
    	 *  
    	 */ 
        $("qosunitbl").style.display = "none" ;
    }
    initRight();
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("eaggrtbl").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("eaggrtbl"), 10) + "px");
    $("eaggrtbl").oncontextmenu = popupMenuHandler;
    
    unist = new SortTable();
    unitc = window.tableconf[1];
    unist.setImage("../../../../../../images/");
    createTableHead(unist, unitc);
    $("unitbl").appendChild(unist.getTable());
    unist.setBodyHeight(getComponetHeight($("unitbl"), 180) + "px");
    
    nnipwst = new SortTable();
    nnipwtc = window.tableconf[2];
    nnipwst.setImage("../../../../../../images/");
    nnipwst.setOnRowSelectHandler(rowSelectHandler_NNIPW);
    createTableHead(nnipwst, nnipwtc);
    $("pwtbl").appendChild(nnipwst.getTable());
    nnipwst.setBodyHeight(getComponetHeight($("pwtbl"), 180) + "px");
    $("pwtbl").oncontextmenu = popupMenuHandler_NNIPW;
    
    nniportst = new SortTable();
    nniporttc = window.tableconf[3];
    nniportst.setImage("../../../../../../images/");
    createTableHead(nniportst, nniporttc);
    $("porttbl").appendChild(nniportst.getTable());
    nniportst.setBodyHeight(getComponetHeight($("porttbl"), 180) + "px");
    
    qosunist = new SortTable();
    qosunist.setImage("../../../../../../images/");
    qosunist.setOnRowSelectHandler(rowSelectHandler_QoS);
    qosunist.setOnCellEditHandler(cellEditHandler_QoS);
    qosunist.isUsedForSelectList = true;
    createTableHead(qosunist, window.tableconf[4]);
    $("qosunitbl").appendChild(qosunist.getTable());
    qosunist.setBodyHeight(getComponetHeight($("qosunitbl"), 180) + "px");
    $("qosunitbl").oncontextmenu = popupMenuHandler_QoS;
    
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    qospwst.isUsedForSelectList = true;
    qospwst.setOnRowSelectHandler(rowSelectHandler_QoS);
    qospwst.setOnCellEditHandler(cellEditHandler_QoS);
    createTableHead(qospwst, window.tableconf[5]);
    $("qospwtbl").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("qospwtbl"), 180) + "px");
    $("qospwtbl").oncontextmenu = popupMenuHandler_QoS;
    
    portattrst = new SortTable();
    portattrst.setImage("../../../../../../images/");
    createTableHead(portattrst, window.tableconf[6]);
    $("portattrtbl").appendChild(portattrst.getTable());
    portattrst.setBodyHeight(getComponetHeight($("portattrtbl"), 180) + "px");
    
    vlanst = new SortTable();
    vlanst.setImage("../../../../../../images/");
    vlanst.setOnRowSelectHandler(rowSelectHandler_VLAN);
    createTableHead(vlanst, window.tableconf[7]);
    $("vlantbl").appendChild(vlanst.getTable());
    vlanst.setBodyHeight(getComponetHeight($("vlantbl"), 180) + "px");
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("printbtn").value = RESOURCE["printbutton"];
    
    $("cfgunibtn").value = RESOURCE["configbtn"];
    $("applyunibtn").value = RESOURCE["applybutton"];
    
    $("querypwbtn").value = RESOURCE["querybutton"];
    $("newpwbtn").value = RESOURCE["newbutton"];
    $("deletepwbtn").value = RESOURCE["deletebutton"];
    $("applypwbtn").value = RESOURCE["applybutton"];
    $("cfgnnibtn").value = RESOURCE["configbtn"];
    $("applynnibtn").value = RESOURCE["applybutton"];
    
    $("queryqosbtn").value = RESOURCE["querybutton"];
    $("querypolicybtn").value = RESOURCE["querypolicybtn"];
    $("applyqosbtn").value = RESOURCE["applybutton"];
    
    $("queryportattrbtn").value = RESOURCE["querybutton"];
    
    $("queryvlanbtn").value = RESOURCE["querybutton"];
    $("newvlanbtn").value = RESOURCE["newbutton"];
    $("deletevlanbtn").value = RESOURCE["deletebutton"];
}

function initText()
{
    $("pwlabel").innerHTML = "PW";
    $("portlabel").innerHTML = RESOURCE["port"];
    $("qosunilabel").innerHTML = "UNI";
    $("qospwlabel").innerHTML = "PW";
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", "UNI", $("tab1div"));
    tab.addEmbedTab("tab2div", "NNI", $("tab2div"));
    tab.addEmbedTab("tab3div", "QoS", $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["portattr"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["vlanforwardtableitem"], $("tab5div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMDCODE_IPPTN_QUERY_EAGGR);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_IPPTN_ADD_EAGGR);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_CMDCODE_IPPTN_DEL_EAGGR);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMDCODE_IPPTN_MOD_EAGGR);
    
    getRightInfo(winobj, btnRightArr);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
}

function swicthTab(arg)
{
    $(arg).className = "tabSelect";
    if (arg == "pwlabel") 
    {
        tabSelectFlg = "nnipw";
        $("portlabel").className = "tabUnselect";
        $("pwtbl").style.display = "inline";
        $("porttbl").style.display = "none";
        
        $("querypwbtn").style.display = "inline";
        $("newpwbtn").style.display = "inline";
        $("deletepwbtn").style.display = "inline";
        $("applypwbtn").style.display = "inline";
        $("cfgnnibtn").style.display = "none";
        $("applynnibtn").style.display = "none";
        
        doQueryNNI(LOAD_TYPE_PW);
    }
    else if (arg == "portlabel") 
    {
        tabSelectFlg = "nniport";
        $("pwlabel").className = "tabUnselect";
        $("pwtbl").style.display = "none";
        $("porttbl").style.display = "inline";
        
        $("querypwbtn").style.display = "none";
        $("newpwbtn").style.display = "none";
        $("deletepwbtn").style.display = "none";
        $("applypwbtn").style.display = "none";
        $("cfgnnibtn").style.display = "inline";
        $("applynnibtn").style.display = "inline";
        
        doQueryNNI(LOAD_TYPE_PHY_PORT);
    }
    else if (arg == "qosunilabel") 
    {
        tabSelectFlg = "qosuni";
        $("qospwlabel").className = "tabUnselect";
        $("qosunitbl").style.display = "inline";
        $("qospwtbl").style.display = "none";
        
        doQueryQoS();
    }
    else if (arg == "qospwlabel") 
    {
        tabSelectFlg = "qospw";
        $("qosunilabel").className = "tabUnselect";
        $("qosunitbl").style.display = "none";
        $("qospwtbl").style.display = "inline";
        doQueryQoS();
    }
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("cfgunibtn").disabled = !btnRightArr.newbtn.right;
        $("querypwbtn").disabled = !btnRightArr.querybtn.right;
        $("newpwbtn").disabled = !btnRightArr.newbtn.right;
        $("cfgnnibtn").disabled = !btnRightArr.newbtn.right;
        $("queryqosbtn").disabled = !btnRightArr.querybtn.right;
        $("queryportattrbtn").disabled = !btnRightArr.querybtn.right;
        $("queryvlanbtn").disabled = !btnRightArr.querybtn.right;
        $("newvlanbtn").disabled = !btnRightArr.newbtn.right;
        embedTabSelectHandler(tab.getSelectEmbedTab());
    }
    else 
    {
        $("deletebtn").disabled = true;
        $("cfgunibtn").disabled = true;
        $("querypwbtn").disabled = true;
        $("newpwbtn").disabled = true;
        $("cfgnnibtn").disabled = true;
        $("queryqosbtn").disabled = true;
        $("querypolicybtn").disabled = true;
        $("queryportattrbtn").disabled = true;
        $("queryvlanbtn").disabled = true;
        $("newvlanbtn").disabled = true;
        
        unist.clearTableData();
        nnipwst.clearTableData();
        nniportst.clearTableData();
        qosunist.clearTableData();
        qospwst.clearTableData();
        portattrst.clearTableData();
        vlanst.clearTableData();
    }
}

function cellEditHandler()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        if (st.getModify(i)) 
        {
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            break;
        }
    }
}

function cellEditHandler_QoS()
{
    $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
}

function rowSelectHandler_NNIPW()
{
    var selectedRowCount = nnipwst.getSelectedRowCount();
    
    if (selectedRowCount > 0) 
    {
        $("deletepwbtn").disabled = !btnRightArr.deletebtn.right;
    }
}

function rowSelectHandler_QoS()
{
    var tmpst = qospwst;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
    }
    
    var selectedRows = tmpst.getSelectedRows();
    if (selectedRows.length > 0) 
    {
        var policyId = parseInt(tmpst.getCellStoreValue(selectedRows[0], "policyId", "policyId"));
        if (policyId != INVALID_LABEL_VALUE_2) 
        {
            $("querypolicybtn").disabled = !btnRightArr.querybtn.right;
            return;
        }
    }
    $("querypolicybtn").disabled = true;
}

function rowSelectHandler_VLAN()
{
    var selectedRowCount = vlanst.getSelectedRowCount();
    if (selectedRowCount > 0) 
    {
        $("deletevlanbtn").disabled = !btnRightArr.deletebtn.right;
    }
    else 
    {
        $("deletevlanbtn").disabled = true;
    }
}

/**
 *       
 * @param {Object} evt
 */
function popupMenuHandler_NNIPW(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        createTablePopupMenu_NNIPW(rows, evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createTablePopupMenu_NNIPW(rows, evt)
{
    removejsDOMmenu();
    var enableMenu = false;//      
    var disableMenu = false;//      
    for (var i = 0; i < rows.length; i++) 
    {
        var enableState = nnipwst.getCellStoreValue(rows[i], "enableState", "enableState");
        if (enableState == ENABLED) 
        {
            disableMenu = true;//                   
        }
        else 
        {
            enableMenu = true;
        }
    }
    if( winobj.neType == "76" || winobj.neType == "77" || winobj.neType == "83" )
    {
    	var versionArray = winobj.neversion.split(".");
    	if( (versionArray[2] + "." + versionArray[3]) >= "03.30" )
    	{
    		disableMenu = false;		
    	}
    }
	if(SpecialAttrMgr.isNESupport(winobj.neid,"TE_FUNC_CFG_IPPTN_PW","PW_ATTR_NOTSUPPORT_DISABLED_MENU"))
	{
		disableMenu = false;
	}
    var menuWidth = 150;
    if(SYSTEMCONF.getLanguage() == "en")
	{
    	menuWidth = 210;
	}
    var cursorMenu1 = new jsDOMenu(menuWidth);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enabled"], "", doSetEnabledStat, ENABLED, enableMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["disabled"], "", doSetEnabledStat, DISABLED, disableMenu));
    
    if ((winobj["neType"] != "89") && (winobj["neType"] != "90")
		&& !SpecialAttrMgr.isNENotSupport(obj.neid,"TE_MSTP_ELINE","ELINE_ATTR_SUPPORT_CONTROL_WORD_MENU"))
    {
    	cursorMenu1.addMenuItem(new menuItem("-", "-", null, DISABLED, disableMenu))
    	cursorMenu1.addMenuItem(new menuItem(RESOURCE["controlWord_1"], "", doWord, 1, true));
    	cursorMenu1.addMenuItem(new menuItem(RESOURCE["controlWord_2"], "", doWord, 2, true));
    }
    
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

function doWord(word)
{
	removejsDOMmenu();
    var rows = nnipwst.getSelectedRows();
    var xml = createDoWordXML(word, rows);
    var param = [];
    param[0] = rows;
    param[1] = word;
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTN_MPLS_PW_CW + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, createDoWordXMLCallBack, param, "inputdata=" + xml);
}

function createDoWordXML(word)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = nnipwst.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = nnipwst.getCellCurrentValue(rows[i], "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
		var pwId = nnipwst.getCellCurrentValue(rows[i], "pwID", "pwID");
		row.appendChild(createTagElement("pwID", pwId));
		row.appendChild(createTagElement("autoassign", 0));
        
        var rowControlWord = nnipwst.getCellCurrentValue(rows[i], "controlWord", "controlWord");
        if (rowControlWord != word) 
        {
            row.appendChild(createTagElement("controlWord", word));
            var ctrlChanType = nnipwst.getCellCurrentValue(rows[i], "ctrlChanType", "ctrlChanType");
            row.appendChild(createTagElement("ctrlChanType", ctrlChanType));
            
            var vccv = nnipwst.getCellCurrentValue(rows[i], "vccv", "vccv");
            row.appendChild(createTagElement("vccv", vccv));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createDoWordXMLCallBack(doc, param)
{
	 var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = rows.length - 1; j >= 0; j--) 
        {
            var tempIndex = nnipwst.getCellCurrentValue(rows[j], "pwIndex", "pwIndex");
            if (pwIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var controlWordCell = nnipwst.getCell(rows[k], "controlWord");
        nnipwst.setCellValue(controlWordCell, "controlWord", param[1]);
        var cellShow = nnipwst.getCellShow(rows[k], "controlWord");
        cellShow.element.innerHTML = RESOURCE["controlWord_" + param[1]];
    }
}
/*
 * Add table popupmenu handler
 */
function popupMenuHandler_QoS(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent ||
    elem.editElement == null) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            if (colid == "policy") 
            {
                openDialog_QoS();
                return;
            }
            createTablePopupMenu(elem, evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                if (colid == "policy") 
                {
                    openDialog();
                    return;
                }
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
    }
}

function openDialog_QoS()
{
    var policyType = PW_POLICY;
    var tmpst = qospwst;
    if ($("qosunitbl").style.display != "none") 
    {
        policyType = VUNI_INGRESS_POLICY;
        tmpst = qosunist;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    
    if (tmpst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var index = tmpst.getSelectedRows()[0];
    var direction = st.getCellStoreValue(index, "direction", "direction");
    
    var url = "policyselect.html?policyType=" + policyType + "&direction=" + direction;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function embedTabSelectHandler(id)
{
    if (id == "tab1div") 
    {
        doQueryUNI();
    }
    else if (id == "tab2div") 
    {
        if ($("pwtbl").style.display != "none") 
        {
            doQueryNNI(LOAD_TYPE_PW);
        }
        else 
        {
            doQueryNNI(LOAD_TYPE_PHY_PORT);
        }
    }
    else if (id == "tab3div") 
    {
        doQueryQoS();
    }
    else if (id == "tab4div") 
    {
        doQueryPortAttr();
    }
    else 
    {
        doQueryVlan();
    }
}

function doQuery()
{
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createQueryXml();
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_QUERY_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(urlstr, "POST", false, queryCallBack, null, "inputdata=" + xmldata);
}

function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    st.clearTableData();
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
        }
    }
    
    rowSelectHandler();
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "serviceName");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
		st.getCellShow(i, "mtu").element.innerHTML = "-";
        
        if (st.getCellStoreValue(i, "serviceTagRole", "serviceTagRole") == null) 
        {
            st.getCellShow(i, "serviceTagRole").element.innerHTML = "-";
        }
    }
}

function doNew()
{
    xshowModalDialog("createeaggr.html", RESOURCE["configureport"], 650, 650, "../../../../../../images/");
}

function createDeleteXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0, m = rows.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("servType", 4));
        rowparams.appendChild(createTagElement("vnniId", 0));
        rowparams.appendChild(createTagElement("servIndex", st.getCellStoreValue(rows[i], "serviceIndex", "serviceIndex")));
        rowparams.appendChild(createTagElement("serviceID", st.getCellStoreValue(rows[i], "serviceID", "serviceID")));
        var serviceName = st.getCellStoreValue(rows[i], "serviceName", "serviceName");
        if (typeof(serviceName) != "undefined" && serviceName != null && serviceName != "") 
        {
            rowparams.appendChild(createTagElement("serviceName", serviceName));
        }
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["SERICE_DELETE_WARN"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDeleteXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_DEL_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var cesIndex = data.getBErrParam(i, "serviceIndex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var ces = st.getCellStoreValue(indexes[j], "serviceIndex", "serviceIndex");
            if (cesIndex == ces) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);
    }
    rowSelectHandler();
    cellEditHandler();
}

function createApplyXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
        rowparams.appendChild(createTagElement("serviceIndex", st.getCellStoreValue(i, "serviceIndex", "serviceIndex")));
        rowparams.appendChild(createTagElement("serviceID", st.getCellStoreValue(i, "serviceID", "serviceID")));
        
        if (st.getCellModify(i, "serviceName")) 
        {
            rowparams.appendChild(createTagElement("serviceName", st.getCellStoreValue(i, "serviceName", "serviceName")));
        }
        
        if (st.getCellModify(i, "mtu")) 
        {
            rowparams.appendChild(createTagElement("mtu", st.getCellStoreValue(i, "mtu", "mtu")));
        }
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("applybtn").disabled = true;
    
    var xml = createApplyXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_MOD_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function doPrint()
{
    openPrintPage("../../../../../../page/", "", "st");
}

function createQueryLogicIFXml(arg0, arg1, arg2)
{
    var serviceIndex = st.getCellStoreValue(arg0, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("servType", "4")); //        
    rowparams.appendChild(createTagElement("servIndex", serviceIndex));
    rowparams.appendChild(createTagElement(arg1, "0"));
    rowparams.appendChild(createTagElement("carrierType", arg2));
    rowparams.appendChild(createTagElement("isLogFlag", "0")); //      
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQueryUNI()
{
    $("applyunibtn").disabled = true;
    unist.clearTableData();
    
    var indexes = st.getSelectedRows();
    if (indexes.length <= 0) 
    {
        return;
    }
    
    var xml = createQueryLogicIFXml(indexes[0], "vuniId");
    
    if (null == xml) 
    {
        return;
    }
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_QUE_EAGGR_VUNI + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryUNICallBack, null, "inputdata=" + xml);
}

function queryUNICallBack(doc)
{

    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(unist, unitc, data, RESOURCE);
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = nnipwst.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = nnipwst.getCellCurrentValue(rows[i], "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
        
        var rowEnableState = nnipwst.getCellCurrentValue(rows[i], "enableState", "enableState");
        if (rowEnableState != enableState) 
        {
            row.appendChild(createTagElement("enableState", enableState));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var rows = nnipwst.getSelectedRows();
    var xml = createSetEnabledXML(enableState, rows);
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_PTN_PWTRIAL_ENABLE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, setEnabledCallBack, param, "inputdata=" + xml);
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = rows.length - 1; j >= 0; j--) 
        {
            var tempIndex = nnipwst.getCellCurrentValue(rows[j], "pwIndex", "pwIndex");
            if (pwIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = nnipwst.getCell(rows[k], "enableState");
        nnipwst.setCellValue(enableStateCell, "enableState", param[1]);
        var cellShow = nnipwst.getCellShow(rows[k], "enableState");
        cellShow.element.innerHTML = RESOURCE["enableState_" + param[1]];
    }
}

function doCfgUNI()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    xshowModalDialog("configureuniport.html?serviceIndex=" + serviceIndex, RESOURCE["configureport"], 600, 420, "../../../../../../images/");
}

function createApplyUNIXml()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = delUNIs.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
        rowparams.appendChild(createTagElement("delvuni", delUNIs[i]));
        bussiness.appendChild(rowparams);
    }
    
    for (var j = 0, n = unist.getDataRowLength(); j < n; j++) 
    {
        var vuniId = unist.getCellStoreValue(j, "vuniId", "vuniId");
        var role = unist.getCellStoreValue(j, "role", "role");
        var slotId = unist.getCellStoreValue(j, "port", "slotid");
        var portId = unist.getCellStoreValue(j, "portid", "port");
        var tagIds = unist.getCellStoreValue(j, "tagIds", "tagIds");
        
        if (typeof(vuniId) == "undefined" || vuniId == "" || vuniId == "-") 
        {
            var rowparams = new tagElement("row-params");
            rowparams.appendChild(createTagElement("neid", neid));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("role", role));
            rowparams.appendChild(createTagElement("slotid", slotId));
            rowparams.appendChild(createTagElement("port", portId));
            rowparams.appendChild(createTagElement("tagNum", "0"));
            rowparams.appendChild(createTagElement("tagID", tagIds));
            
            bussiness.appendChild(rowparams);
        }
        else if (unist.getCellModify(j, "tagIds")) 
        {
            var rowparams = new tagElement("row-params");
            rowparams.appendChild(createTagElement("neid", neid));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("modvuni", vuniId));
            rowparams.appendChild(createTagElement("tagNum", "0"));
            rowparams.appendChild(createTagElement("tagID", tagIds));
            
            bussiness.appendChild(rowparams);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApplyUNI()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("applyunibtn").disabled = true;
    
    var xml = createApplyUNIXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_MOD_EAGGRVUNI + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyUNICallBack, null, "inputdata=" + xml);
}

function applyUNICallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        doQueryUNI();
    }
    else 
    {
        $("applyunibtn").disabled = !btnRightArr.applybtn.right;
    }
}

function doQueryNNI(arg)
{
    $("deletepwbtn").disabled = true;
    $("applypwbtn").disabled = true;
    $("applynnibtn").disabled = true;
    
    var indexes = st.getSelectedRows();
    if (indexes.length <= 0) 
    {
        return;
    }
    
    var xml = createQueryLogicIFXml(indexes[0], "vnniId", arg);
    if (null == xml) 
    {
        return;
    }
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_QUE_EAGGR_VNNI + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryNNICallBack, arg, "inputdata=" + xml);
}

function queryNNICallBack(doc, arg)
{
    var tmpst = nnipwst;
    var tmptc = window.tableconf[2];
    if (arg == LOAD_TYPE_PHY_PORT) 
    {
        tmpst = nniportst;
        tmptc = nniporttc;
    }
    tmpst.clearTableData();
    needCreateNum = 0;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(tmpst, tmptc, data, RESOURCE);
    
    if (arg == LOAD_TYPE_PW) 
    {
        for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
        {
            var v = tmpst.getCellStoreValue(i, "requestVLAN", "requestVLAN")
            if (typeof(v) == "undefined") 
            {
                tmpst.getCellShow(i, "requestVLAN").element.innerHTML = "-";
            }
            v = tmpst.getCellStoreValue(i, "tunnelpolicy", "tunnelpolicy");
            if (typeof(v) == "undefined") 
            {
                tmpst.getCellShow(i, "tunnelpolicy").element.innerHTML = "-";
            }
            v = tmpst.getCellStoreValue(i, "tpID", "tpID");
            if (typeof(v) == "undefined" || parseInt(v) <= 0) 
            {
                tmpst.getCellShow(i, "tpID").element.innerHTML = "-";
            }
        }
    }
}

function doNewPW()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    xshowModalDialog("createpw.html?serviceIndex=" + serviceIndex, RESOURCE["configureport"], 680, 420, "../../../../../../images/");
}

function doDeletePW()
{
    delNNIs = [];
    delPWs = [];
    var indexes = nnipwst.getSelectedRows();
    for (var i = indexes.length - 1; i >= 0; i--) 
    {
        var vnniId = nnipwst.getCellStoreValue(indexes[i], "vnniId", "vnniId");
        var isApplyed = nnipwst.getCellStoreValue(indexes[i], "isApplyed", "isApplyed");
        if (typeof(vnniId) != "undefined" && vnniId != null && vnniId != "" && vnniId != "-" && "0" != isApplyed) 
        {
            delNNIs[delNNIs.length] = vnniId;
            delPWs[delPWs.length] = nnipwst.getCellStoreValue(indexes[i], "pwIndex", "pwIndex");
        }
        
        if ("0" == isApplyed)
        {
        	needCreateNum--;
        }
        
        nnipwst.deleteRow(indexes[i]);
    }
    nnipwst.adjustDataRows();
    
    $("deletepwbtn").disabled = true;
    if (delNNIs.length != 0 || needCreateNum > 0)
    {
    	$("applypwbtn").disabled = !btnRightArr.applybtn.right;
    	alert(RESOURCE["applyOprAlert"]);
    }
    else
    {
    	$("applypwbtn").disabled = true;
    }
}

function doCfgNNI()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    xshowModalDialog("configurenniport.html?serviceIndex=" + serviceIndex, RESOURCE["configureport"], 600, 420, "../../../../../../images/");
}

function createApplyNNIXml()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = delNNIs.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
        rowparams.appendChild(createTagElement("delvnni", delNNIs[i]));
        bussiness.appendChild(rowparams);
    }
    
    for (var j = 0, n = delPWs.length; j < n; j++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("delpw", delPWs[j]));
        bussiness.appendChild(rowparams);
    }
    
    var tmpst = nnipwst;
    var carrierType = LOAD_TYPE_PW;
    if ($("porttbl").style.display != "none") 
    {
        tmpst = nniportst;
        carrierType = LOAD_TYPE_PHY_PORT;
    }
    
    for (var k = 0, mn = tmpst.getDataRowLength(); k < mn; k++) 
    {
        var vnniId = tmpst.getCellStoreValue(k, "vnniId", "vnniId");
        var role = tmpst.getCellStoreValue(k, "role", "role");
        if (typeof(vnniId) == "undefined" || vnniId == "" || vnniId == null || vnniId == "-") 
        {
            var rowparams = new tagElement("row-params");
            rowparams.appendChild(createTagElement("neid", neid));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("vnniID", 0));
            rowparams.appendChild(createTagElement("role", role));
            rowparams.appendChild(createTagElement("carrierType", carrierType));
            
            if (LOAD_TYPE_PW == carrierType) 
            {
                rowparams.appendChild(createTagElement("carrierID1", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID3", INVALID_LABEL_VALUE_2));
                
                rowparams.appendChild(createTagElement("pwSignalType", tmpst.getCellStoreValue(k, "pwSignalType", "pwSignalType")));
                rowparams.appendChild(createTagElement("pwType", tmpst.getCellStoreValue(k, "serviceType", "serviceType")));
                rowparams.appendChild(createTagElement("pwID", tmpst.getCellStoreValue(k, "pwID", "pwID")));
                rowparams.appendChild(createTagElement("direction", tmpst.getCellStoreValue(k, "direction", "direction")));
                rowparams.appendChild(createTagElement("pwIngressLabel", tmpst.getCellStoreValue(k, "pwIngressLabel", "pwIngressLabel")));
                rowparams.appendChild(createTagElement("pwEgressLabel", tmpst.getCellStoreValue(k, "pwEgressLabel", "pwEgressLabel")));
                rowparams.appendChild(createTagElement("oppositeLsrID", tmpst.getCellStoreValue(k, "oppositeLsrID", "oppositeLsrID")));
                var tunnelIndexHex = tenToHex(tmpst.getCellStoreValue(k, "tunnelindex", "tunnelindex"));
                for (var i = tunnelIndexHex.length; i < 8; i++) 
                {
                    tunnelIndexHex = "0" + tunnelIndexHex;
                }
                rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
                rowparams.appendChild(createTagElement("pwEncapsType", tmpst.getCellStoreValue(k, "pwEncapsType", "pwEncapsType")));
                rowparams.appendChild(createTagElement("enableState", tmpst.getCellStoreValue(k, "enableState", "enableState")));
                rowparams.appendChild(createTagElement("controlWord", tmpst.getCellStoreValue(k, "controlWord", "controlWord")));
                rowparams.appendChild(createTagElement("ctrlChanType", tmpst.getCellStoreValue(k, "ctrlChanType", "ctrlChanType")));
                rowparams.appendChild(createTagElement("vccv", tmpst.getCellStoreValue(k, "vccv", "vccv")));
                var v = tmpst.getCellStoreValue(k, "requestVLAN", "requestVLAN");
                if (v != "" && v != "-") 
                {
                    rowparams.appendChild(createTagElement("requestVLAN", v));
                }
                v = tmpst.getCellStoreValue(k, "tpID", "tpID");
                if (v != "" && v != "-") 
                {
                    rowparams.appendChild(createTagElement("tpID", v));
                }
            }
            else 
            {
                rowparams.appendChild(createTagElement("carrierID1", tmpst.getCellStoreValue(k, "port", "slotid")));
                rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
                rowparams.appendChild(createTagElement("carrierID3", tmpst.getCellStoreValue(k, "portid", "port")));
            }
            bussiness.appendChild(rowparams);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApplyNNI()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("applypwbtn").disabled = true;
    $("applynnibtn").disabled = true;
    
    var xml = createApplyNNIXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_MOD_EAGGRVNNI + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyNNICallBack, null, "inputdata=" + xml);
}

function applyNNICallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        var carrierType = LOAD_TYPE_PW;
        if ($("porttbl").style.display != "none") 
        {
            carrierType = LOAD_TYPE_PHY_PORT;
        }
        doQueryNNI(carrierType);
    }
    else 
    {
        if ($("porttbl").style.display != "none") 
        {
            $("applynnibtn").disabled = !btnRightArr.applybtn.right;
        }
        else 
        {
            $("applypwbtn").disabled = !btnRightArr.applybtn.right;
        }
    }
}

function createQueryQoSXml(arg0, arg1, arg2)
{
    var serviceIndex = st.getCellStoreValue(arg0, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("servType", "4")); //        
    rowparams.appendChild(createTagElement("servIndex", serviceIndex));
    rowparams.appendChild(createTagElement(arg1, "0"));
    rowparams.appendChild(createTagElement("direction", "0"));
    rowparams.appendChild(createTagElement("qostype", arg2));
    rowparams.appendChild(createTagElement("isLogFlag", "0")); //      
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQueryQoS()
{
    $("querypolicybtn").disabled = true;
    $("applyqosbtn").disabled = true;
    
    var indexes = st.getSelectedRows();
    if (indexes.length <= 0) 
    {
        return;
    }
    
    var xml = null;
    var arg = null;
    if ($("qosunitbl").style.display != "none") 
    {
    	/**
    	 *       DTS2011121000433 
    	 *      f00177546
    	 *             Qos                    UNI QOS
    	 *   U2000       UNI            
    	 */    	
        arg = LOAD_TYPE_PHY_PORT;
        xml = createQueryQoSXml(indexes[0], "vuniId", arg);
    }
    else 
    {
        arg = LOAD_TYPE_PW;
        xml = createQueryQoSXml(indexes[0], "vnniId", arg);
    }
    
    if (null == xml) 
    {
        return;
    }
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_QUERY_QOS_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryQoSCallBack, arg, "inputdata=" + xml);
}

function queryQoSCallBack(doc, arg)
{
    var tmpst = qosunist;
    var tmptc = window.tableconf[4];
    if (arg == LOAD_TYPE_PW) 
    {
        tmpst = qospwst;
        tmptc = window.tableconf[5];
    }
    tmpst.clearTableData();
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(tmpst, tmptc, data, RESOURCE);
    
    var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
        var direction = parseInt(tmpst.getCellStoreValue(i, "direction", "direction"));
        handleTableQos(tmpst,i,arg);
        if (arg == LOAD_TYPE_PHY_PORT) 
        {
        	cell = tmpst.getCell(i, "cbs");
        	tmpst.setCellIsEdit(cell, 0);
        	tmpst.getCellShow(i, "cbs").element.innerHTML = "-";
    		cell = tmpst.getCell(i, "pbs");
    		tmpst.setCellIsEdit(cell, 0);
    		tmpst.getCellShow(i, "pbs").element.innerHTML = "-";
    		
            cell = tmpst.getCell(i, "policy");
            cell.element.ondblclick = openDialog_QoS;
            if (direction != INGRESS) 
            {
                cell = tmpst.getCell(i, "cos");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tmpst.getCell(i, "color");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
				if(!isSupportEngressQos)
				{
					tmpst.setCellIsEdit(tmpst.getCell(i,"policy"),0);
				}
            }
			else
			{
				if(!isSupportIngressQos)
				{
					tmpst.setCellIsEdit(tmpst.getCell(i,"policy"),0);
				}
			}
        }
        else 
        {
            if (direction == INGRESS) 
            {
                cell = tmpst.getCell(i, "lspmode");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
            }
            else 
            {
                cell = tmpst.getCell(i, "exp");
                tmpst.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
            }
        }
    }
}
function handleTableQos(st,rowindex,qostype)
{
	var bandwithlimit = st.getCellStoreValue(rowindex, "bandwidthlimit",
			"bandwidthlimit");
	var cell = null;
	if (bandwithlimit != "1") {
		var cell = st.getCell(rowindex, "cir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "cir").element.innerHTML = "-";

		cell = st.getCell(rowindex, "pir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "pir").element.innerHTML = "-";
		
		cell = st.getCell(rowindex, "cbs");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "cbs").element.innerHTML = "-";
		cell = st.getCell(rowindex, "pbs");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "pbs").element.innerHTML = "-";
	}
	textCheckWithStepLen(st.getCellEdit(rowindex, "cir").element, 0, 1000000, 64);
    textCheckWithStepLen(st.getCellEdit(rowindex, "pir").element, 0, 1000000, 64);
    textCheck(st.getCellEdit(rowindex, "cbs").element, 0, 4294967295);
    textCheck(st.getCellEdit(rowindex, "pbs").element, 0, 4294967295);
    appendBandWidthEvt(st,rowindex,qostype);
}

function appendBandWidthEvt(st,rowindex,qostype)
{
    var bandwidthlimitCell = st.getCellEdit(rowindex, "bandwidthlimit");
    bandwidthlimitCell.element.onchange = function ()
    {
    	 var selectIndex = st.getSelectedRows()[0];
    	 if(this.value ==1)
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 1);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "64";
    	 	st.setCellValue(cell, "cir", 64);
         
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 1);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "64";
             st.setCellValue(cell, "pir", 64);
             
             if(qostype == LOAD_TYPE_PW)
             {
	             cell = st.getCell(selectIndex, "pbs");
	             st.setCellIsEdit(cell, 1);
	             st.getCellShow(selectIndex, "pbs").element.innerHTML = "";
	             cell = st.getCell(selectIndex, "cbs");
	             st.setCellIsEdit(cell, 1);
	             st.getCellShow(selectIndex, "cbs").element.innerHTML = "";
             }
             else
             {
	             cell = st.getCell(selectIndex, "pbs");
	             st.setCellIsEdit(cell, 0);
	             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
	             cell = st.getCell(selectIndex, "cbs");
	             st.setCellIsEdit(cell, 0);
	             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             }
             
    	 }
    	 else
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 0);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "-";
         
             cell = st.getCell(selectIndex, "cbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
    	 }
    }
}

function createQueryPolicy()
{
    var tmpst = qospwst;
    var policyType = PW_POLICY;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        policyType = VUNI_INGRESS_POLICY;
    }
}

function doQueryPolicy()
{
    var tmpst = qospwst;
    var policyType = PW_POLICY;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        policyType = VUNI_INGRESS_POLICY;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    
    var tmpIndex = tmpst.getSelectedRows()[0];
    var policy = tmpst.getCellStoreValue(tmpIndex, "policy", "policy");
    if (typeof(policy) == "undefined" || null == policy || "" == policy) 
    {
        alert(RESOURCE["selectpolicy"]);
        return;
    }
    var url = "policyinfo.html?policyType=" + policyType + "&policyId=" + policy.substring(0, policy.indexOf("("));
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 580, 420, "../../../../../../images/");
}

function createApplyQoSXml(arg0, arg1)
{
    var index = st.getSelectedRows()[0];
    var serviceIndex = st.getCellStoreValue(index, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = arg0.getDataRowLength(); i < m; i++) 
    {
        if (!arg0.getModify(i)) 
        {
            continue;
        }
        
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        if (arg1 == LOAD_TYPE_PHY_PORT) 
        {
            rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
            rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
            rowparams.appendChild(createTagElement("autoVuniId", "0"));
            rowparams.appendChild(createTagElement("vuniId", arg0.getCellStoreValue(i, "vuniId", "vuniId")));
            rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
            
            if (arg0.getCellModify(i, "policy")) 
            {
                rowparams.appendChild(createTagElement("autoPolicy", "0"));
                var policy = arg0.getCellStoreValue(i, "policy", "policy");
                var policyInfo = policy;
                if (typeof(policy) == "undefined" || policy == "") 
                {
                    policy = INVALID_LABEL_VALUE_2;
                    policyInfo = "";
                }
                else 
                {
                    policy = policy.substring(0, policy.indexOf("("));
                }
                rowparams.appendChild(createTagElement("policyinfo", policyInfo));
                rowparams.appendChild(createTagElement("policy", policy));
            }
            
            if (arg0.getCellModify(i, "cos") || arg0.getCellModify(i, "color")) 
            {
                rowparams.appendChild(createTagElement("cos", arg0.getCellStoreValue(i, "cos", "cos")));
                rowparams.appendChild(createTagElement("color", arg0.getCellStoreValue(i, "color", "color")));
            }
        }
        else 
        {
            rowparams.appendChild(createTagElement("auto", "0"));
            rowparams.appendChild(createTagElement("pwIndex", arg0.getCellStoreValue(i, "pwIndex", "pwIndex")));
            rowparams.appendChild(createTagElement("pwID", arg0.getCellStoreValue(i, "pwID", "pwID")));
            rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
            
            if (arg0.getCellModify(i, "exp")) 
            {
                rowparams.appendChild(createTagElement("exp", arg0.getCellStoreValue(i, "exp", "exp")));
            }
            
            if (arg0.getCellModify(i, "lspmode")) 
            {
                rowparams.appendChild(createTagElement("lspmode", arg0.getCellStoreValue(i, "lspmode", "lspmode")));
            }
        }
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApplyQoS()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("applyqosbtn").disabled = true;
    
    var tmpst = qospwst;
    var qosType = LOAD_TYPE_PW;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        qosType = LOAD_TYPE_PHY_PORT;
    }
    var xml = createApplyQoSXml(tmpst, qosType);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_SET_QOS_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyQoSCallBack, null, "inputdata=" + xml);
}

function applyQoSCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var tmpst = qospwst;
    var tmptc = window.tableconf[5];
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        tmptc = window.tableconf[4];
    }
    refreshTableState(tmpst, tmptc, data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
    }
}

function createQueryPortAttrXml(arg)
{
    var serviceIndex = st.getCellStoreValue(arg, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("servType", "4")); //        
    rowparams.appendChild(createTagElement("servIndex", serviceIndex));
    rowparams.appendChild(createTagElement("vuniId", "0"));
    rowparams.appendChild(createTagElement("vnniId", "0"));
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function doQueryPortAttr()
{
    var indexes = st.getSelectedRows();
    if (indexes.length <= 0) 
    {
        return;
    }
    
    var xml = createQueryPortAttrXml(indexes[0]);
    
    if (null == xml) 
    {
        return;
    }
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_PORT_PHYATTR_QUERY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryPortAttrCallBack, null, "inputdata=" + xml);
}

function queryPortAttrCallBack(doc)
{
    portattrst.clearTableData();
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(portattrst, window.tableconf[6], data, RESOURCE);
    
    for (var i = 0, m = portattrst.getDataRowLength(); i < m; i++) 
    {
        var v = portattrst.getCellStoreValue(i, "enableport", "ATTR_ETHOVERPTN_MAC_ENABLE");
        if (typeof(v) == "undefined") 
        {
            portattrst.getCellShow(i, "enableport").element.innerHTML = "-";
        }
    }
    
    var ce = portattrst.getHeadCell("port").element;
    portattrst.sortRows(ce, 1);
}

function createQueryVlanXml(arg)
{
    var serviceIndex = st.getCellStoreValue(arg, "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
    rowparams.appendChild(createTagElement("vlanFwdID", "0"));
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQueryVlan()
{
    var indexes = st.getSelectedRows();
    if (indexes.length <= 0) 
    {
        return;
    }
    
    var xml = createQueryVlanXml(indexes[0]);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_QUERY_VLANFWD_ENTRY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryVlanCallBack, null, "inputdata=" + xml);
}

function queryVlanCallBack(doc)
{
    vlanst.clearTableData();
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    createTableBody(vlanst, window.tableconf[7], data, RESOURCE);
}

/**
 *   VLAN      VUNI VNNI
 */
function queryResource(arg)
{
    var xmldata = createQueryResXml(arg);
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GETAVAILBELERES + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryResCallBack, arg, "inputdata=" + xmldata);
}

/**
 *   VUNI VNNI  XML
 */
function createQueryResXml(arg)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("servType", "4")); //        
    rowparams.appendChild(createTagElement("servIndex", arg));
    rowparams.appendChild(createTagElement("vuniID", "0"));
    rowparams.appendChild(createTagElement("vnniID", "0"));
    rowparams.appendChild(createTagElement("isLogFlag", "0")); //      
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryResCallBack(doc, arg)
{
    resources = [];
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var resource = new Object();
            resource.iftype = data.getDataRowParam(i, "iftype");
            resource.ifid = data.getDataRowParam(i, "ifid");
            resource.role = data.getDataRowParam(i, "role");
            resource.name = data.getDataRowParam(i, "name");
            resources.push(resource);
        }
        xshowModalDialog("createvlantable.html?serviceIndex=" + arg, RESOURCE["createvlantable"], 400, 255, "../../../../../../images/");
    }
}

function doNewVlan()
{
    var rowcount = st.getSelectedRowCount();
    if (rowcount <= 0) 
    {
        return;
    }
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    queryResource(serviceIndex);
}

function createDeleteVlanXml()
{
    var serviceIndex = st.getCellStoreValue(st.getSelectedRows()[0], "serviceIndex", "serviceIndex");
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = vlanst.getSelectedRows();
    for (var i = 0, m = rows.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
        rowparams.appendChild(createTagElement("vlanFwdID", vlanst.getCellStoreValue(rows[i], "vlanFwdID", "vlanFwdID")));
        rowparams.appendChild(createTagElement("inLogicInfType", vlanst.getCellStoreValue(rows[i], "inLogicInfType", "inLogicInfType")));
        rowparams.appendChild(createTagElement("inLogicInf", vlanst.getCellStoreValue(rows[i], "srcPort", "srcPort")));
        rowparams.appendChild(createTagElement("inVlanID", vlanst.getCellStoreValue(rows[i], "inVlanID", "inVlanID")));
        rowparams.appendChild(createTagElement("outLogicInfType", vlanst.getCellStoreValue(rows[i], "outLogicInfType", "outLogicInfType")));
        rowparams.appendChild(createTagElement("outLogicInf", vlanst.getCellStoreValue(rows[i], "sinkPort", "sinkPort")));
        rowparams.appendChild(createTagElement("outVlanID", vlanst.getCellStoreValue(rows[i], "outVlanID", "outVlanID")));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDeleteVlan()
{
    if (!confirm(RESOURCE["SERICE_DELETE_VLAN_WARN"])) 
    {
        return;
    }
    
    $("deletebtn").disabled = true;
    var xml = createDeleteVlanXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_DEL_VLANFWD_ENTRY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteValnCallBack, null, "inputdata=" + xml);
}

function deleteValnCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = vlanst.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var vlanFwdID = data.getBErrParam(i, "vlanFwdID");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var fwdID = vlanst.getCellStoreValue(indexes[j], "vlanFwdID", "vlanFwdID");
            if (vlanFwdID == fwdID) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        vlanst.deleteRow(indexes[k]);
    }
    vlanst.adjustDataRows();
    
    rowSelectHandler_VLAN();
}
