var LOAD_TYPE_PW = 1; // PW
var LOAD_TYPE_PHY_PORT = 3; // PHY PORT
var INVALID_IP = 0; //   IP  
var INVALID_VALUE = "-"; //       
var INVALID_LABEL_VALUE_1 = 0; //    label 
var INVALID_LABEL_VALUE_2 = 0xFFFFFFFF; //    label 
var DISABLED = 0; //    
var ENABLED = 1; //   
var INGRESS = 1;
var EGRESS = 2;
var VUNI_INGRESS_POLICY = 2; //     VUNI
var VUNI_EGRESS_POLICY = 3; //     VUNI
var PW_POLICY = 4; //     PW
var QINQ_POLICY = 6;//QINQ    
var role = [];
role[1] = "sink";
role[2] = "source";

var pwSignalType = []; // PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = []; // PW  
pwType[4] = "pwType_4"; //   Tag  
pwType[5] = "pwType_5"; //   

var pwDirection = []; //   
pwDirection[0] = "pwDirection_0";
pwDirection[1] = "pwDirection_1";
pwDirection[2] = "pwDirection_2";

var pwEncapsType = [];//PW    
pwEncapsType[1] = "pwEncapsType_1";//MPLS
pwEncapsType[2] = "pwEncapsType_2";//UDP

var enableState = [];//    
enableState[0] = "disabled";//  
enableState[1] = "enabled"//  

var workingStat = [];
workingStat[0] = "workingStat_0";//UP
workingStat[1] = "workingStat_1";//     
workingStat[2] = "workingStat_2";
workingStat[4] = "workingStat_4";
workingStat[6] = "workingStat_6";
workingStat[8] = "workingStat_8";
workingStat[10] = "workingStat_10";
workingStat[12] = "workingStat_12";
workingStat[14] = "workingStat_14";
workingStat[16] = "workingStat_16";
workingStat[18] = "workingStat_18";
workingStat[20] = "workingStat_20";
workingStat[22] = "workingStat_22";
workingStat[24] = "workingStat_24";
workingStat[26] = "workingStat_26";
workingStat[28] = "workingStat_28";
workingStat[30] = "workingStat_30";
workingStat[32] = "workingStat_32";
workingStat[64] = "workingStat_64";

var tunnelType = [];
tunnelType["NSCMD_CFG_MPLS_GET_TUNNEL"] = "MPLS";
tunnelType["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = "IP";
tunnelType["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = "GRE";

var controlWord = [];//   
controlWord[1] = "controlWord_1";//   
controlWord[2] = "controlWord_2";//    
controlWord[3] = "controlWord_3";//    

var ctrlChanType = [];//      
ctrlChanType[0] = "ctrlChanType_0";//None
ctrlChanType[1] = "ctrlChanType_1";//CW
ctrlChanType[2] = "ctrlChanType_2";//Alert
ctrlChanType[3] = "ctrlChanType_3";//TTL 1

var vccv = [];//VCCV    
vccv[0] = "vccv_0";//None
vccv[1] = "vccv_1";//Ping
vccv[2] = "vccv_2";//BFD

var requestVLAN = [];//  VLAN
requestVLAN[0] = "disabled";//  
requestVLAN[1] = "enabled";//  

var exp = [];
exp[0] = "0";
exp[1] = "1";
exp[2] = "2";
exp[3] = "3";
exp[4] = "4";
exp[5] = "5";
exp[6] = "6";
exp[7] = "7";
exp[255] = "None";
exp[-1] = "-";

var lspMode = [];
lspMode[1] = "Uniform";
lspMode[2] = "Pipe";

var tagFlag = [];
tagFlag[0] = "Access";
tagFlag[1] = "Tag Aware";
tagFlag[2] = "Hybrid";
tagFlag[3] = "No Tag Aware";

var encapType = [];
encapType[0] =	"Null";
encapType[1] =	"802.1Q";
encapType[2] =	"QINQ";

var handleMode = [];
handleMode[1] = "Pass";
handleMode[2] = "Discard";
handleMode[3] = "Remark";

var ccperiod = [];
ccperiod[1] = "ccperiod1";
ccperiod[2] = "ccperiod2";
ccperiod[3] = "ccperiod3";
ccperiod[4] = "ccperiod4";
ccperiod[5] = "ccperiod5";
ccperiod[6] = "ccperiod6";
ccperiod[7] = "ccperiod7";

var direction = [];
direction[1] = "direction1";
direction[2] = "direction2";

var ccstatus = [];
ccstatus[0] = "inactive";
ccstatus[1] = "active";

function vlanstr(v)
{
    if (v == '65535') 
    {
        return '-';
    }
    else
    {
        return v;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createParamElement(name, value)
{
    var elem = document.createElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createErrorMsgElement(errorcode, errorinfo)
{
	var elem = document.createElement("error-message");
    elem.setAttribute("errorcode", errorcode);
    elem.setAttribute("errorinfo", errorinfo);
    return elem;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function convertBSLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function convertUNI(param)
{
	return "UNI ID:" + param;
}

function convertPrototype(arg)
{
    var tagIds = "";
    if (typeof(arg) != "undefined" && arg != "") 
    {
        var tmpArr = arg.split(",");
        for (var i = 0, m = tmpArr.length; i < m; i++) 
        {
            if (tmpArr[i].indexOf("-") < 0) 
            {
                tagIds += convertHex(tmpArr[i]);
            }
            else 
            {
                var arr = tmpArr[i].split("-");
                for (var j = parseInt(arr[0]); j <= parseInt(arr[1]); j++) 
                {
                    tagIds += convertHex(j);
                }
            }
        }
    }
    return tagIds;
}

function convertHex(arg)
{
    var v = tenToHex(parseInt(arg));
    for (var i = v.length; i < 8; i++) 
    {
        v = "0" + v;
    }
    return v;
}

function checkIntegrality()
{
    var count = 0;
    for (var i = 0, m = sst.getDataRowLength(); i < m; i++) 
    {
        var role = sst.getCellStoreValue(i, "role", "role");
        if (typeof(role) == "undefined" || role == "") 
        {
            alert(RESOURCE["positiontip"]);
            return false;
        }
        else if (parseInt(role) == 1) 
        {
            count++;
            if (count > 1) 
            {
                alert(RESOURCE["numtip"]);
                return false;
            }
        }
    }
    return true;
}

function handel_QosPW(curvar, curst, rowindex)
{
	var cirCell = curst.getCell(rowindex, "cir");
	var cbsCell = curst.getCell(rowindex, "cbs");
	var pirCell = curst.getCell(rowindex, "pir");
	var pbsCell = curst.getCell(rowindex, "pbs");
	
	var cirCellShow = curst.getCellShow(rowindex, "cir", "cir");
	var cbsCellShow = curst.getCellShow(rowindex, "cbs", "cbs");
	var pirCellShow = curst.getCellShow(rowindex, "pir", "pir");
	var pbsCellShow = curst.getCellShow(rowindex, "pbs", "pbs");
	
	if (curvar == "1")
	{
        setCellStatus(cirCell, cirCellShow, 1, "64", curst, "cir");
        setCellStatus(cbsCell, cbsCellShow, 1, "", curst, "cbs");
        setCellStatus(pirCell, pirCellShow, 1, "64", curst, "pir");
        setCellStatus(pbsCell, pbsCellShow, 1, "", curst, "pbs");
	}
	else
	{
		setCellStatus(cirCell, cirCellShow, 0, "-", curst, "cir");
        setCellStatus(cbsCell, cbsCellShow, 0, "-", curst, "cbs");
        setCellStatus(pirCell, pirCellShow, 0, "-", curst, "pir");
        setCellStatus(pbsCell, pbsCellShow, 0, "-", curst, "pbs");
	}
}

function setCellStatus(cell, cellShow, isEdit, cellvar, st, colid)
{
	st.setCellIsEdit(cell,isEdit);
	
	if (isEdit == "0")
	{
		cell.element.modify = false;
		cell.element.style.backgroundColor = "";
		cell.element.ondblclick = null;
		cell.element.style.cursor = "";
	}
	else
	{
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		cell.element.ondblclick = cellondbclick;
	}
	
	cellShow.setValue(cellvar);
	st.setCellValue(cell, colid, cellvar);
}
