var ct = null;

var ROLE_ROOT = 1;
var ROLE_LEAF = 2;

var IF_VUNI = 1;
var IF_VNNI = 2;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

window.onload = function()
{
    initPage();
    initTable();
    initInterface();
}

function initPage()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("V-UNI", 1);
    atom.addOption("V-NNI", 2);
    atom.element.onchange = function()
    {
        changeInterfaceType(this.value, ROLE_LEAF);
    }
    ct.addAttrRow("sourceinterfacetype", RESOURCE["sourceinterfacetype"], atom);
    
    atom = new Atom("select");
    ct.addAttrRow("sourceinterface", RESOURCE["sourceinterface"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4094");
    ct.addAttrRow("sourcevlanid", RESOURCE["sourcevlanid"], atom);
    
    var atom = new Atom("select");
    atom.addOption("V-UNI", 1);
    atom.addOption("V-NNI", 2);
    atom.element.onchange = function()
    {
        changeInterfaceType(this.value, ROLE_ROOT);
    }
    ct.addAttrRow("sinkinterfacetype", RESOURCE["sinkinterfacetype"], atom);
    
    atom = new Atom("select");
    ct.addAttrRow("sinkinterface", RESOURCE["sinkinterface"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4094");
    ct.addAttrRow("sinkvlanid", RESOURCE["sinkvlanid"], atom);
    
    $("ctbl").appendChild(ct.getTable());
}

function initInterface()
{
    var srcAtom = ct.getAtom("sourceinterface");
    var srcType = ct.getAtom("sourceinterfacetype").getValue();
    var snkAtom = ct.getAtom("sinkinterface");
    var snkType = ct.getAtom("sinkinterfacetype").getValue();
    
    var resource = null;
    for (var i = 0, m = win.resources.length; i < m; i++) 
    {
        resource = win.resources[i];
        if (resource.role == ROLE_LEAF) 
        {
            if (resource.iftype == srcType) 
            {
                srcAtom.addOption(resource.name, resource.ifid);
            }
        }
        else 
        {
            if (resource.iftype == snkType) 
            {
                snkAtom.addOption(resource.name, resource.ifid);
            }
        }
    }
}

function changeInterfaceType(arg0, arg1)
{
    var atom = ct.getAtom("sourceinterface");
    if (arg1 == ROLE_ROOT) 
    {
        atom = ct.getAtom("sinkinterface");
    }
    atom.removeAllOptions();
    
    var resource = null;
    for (var i = 0, m = win.resources.length; i < m; i++) 
    {
        resource = win.resources[i];
        if (resource.role == arg1) 
        {
            if (resource.iftype == arg0) 
            {
                atom.addOption(resource.name, resource.ifid);
            }
        }
    }
}

function validate()
{
    if (ct.getAtom("sourceinterface").getValue() == "") 
    {
        alert(RESOURCE["selectsource"]);
        return false;
    }
    if (ct.getAtom("sourcevlanid").getValue() == "") 
    {
        alert(RESOURCE["writesource"]);
        return false;
    }
    if (ct.getAtom("sinkinterface").getValue() == "") 
    {
        alert(RESOURCE["selectsink"]);
        return false;
    }
    if (ct.getAtom("sinkvlanid").getValue() == "") 
    {
        alert(RESOURCE["writesink"]);
        return false;
    }
    return true;
}

function createNewXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
    rowparams.appendChild(createTagElement("serviceIndex", getNeProperty(self).serviceIndex));
    rowparams.appendChild(createTagElement("autoVlanFwdID", "1"));
    rowparams.appendChild(createTagElement("vlanFwdID", "0"));
    rowparams.appendChild(createTagElement("autoInLogicInfID", "0"));
    
    var options = ct.getAtom("sourceinterface").element.options;
    var option = options[options.selectedIndex];
    rowparams.appendChild(createTagElement("inLogicInfID", option.value));
    rowparams.appendChild(createTagElement("inLogicInf", option.text));
    rowparams.appendChild(createTagElement("inLogicInfType", ct.getAtom("sourceinterfacetype").getValue()));
    rowparams.appendChild(createTagElement("inVlanID", ct.getAtom("sourcevlanid").getValue()));
    rowparams.appendChild(createTagElement("autoOutLogicInfID", "0"));
    
    options = ct.getAtom("sinkinterface").element.options;
    option = options[options.selectedIndex];
    rowparams.appendChild(createTagElement("outLogicInfID", option.value));
    rowparams.appendChild(createTagElement("outLogicInf", option.text));
    rowparams.appendChild(createTagElement("outLogicInfType", ct.getAtom("sinkinterfacetype").getValue()));
    rowparams.appendChild(createTagElement("outVlanID", ct.getAtom("sinkvlanid").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(arg)
{
    if (!validate()) 
    {
        return;
    }
    
    if (win.st) 
    {
        var xml = createNewXml();
        var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_ADD_VLANFWD_ENTRY + "&nmUser=" + nmUser;
        loadXMLdoc(url, "POST", false, createCallBack, arg, "inputdata=" + xml);
    }
    else 
    {
    	fillVlanTableData(arg);
    }
}

function createCallBack(doc, arg)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0) 
    {
        var vlanFwdID = data.getDataRowParam(0, "vlanFwdID");
        
        var di = document.createElement("datainterface");
        var bparams = document.createElement("bussiness-params");
        
        var rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("vlanFwdID", vlanFwdID));
        
        var options = ct.getAtom("sourceinterface").element.options;
        var option = options[options.selectedIndex];
        rowParams.appendChild(createParamElement("inLogicInfID", option.value));
        rowParams.appendChild(createParamElement("inLogicInfType", ct.getAtom("sourceinterfacetype").getValue()));
        rowParams.appendChild(createParamElement("srcPort", option.text));
        rowParams.appendChild(createParamElement("inVlanID", ct.getAtom("sourcevlanid").getValue()));
        
        options = ct.getAtom("sinkinterface").element.options;
        option = options[options.selectedIndex];
        
        rowParams.appendChild(createParamElement("outLogicInfID", option.value));
        rowParams.appendChild(createParamElement("outLogicInfType", ct.getAtom("sinkinterfacetype").getValue()));
        rowParams.appendChild(createParamElement("sinkPort", option.text));
        rowParams.appendChild(createParamElement("outVlanID", ct.getAtom("sinkvlanid").getValue()));
        
        bparams.appendChild(rowParams);
        di.appendChild(bparams);
        
        createTableBody(win.vlanst, win.window.tableconf[7], EncapsulateData(di), RESOURCE);
        
        if (arg) 
        {
            xcloseDialog();
        }
    }
}

function fillVlanTableData(arg)
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    rowParams.appendChild(createParamElement("vlanFwdID", 0));
    rowParams.appendChild(createParamElement("inLogicInfID", ct.getAtom("sourceinterface").getValue()));
    rowParams.appendChild(createParamElement("inLogicInfType", ct.getAtom("sourceinterfacetype").getValue()));
    var options = ct.getAtom("sourceinterface").element.options;
    var option = options[options.selectedIndex];
    rowParams.appendChild(createParamElement("srcPort", option.text));
    rowParams.appendChild(createParamElement("inVlanID", ct.getAtom("sourcevlanid").getValue()));
    
    rowParams.appendChild(createParamElement("outLogicInfID", ct.getAtom("sinkinterface").getValue()));
    rowParams.appendChild(createParamElement("outLogicInfType", ct.getAtom("sinkinterfacetype").getValue()));
    options = ct.getAtom("sinkinterface").element.options;
    option = options[options.selectedIndex];
    rowParams.appendChild(createParamElement("sinkPort", option.text));
    rowParams.appendChild(createParamElement("outVlanID", ct.getAtom("sinkvlanid").getValue()));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    createTableBody(win.vlanst, win.vlantc, EncapsulateData(di), RESOURCE);
    
    if (arg) 
    {
        xcloseDialog();
    }
}
