var ct = null;
var act = null;

var tab = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;


var tunnelTypes = [];
tunnelTypes[TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL] = "NSCMD_CFG_MPLS_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_GRETUNNEL_QUERY] = "NSCMD_CFG_GRE_TNL_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_IPTUNNEL_QUERY] = "NSCMD_CFG_IP_TNL_GET_TUNNEL";

function init()
{
	intNeVersion();
    initGeneralTable();
    initAdvancedTable();
    initUI();
    initTabs();
}

function intNeVersion()
{
	if(getNeProperty(self) != null)
	{
		neversion = getNeProperty(self).neversion;
	}
	else
	{
		neversion = win.win.winobj.neversion;
	}
}

function initGeneralTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    $("general").appendChild(ct.getTable());
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["source"], 2);
    atom.addOption(RESOURCE["sink"], 1);
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("location", RESOURCE["location"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwid", RESOURCE["pwid"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["static"], "1");
    atom.addOption(RESOURCE["dynamic"], "2");
    atom.element.onchange = changeSignalType;
    ct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ethernet"], "5");
    atom.addOption(RESOURCE["ethernettag"], "4");
    atom.element.onchange = changePWType;
    ct.addAttrRow("pwtype", RESOURCE["pwtype"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["bidirectional"], "1");
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", 1);
    atom.addOption("UDP", 2);
    atom.element.onchange = changeEncapType;
    ct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["manually"], "0");
    ct.addAttrRow("tunnelmode", RESOURCE["tunnelmode"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
    atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
    atom.element.onchange = changeTunnelType;
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("tunnel", "Tunnel", atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("hadtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["createbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel";
    elem.onclick = function()
    {
		$("applybtn").disabled = false;
        $("newtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["usehad"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom);
}

function initAdvancedTable()
{
    act = new CTable();
    act.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["usedfirst"], 2);
    atom.addOption(RESOURCE["nouse"], 1);
    act.addAttrRow("controlword", RESOURCE["controlword"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("CW", "1");
    if (compare(neversion, "5.76.01.40") > 0 && compare(neversion, "5.76.01.99") < 0)
    {
        atom.addOption("Alert Label", "2");
    }
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Ping", "1");
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "4094");
    act.addAttrRow("requestvlan", RESOURCE["requestvlan"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    checkText(atom.element, "1", "65535");
    act.addAttrRow("tpid", "TPID", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    $("advance").appendChild(act.getTable());
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["generalattr"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["advancedattr"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function changeSignalType()
{
	$("applybtn").disabled = false;
	
    var encapTypeAtom = ct.getAtom("pwencaptype");
    var inLabelAtom = ct.getAtom("pwinlabel");
    var outLabelAtom = ct.getAtom("pwoutlabel");
    var tunnelTypeAtom = ct.getAtom("tunneltype");
    if (parseInt(this.value) == 2) 
    {
        var encapType = encapTypeAtom.getValue();
        if (encapType != 1) 
        {
            encapTypeAtom.element.options.selectedIndex = 0;
            tunnelTypeAtom.clearOptions();
            tunnelTypeAtom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
            tunnelTypeAtom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
            tunnelTypeAtom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        }
        encapTypeAtom.element.disabled = true;
        inLabelAtom.element.disabled = true;
        inLabelAtom.setValue("-");
        outLabelAtom.element.disabled = true;
        outLabelAtom.setValue("-");
    }
    else 
    {
        encapTypeAtom.element.disabled = false;
        inLabelAtom.element.disabled = false;
        inLabelAtom.setValue("");
        outLabelAtom.element.disabled = false;
        outLabelAtom.setValue("");
    }
}

function changeEncapType()
{
	$("applybtn").disabled = false;
	
    var atom = ct.getAtom("tunneltype");
    atom.clearOptions();
    if (this.value == 1) 
    {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        
        atom = ct.getAtom("pwinlabel");
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
        atom = ct.getAtom("pwoutlabel");
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        
        atom = ct.getAtom("pwinlabel");
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
        atom = ct.getAtom("pwoutlabel");
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
    }
}

function changePWType()
{
	$("applybtn").disabled = false;
	
    var ratom = act.getAtom("requestvlan");
    var tatom = act.getAtom("tpid");
    if (parseInt(this.value) == 4) 
    {
        ratom.setValue(1);
        ratom.element.disabled = false;
        
        tatom.setValue(34984);
        tatom.element.disabled = false;
    }
    else 
    {
        ratom.setValue("-");
        ratom.element.disabled = true;
        
        tatom.setValue("-");
        tatom.element.disabled = true;
    }
}

function changeTunnelType()
{
	$("applybtn").disabled = false;
	
    $("selectedtunnel").value = "";
    $("tunnelindex").value = "";
    ct.getAtom("oppsitelsrid").setValue("0.0.0.0");
}

function doSelectTunnel()
{
    var tunnelType = ct.getAtom("tunneltype").getValue();
    if ($("hadtunnel").checked) 
    {
        xshowModalDialog("../ethcommon/selecttunnel.html?tunnelType=" + tunnelType+"&nodeType=1", RESOURCE["resourceselected"], 680, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../ethcommon/createmplstunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 680, 600, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 680, 450, "../../../../../../images/");
        }
    }
}

function validate()
{
    var msgArr = new Array();
    var notEntered = RESOURCE["notentered"];
    if (ct.getAtom("pwid").getValue() == "") 
    {
        msgArr[msgArr.length] = "PW ID" + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var pwEncapType = parseInt(ct.getAtom("pwencaptype").getValue());
    if (pwEncapType == 2) // UDP
    {
        labelRange = "49153~50176";
    }
    var v = ct.getAtom("pwinlabel").getValue();
    if (v != "-" && v == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    v = ct.getAtom("pwoutlabel").getValue();
    if (v != "-" && v == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    if ($("selectedtunnel").value == "") 
    {
        msgArr[msgArr.length] = "Tunnel"
    }
    v = ct.getAtom("oppsitelsrid").getValue();
    var arr = v.split(".");
    var fIp = parseInt(arr[0]);
    var tIp = parseInt(arr[3]);
    if (fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
    {
        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    
    return true;
}

function doCreate(param)
{
	if (param && $("applybtn").disabled)
	{
		xcloseDialog();
	}
	
    if (!validate()) 
    {
        return;
    }
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    rowParams.appendChild(createParamElement("vnniId", win.vnniID != null ? win.vnniID++ : "-"));
    rowParams.appendChild(createParamElement("role", ct.getAtom("location").getValue()));
    rowParams.appendChild(createParamElement("pwID", ct.getAtom("pwid").getValue()));
    rowParams.appendChild(createParamElement("pwIndex", 0));
    rowParams.appendChild(createParamElement("enableState", 1));
    var pwSignalType = parseInt(ct.getAtom("pwsignaltype").getValue());
    rowParams.appendChild(createParamElement("pwSignalType", pwSignalType));
    rowParams.appendChild(createParamElement("serviceType", ct.getAtom("pwtype").getValue()));
    rowParams.appendChild(createParamElement("direction", ct.getAtom("direction").getValue()));
    rowParams.appendChild(createParamElement("pwEncapsType", ct.getAtom("pwencaptype").getValue()));
    rowParams.appendChild(createParamElement("pwIngressLabel", ct.getAtom("pwinlabel").getValue()));
    rowParams.appendChild(createParamElement("pwEgressLabel", ct.getAtom("pwoutlabel").getValue()));
    rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(ct.getAtom("oppsitelsrid").getValue())));
    rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[ct.getAtom("tunneltype").getValue()]));
    rowParams.appendChild(createParamElement("tunnelindex", $("tunnelindex").value));
    rowParams.appendChild(createParamElement("tunnelid", $("selectedtunnel").value));
    
    rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword").getValue()));
    rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
    rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode").getValue()));
    rowParams.appendChild(createParamElement("requestVLAN", act.getAtom("requestvlan").getValue()));
    rowParams.appendChild(createParamElement("tpID", act.getAtom("tpid").getValue()));
    rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
    rowParams.appendChild(createParamElement("localWorkingStat", 0));
    rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
    rowParams.appendChild(createParamElement("compWorkingStat", 0));
    rowParams.appendChild(createParamElement("isApplyed", 0));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    createTableBody(win.nnipwst, win.nnipwtc, EncapsulateData(di), RESOURCE);
    
    win.needCreateNum++;
    
    win.addCellListener();
    var index = win.nnipwst.getDataRowLength() - 1;
    if (pwSignalType == 1) 
    {
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwIngressLabel"), 1);
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwEgressLabel"), 1);
    }
    
    if (win.$("applypwbtn")) 
    {
        win.$("applypwbtn").disabled = !win.btnRightArr.applybtn.right;
    }
    clearInputParam();
    
    alert(RESOURCE["applyOprAlert"]);
    
    if (param) 
    {
        xcloseDialog();
    }
    else 
    {
        $("applybtn").disabled = true;
    }
}
function clearInputParam()
{
	ct.getAtom("pwid").setValue("");
	ct.getAtom("pwinlabel").setValue("");
	ct.getAtom("pwoutlabel").setValue("");
	
}
