var ct = null;
var unist = null;
var nnipwst = null;
var nniportst = null;
var vlanst = null;

var unitc = null;
var nnipwtc = null;
var nniporttc = null;
var vlantc = null;

var tab = null;

var resources = null;

var vuniID = 1;
var vnniID = 1;

var qosUni = [];
var qosNni = [];

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var tunnelTypes = [];
tunnelTypes["NSCMD_CFG_MPLS_GET_TUNNEL"] = TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL;
tunnelTypes["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = TECMDCODE_PTN_GRETUNNEL_QUERY;
tunnelTypes["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = TECMDCODE_PTN_IPTUNNEL_QUERY;

function init()
{
    initTable();
    initUI();
    initTabs();
    
    swicthTab("pwlabel");
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");
    atom.setValue(1);
    checkText(atom.element, "1", "4294967294");
    ct.addAttrRow("serviceid", RESOURCE["serviceid"], atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("servicename", RESOURCE["servicename"], atom);
    
    atom = new Atom("text");
	atom.element.disabled = true;
	atom.setValue("-");
    ct.addAttrRow("mtu", RESOURCE["mtu"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue("-");
    ct.addAttrRow("servicetagrole", RESOURCE["servicetagrole"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
    
    unist = new SortTable();
    unitc = window.tableconf[0];
    unitc.colArray[0].width = "0%";
    unist.setImage("../../../../../../images/");
    createTableHead(unist, unitc);
    $("vunitbl").appendChild(unist.getTable());
    unist.setBodyHeight(getComponetHeight($("vunitbl"), 33) + "px");
    
    nnipwst = new SortTable();
    nnipwtc = window.tableconf[1];
    nnipwtc.colArray[0].width = "0%";
    nnipwtc.colArray[2].cell.isEdit = 1;
    nnipwtc.colArray[11].cell.isEdit = 1;
    nnipwtc.colArray[14].cell.isEdit = 1;
    nnipwst.setImage("../../../../../../images/");
    nnipwst.setOnCellEditHandler(cellEditHandler);
    createTableHead(nnipwst, nnipwtc);
    $("pwtbl").appendChild(nnipwst.getTable());
    nnipwst.setBodyHeight(getComponetHeight($("pwtbl"), 33) + "px");
    
    nniportst = new SortTable();
    nniporttc = window.tableconf[2];
    nniporttc.colArray[0].width = "0%";
    nniportst.setImage("../../../../../../images/");
    createTableHead(nniportst, nniporttc);
    $("porttbl").appendChild(nniportst.getTable());
    nniportst.setBodyHeight(getComponetHeight($("porttbl"), 33) + "px");
    
    vlanst = new SortTable();
    vlantc = window.tableconf[3];
    vlanst.setImage("../../../../../../images/");
    createTableHead(vlanst, vlantc);
    $("vlantbl").appendChild(vlanst.getTable());
    vlanst.setBodyHeight(getComponetHeight($("vlantbl"), 33) + "px");
}

function initUI()
{
    $("cfgqosbtn").value = RESOURCE["cfgqosbtn"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
    $("cfgunibtn").value = RESOURCE["configbtn"];
    
    $("newpwbtn").value = RESOURCE["newbutton"];
    $("deletepwbtn").value = RESOURCE["deletebutton"];
    $("cfgnnibtn").value = RESOURCE["configbtn"];
    
    $("newvlanbtn").value = RESOURCE["newbutton"];
    $("deletevlanbtn").value = RESOURCE["deletebutton"];
    
    $("pwlabel").innerHTML = "PW";
    $("portlabel").innerHTML = RESOURCE["port"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", "UNI", $("tab1div"));
    tab.addEmbedTab("tab2div", "NNI", $("tab2div"));
    tab.addEmbedTab("tab3div", RESOURCE["vlanforwardtableitem"], $("tab3div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function addCellListener()
{
    for (var i = 0, m = nnipwst.getDataRowLength(); i < m; i++) 
    {
        var cell = nnipwst.getCellEdit(i, "pwID");
        textCheck(cell.element, "1", "4294967295");
        
        cell = nnipwst.getCellEdit(i, "oppositeLsrID");
        validateIp(cell.element, true);
        
        nnipwst.getCell(i, "tunnelid").element.ondblclick = function()
        {
    		var tunnelType = nnipwst.getCellStoreValue(this.parentNode.rowIndex, "tunneltype", "tunneltype");
			tunnelType = tunnelTypes[tunnelType]; 
            xshowModalDialog("../ethcommon/selecttunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
        }
    }
}

function cellEditHandler(param)
{
    var rowIndex = param.rowindex;
    var minLabel = 16;
    var maxLabel = 1048575;
    var pwEncapType = parseInt(nnipwst.getCellStoreValue(rowIndex, "pwEncapsType", "pwEncapsType"));
    if (pwEncapType == 2) 
    {
        minLabel = 49153;
        maxLabel = 50176;
    }
    
    if (param.colid == "pwIngressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = nnipwst.getCellEdit(rowIndex, "pwIngressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
    
    if (param.colid == "pwEgressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = nnipwst.getCellEdit(rowIndex, "pwEgressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
}

function checkAutoAssign()
{
    var atom = ct.getAtom("serviceid");
    if (this.checked) 
    {
        atom.setValue("");
        atom.element.disabled = true;
    }
    else 
    {
        atom.setValue("1");
        atom.element.disabled = false;
    }
}

function swicthTab(arg)
{
    $(arg).className = "tabSelect";
    if (arg == "pwlabel") 
    {
        $("portlabel").className = "tabUnselect";
        $("pwtbl").style.display = "inline";
        $("porttbl").style.display = "none";
        
        $("newpwbtn").style.display = "inline";
        $("deletepwbtn").style.display = "inline";
        $("cfgnnibtn").style.display = "none";
    }
    else if (arg == "portlabel") 
    {
        $("pwlabel").className = "tabUnselect";
        $("pwtbl").style.display = "none";
        $("porttbl").style.display = "inline";
        
        $("newpwbtn").style.display = "none";
        $("deletepwbtn").style.display = "none";
        $("cfgnnibtn").style.display = "inline";
    }
}

function embedTabSelectHandler(id)
{
    if (("tab3div") == id) 
    {
        for (var i = vlanst.getDataRowLength() - 1; i >= 0; i--) 
        {
            var srcPort = vlanst.getCellStoreValue(i, "srcPort", "srcPort");
            var snkPort = vlanst.getCellStoreValue(i, "sinkPort", "sinkPort");
            if (!isExist(srcPort) || !isExist(snkPort)) 
            {
                vlanst.deleteRow(i);
            }
        }
        
        vlanst.adjustDataRows();
    }
}

function isExist(iface)
{
    for (var i = 0, m = unist.getDataRowLength(); i < m; i++) 
    {
        if (iface == unist.getCellShow(i, "port").element.innerHTML) 
        {
            return true;
        }
    }
    for (var j = 0, n = nnipwst.getDataRowLength(); j < n; j++) 
    {
        var pwType = nnipwst.getCellShow(j, "serviceType").element.innerHTML;
        var pwID = nnipwst.getCellStoreValue(j, "pwID", "pwID");
        if (iface == "PW(" + pwType + "," + pwID + ")") 
        {
            return true;
        }
    }
    for (var k = 0, mn = nniportst.getDataRowLength(); k < mn; k++) 
    {
        if (iface == nniportst.getCellShow(k, "port").element.innerHTML) 
        {
            return true;
        }
    }
    return false;
}

function doCfgUNI()
{
    xshowModalDialog("configureuniport.html?serviceIndex=" + INVALID_LABEL_VALUE_2, RESOURCE["configureport"], 650, 420, "../../../../../../images/");
}

function doNewPW()
{
    xshowModalDialog("createpw.html?isfromcrt=true", RESOURCE["newbutton"], 680, 420, "../../../../../../images/");
}

function doDeletePW()
{
    var indexes = nnipwst.getSelectedRows();
    for (var i = indexes.length - 1; i >= 0; i--) 
    {
        qosNni.removeAt(parseInt(nnipwst.getCellStoreValue(indexes[i], "pwID", "pwID")));
        nnipwst.deleteRow(indexes[i]);
    }
    nnipwst.adjustDataRows();
}

function doCfgNNI()
{
    xshowModalDialog("configurenniport.html?serviceIndex=" + INVALID_LABEL_VALUE_2, RESOURCE["configureport"], 650, 420, "../../../../../../images/");
}

function doNewVlan()
{
    resources = [];
    for (var i = 0, m = unist.getDataRowLength(); i < m; i++) 
    {
        var resource = new Object();
        resource.iftype = 1;
        resource.ifid = unist.getCellStoreValue(i, "vuniId", "vuniId");
        resource.role = unist.getCellStoreValue(i, "role", "role");
        resource.name = unist.getCellShow(i, "port").element.innerHTML;
        resources.push(resource);
    }
    for (var j = 0, n = nnipwst.getDataRowLength(); j < n; j++) 
    {
        var resource = new Object();
        resource.iftype = 2;
        resource.ifid = nnipwst.getCellStoreValue(j, "vnniId", "vnniId");
        resource.role = nnipwst.getCellStoreValue(j, "role", "role");
        var pwType = nnipwst.getCellShow(j, "serviceType").element.innerHTML;
        var pwID = nnipwst.getCellStoreValue(j, "pwID", "pwID");
        resource.name = "PW(" + pwType + "," + pwID + ")";
        resources.push(resource);
    }
    for (var k = 0, mn = nniportst.getDataRowLength(); k < mn; k++) 
    {
        var resource = new Object();
        resource.iftype = 2;
        resource.ifid = nniportst.getCellStoreValue(k, "vnniId", "vnniId");
        resource.role = nniportst.getCellStoreValue(k, "role", "role");
        resource.name = nniportst.getCellShow(k, "port").element.innerHTML;
        resources.push(resource);
    }
    xshowModalDialog("createvlantable.html", RESOURCE["createvlantable"], 400, 255, "../../../../../../images/");
}

function doDeleteVlan()
{
    var indexes = vlanst.getSelectedRows();
    for (var i = indexes.length - 1; i >= 0; i--) 
    {
        vlanst.deleteRow(indexes[i]);
    }
    vlanst.adjustDataRows();
}

function doCfgQoS()
{
    xshowModalDialog("cfgqos.html", RESOURCE["cfgqosbtn"], 650, 300, "../../../../../../images/");
}

function createEAggrXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("serviceIndex", 0));
    rowparams.appendChild(createTagElement("serviceID", ct.getAtom("serviceid").getValue()));
    rowparams.appendChild(createTagElement("serviceName", ct.getAtom("servicename").getValue()));
    rowparams.appendChild(createTagElement("bpdu", 0));
    rowparams.appendChild(createTagElement("ethType", 4)); // E-AGGR
    bussiness.appendChild(rowparams);
    
    for (var i = 0, m = unist.getDataRowLength(); i < m; i++) 
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        var vuniId = unist.getCellStoreValue(i, "vuniId", "vuniId");
        rowparams.appendChild(createTagElement("vuniID", vuniId));
        rowparams.appendChild(createTagElement("role", unist.getCellStoreValue(i, "role", "role")));
        rowparams.appendChild(createTagElement("slotid", unist.getCellStoreValue(i, "port", "slotid")));
        rowparams.appendChild(createTagElement("subslotid", 0xFF));
        rowparams.appendChild(createTagElement("portid", unist.getCellStoreValue(i, "portid", "port")));
        /**
		var tagIds = getTags(unist.getCellStoreValue(i, "tagIds", "tagIds"));
        rowparams.appendChild(createTagElement("tagNum", tagIds.length / 8));
        rowparams.appendChild(createTagElement("tagID", tagIds));
		*/
		
        rowparams.appendChild(createTagElement("tagNum", "0"));
        rowparams.appendChild(createTagElement("tagID", unist.getCellStoreValue(i, "tagIds", "tagIds")));
		
		
        bussiness.appendChild(rowparams);
    }
    
    for (var j = 0, n = nnipwst.getDataRowLength(); j < n; j++) 
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("vnniID", nnipwst.getCellStoreValue(j, "vnniId", "vnniId")));
        rowparams.appendChild(createTagElement("role", nnipwst.getCellStoreValue(j, "role", "role")));
        rowparams.appendChild(createTagElement("carrierType", LOAD_TYPE_PW));
        rowparams.appendChild(createTagElement("carrierID1", INVALID_LABEL_VALUE_2));
        rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
        rowparams.appendChild(createTagElement("carrierID3", INVALID_LABEL_VALUE_2));
        
        rowparams.appendChild(createTagElement("pwSignalType", nnipwst.getCellStoreValue(j, "pwSignalType", "pwSignalType")));
        rowparams.appendChild(createTagElement("pwType", nnipwst.getCellStoreValue(j, "serviceType", "serviceType")));
        var pwID = nnipwst.getCellStoreValue(j, "pwID", "pwID");
        rowparams.appendChild(createTagElement("pwID", pwID));
        rowparams.appendChild(createTagElement("direction", nnipwst.getCellStoreValue(j, "direction", "direction")));
        rowparams.appendChild(createTagElement("pwIngressLabel", nnipwst.getCellStoreValue(j, "pwIngressLabel", "pwIngressLabel")));
        rowparams.appendChild(createTagElement("pwEgressLabel", nnipwst.getCellStoreValue(j, "pwEgressLabel", "pwEgressLabel")));
		var oppositeLsrID = nnipwst.getCellShow(j, "oppositeLsrID").element.innerHTML;
        rowparams.appendChild(createTagElement("oppositeLsrID", convertIPStrToLong(oppositeLsrID)));
        var tunnelIndexHex = tenToHex(nnipwst.getCellStoreValue(j, "tunnelindex", "tunnelindex"));
        for (var i = tunnelIndexHex.length; i < 8; i++) 
        {
            tunnelIndexHex = "0" + tunnelIndexHex;
        }
        rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
        rowparams.appendChild(createTagElement("pwEncapsType", nnipwst.getCellStoreValue(j, "pwEncapsType", "pwEncapsType")));
        rowparams.appendChild(createTagElement("enableState", nnipwst.getCellStoreValue(j, "enableState", "enableState")));
        rowparams.appendChild(createTagElement("controlWord", nnipwst.getCellStoreValue(j, "controlWord", "controlWord")));
        rowparams.appendChild(createTagElement("ctrlChanType", nnipwst.getCellStoreValue(j, "ctrlChanType", "ctrlChanType")));
        rowparams.appendChild(createTagElement("vccv", nnipwst.getCellStoreValue(j, "vccv", "vccv")));
        
        var v = nnipwst.getCellStoreValue(j, "requestVLAN", "requestVLAN");
        if (v != "" && v != "-") 
        {
            rowparams.appendChild(createTagElement("requestVLAN", v));
        }
        
        v = nnipwst.getCellStoreValue(j, "tpID", "tpID");
        if (v != "" && v != "-") 
        {
            rowparams.appendChild(createTagElement("tpID", v));
        }
        
        if (qosNni[pwID] != null) 
        {
            var qos = qosNni[pwID];
            if (qos.exp != null) 
            {
                rowparams.appendChild(createTagElement("idirection", INGRESS));
                rowparams.appendChild(createTagElement("exp", qos.exp));
            }
            if (qos.lspmode != null) 
            {
                rowparams.appendChild(createTagElement("edirection", EGRESS));
                rowparams.appendChild(createTagElement("lspmode", qos.lspmode));
            }
        }
        
        bussiness.appendChild(rowparams);
    }
    
    for (var k = 0, mn = nniportst.getDataRowLength(); k < mn; k++) 
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("vnniID", nniportst.getCellStoreValue(k, "vnniId", "vnniId")));
        rowparams.appendChild(createTagElement("role", nniportst.getCellStoreValue(k, "role", "role")));
        rowparams.appendChild(createTagElement("carrierType", LOAD_TYPE_PHY_PORT));
        rowparams.appendChild(createTagElement("carrierID1", nniportst.getCellStoreValue(k, "port", "slotid")));
        rowparams.appendChild(createTagElement("carrierID2", 0xFF));
        rowparams.appendChild(createTagElement("carrierID3", nniportst.getCellStoreValue(k, "portid", "port")));
        bussiness.appendChild(rowparams);
    }
    
    for (var x = 0, y = vlanst.getDataRowLength(); x < y; x++) 
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("inLogicInfID", vlanst.getCellStoreValue(x, "inLogicInfID", "inLogicInfID")));
        rowparams.appendChild(createTagElement("inLogicInfType", vlanst.getCellStoreValue(x, "inLogicInfType", "inLogicInfType")));
        rowparams.appendChild(createTagElement("inVlanID", vlanst.getCellStoreValue(x, "inVlanID", "inVlanID")));
        
        rowparams.appendChild(createTagElement("outLogicInfID", vlanst.getCellStoreValue(x, "outLogicInfID", "outLogicInfID")));
        rowparams.appendChild(createTagElement("outLogicInfType", vlanst.getCellStoreValue(x, "outLogicInfType", "outLogicInfType")));
        rowparams.appendChild(createTagElement("outVlanID", vlanst.getCellStoreValue(x, "outVlanID", "outVlanID")));
        bussiness.appendChild(rowparams);
    }
    
    for (var s = 0, t = qosUni.length; s < t; s++) 
    {
        if (qosUni[s] != null) 
        {
            var qos = qosUni[s];
            rowparams.appendChild(createTagElement("qosUniID", s));
            rowparams.appendChild(createTagElement("direction", qos.direction));
            if (qos.policy != null) 
            {
                var policyId = INVALID_LABEL_VALUE_2;
                if (qos.policy != "") 
                {
                    policyId = qos.policy.substring(0, qos.policy.indexOf("("));
                }
                rowparams.appendChild(createTagElement("policy", policyId));
            }
            if (qos.cos != null || qos.color != null) 
            {
                rowparams.appendChild(createTagElement("cos", qos.cos));
                rowparams.appendChild(createTagElement("color", qos.color));
            }
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getTags(tagStr)
{
    var tagIds = "";
    if (typeof(tagStr) == "undefined" || tagStr == "") 
    {
        return tagIds;
    }
    var arr = tagStr.split(",");
    for (var i = 0, m = arr.length; i < m; i++) 
    {
        var tag = arr[i];
        var tmpArr = tag.split("-");
        if (tmpArr.length == 2) 
        {
            for (var j = parseInt(tmpArr[0]); j <= parseInt(tmpArr[1]); j++) 
            {
                tagIds += tagPrototype(j);
            }
        }
        else 
        {
            tagIds += tagPrototype(tag);
        }
    }
    return tagIds;
}

function tagPrototype(tag)
{
    var tagHex = tenToHex(tag);
    for (var i = tagHex.length; i < 8; i++) 
    {
        tagHex = "0" + tagHex;
    }
    return tagHex;
}

function doCreate(arg)
{
    var serviceId = ct.getAtom("serviceid").getValue();
    if (typeof(serviceId) == "undefined" || serviceId == "") 
    {
        alert(RESOURCE["inputserviceid"]);
        return;
    }
    var xml = createEAggrXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ADD_EAGGR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createEAggrCallBack, arg, "inputdata=" + xml);
}

function createEAggrCallBack(doc, arg)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var di = document.createElement("datainterface");
        var bparams = document.createElement("bussiness-params");
        var rowParams = document.createElement("row-params");
        
        rowParams.appendChild(createParamElement("serviceIndex", data.getDataRowParam(0, "serviceIndex")));
        rowParams.appendChild(createParamElement("serviceID", ct.getAtom("serviceid").getValue()));
        rowParams.appendChild(createParamElement("serviceName", ct.getAtom("servicename").getValue()));
        rowParams.appendChild(createParamElement("serviceType", 4));
        rowParams.appendChild(createParamElement("mtu", ct.getAtom("mtu").getValue()));
		rowParams.appendChild(createParamElement("serviceTagRole", "-"));
        
        bparams.appendChild(rowParams);
        di.appendChild(bparams);
        createTableBody(win.st, win.window.tableconf[0], EncapsulateData(di), RESOURCE);
		
		var indexes = win.st.getSelectedRows();
		for (var i = 0, m = indexes.length; i < m; i++)
		{
			win.st.setRowNoneSelect(indexes[i]);
		}
        
        win.st.setRowSelect(win.st.getDataRowLength() - 1);
        win.rowSelectHandler();
        
        if (arg) 
        {
            xcloseDialog();
        }
    }
}
