var tc0 = null;
var tc1 = null;
var ast = null;
var sst = null;

var delUNIs = new Array();

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var serviceIndex = getNeProperty(self).serviceIndex;

window.onload = function()
{
    initPage();
    initTable();
    initSelectedPorts();
    initAvailablePorts();
}

function initPage()
{
    $("availableport").innerHTML = RESOURCE["avaliableports"];
    $("selectedport").innerHTML = RESOURCE["selectedports"];
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTable()
{
    tc0 = window.tableconf[0];
    tc0.colArray[0].width = "0%";
    tc0.colArray[1].width = "0%";
    tc0.colArray[2].width = "100%";
    tc0.colArray[4].width = "0%";
    tc0.colArray[5].width = "0%";
    
    ast = new SortTable();
    ast.setImage("../../../../../../images/");
    ast.isUsedForSelectList = true;
    createTableHead(ast, tc0);
    $("atbl").appendChild(ast.getTable());
    ast.setBodyHeight(getComponetHeight($("atbl"), 70) + "px");
    
    tc1 = window.tableconf[1];
    tc1.colArray[0].width = "0%";
    tc1.colArray[1].cell.isEdit = 1;
    tc1.colArray[1].width = "25%";
    tc1.colArray[2].width = "25%";
    tc1.colArray[4].cell.isEdit = 1;
    tc1.colArray[4].width = "25%";
    tc1.colArray[5].cell.isEdit = 0;
    tc1.colArray[5].width = "25%";
    
    sst = new SortTable();
    sst.setImage("../../../../../../images/");
    sst.isUsedForSelectList = true;
    createTableHead(sst, tc1);
    $("stbl").appendChild(sst.getTable());
    sst.setBodyHeight(getComponetHeight($("stbl"), 70) + "px");
}

function initSelectedPorts()
{
    sst.clearTableData();
    
    var st = win.unist;
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        addTableRow(st, sst, tc1, i);
        var index = sst.getDataRowLength() - 1;
        var vuniId = sst.getCellStoreValue(index, "vuniId", "vuniId");
        if (typeof(vuniId) != "undefined" && vuniId != null && vuniId != "" && win.ct == null) 
        {
            sst.setCellIsEdit(sst.getCell(index, "role"), 0);
        }
    }
	
	addCellListener();
}

function addTableRow(gst, ist, itc, index)
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    var value = gst.getCellStoreValue(index, "vuniId", "vuniId");
    if (win.vuniID) 
    {
        rowParams.appendChild(createParamElement("vuniId", typeof(value) == "undefined" ? win.vuniID++ : value));
    }
    else 
    {
        rowParams.appendChild(createParamElement("vuniId", typeof(value) == "undefined" ? "" : value));
    }
    value = gst.getCellStoreValue(index, "role", "role");
    rowParams.appendChild(createParamElement("role", typeof(value) == "undefined" ? "" : value));
    rowParams.appendChild(createParamElement("slotid", gst.getCellStoreValue(index, "port", "slotid")));
    rowParams.appendChild(createParamElement("boardname", gst.getCellStoreValue(index, "port", "boardname")));
    rowParams.appendChild(createParamElement("portname", gst.getCellStoreValue(index, "port", "portname")));
    rowParams.appendChild(createParamElement("port", gst.getCellStoreValue(index, "portid", "port")));
    value = gst.getCellStoreValue(index, "tagIds", "tagIds");
    rowParams.appendChild(createParamElement("tagIds", typeof(value) == "undefined" ? "" : value));
    value = gst.getCellStoreValue(index, "prioritylist", "prioritylist");
    rowParams.appendChild(createParamElement("prioritylist", typeof(value) == "undefined" ? "" : value));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    createTableBody(ist, itc, EncapsulateData(di), RESOURCE);
}

function createQueryResXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("serviceIndex", serviceIndex));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function initAvailablePorts()
{
    ast.clearTableData();
    
    var xml = createQueryResXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_GET_EAGGR_RES;
    loadXMLdoc(url, "POST", false, fillAvailablePorts, null, "inputdata=" + xml);
}

function fillAvailablePorts(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        createTableBody(ast, tc0, data, RESOURCE);
        for (var i = ast.getDataRowLength() - 1; i >= 0; i--) 
        {
            var slotId = ast.getCellStoreValue(i, "port", "slotid");
            var portId = ast.getCellStoreValue(i, "portid", "port");
            for (var j = 0, m = sst.getDataRowLength(); j < m; j++) 
            {
                if (slotId == sst.getCellStoreValue(j, "port", "slotid") && portId == sst.getCellStoreValue(j, "portid", "port")) 
                {
                    ast.deleteRow(i);
                    break;
                }
            }
			for (var k = 0, n = win.nniportst.getDataRowLength(); k < n; k++) 
			{
				if (slotId == win.nniportst.getCellStoreValue(k, "port", "slotid") && portId == win.nniportst.getCellStoreValue(k, "portid", "port")) 
                {
                    ast.deleteRow(i);
                    break;
                }
			}
        }
        ast.adjustDataRows();
    }
}

function rightMove()
{
    var rowIndex = -1;
    var rows = ast.getSelectedRows();
    for (var i = rows.length - 1; i >= 0; i--) 
    {
        rowIndex = rows[i];
        addTableRow(ast, sst, tc1, rowIndex);
        var vuniId = ast.getCellStoreValue(rowIndex, "vuniId", "vuniId");
        if (typeof(vuniId) != "undefined" && vuniId != "" && win.ct == null) 
        {
            var cell = sst.getCell(sst.getDataRowLength() - 1, "role");
            sst.setCellIsEdit(cell, 0);
            
            delUNIs.remove(vuniId);
        }
        
        ast.deleteRow(rowIndex);
    }
    ast.adjustDataRows();
    
    addCellListener();
}

function leftMove()
{
    var rowIndex = -1;
    var rows = sst.getSelectedRows();
    for (var i = rows.length - 1; i >= 0; i--) 
    {
        rowIndex = rows[i];
        addTableRow(sst, ast, tc0, rowIndex);
        var vuniId = sst.getCellStoreValue(rowIndex, "vuniId", "vuniId");
        if (typeof(vuniId) != "undefined" && vuniId != "") 
        {
            delUNIs[delUNIs.length] = vuniId;
        }
        
        sst.deleteRow(rowIndex);
    }
    sst.adjustDataRows();
}

function addCellListener()
{
    for (var i = 0, m = sst.getDataRowLength(); i < m; i++) 
    {
        limitVlanInput(sst.getCellEdit(i, "tagIds").element, "1", "4094");
    }
}

function doOK()
{
	if (!checkIntegrality()) 
    {
        return;
    }
    
    var st = win.unist;
    st.clearTableData();
    
    var isChange = false;
    
    win.delUNIs = delUNIs;
    if (win.delUNIs.length > 0) 
    {
        if (win.qosUni) 
        {
            for (var i = 0, m = delUNIs.length; i < m; i++) 
            {
                win.qosUni.removeAt(parseInt(delUNIs[i]));
            }
        }
        isChange = true;
    }
    
    for (var i = 0, m = sst.getDataRowLength(); i < m; i++) 
    {
        addTableRow(sst, win.unist, win.unitc, i);
        var index = win.unist.getDataRowLength() - 1;
        var vuniId = win.unist.getCellStoreValue(index, "vuniId", "vuniId");
        if (typeof(vuniId) == "undefined") 
        {
            win.unist.getCellShow(index, "vuniId").element.innerHTML = "-";
            isChange = true;
        }
        else if (sst.getCellModify(i, "tagIds")) 
        {
            win.unist.setCellModify(index, "tagIds", true);
            isChange = true;
        }
    }
    
    if (isChange && null != win.$("applyunibtn")) 
    {
        win.$("applyunibtn").disabled = !win.btnRightArr.applybtn.right;
    }
    xcloseDialog();
}

function limitVlanInput(obj, minValue, maxValue)
{
    var minvalue = minValue;
    var maxvalue = maxValue;
    
    obj.value = "";
    obj.style.imeMode = "disabled";
    obj.onkeypress = function()
    {
        var evt = window.event;
        return restrictVlan(obj, evt, minvalue, maxvalue);
    };
    obj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = obj.value + pasteText;
        return vlanTextCheck(pasteText, minvalue, maxvalue);
        
    };
}

function restrictVlan(field, event, minvalue, maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' ||
    keychar == '[' ||
    keychar == ']' ||
    keychar == '\\' ||
    keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') ||
            (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function vlanTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}
