var qosunist = new SortTable();;
var qospwst = null;

var qosunitc = null;

var tab = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var isSupportEgressQos = false;
var isSupportIngressQos = false;
var isSupportIngressColor = false;
function init()
{
	isSupportEgressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIEGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIEGRESSPOLICY");
	isSupportIngressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSPOLICY");
	isSupportIngressColor = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSCOSCOLOR");
    initTable();
    initUI();
    initTabs();
    if(isSupportEgressQos || isSupportIngressQos)
    {
    	initUNIQoSTableData();
    }
    initPWQoSTableData();
}

function initTable()
{
	/**
	 *       DTS2011121000433 
	 *      f00177546
	 *             Qos                    UNI QOS
	 */   
	if(isSupportEgressQos || isSupportIngressQos)
    {
	    qosunist = new SortTable();
	    qosunitc = window.tableconf[0];
	    qosunitc.colArray[0].width = "10%";
	    qosunitc.colArray[0].isSort = "1";
	    qosunist.setImage("../../../../../../images/");
	    createTableHead(qosunist, qosunitc);
	    $("qosporttbl").appendChild(qosunist.getTable());
	    qosunist.setBodyHeight(getComponetHeight($("qosporttbl"), 220) + "px");
    }
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    createTableHead(qospwst, window.tableconf[1]);
    $("qospwtbl").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("qospwtbl"), 220) + "px");
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    if(isSupportIngressQos || isSupportEgressQos)
    {
    	tab.addEmbedTab("tab1div", "UNI", $("tab1div"));
    }
    tab.addEmbedTab("tab2div", "PW", $("tab2div"));
    if(isSupportIngressQos || isSupportEgressQos)
    {
    	setSelectedEmbedTab("tab1div");
    }
    else
    {
    	setSelectedEmbedTab("tab2div");
    }
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function embedTabSelectHandler(id)
{
    if (id == "tab2div") 
    {
        adjustTableLayout(qospwst, window.tableconf[1]);
    }
}

function initUNIQoSTableData()
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    for (var i = 0, m = win.unist.getDataRowLength(); i < m; i++) 
    {
        var rowParams = document.createElement("row-params");
        var vuniId = parseInt(win.unist.getCellStoreValue(i, "vuniId", "vuniId"));
        var role = win.unist.getCellStoreValue(i, "role", "role");
        var slotid = win.unist.getCellStoreValue(i, "port", "slotid");
        var boardname = win.unist.getCellStoreValue(i, "port", "boardname");
        var portname = win.unist.getCellStoreValue(i, "port", "portname");
        var qos = win.qosUni[vuniId];
        rowParams.appendChild(createParamElement("vuniId", vuniId + "-" + role));
        rowParams.appendChild(createParamElement("slotid", slotid));
        rowParams.appendChild(createParamElement("boardname", boardname));
        rowParams.appendChild(createParamElement("portname", portname));
        rowParams.appendChild(createParamElement("direction", 1));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", (qos != null && qos.policy != null) ? qos.policy : ""));
        rowParams.appendChild(createParamElement("cos", (qos != null && qos.cos != null) ? qos.cos : 8));
        rowParams.appendChild(createParamElement("color", (qos != null && qos.color != null) ? qos.color : 3));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        bparams.appendChild(rowParams);
        
        rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("vuniId", vuniId + "-" + role));
        rowParams.appendChild(createParamElement("slotid", slotid));
        rowParams.appendChild(createParamElement("boardname", boardname));
        rowParams.appendChild(createParamElement("portname", portname));
        rowParams.appendChild(createParamElement("direction", 2));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", ""));
        rowParams.appendChild(createParamElement("cos", ""));
        rowParams.appendChild(createParamElement("color", ""));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        bparams.appendChild(rowParams);
    }
    
    di.appendChild(bparams);
    createTableBody(qosunist, qosunitc, EncapsulateData(di), RESOURCE);
    
    for (var j = 0, n = qosunist.getDataRowLength(); j < n; j++) 
    {
        var direction = parseInt(qosunist.getCellStoreValue(j, "direction", "direction"));
		var cell = qosunist.getCell(j, "policy");
        if(direction == "1")
        {            
            if (isSupportIngressQos) 
            {
                qosunist.setCellIsEdit(cell, "1");
                cell.element.ondblclick = function()
                {
                    openPolicyDialog(VUNI_INGRESS_POLICY, direction);
                }
            }
			else
			{
				qosunist.setCellIsEdit(cell,"0");
			}
        }
        else
        {            
            if (isSupportEgressQos) 
            {
                qosunist.setCellIsEdit(cell, "1");
                cell.element.ondblclick = function()
                {
                    openPolicyDialog(VUNI_EGRESS_POLICY, direction);
                }
            }
			else
			{
				qosunist.setCellIsEdit(cell,"0");
			}
        }
        handleTablePortQos(qosunist,j);
        if (direction == EGRESS || !isSupportIngressColor) // Egress
        {
            cell = qosunist.getCell(j, "cos");
            qosunist.setCellIsEdit(cell, 0);
            qosunist.getCellShow(j, "cos").element.innerHTML = "-";
            
            cell = qosunist.getCell(j, "color");
            qosunist.setCellIsEdit(cell, 0);
            qosunist.getCellShow(j, "color").element.innerHTML = "-";
        }
    }
}

function initPWQoSTableData()
{
    var pwId = 0;
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    for (var i = 0, m = win.nnipwst.getDataRowLength(); i < m; i++) 
    {
        var tmpPwId = win.nnipwst.getCellStoreValue(i, "pwID", "pwID");
        if (pwId == tmpPwId) 
        {
            continue;
        }
        pwId = tmpPwId;
        var qos = win.qosNni[parseInt(pwId)];
        var serviceType = win.nnipwst.getCellStoreValue(i, "serviceType", "serviceType");
        
        var rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("pwIndex", 0));
        rowParams.appendChild(createParamElement("pwID", tmpPwId));
        rowParams.appendChild(createParamElement("direction", 1));
        rowParams.appendChild(createParamElement("serviceType", serviceType));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", ""));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        rowParams.appendChild(createParamElement("exp", (qos != null && qos.exp != null) ? qos.exp : 255));
        rowParams.appendChild(createParamElement("lspmode", ""));
        bparams.appendChild(rowParams);
        
        rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("pwIndex", 0));
        rowParams.appendChild(createParamElement("pwID", tmpPwId));
        rowParams.appendChild(createParamElement("direction", 2));
        rowParams.appendChild(createParamElement("serviceType", serviceType));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", ""));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        rowParams.appendChild(createParamElement("exp", ""));
        rowParams.appendChild(createParamElement("lspmode", (qos != null && qos.lspmode != null) ? qos.lspmode : 1));
        bparams.appendChild(rowParams);
    }
    
    di.appendChild(bparams);
    createTableBody(qospwst, window.tableconf[1], EncapsulateData(di), RESOURCE);
    
    for (var j = 0, n = qospwst.getDataRowLength(); j < n; j++) 
    {
        var direction = parseInt(qospwst.getCellStoreValue(j, "direction", "direction"));
        
        
        if (direction == INGRESS) // Ingress
        {
        	var bandwidthlimit = qospwst.getCell(j, "bandwidthlimit");
        	qospwst.setCellIsEdit(bandwidthlimit, 1);    
        	qospwst.getCell(j, "policy").element.ondblclick = function()
	        {
	            openPolicyDialog(PW_POLICY, direction);
	        }
        }
        else 
        {
            var cell = qospwst.getCell(j, "policy");
            qospwst.setCellIsEdit(cell, 0);
            qospwst.getCellShow(j, "policy").element.innerHTML = "-";            
         
        }
        handleTablePWQos(qospwst,j);
        
        var cell = qospwst.getCell(j, "exp");
        qospwst.setCellIsEdit(cell, 0);
        qospwst.getCellShow(j, "exp").element.innerHTML = "-";
        
        cell = qospwst.getCell(j, "lspmode");
        qospwst.setCellIsEdit(cell, 0);
        qospwst.getCellShow(j, "lspmode").element.innerHTML = "-";
    }
}

function handleTablePWQos(st,rowindex)
{
	var bandwithlimit = st.getCellStoreValue(rowindex, "bandwidthlimit",
			"bandwidthlimit");
	var cell = null;
	if (bandwithlimit != "1") {
		cell = st.getCell(rowindex, "cbs");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "cbs").element.innerHTML = "-";
		cell = st.getCell(rowindex, "pbs");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "pbs").element.innerHTML = "-";
		cell = st.getCell(rowindex, "cir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "cir").element.innerHTML = "-";

		cell = st.getCell(rowindex, "pir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "pir").element.innerHTML = "-";
	}
	textCheckWithStepLen(st.getCellEdit(rowindex, "cir").element, 0, 1000000, 64);
    textCheckWithStepLen(st.getCellEdit(rowindex, "pir").element, 0, 1000000, 64);
    textCheck(st.getCellEdit(rowindex, "cbs").element, 0, 4294967295);
    textCheck(st.getCellEdit(rowindex, "pbs").element, 0, 4294967295);
    var bandwidthlimitCell = st.getCellEdit(rowindex, "bandwidthlimit");
    bandwidthlimitCell.element.onchange = function ()
    {
    	 var selectIndex = st.getSelectedRows()[0];
    	 if(this.value ==1)
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 1);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "64";
    	 	st.setCellValue(cell, "cir", 64);
         
             cell = st.getCell(selectIndex, "cbs");
             st.setCellIsEdit(cell, 1);
             st.getCellShow(selectIndex, "cbs").element.innerHTML = "";
             
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 1);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "64";
             st.setCellValue(cell, "pir", 64);
             
             cell = st.getCell(selectIndex, "pbs");
             st.setCellIsEdit(cell, 1);
             st.getCellShow(selectIndex, "pbs").element.innerHTML = "";
             
    	 }
    	 else
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 0);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "-";
         
             cell = st.getCell(selectIndex, "cbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
    	 }
    }
}

function handleTablePortQos(st,rowindex)
{
	var bandwithlimit = st.getCellStoreValue(rowindex, "bandwidthlimit",
			"bandwidthlimit");
	var cell = st.getCell(rowindex, "cbs");
	st.setCellIsEdit(cell, 0);
	st.getCellShow(rowindex, "cbs").element.innerHTML = "-";
	cell = st.getCell(rowindex, "pbs");
	st.setCellIsEdit(cell, 0);
	st.getCellShow(rowindex, "pbs").element.innerHTML = "-";
	if (bandwithlimit != "1") {
		var cell = st.getCell(rowindex, "cir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "cir").element.innerHTML = "-";

		cell = st.getCell(rowindex, "pir");
		st.setCellIsEdit(cell, 0);
		st.getCellShow(rowindex, "pir").element.innerHTML = "-";
	}
	textCheckWithStepLen(st.getCellEdit(rowindex, "cir").element, 0, 1000000, 64);
    textCheckWithStepLen(st.getCellEdit(rowindex, "pir").element, 0, 1000000, 64);
    textCheck(st.getCellEdit(rowindex, "cbs").element, 0, 4294967295);
    textCheck(st.getCellEdit(rowindex, "pbs").element, 0, 4294967295);
    var bandwidthlimitCell = st.getCellEdit(rowindex, "bandwidthlimit");
    bandwidthlimitCell.element.onchange = function ()
    {
    	 var selectIndex = st.getSelectedRows()[0];
    	 if(this.value ==1)
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 1);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "64";
    	 	st.setCellValue(cell, "cir", 64);
         
             cell = st.getCell(selectIndex, "cbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 1);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "64";
             st.setCellValue(cell, "pir", 64);
             
             cell = st.getCell(selectIndex, "pbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
             
    	 }
    	 else
    	 {
    	 	 var cell = st.getCell(selectIndex, "cir");
    	 	st.setCellIsEdit(cell, 0);
    	 	st.getCellShow(selectIndex, "cir").element.innerHTML = "-";
         
             cell = st.getCell(selectIndex, "cbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pir");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pir").element.innerHTML = "-";
             
             cell = st.getCell(selectIndex, "pbs");
             st.setCellIsEdit(cell, 0);
             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
    	 }
    }
}


function convertUNI(param)
{
    return RESOURCE[role[param.split("-")[1]]];
}

function doConfig()
{
	if(!checkDataValid("cbs"))
	{
		alert(RESOURCE["errcbs"]);
        return;
	}
	if(!checkDataValid("pbs"))
	{
		alert(RESOURCE["errpbs"]);
        return;
	}
    for (var i = 0, m = qosunist.getDataRowLength(); i < m; i++) 
    {
        if (qosunist.getModify(i)) 
        {
            var vuniId = parseInt(qosunist.getCellStoreValue(i, "vuniId", "vuniId").split("-")[0]);
            if (win.qosUni[vuniId] == null) 
            {
                win.qosUni[vuniId] = new Object();
            }
            win.qosUni[vuniId].direction = qosunist.getCellStoreValue(i, "direction", "direction");
            if (qosunist.getCellModify(i, "policy")) 
            {
                win.qosUni[vuniId].policy = qosunist.getCellStoreValue(i, "policy", "policy");
            }
            if (qosunist.getCellModify(i, "cos") || qosunist.getCellModify(i, "color")) 
            {
                win.qosUni[vuniId].cos = qosunist.getCellStoreValue(i, "cos", "cos");
                win.qosUni[vuniId].color = qosunist.getCellStoreValue(i, "color", "color");
            }
            if (qosunist.getCellModify(i, "bandwidthlimit")) 
            {
                win.qosUni[vuniId].bandwidthlimit = qosunist.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit");
                win.qosUni[vuniId].cir = qosunist.getCellStoreValue(i, "cir", "cir");
                win.qosUni[vuniId].cbs = qosunist.getCellStoreValue(i, "cbs", "cbs");
                win.qosUni[vuniId].pir = qosunist.getCellStoreValue(i, "pir", "pir");              
                win.qosUni[vuniId].pbs = qosunist.getCellStoreValue(i, "pbs", "pbs");
            }
        }
    }
    for (var k = 0, n = qospwst.getDataRowLength(); k < n; k++) 
    {
        if (qospwst.getModify(k)) 
        {
            var pwID = parseInt(qospwst.getCellStoreValue(k, "pwID", "pwID"));
            if (win.qosNni[pwID] == null) 
            {
                win.qosNni[pwID] = new Object();
            }
             
            if (qospwst.getCellModify(k, "exp")) 
            {
                win.qosNni[pwID].exp = qospwst.getCellStoreValue(k, "exp", "exp");
            }
            if (qospwst.getCellModify(k, "lspmode")) 
            {
                win.qosNni[pwID].lspmode = qospwst.getCellStoreValue(k, "lspmode", "lspmode");
            }            
            var direction = parseInt(qospwst.getCellStoreValue(k, "direction", "direction"));
            if (direction != INGRESS ) 
            {
            	continue;               
            }  
            if (qospwst.getCellModify(k, "bandwidthlimit")) 
            {            
            	win.qosNni[pwID].pwIndex = qospwst.getCellStoreValue(k, "pwID", "pwID");
            	win.qosNni[pwID].direction = direction;
                win.qosNni[pwID].bandwidthlimit = qospwst.getCellStoreValue(k, "bandwidthlimit", "bandwidthlimit");
                win.qosNni[pwID].cir = qospwst.getCellStoreValue(k, "cir", "cir");
                win.qosNni[pwID].cbs = qospwst.getCellStoreValue(k, "cbs", "cbs");
                win.qosNni[pwID].pir = qospwst.getCellStoreValue(k, "pir", "pir");              
                win.qosNni[pwID].pbs = qospwst.getCellStoreValue(k, "pbs", "pbs");
            }       
        }
    }
    xcloseDialog();
}

function openPolicyDialog(policyType, direction)
{
    var tmpst = qospwst;
    if (policyType == VUNI_INGRESS_POLICY) 
    {
        tmpst = qosunist;
    }
    
    if (tmpst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "policyselect.html?policyType=" + policyType + "&direction=" + direction;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function checkDataValid(name)
{
    for (var rowindex = 0, rowlen = qospwst.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        var cbsValue = qospwst.getCellShow(rowindex, "cbs").element.innerText;
        if (cbsValue == "" || cbsValue == null) 
        {
            return false;
        }
    }
    return true;
}
