/**
 *      
 * @return
 */
function init()
{
    initTable();
    initUI();
    initTabs();
    refreshBoardData("src");
    getPortRes();
    refreshSnkBoardData();
    initData();
    iniOverHeadStatus();
}

/**
 *                                             
 * @return
 */
function iniOverHeadStatus()
{
	var ptElm = ct.getAtom("overhead").element.parentNode;
	ptElm.style.display = "";
	$("overhead").style.display = "";
	$("overhead").parentNode.parentNode.style.display = "";
    $("overhead").disabled = true;
    $("overhead").value = "-";
    $("overheadbutton").disabled = true;
}

/**
 *      
 * @return
 */
function iniUpCTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    var atom = new Atom("span");
    ct.addAttrRow("cesid", RESOURCE["serviceid"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "serviceid";
    checkText(elem, "1", "4294967295");
    elem.style.width = "44%";
    elem.disabled = true;
    elem.value = "-";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "checkbox";
    elem.id = "isAuto";
    elem.style.width = "10%";
    
    elem.onclick = function()
    {
        if ($("isAuto").checked) 
        {
            $("serviceid").disabled = true;
            $("serviceid").value = "-";
        }
        else 
        {
            $("serviceid").disabled = false;
            $("serviceid").value = "";
        }
    };
    atom.element.parentNode.appendChild(elem);
    
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["autoassign"];
    elem.style.width = "45%";
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("servicename", RESOURCE["servicename"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption("E1", 1);
    ct.addAttrRow("level", RESOURCE["level"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = false;
    atom.addOption(RESOURCE["NORMALP2P"], NORMALP2P);
    atom.addOption(RESOURCE["TRANSITP2P"], TRANSITP2P);
    atom.element.options.selectedIndex = 0;
    atom.element.onchange = changeServiceType;
    ct.addAttrRow("servicetype", RESOURCE["servicetype"], atom);
    
    atom = new Atom("select");
    atom.addOption("UNI-UNI", UNI_UNI);
    atom.addOption("UNI-NNI", UNI_NNI);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeMode;
    ct.addAttrRow("mode", RESOURCE["mode"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ID_DISABLE"], DISABLE);
    atom.addOption(RESOURCE["ID_ENABLE"], ENABLE);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeFractionized;
    ct.addAttrRow("fractionized", RESOURCE["fractionized"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    
    atom = new Atom("span");
    ct.addAttrRow("overhead", RESOURCE["overhead"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "overhead";   
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.id = "overheadbutton";
    elem.style.width = "20%";
    elem.onclick = onSelectOverHead;
    atom.element.parentNode.appendChild(elem);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "src");
    }
    ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("srchighpath", RESOURCE["srchighpath"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");

	atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("srclowpath", RESOURCE["srclowpath"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("srctimeslot", RESOURCE["src64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "src64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.id = "src64ktimeslotBtn";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
   
   /**
    *        
    */
    atom = new Atom("select");
    atom.addOption("CS7", 1);
    atom.addOption("CS6", 2);
    atom.addOption("EF", 3);
    atom.addOption("AF4", 4);
    atom.addOption("AF3", 5);
    atom.addOption("AF2", 6);
    atom.addOption("AF1", 7);
    atom.addOption("BE", 8);
    atom.element.options.selectedIndex = 2;
    ct.addAttrRow("srvPri", RESOURCE["prilist"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["NO_PROTECT"], NO_PROTECT);
    atom.addOption(RESOURCE["PW_APS"], PW_APS);
    atom.addOption(RESOURCE["PROTECT_PAIRS"], PROTECT_PAIRS);
    atom.element.options.selectedIndex = 0; 
    ct.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    atom.element.onchange = function()
    {
        changeProtecttype();
    }

    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "snk");
    }
    ct.addAttrRow("snkboard", RESOURCE["snkboard"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("snkhighpath", RESOURCE["snkhighpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");
    atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("snklowpath", RESOURCE["snklowpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("span");
    ct.addAttrRow("snktimeslot", RESOURCE["snk64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "snk64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "snk64ktimeslotBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
    
    atom.element.parentNode.parentNode.style.display = "none";
    
    $("tbdiv").appendChild(ct.getTable());
    $("isAuto").checked = true;
}

/**
 *          
 * @return
 */
function changeServiceType()
{
	var atom = ct.getAtom("srcboard");
	 var selectvalue = ct.getAtom("servicetype").element.value;
	 var modevalue = ct.getAtom("mode").element.value;
	 
	 var text = null;
	 var res = null;
	 var boardName = null;
	 var tmpArr = new Array();
	 atom.clearOptions();
	 for (var i = 0, m = win.resData.length; i < m; i++) 
	 {
	     res = win.resData[i];
	     boardName = res.boardName;
	     text = res.slotId + "-" + res.boardName;
	     value = res.slotId;

	     if (parseInt(res.isTUorLU) == CES_SDH) 
	        {
	            text += "-" + res.portName;
	            value += "-" + res.portId + "-" + res.highChannelCount;
	        }
	        	        
	     if (!tmpArr.contains(value)) 
	     {
	        if(selectvalue == NORMALP2P)
	        {
	        	atom.addOption(text, value);
		        tmpArr[tmpArr.length] = value;
		        
	        }else{
	        	   if(boardName == "CQ1")
	        	    {
	        		atom.addOption(text, value);
		            tmpArr[tmpArr.length] = value;
	        		}
	        	}	       	 	            
	        }
	    }
	 	 
	 changeBoard(atom.getValue(), "src");

	 if(selectvalue == NORMALP2P)
     {
	     $("overhead").disabled = true;
         $("overhead").value = "-";
         $("overheadbutton").disabled = true;
         
         atom = ct.getAtom("srclowpath");
         atom.element.disabled = false;
         atom.element.value = "";
         
         $("src64ktimeslot").disabled = false;
         $("src64ktimeslot").value = "1-31";
         $("src64ktimeslotBtn").disabled = false;
         
         atom = ct.getAtom("mode");
         atom.clearOptions();
         atom.addOption("UNI-UNI", UNI_UNI);
         atom.addOption("UNI-NNI", UNI_NNI);
         atom.element.options.selectedIndex = 1;

    	 atom = pwct.getAtom("pwtype",0);
         atom.clearOptions();
         atom.addOption("CESoPSN", "21");
         atom.addOption("SATop", "17");
         atom.element.options.selectedIndex = 0;    
    	 atom = pwct.getAtom("pwtype",1);
         atom.clearOptions();
         atom.addOption("CESoPSN", "21");
         atom.addOption("SATop", "17");
         atom.element.options.selectedIndex = 0;    
     }else{
         atom = ct.getAtom("mode");
         atom.clearOptions();
         atom.addOption("UNI-NNI", UNI_NNI);
         atom.element.options.selectedIndex = 0;
         
         if (UNI_NNI != modevalue)
         {
             atom.element.onchange();
         } 
    	 
    	 $("overhead").disabled = false;
         $("overhead").value = "";
         $("overheadbutton").disabled = false;
         $("overhead").readOnly = true;

         atom = ct.getAtom("srclowpath");
         atom.element.disabled = true;
         atom.setValue("-");
         
         $("src64ktimeslot").disabled = true;
         $("src64ktimeslot").value = "-";
         $("src64ktimeslotBtn").disabled = true;
         
         atom = pwct.getAtom("pwtype",0);
         atom.clearOptions();
         atom.addOption("SATop", "17");
         atom.element.options.selectedIndex = 0;
         
         atom = pwct.getAtom("pwtype",1);
         atom.clearOptions();
         atom.addOption("SATop", "17");
         atom.element.options.selectedIndex = 0;
     }	 	 	 
}

/**
 *               
 * @return
 */
function onSelectOverHead()
{
    atom = ct.getAtom("srcboard");
    var boardPortString = atom.getValue();
    if (boardPortString != "") 
    {
    	var url = "overheadselect.html?overhead=" + $("overhead").value;
        xshowModalDialog(url, RESOURCE["overhead"], 720, 300, "../../../../../../images/");
    }
}

/**
 *                   
 * @return
 */
function setOverHeadString(/*String*/overheadString)
{
	$("overhead").value = overheadString;
}
