var invalid_char = "-";
var selectedRowID = -1;

function rowSelectHandler()
{    
    var rows = st.getSelectedRows();
    var selectedRowCount = rows.length;
    selectedRowID = -1;
    if (0 < selectedRowCount) 
    {
        selectedRowID = rows[0];
    }
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        doQueryPW();
        doQueryQoS();
        doQueryAttr();
        doQueryProtectGroup();
    }
    else 
    {
        $("deletebtn").disabled = true;
		pwst.clearTableData();
		qosst.clearTableData();
		attrst.clearTableData();
    }
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    closeBarFlg=true;
    
    var data = EncapsulateData(doc);
	LoadingProcess.removeWaitStatus();
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
    	var rowDatas = data.rows;
    	var rowData;
    	var overHeadValue;
    	for(var i = 0,len = rowDatas.length; i < len; i++)
    	{
    		rowData = rowDatas[i];  
    		overHeadValue = processOverHeadValue(data.rows[i].overhead.value);
    		data.rows[i].overhead.value = overHeadValue;
    	}
    	    	
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        adapterSrvPri();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("serviceid").element;
        st.sortRows(ce, 1);
        
        var serviceType;
		var colary;
		 for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
		 {	
			 serviceType = st.getCellStoreValue(i, "servicetype", "servicetype");
			colary = new Array("overhead");
			if(serviceType != TRANSITP2P)
			{
				setOverHeadCellStatus(i, colary, 0, null);	
				setOverHeadCellDefault(i, colary, invalid_char);
			}			
		 }
		 
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
        }
    }
    
    rowSelectHandler();
	
}

function adapterSrvPri()
{
	 for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
	 {
		    var srvPriValue = st.getCellStoreValue(i,"srvPri","srvPri");
			var srvPriCell = st.getCell(i,"srvPri");
		    if(srvPriCell != null && (srvPriValue == undefined || "" ==  srvPriValue))
		    {
		    	var srvPriCellShow = st.getCellShow(i,"srvPri");
		    	st.setCellIsEdit(srvPriCell,"0");
		    	srvPriCellShow.setValue("-");
		    	srvPriCell.element.ondblclick = null;
		    }
	  }    
}

/**
 *   st                 
 * @param row
 * @param colAry
 * @param isEdit
 * @param k
 * @return
 */
function setOverHeadCellStatus(row, colAry, isEdit, dbclickFunc)
{
    for (var i = 0, length = colAry.length; i < length; i++) 
    {
    	st.setCellIsEdit(st.getCell(row, colAry[i]), isEdit);
    	st.getCellElement(row, colAry[i]).ondblclick = dbclickFunc;    	
    }
}

/**
 *   st              
 * @param row
 * @param colary
 * @param defval
 * @return
 */
function setOverHeadCellDefault(row, colary, defval)
{
    var cell;
    for (var i = 0, length = colary.length; i < length; i++) 
    {
        cell = st.getCell(row, colary[i]);
        cell.element.showElement.setValue(defval);        
        st.setCellValue(cell, colary[i], defval);
    }
}

/**
 *           
 * @param overheadcount
 * @param overhead
 * @return
 */
function processOverHeadValue(/*String*/overhead)
{
	var overHeadString = "";
	var overheadinfo = overhead.split(";")
	for(var i = 0, length = overheadinfo.length; i < length; i++)
	{
		if(overheadinfo[i] == "")
		{
			continue;
		}
		overHeadString = overHeadString + overheadString[overheadinfo[i]] + ";";		
	}
	
	var index = overHeadString.lastIndexOf(";");
	if(index > -1)
	{
		overHeadString = overHeadString.substring(0, index);
	}

	return overHeadString;
}

/**
 *               
 * @return
 */
function onSelectOverHead()
{   
  var url = "overheadselect.html?overhead=" + st.getCellShow(selectedRowID,"overhead").element.innerText;
  xshowModalDialog(url, RESOURCE["overhead"], 720, 300, "../../../../../../images/");
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "servicename");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
        cell = st.getCell(i,"overhead");		
		if(null != cell)
		{
			cell.element["ondblclick"] = function()
			{	
				this.modify = true;  
                this.parentNode.modify = true;
                onSelectOverHead();
			}
			
			cell.element.oncontextmenu = function()
			{
				this.modify = true;  
                this.parentNode.modify = true;
                onSelectOverHead();
			}
		}
		
        setInvalidValue(i, "pwID");
        setInvalidValue(i, "tunnel");
        setInvalidValue(i, "snkboard");
        setInvalidValue(i, "snkhighchannel");
        setInvalidValue(i, "snklowchannel");
        setInvalidValue(i, "snktimeslot");
    }
}

function createSendXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    var serviceType;
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("cesindex", st.getCellCurrentValue(indexes[i], "cesindex", "cesindex")));
        rowparams.appendChild(createTagElement("serviceid", st.getCellCurrentValue(i, "serviceid", "serviceid")));
        rowparams.appendChild(createTagElement("servicename", st.getCellCurrentValue(i, "servicename", "servicename")));
        serviceType = st.getCellStoreValue(i, "servicetype", "servicetype");
		colary = new Array("overhead");
		if(serviceType == TRANSITP2P)
        {
        	rowparams.appendChild(createTagElement("autoassign", 0));
            rowparams.appendChild(createTagElement("overheadcount", 0));
            rowparams.appendChild(createTagElement("overhead", "FF"));
        }
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("cesindex", st.getCellCurrentValue(i, "cesindex", "cesindex")));
		row.appendChild(createTagElement("serviceid", st.getCellCurrentValue(i, "serviceid", "serviceid")));
        
        if (st.getCellModify(i, "servicename")) 
        {
            row.appendChild(createTagElement("servicename", st.getCellCurrentValue(i, "servicename", "servicename")));
        }
        if (st.getCellModify(i, "srvPri")) 
        {
            row.appendChild(createTagElement("srvPri", st.getCellCurrentValue(i, "srvPri", "srvPri")));
			row.appendChild(createTagElement("isAuto", 0));
			row.appendChild(createTagElement("isUniAuto", 0));
			row.appendChild(createTagElement("vuniid", st.getCellCurrentValue(i, "vuniid", "vuniid")));
        }  
        
        if (st.getCellModify(i, "overhead")) 
        {
			row.appendChild(createTagElement("autoassign", 0));
			var overHead = st.getCellCurrentValue(i, "overhead", "overhead");
			if(overHead == "")
			{
				row.appendChild(createTagElement("overheadcount", 0));
				row.appendChild(createTagElement("overhead", "FF"));
			}else{
				var overheadinfo = overHead.split(";")
				row.appendChild(createTagElement("overheadcount", overheadinfo.length));
				row.appendChild(createTagElement("overhead", getOverHeadPara(overheadinfo)));
			}			
        }  
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *                               
 * @return
 */
function setOverHeadString(/*String*/overheadString)
{
	var cell = st.getCell(selectedRowID,"overhead");
    cell.element.showElement.setValue(overheadString);        
    st.setCellValue(cell, "overhead", overheadString);
    st.setCellModify(selectedRowID,"overhead",true);
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}
