/**
 *       
 * @param {Object} evt
 */
function popupMenuHandler_PW(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        createTablePopupMenu_PW(rows, evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createTablePopupMenu_PW(rows, evt)
{
    removejsDOMmenu();
    var enableMenu = false;//      
    var disableMenu = false;//      
    for (var i = 0; i < rows.length; i++) 
    {
        var enableState = pwst.getCellStoreValue(rows[i], "enableState", "enableState");
        if (enableState == ENABLED) 
        {
            disableMenu = true;//                   
        }
        else 
        {
            enableMenu = true;
        }
    }
    
    if( winobj.neType == "76" || winobj.neType == "77" || winobj.neType == "83" )
    {
    	var versionArray = winobj.neversion.split(".");
    	if( versionArray[2] >= "03" && versionArray[3] >= "30" )
    	{
    		disableMenu = false;		
    	}
    }
    
    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_1"], "", doSetEnabledStat, ENABLED, enableMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_0"], "", doSetEnabledStat, DISABLED, disableMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["replacetunnel"], "", doReplaceTunnel, rows, false));//          ping  
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

/**
 *     PW
 */
function doQueryPW()
{
	var indexes = st.getSelectedRows();
	if (indexes.length <= 0)
	{
		pwst.clearTableData();
		return;
	}
	var pwIndex = st.getCellStoreValue(indexes[0], "pwIndex", "pwIndex");
	if (null == pwIndex || "" == pwIndex || "nbsp;" == pwIndex)
	{
		pwst.clearTableData();
		return;
	}
    var xml = createQueryPWXml(pwIndex);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_IPPTN_QUERY_PW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryPWCallBack, null, "inputdata=" + xml);
}

/**
 *       PW xml
 */
function createQueryPWXml(param)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("pwIndex", param));
    rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
    bussiness.appendChild(rowparams);
    
    var protectPwIndex = st.getCellStoreValue(indexes[0], 'protectPwIndex', 'protectPwIndex');
    if(protectPwIndex != '' && protectPwIndex)
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", protectPwIndex));
        rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
        bussiness.appendChild(rowparams);
    }

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW     
 * @param {Object} doc
 */
function queryPWCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        pwst.clearTableData();
        createTableBody(pwst, window.tableconf[1], data, RESOURCE);
        refreshPwStatus();
    }
	
	/**for (var i = 0, m = pwst.getDataRowLength(); i < m; i++)
	{
		var workStatus = pwst.getCellCurrentValue(i, "workingStatus", "workingStatus");
		if (null == workStatus || "" == workStatus)
		{
			pwst.getCellShow(i, "workingStatus").element.innerHTML = "-";
		}
	}**/
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = pwst.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = pwst.getCellCurrentValue(rows[i], "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
        
        var rowEnableState = pwst.getCellCurrentValue(rows[i], "enableState", "enableState");
        if (rowEnableState != enableState) 
        {
            row.appendChild(createTagElement("enableState", enableState));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var rows = pwst.getSelectedRows();
    var xml = createSetEnabledXML(enableState, rows);
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_PTN_PWTRIAL_ENABLE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, setEnabledCallBack, param, "inputdata=" + xml);
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = pwst.getCellCurrentValue(rows[j], "pwIndex", "pwIndex");
            if (pwIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = pwst.getCell(rows[k], "enableState");
        pwst.setCellValue(enableStateCell, "enableState", param[1]);
        var cellShow = pwst.getCellShow(rows[k], "enableState");
        cellShow.element.innerHTML = RESOURCE["enableState_" + param[1]];
    }
}

/**
 *   Tunnel      
 * @param {Object} rows
 */
function doReplaceTunnel(rows)
{
}

function refreshPwStatus()
{
    var workPwIndex = st.getCellCurrentValue(st.getSelectedRows()[0], 'pwIndex', 'pwIndex');
    var protectPwIndex = st.getCellCurrentValue(st.getSelectedRows()[0], 'protectPwIndex', 'protectPwIndex');
    for(var i = 0, len = pwst.getDataRowLength(); i < len; i++)
    {
        var pwIndex = pwst.getCellCurrentValue(i, 'pwIndex', 'pwIndex');

        if(pwIndex == workPwIndex)
        {
            pwst.getCellShow(i, 'workingStatus').element.innerText = RESOURCE['working'];
        } else if(pwIndex == protectPwIndex)
        {
            pwst.getCellShow(i, 'workingStatus').element.innerText = RESOURCE['protection'];
        }
    }
}
