var pwct = null;
var pwProtectCT = null;
var pairPwProtectCT = null;
var pwOamCT = null;
var tab = null;
var pwAdvanceAttr = null;


var mode = UNI_NNI;
var selTunnel;
var ENABLE = 1;
var DISABLE = 0;
var srcnode=0;
var snknode=0;
var egresstunnelid=0;
var egresstunnelindex=0;

var protectType = getNeProperty(self).protectType;

var win = getParentWindow();

var nevr =  getNeProperty(win).neversion.split('.');
var neType = getNeProperty(win).neType;

var nmUser = win.nmUser;
var neid = win.neid;

function init()
{
    initTable();
    initUI();
    initTabs();
    initData();
}

function initData()
{
    pwAdvanceAttr = new Object();
    pwAdvanceAttr.rtpEnableState = 0;
    pwAdvanceAttr.cacheTime = 8000;
    pwAdvanceAttr.loadTime = 1000;
    pwAdvanceAttr.clockMode = 0;
    pwAdvanceAttr.ingressExp = 255;    
    pwAdvanceAttr.cesalarmtran = 0;    
    pwAdvanceAttr.thresholdenter = 100;  
    pwAdvanceAttr.thresholdexit = 5;  
    pwAdvanceAttr.serialMode = 1;  
    pwAdvanceAttr.controlchanneltype = 0; 
    pwAdvanceAttr.vccv = 1; 
    doQueryAttr();
}

/**
 *     
 */
function doQueryAttr()
{
    
    var pwIndex = win.pwst.getCellStoreValue(0, 'pwIndex', 'pwIndex');
  
    var xml = createQueryAttrXml(pwIndex);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryAttrCallBack, null, "inputdata=" + xml);
}
/**
 *        xml
 */
function createQueryAttrXml(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("pwIndex", pwIndex));//       
    rowparams.appendChild(createTagElement("pwdomain", "CES"));
    rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
/**
 *        
 * @param {Object} doc
 */
function queryAttrCallBack(doc)
{
    var data = EncapsulateData(doc);
    for(var i=0;i<data.getDataRowLength();i++)
    {
    	if(data.rows[i].clockmode.value=="")
    	{
    		data.rows[i].clockmode.value=-1;
    	}
    	else
    	{
    		pwAdvanceAttr.clockMode = data.rows[i].clockmode.value;
    	}
   		pwAdvanceAttr.rtpEnableState = data.rows[i].rtpEnableState.value;
   		pwAdvanceAttr.cacheTime = data.rows[i].cachtime.value;
   		pwAdvanceAttr.loadTime = data.rows[i].loadtime.value;
   		pwAdvanceAttr.cesalarmtran = data.rows[i].cesalarmtran.value;
   		pwAdvanceAttr.thresholdenter = data.rows[i].thresholdenter.value;
   		pwAdvanceAttr.thresholdexit = data.rows[i].thresholdexit.value;
   		pwAdvanceAttr.serialMode = data.rows[i].serialMode.value;
   		pwAdvanceAttr.controlchanneltype = data.rows[i].ctrlChanType.value;
   		pwAdvanceAttr.vccv = data.rows[i].vccv.value;

    }


}

/**
 *    PW 
 * @return
 */
function initPWCTable()
{
    pwct = new CTable2();
    pwct.element.id = "pwct";
    pwct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]); 
    $("pwtb").appendChild(pwct.getTable());   
    
    var atom = new Atom("text");
    atom.element.name = "0";
    atom.element.disabled = true;
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "4294967295");
    atom1.element.name = "1";
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom, atom1);
    
    var atom2 = document.createElement("input");
    atom2.type = "hidden";
    atom2.id = "workPwIndex";
    atom.element.parentNode.appendChild(atom2);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["static"], "0");
    atom.element.name = "0";
    atom.element.disabled = true;
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["static"], "0");
    atom1.element.onchange = changeSignType;
    atom1.element.name = "1";
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom, atom1);
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption("CESoPSN", "21");
    atom.addOption("SATop", "17");
    atom.element.disabled = true;
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption("CESoPSN", "21");
    atom1.addOption("SATop", "17");
    atom1.element.disabled = true;
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom, atom1);
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["bidirectional"], "1");
    atom.element.disabled = true;
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["bidirectional"], "1");
    atom1.element.disabled = true;
    pwct.addAttrRow("direction", RESOURCE["direction"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.addOption("MPLS", 1);
    atom.element.disabled = true;
    atom1 = new Atom("select");
    atom1.addOption("MPLS", 1);
    atom1.element.name = "1";
    atom1.element.disabled = true;
    pwct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.element.name = "0";
    atom1 = new Atom("text");
    atom1.element.name = "1";
    checkText(atom1.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.name = "0";
    atom.element.disabled = true;
    atom1 = new Atom("text");
    atom1.element.name = "1";
    checkText(atom1.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.disabled = true;
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom, atom1);
    
    atom = new Atom("span");
    atom1 = new Atom("span");
    pwct.addAttrRow("tunnel", "Ingress Tunnel", atom, atom1);
    
    createTunnelAtom(atom, 0);
    disaWkPWsel(0);
    createTunnelAtom(atom1, 1);
    
    atom = new Atom("span");
    atom1 = new Atom("span");
    pwct.addAttrRow("tunnel", "Egress Tunnel", atom, atom1);
    
    createTunnelAtom(atom, 2);
    disaWkPWsel(2);
    createTunnelAtom(atom1, 3);    
    
    atom = new Atom("text");
    atom.element.disabled = true;
    validateIp(atom.element);
    atom1 = new Atom("text");
    validateIp(atom1.element);
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom, atom1);

    setDisplay("33%", ""); 
    
    initPwCtData();
}

function initTable()
{    
    initPWCTable();
    
    initPWProtectTable();
	
    initPairPWProtectTable();
    
    initPWOamTable();
}

function initUI()
{
    $("advattrbtn").value = RESOURCE["advancedattr"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab3div", RESOURCE["configpw"], $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["PW_PROTECT_GROUP"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["PW_PROTECT_GROUP"], $("tab5div"));
    tab.addEmbedTab("tab6div", RESOURCE["PW_OAM"], $("tab6div"));
    
    if(protectType == PW_APS)
    {
        tabHeadList["tab4div"].style.display = ""; 
        tabHeadList["tab5div"].style.display = "none";
        tabHeadList["tab6div"].style.display = "";
    } else {
        tabHeadList["tab4div"].style.display = "none"; 
        tabHeadList["tab5div"].style.display = "";
        tabHeadList["tab6div"].style.display = "none";
    }
    
    setSelectedEmbedTab("tab3div");
    
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function changeSignType()
{
    var index = this.name;
    var signaltype = parseInt(this.value);
    var pwencaptype = pwct.getAtom("pwencaptype", index).element;
    var pwinlabel = pwct.getAtom("pwinlabel", index).element;
    var pwoutlabel = pwct.getAtom("pwoutlabel", index).element;
    
    if (this.value == "1") 
    {
        pwencaptype.disabled = false;
        pwinlabel.value = "";
        pwinlabel.disabled = false;
        pwoutlabel.value = "";
        pwoutlabel.disabled = false; 
    }
    else 
    {
        pwencaptype.selectedIndex = 0;
        pwencaptype.disabled = true;
        pwinlabel.value = "-";
        pwinlabel.disabled = true;
        pwoutlabel.value = "-";
        pwoutlabel.disabled = true;
    }
    
    changeRelatedParam(pwencaptype.value, index);
}

function changeEncapType()
{
    var index = this.name;
    var atom = pwct.getAtom("tunneltype", index);
    atom.clearOptions();
    if (this.value == 1) {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
        atom = pwct.getAtom("pwoutlabel", index);
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
        atom = pwct.getAtom("pwoutlabel", index);
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
    }
}

function changeTunnelType(objid)
{
   if(objid.indexOf("egress")!=-1)
   {
   	   if ($("egressselectedtunnel") != null) 
    {
        $("egressselectedtunnel").value = "";
    }
    if ($("selectedEgresstunnel") != null) 
    {
        $("selectedEgresstunnel").value = "";
    }
   }
    else
   {
    
    if ($("selectedIngresstunnel") != null) 
    {
        $("selectedIngresstunnel").value = "";
    }
    if ($("ingresstunnelindex") != null) 
    {
        $("ingresstunnelindex").value = "";
    }
   
    if (pwct.getAtom("oppsitelsrid") != null) 
    {
        pwct.getAtom("oppsitelsrid").element.value = "";
    }
  }   
}

function doAdvance()
{
    /**
     * RTN R3C02            
     * DTS2011062402520
     */
	 if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0330'))
	 {
		 xshowModalDialog("pwadvanceattr_pt_rtnr3c02.html", RESOURCE["advancedattr"], 580, 520, "../../../../../../images/");
	 }
	 else
	 {
		 xshowModalDialog("pwadvanceattr_pt.html", RESOURCE["advancedattr"], 580, 520, "../../../../../../images/");
	 }
}

function doSelectTunnel()
{
    var buttonIndex =  this.name;
    tunnelIndex = (buttonIndex > 1) ? buttonIndex - 2 : buttonIndex;
    var tunnelType = pwct.getAtom("tunneltype", tunnelIndex).getValue();
   
    var nodetype = -1;
    if (buttonIndex == 0 || buttonIndex == 1)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
        
            xshowModalDialog("../eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function changePWType()
{
    if (this.value == "21") 
    {
        $("src64ktimeslot").value = "1-31";
        $("src64ktimeslot").disabled = false;
        
    }
    else 
    {
        $("src64ktimeslot").value = "-";
        $("src64ktimeslot").disabled = true;
    }
}


function changeRelatedParam(paramvalue, index){
    var atom = pwct.getAtom("tunneltype", index);
    atom.clearOptions();
    
    if (paramvalue == 1) {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        checkText(atom.element, "16", "1048575");
        atom = pwct.getAtom("pwoutlabel", index);
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        checkText(atom.element, "49153", "50176");
        atom = pwct.getAtom("pwoutlabel", index);
        checkText(atom.element, "49153", "50176");
    }
}

function initPWProtectTable(){
    pwProtectCT = new CTable();
    pwProtectCT.element.id = "pwProtectCT";
    pwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("PW APS", "1");
    atom.element.disabled=true;
	pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
   
    
    atom = new Atom("text");
    checkText(atom.element, "1", "32");
    pwProtectCT.addAttrRow("protectid", RESOURCE["PROTECT_ID"], atom);
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["enabled"], "1");
    atom.addOption(RESOURCE["disabled"], "0");
    pwProtectCT.addAttrRow("isenable", RESOURCE["ISENABLE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("1:1", "1");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("protectmode", RESOURCE["PROTECT_MODE"], atom);
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["SWTICH_MODE2"], "1");
    atom.addOption(RESOURCE["SWTICH_MODE1"], "0");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("swtichmode", RESOURCE["SWTICH_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["revertive"], "1");
    atom.addOption(RESOURCE["NO_RECOVERY_MODE"], "0");
    atom.element.onchange = function()
    {
    	 
    	 
    	 var recoverytime = pwProtectCT.getAtom("recoverytime");
    	 if(pwProtectCT.getAtom("recoverymode").getValue() == "1")
    	 {
    	 	   recoverytime.element.disabled = false;
    	 	   recoverytime.element.value = "1";
    	 }else
    	 {
    	 	   recoverytime.element.disabled = true;
    	 	   recoverytime.element.value = "-";
    	 }
    	 
    }
    pwProtectCT.addAttrRow("recoverymode", RESOURCE["RECOVERY_MODE"], atom);
    
    atom = new Atom("text");
    atom.element.value = 1;
    checkText(atom.element, "1", "12");
    pwProtectCT.addAttrRow("recoverytime", RESOURCE["RECOVERY_TIME"], atom);
    
    atom = new Atom("text");
    atom.element.value = 0;
    checkText(atom.element, "0", "100");
    pwProtectCT.addAttrRow("swtichtime", RESOURCE["DELAY_TIME"], atom);
    
    $("pwprotecttb").appendChild(pwProtectCT.getTable());
}

function initPairPWProtectTable()
{
    pairPwProtectCT = new CTable();
    pairPwProtectCT.element.id = "pairPwProtectCT";
    pairPwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["PROTECT_PAIRS"], "1");
    atom.element.disabled=true;
	pairPwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    
    atom = new Atom("span");
    pairPwProtectCT.addAttrRow("protectidspan", RESOURCE["PROTECT_ID"], atom);
    
    var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "protectidforpair";
    checkText(elem, "1", "32");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "protectidBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = function()
	{
		xshowModalDialog("../eline_u2kv1r3c00/selectaps.html", RESOURCE["resourceselected"], 720, 400, "../../../../../../images/");
	};
    atom.element.parentNode.appendChild(elem); 
 
    $("pairpwprotecttb").appendChild(pairPwProtectCT.getTable());
}

function initPWOamTable()
{
    pwOamCT = new CTable2();
    pwOamCT.element.id = "pwOamCT";
    pwOamCT.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]); 
    $("pwoamtb").appendChild(pwOamCT.getTable());   
    
    var atom1 = new Atom("select");
    var atom2 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["enabled"], "1");
    atom1.element.disabled = true;
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["enabled"], "1");
    atom2.element.disabled = true;
    pwOamCT.addAttrRow("pwoam_oamstatus", RESOURCE["OAM_STATUS"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["dtmode1"], "1");
    atom1.addOption(RESOURCE["dtmode2"], "2");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["dtmode1"], "1");
    atom2.addOption(RESOURCE["dtmode2"], "2");
    pwOamCT.addAttrRow("pwoam_dtmode", RESOURCE["DETECT_MODE"], atom1, atom2);
   
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.element.name = "0"
    atom1.element.onchange = changeDetPeriod;
    atom1.addOption(RESOURCE["dtpktype1"], "1");
    atom1.addOption(RESOURCE["dtpktype2"], "2");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.element.name = "1";
    atom2.element.onchange = changeDetPeriod;
    atom2.addOption(RESOURCE["dtpktype1"], "1");
    atom2.addOption(RESOURCE["dtpktype2"], "2");
    pwOamCT.addAttrRow("pwoam_dtpktype", RESOURCE["DETECT_PACKET_TYPE"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption("1000", "255");
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption("1000", "255");
    atom2.element.disabled = true;
    pwOamCT.addAttrRow("pwoam_dtpkpd", RESOURCE["DETECT_PACKET_PERIOD"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.name = "0";
    validateIp(atom1.element);
    atom2 = new Atom("text");
    atom2.element.name = "1";
    validateIp(atom2.element);
    pwOamCT.addAttrRow("pwoam_revlsrid", RESOURCE["LSRID_TOBERECIEVED"], atom1, atom2);
   
    atom1 = new Atom("text");
    atom1.element.name = "0";
    checkText(atom1.element, "1", "4294967295");
    atom2 = new Atom("text");
    atom2.element.name = "1";
    checkText(atom2.element, "1", "4294967295");
    pwOamCT.addAttrRow("pwoam_tstpwid", RESOURCE["TRANSMIT_PWID"], atom1, atom2);
}

function changeDetPeriod()
{
    var index = this.name;
    var atom = pwOamCT.getAtom("pwoam_dtpkpd", index);
    atom.clearOptions();
    if (this.value == 1) {
        atom.addOption("1000", "255");
        atom.element.disabled = true;
    }
    else 
    {
        atom.addOption("3.3", "1");
        atom.addOption("10", "2");
        atom.addOption("20", "3");
        atom.addOption("50", "4");
        atom.addOption("100", "5");
        atom.addOption("200", "6");
        atom.addOption("500", "7");
        atom.element.selectedIndex = 3;
        atom.element.disabled = false;
    }
}

function disaWkPWsel(index)
{
    $('newtunnel' + index).disabled = true;
    $('hadtunnel' + index).disabled = true;
    $('selectedtunnel' + index).disabled = true;
    $('tunnelindex' + index).disabled = true;
    $('ingressid' + index).disabled = true;
    $('egressid' + index).disabled = true;
    $('tunnelBtn' + index).disabled = true;
}

function initPwCtData()
{
    var workPwId = win.pwst.getCellStoreValue(0, 'pwID', 'pwID');
    var workPwIdex = win.pwst.getCellStoreValue(0, 'pwIndex', 'pwIndex');
    
    var servicePwType = win.pwst.getCellStoreValue(0, 'serviceType', 'serviceType');
    
    var pwIngressLabel = win.pwst.getCellStoreValue(0, 'pwIngressLabel', 'pwIngressLabel'); 
    var pwEgressLabel = win.pwst.getCellStoreValue(0, 'pwEgressLabel', 'pwEgressLabel');
    var ingressTunnelId = win.pwst.getCellStoreValue(0, 'tunnelid', 'tunnelid');
    var egressTunnelId = win.pwst.getCellStoreValue(0, 'tunnelid_e', 'tunnelid_e');
    var et_ingressid = win.pwst.getCellStoreValue(0, 'ingressid', 'ingressid');
    var et_egressid = win.pwst.getCellStoreValue(0, 'egressid', 'egressid');
    var et_egressid = win.pwst.getCellStoreValue(0, 'egressid', 'egressid');
    var oppositeLsrID = win.pwst.getCellStoreValue(0, 'oppositeLsrID', 'oppositeLsrID');
    
    pwct.setAttrValue('pwid', 0, workPwId);
    $('workPwIndex').value = workPwIdex;
    
    pwct.getAtom("pwtype", 0).element.selectedIndex = selectActValue(pwct.getAtom("pwtype", 0),servicePwType);
    pwct.getAtom("pwtype", 1).element.selectedIndex = selectActValue(pwct.getAtom("pwtype", 1),servicePwType);
    
    pwct.setAttrValue('pwinlabel', 0, pwIngressLabel);
    pwct.setAttrValue('pwoutlabel', 0, pwEgressLabel);
    $('selectedtunnel0').value = ingressTunnelId;
    $('selectedtunnel2').value = egressTunnelId;
    $('ingressid2').value = et_ingressid;
    $('egressid2').value = et_egressid;
    pwct.setAttrValue('oppsitelsrid', 0, convertNumToIpaddr(oppositeLsrID));
}

function selectActValue(atom,value)
{
	var defaultIndex = 0;
	if(!atom || !value)
	{
		return defaultIndex;
	}
	var ele = atom.element.options;
	for(var i = 0;i < ele.length;i++)
	{
		if(ele[i].value == value)
		{
			defaultIndex = i;
			break;
		}
	}
	return defaultIndex;
}

function createProtectGroup(param)
{
    if (!validate(0) || !validate(1)) 
    {
        return null;
    }

    var xml = createGroupXml();

    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_MSTPPLUS_PW_CREATE_PROTECTGROUP_CES + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createGroupXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    addPwXml(bussiness);//  PW         
    addSetWorkPwXml(bussiness);
    if(protectType == PW_APS)
    {
        addPwApsGroupXml(bussiness);
    } else if(protectType == PROTECT_PAIRS){
        addSetWorkPwXml(bussiness);
        addSlavePairsGroupXml(bussiness);
    }
    
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

function addSetWorkPwXml(bussiness)
{
    var rowParams = new tagElement("row-params");
    rowParams.appendChild(createTagElement("neid", neid));
    rowParams.appendChild(createTagElement("exp", pwAdvanceAttr.ingressExp));
    rowParams.appendChild(createTagElement("direction", pwct.getAtom("direction",0).getValue()));//
    rowParams.appendChild(createTagElement("unknown", "0"));
    rowParams.appendChild(createTagElement("enablestate", pwOamCT.getAtom("pwoam_oamstatus",0).getValue()));
    rowParams.appendChild(createTagElement("checkMode", pwOamCT.getAtom("pwoam_dtmode",0).getValue()));
    rowParams.appendChild(createTagElement("pagcketType", pwOamCT.getAtom("pwoam_dtpktype",0).getValue()));
    rowParams.appendChild(createTagElement("checkPeriod", pwOamCT.getAtom("pwoam_dtpkpd",0).getValue()));
    if(pwOamCT.getAtom("pwoam_revlsrid",0).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",0).getValue()==null)
    {
       rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwct.getAtom("oppsitelsrid",0).getValue())));
    }
    else
    {
       rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwOamCT.getAtom("pwoam_revlsrid",0).getValue())));
    }
    if(pwOamCT.getAtom("pwoam_tstpwid",0).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",0).getValue()==null)
    {
       rowParams.appendChild(createTagElement("sendpwId", pwct.getAtom("pwid",0).getValue()));
    }
     else
    {
       rowParams.appendChild(createTagElement("sendpwId", pwOamCT.getAtom("pwoam_tstpwid",0).getValue()));
    }
        
    bussiness.appendChild(rowParams);
}


function addPwXml(bussiness)
{
    var rowParams = new tagElement("row-params");
    rowParams.appendChild(createTagElement("neid", neid));
    var tunnelIndex = $("tunnelindex1").value;
    /**
     * java       16            
     */
    var tunnelIndexHex = tunnelIndex;//tenToHex(tunnelIndex);
    
    rowParams.appendChild(createTagElement("protectType", protectType));
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowParams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));  //tunnelIndexes:PW  Ingress  
    rowParams.appendChild(createTagElement("pwType", pwct.getAtom("pwtype",1).getValue()));//
    rowParams.appendChild(createTagElement("pwID", pwct.getAtom("pwid",1).getValue()));//
    rowParams.appendChild(createTagElement("direction", pwct.getAtom("direction",1).getValue()));//
    rowParams.appendChild(createTagElement("pwIngressLabel", pwct.getAtom("pwinlabel",1).getValue()));//
    rowParams.appendChild(createTagElement("pwEgressLabel", pwct.getAtom("pwoutlabel",1).getValue()));//
    rowParams.appendChild(createTagElement("oppositeLsrID", convertIPStrToLong(pwct.getAtom("oppsitelsrid",1).getValue())));//
    rowParams.appendChild(createTagElement("pwSignalType", pwct.getAtom("pwsignaltype",1).getValue()));//
    var tunnelid = $("tunnelindex3").value;
    var ingressid = $("ingressid3").value;
    var egressid = $("egressid3").value;
    rowParams.appendChild(createTagElement("ingressid", ingressid)); 
    rowParams.appendChild(createTagElement("egressid", egressid)); 
    rowParams.appendChild(createTagElement("tunnelid", tunnelid)); 
    rowParams.appendChild(createTagElement("tunnelNum", "1")); 
 
    rowParams.appendChild(createTagElement("rtpEnableState", pwAdvanceAttr.rtpEnableState));
    rowParams.appendChild(createTagElement("cachtime", pwAdvanceAttr.cacheTime));
    rowParams.appendChild(createTagElement("loadtime", pwAdvanceAttr.loadTime));
    rowParams.appendChild(createTagElement("timeMode", pwAdvanceAttr.clockMode));
    /**
     *     DTS2011070706699
     *   PW         pw VCC              
     *     44214 PW APS      PW            
     */
	
    rowParams.appendChild(createTagElement("ctrlChanType", pwAdvanceAttr.controlchanneltype));
    rowParams.appendChild(createTagElement("vccv", pwAdvanceAttr.vccv));
    
    rowParams.appendChild(createTagElement("emuLevel", win.pwst.getCellStoreValue(0, 'emulLevel', 'emulLevel')));
    rowParams.appendChild(createTagElement("validTimeslotNum", win.pwst.getCellStoreValue(0, 'timeslotCount', 'timeslotCount')));
    rowParams.appendChild(createTagElement("exp", pwAdvanceAttr.ingressExp));
    
    if(protectType == PW_APS)
    {
        rowParams.appendChild(createTagElement("unknown", "0"));
        rowParams.appendChild(createTagElement("enablestate", pwOamCT.getAtom("pwoam_oamstatus",1).getValue()));
        rowParams.appendChild(createTagElement("checkMode", pwOamCT.getAtom("pwoam_dtmode",1).getValue()));
        rowParams.appendChild(createTagElement("pagcketType", pwOamCT.getAtom("pwoam_dtpktype",1).getValue()));
        rowParams.appendChild(createTagElement("checkPeriod", pwOamCT.getAtom("pwoam_dtpkpd",1).getValue()));
        if(pwOamCT.getAtom("pwoam_revlsrid",1).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",1).getValue()==null)
    {
       rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwct.getAtom("oppsitelsrid",1).getValue())));
    }
    else
    {
       rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwOamCT.getAtom("pwoam_revlsrid",1).getValue())));
    }
    if(pwOamCT.getAtom("pwoam_tstpwid",1).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",1).getValue()==null)
    {
       rowParams.appendChild(createTagElement("sendpwId", pwct.getAtom("pwid",1).getValue()));
    }
     else
    {
       rowParams.appendChild(createTagElement("sendpwId", pwOamCT.getAtom("pwoam_tstpwid",1).getValue()));
    }
    }
        
    bussiness.appendChild(rowParams);
}

function addPwApsGroupXml(bussiness)
{
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("protectType", protectType));  //tunnelIndexes:PW  Ingress  
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 0));
    rowparams.appendChild(createTagElement("apsid", pwProtectCT.getAttrValue('protectid')));
    rowparams.appendChild(createTagElement("tunneltype", 1));
    rowparams.appendChild(createTagElement("protype", pwProtectCT.getAttrValue('protectmode')));
    rowparams.appendChild(createTagElement("isenable", pwProtectCT.getAttrValue('isenable')));
    rowparams.appendChild(createTagElement("switchmode", pwProtectCT.getAttrValue('swtichmode')));
    rowparams.appendChild(createTagElement("rvtmode", pwProtectCT.getAttrValue('recoverymode')));
    rowparams.appendChild(createTagElement("wtrtime", pwProtectCT.getAttrValue('recoverytime')));
    rowparams.appendChild(createTagElement("delaytime", pwProtectCT.getAttrValue('swtichtime')));
    rowparams.appendChild(createTagElement("groupid", 0xFFFF));
    rowparams.appendChild(createTagElement("workPwIndex", $('workPwIndex').value));  
        
    bussiness.appendChild(rowparams);
}

function addSlavePairsGroupXml(bussiness)
{
    var rowParams = new tagElement("row-params");
        
    rowParams.appendChild(createTagElement("protectType", protectType));  //tunnelIndexes:PW  Ingress  
    rowParams.appendChild(createTagElement("neid", neid));
    rowParams.appendChild(createTagElement("autoassign", 0));
    rowParams.appendChild(createTagElement("apsid", $('protectidforpair').value));
    rowParams.appendChild(createTagElement("extendargs", '0000'));
    rowParams.appendChild(createTagElement("workPwIndex", $('workPwIndex').value));  
    
    bussiness.appendChild(rowParams);
}

function validate(index)
{
    var msgArr = new Array();
    var pwID = pwct.getAtom("pwid", index).getValue();
    if (typeof(pwID) == "undefined" || pwID == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwid"] + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var label = pwct.getAtom("pwinlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    label = pwct.getAtom("pwoutlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    var ingresstunnel = $("selectedtunnel" + index).value; //  Ingress Tunnel
    var egresstunnel = $("selectedtunnel" + (index + 2)).value; //  Egress Tunnel
    if (ingresstunnel == "" || egresstunnel == "") 
    {
        msgArr[msgArr.length] = RESOURCE["inputtunnel"];
    }
    if (index == 1)//     ID
    {
    	var protectId = "undefined";
    	var tstpwid1,tstpwid2;
    	var lsrid1,lsrid2;
    	if (protectType == PW_APS)
  	{
  		protectId = pwProtectCT.getAtom("protectid").getValue();
  		tstpwid1 = pwOamCT.getAtom("pwoam_tstpwid", 0).getValue();
  		tstpwid2 = pwOamCT.getAtom("pwoam_tstpwid", 1).getValue();
  		lsrid1 = pwOamCT.getAtom("pwoam_revlsrid", 0).getValue();
  		lsrid2 = pwOamCT.getAtom("pwoam_revlsrid", 1).getValue();
  	}
  	else if(protectType == PROTECT_PAIRS)
	{
		protectId = $("protectidforpair").value;
	}
	
	if (typeof(protectId) == "undefined" || protectId == "") 
	{
                msgArr[msgArr.length] = RESOURCE["PROTECT_ID"] + RESOURCE["rangemsg"] + "1~32";
        }
        
        /*
        if((!lsrid1 || !lsrid2) && protectType == PW_APS)
        {
            msgArr[msgArr.length] = RESOURCE["inputlsridtobereceived"];
        }
        
        if((!tstpwid1 || !tstpwid2) && protectType == PW_APS )
        {
            msgArr[msgArr.length] = RESOURCE["TRANSMIT_PWID"] + RESOURCE["rangemsg"] + "1~4294967295";
        }*/
    }

    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    return true;
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var protectPwIndex = data.getDataRowParam(0, "protectpw");
        var cell = win.st.getCell(win.st.getSelectedRows()[0], 'protectPwIndex');
        win.st.setCellValue(cell, 'protectPwIndex', protectPwIndex);
        
        win.doQueryProtectGroup();
        if (param) 
        {
            xcloseDialog();
        }
    }
}


function embedTabSelectHandler(id)
{
	
	if (id == "tab6div") 
    {
       if(pwOamCT.getAtom("pwoam_tstpwid",0).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",0).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_tstpwid",0).setValue(pwct.getAtom("pwid",0).getValue());
       }
       
       if(pwOamCT.getAtom("pwoam_tstpwid",1).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",1).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_tstpwid",1).setValue(pwct.getAtom("pwid",1).getValue());
       }
       
        if(pwOamCT.getAtom("pwoam_revlsrid",0).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",0).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_revlsrid",0).setValue(pwct.getAtom("oppsitelsrid",0).getValue());
       }
       
       if(pwOamCT.getAtom("pwoam_revlsrid",1).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",1).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_revlsrid",1).setValue(pwct.getAtom("oppsitelsrid",1).getValue());
       }
       
    }
	
}
























