var ct = null;
var st = null;
var pwct = null;
var pwProtectCT = null;
var pairPwProtectCT = null;
var pwOamCT = null;
var tab = null;
var portRes = null;
var pwAdvanceAttr = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var nevr =  getNeProperty(win).neversion.split('.');
var neType = getNeProperty(win).neType;
var mode = UNI_NNI;
var selTunnel;
var ENABLE = 1;
var DISABLE = 0;
var srcnode=0;
var snknode=0;
var egresstunnelid=0;
var egresstunnelindex=0;

/**
 *       PW
 */
var isSupportDynamicPW = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_PTN_CFG_CREATCES","TE_ATTR_SUPPORT_DYNAMICPW");

function init()
{
    initTable();
    initUI();
    initTabs();
    refreshBoardData("src");
    getPortRes();
    refreshSnkBoardData();
    initData();
}

function initData()
{
    pwAdvanceAttr = new Object();
    pwAdvanceAttr.rtpEnableState = 0;
    pwAdvanceAttr.cacheTime = 8000;
    pwAdvanceAttr.loadTime = 1000;
    pwAdvanceAttr.clockMode = 0;
    pwAdvanceAttr.ingressExp = 255;    
    pwAdvanceAttr.cesalarmtran = 0;    
    pwAdvanceAttr.thresholdenter = 100;  
    pwAdvanceAttr.thresholdexit = 5;  
    pwAdvanceAttr.serialMode = 1;  
    pwAdvanceAttr.controlchanneltype = 0; 
    pwAdvanceAttr.vccv = 1; 
}

function iniUpCTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    var atom = new Atom("span");
    ct.addAttrRow("cesid", RESOURCE["serviceid"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "serviceid";
    checkText(elem, "1", "4294967295");
    elem.style.width = "44%";
    elem.disabled = true;
    elem.value = "-";
    atom.element.parentNode.appendChild(elem);

    var elem = document.createElement("input");
    elem.type = "checkbox";
    elem.id = "isAuto";
    elem.style.width = "10%";
    
    elem.onclick = function()
    {
        if ($("isAuto").checked) 
        {
            $("serviceid").disabled = true;
            $("serviceid").value = "-";
        }
        else 
        {
            $("serviceid").disabled = false;
            $("serviceid").value = "";
        }
    };
    atom.element.parentNode.appendChild(elem);
    
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["autoassign"];
    elem.style.width = "45%";
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("servicename", RESOURCE["servicename"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption("E1", 1);
    ct.addAttrRow("level", RESOURCE["level"], atom);
    
    atom = new Atom("select");
    atom.addOption("UNI-UNI", UNI_UNI);
    atom.addOption("UNI-NNI", UNI_NNI);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeMode;
    ct.addAttrRow("mode", RESOURCE["mode"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ID_DISABLE"], DISABLE);
    atom.addOption(RESOURCE["ID_ENABLE"], ENABLE);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeFractionized;
    ct.addAttrRow("fractionized", RESOURCE["fractionized"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "src");
    }
    ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("srchighpath", RESOURCE["srchighpath"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");
	atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("srclowpath", RESOURCE["srclowpath"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("srctimeslot", RESOURCE["src64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "src64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.id = "src64ktimeslotBtn";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
   
   /**
    *        
    */
    atom = new Atom("select");
    atom.addOption("CS7", 1);
    atom.addOption("CS6", 2);
    atom.addOption("EF", 3);
    atom.addOption("AF4", 4);
    atom.addOption("AF3", 5);
    atom.addOption("AF2", 6);
    atom.addOption("AF1", 7);
    atom.addOption("BE", 8);
    atom.element.options.selectedIndex = 2;
    ct.addAttrRow("srvPri", RESOURCE["prilist"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["NO_PROTECT"], NO_PROTECT);
    atom.addOption(RESOURCE["PW_APS"], PW_APS);
    atom.addOption(RESOURCE["PROTECT_PAIRS"], PROTECT_PAIRS);
    atom.element.options.selectedIndex = 0; 
    ct.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    atom.element.onchange = function()
    {
        changeProtecttype();
    }

    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "snk");
    }
    ct.addAttrRow("snkboard", RESOURCE["snkboard"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("snkhighpath", RESOURCE["snkhighpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");
    atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("snklowpath", RESOURCE["snklowpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("span");
    ct.addAttrRow("snktimeslot", RESOURCE["snk64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "snk64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "snk64ktimeslotBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
    
    atom.element.parentNode.parentNode.style.display = "none";
    
    $("tbdiv").appendChild(ct.getTable());
    $("isAuto").checked = true;
}


/**
 *    PW 
 * @return
 */
function initPWCTable()
{
    pwct = new CTable2();
    pwct.element.id = "pwct";
    pwct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]); 
    $("pwtb").appendChild(pwct.getTable());   
    
    var atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    atom.element.name = "0";
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "4294967295");
    atom1.element.name = "1";
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["static"], "0");
    if (isSupportDynamicPW)
    {
    	atom.addOption(RESOURCE["dynamic"], "1");
    }

    atom.element.onchange = changeSignType;
    atom.element.name = "0";
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["static"], "0");
    atom1.element.onchange = changeSignType;
    atom1.element.name = "1";
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption("CESoPSN", "21");
    atom.addOption("SATop", "17");

    atom.element.onchange = changePWType;
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption("CESoPSN", "21");
    atom1.addOption("SATop", "17");
    atom1.element.disabled = true;
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption(RESOURCE["bidirectional"], "1");
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["bidirectional"], "1");
    atom1.element.disabled = true;
    pwct.addAttrRow("direction", RESOURCE["direction"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.addOption("MPLS", 1);
    atom.element.disabled = true;
    atom.element.onchange = changeEncapType;
    atom1 = new Atom("select");
    atom1.addOption("MPLS", 1);
    atom1.element.name = "1";
    atom1.element.disabled = true;
    pwct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.name = "0";
    checkText(atom.element, "16", "1048575");
    atom1 = new Atom("text");
    atom1.element.name = "1";
    checkText(atom1.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.name = "0";
    checkText(atom.element, "16", "1048575");
    atom1 = new Atom("text");
    atom1.element.name = "1";
    checkText(atom1.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom, atom1);
    
    atom = new Atom("span");
    atom1 = new Atom("span");
    pwct.addAttrRow("ingresstunnel", "Ingress Tunnel", atom, atom1, null, "ingresstunnel");
    
    createTunnelAtom(atom, 0);
    createTunnelAtom(atom1, 1);
    
    atom = new Atom("span");
    atom1 = new Atom("span");
    pwct.addAttrRow("egresstunnel", "Egress Tunnel", atom, atom1, null, "egresstunnel");
    
    createTunnelAtom(atom, 2);
    createTunnelAtom(atom1, 3);    
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom1 = new Atom("text");
    validateIp(atom1.element);
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom, atom1);
    
    setDisplay("50%", "none"); 
}

function initTable()
{

    iniUpCTable();
    
    initPortTable();
    
    initPWCTable();
    
    initPWProtectTable();
	
    initPairPWProtectTable();
    
    initPWOamTable();
}

function initUI()
{    
    $("advattrbtn").value = RESOURCE["advancedattr"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["configportattr"], $("tab1div"));  
    tab.addEmbedTab("tab3div", RESOURCE["configpw"], $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["PW_PROTECT_GROUP"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["PW_PROTECT_GROUP"], $("tab5div"));
    tab.addEmbedTab("tab6div", RESOURCE["PW_OAM"], $("tab6div"));
    
    setSelectedEmbedTab("tab1div");
    
    tabHeadList["tab4div"].style.display = "none"; 
    tabHeadList["tab5div"].style.display = "none";
    tabHeadList["tab6div"].style.display = "none";
    
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function embedTabSelectHandler(id)
{
	
	if (id == "tab6div") 
    {
       if(pwOamCT.getAtom("pwoam_tstpwid",0).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",0).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_tstpwid",0).setValue(pwct.getAtom("pwid",0).getValue());
       }
       
       if(pwOamCT.getAtom("pwoam_tstpwid",1).getValue()=="" || pwOamCT.getAtom("pwoam_tstpwid",1).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_tstpwid",1).setValue(pwct.getAtom("pwid",1).getValue());
       }
       
        if(pwOamCT.getAtom("pwoam_revlsrid",0).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",0).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_revlsrid",0).setValue(pwct.getAtom("oppsitelsrid",0).getValue());
       }
       
       if(pwOamCT.getAtom("pwoam_revlsrid",1).getValue()=="" || pwOamCT.getAtom("pwoam_revlsrid",1).getValue()==null)
       {
       	pwOamCT.getAtom("pwoam_revlsrid",1).setValue(pwct.getAtom("oppsitelsrid",1).getValue());
       }       
    }	
}


function refreshBoardData(param)
{
    var text = null;
    var value = null;
    var res = null;
    var tmpArr = new Array();
    var atom = ct.getAtom(param + "board");
    atom.clearOptions();
    for (var i = 0, m = win.resData.length; i < m; i++) 
    {
        res = win.resData[i];
        text = res.slotId + "-" + res.boardName;
        value = res.slotId;
        if (parseInt(res.isTUorLU) == CES_SDH) 
        {
            text += "-" + res.portName;
            value += "-" + res.portId + "-" + res.highChannelCount;
        }
        if (!tmpArr.contains(value)) 
        {
            atom.addOption(text, value);
            tmpArr[tmpArr.length] = value;
        }
    }
    changeBoard(atom.getValue(), param);
}

/**
 *                            null
 * @param param
 * @return
 */
function getHighpathValue(param)
{
    var atom = ct.getAtom(param + "highpath");
    if (!atom.element.disabled) 
    {
        return atom.getValue();
    }
    return "null";
}

function getLowpathValue(param)
{
    var latom = ct.getAtom(param + "lowpath");
    var hatom = ct.getAtom(param + "highpath");
    if (!hatom.element.disabled) 
    {
        return latom.getValue();
    }
    return "null";
}

function changeBoard(param1, param2)
{
    if (param2 == "snk" && parseInt(ct.getAtom("mode").getValue()) == UNI_NNI) 
    {
        var options = ct.getAtom("snkboard").element.options;
        var option = options[options.selectedIndex];
        if (null != tct) 
        {
            var atom = tct.getAtom("inboard", 1);
            atom.clearOptions();
            atom.addOption(option.text, option.value);
            atom = tct.getAtom("outboard", 0);
            atom.clearOptions();
            atom.addOption(option.text, option.value);
        }
        return;
    }
    
    var atom = ct.getAtom(param2 + "highpath");
    atom.clearOptions();
    if (param1.indexOf("-") > 0) 
    {
        atom.element.disabled = false;
        var highCount = parseInt(param1.split("-")[2]);
        for (var i = 1; i <= highCount; i++) 
        {
            atom.addOption("VC4-" + i, i);
        }
    }
    else 
    {
        atom.element.disabled = true;
    }
    
    if ($(param2 + "64ktimeslot").disabled) 
    {
        $(param2 + "64ktimeslot").value = "-";
    }
    else 
    {
        $(param2 + "64ktimeslot").value = "1-31";
    }
    
    if (ct.getAtom(param2 + "lowpath").element.disabled) 
    {
    	ct.getAtom(param2 + "lowpath").element.value = "-";
    }
    else 
    {
    	ct.getAtom(param2 + "lowpath").element.value = "";
    }
   
}


function setElementisEdit(isEdit)
{
    var atom = tct.getAtom("bandwidth", 0);
    atom.element.parent.selview.disabled = isEdit;
    atom.element.parent.txtview.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("nexthopaddr", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("snknode", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("exp", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("inlabel", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelid", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelid", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelname", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelname", 1);
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("staticroute");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("nexthop");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("dstipaddr");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("dstipmask");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("tunnelid");
    atom.element.disabled = isEdit;
    
}

function changeMode()
{
    var highElm = ct.getAtom("snkhighpath").element.parentNode.parentNode;
    var lowElm = ct.getAtom("snklowpath").element.parentNode.parentNode;
    var fractElm = ct.getAtom("fractionized").element.parentNode.parentNode;
    var snkboardElm = ct.getAtom("snkboard").element.parentNode.parentNode;	
    var srvPriElm = ct.getAtom("srvPri").element.parentNode.parentNode;
    var ptElm = ct.getAtom("protecttype").element.parentNode.parentNode;
    
    switch (parseInt(this.value))
    {
        case UNI_NNI:
            if (isIE) 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.dialogHeight = "700px";
                }
                else 
                {
                    window.dialogHeight = "650px";
                }
            }
            else 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.parent.resizeTo(740);
                }
                else 
                {
                    window.parent.resizeTo(700);
                }
            }
            mode = UNI_NNI;
            refreshSnkBoardData();
            highElm.style.display = "none";
            lowElm.style.display = "none";
            fractElm.style.display = "none";
			/**
			 *      
			 */
			srvPriElm.style.display = "";
            $("snk64ktimeslot").parentNode.parentNode.style.display = "none";
            $("snk64ktimeslot").style.display = "none";
            snkboardElm.style.display = "none";
            tabHeadList["tab3div"].disabled = false;
            tabHeadList["tab3div"].style.display = "";
            $("src64ktimeslot").value = "1-31";
            $("src64ktimeslot").disabled = false;
            $("src64ktimeslotBtn").disabled = false;
            checkText($("serviceid"), "1", "4294967295");
            checkText(ct.getAtom("srclowpath").element, "1", "63");
            checkText(ct.getAtom("snklowpath").element, "1", "63");
            ct.getAtom("srclowpath").element.onblur = onLowChannelTextFocusLose;
            ptElm.style.display = "";
            changeProtecttype();
            break;
        case UNI_UNI:
            if (isIE) 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.dialogHeight = "815px";
                }
                else 
                {
                    window.dialogHeight = "765px";
                }
            }
            else 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.parent.resizeTo(825);
                }
                else 
                {
                    window.parent.resizeTo(785);
                }
            }
            mode = UNI_UNI;
            refreshBoardData("snk");
            highElm.style.display = "";
            lowElm.style.display = "";
            fractElm.style.display = "";
            ct.getAtom("fractionized").element.options.selectedIndex = 1;
            $("snk64ktimeslot").parentNode.parentNode.style.display = "";
            $("snk64ktimeslot").style.display = "";
            snkboardElm.style.display = "";
            setSelectedEmbedTab("tab1div");
            tabHeadList["tab3div"].disabled = true;
            tabHeadList["tab3div"].style.display = "none";
            tabHeadList["tab4div"].style.display = "none";
            tabHeadList["tab5div"].style.display = "none";
            tabHeadList["tab6div"].style.display = "none";
            changeFractionized();
            $("serviceid").onblur = function()
            {
            };
            limitPathInput($("serviceid"), "1", "4294967295");
            limitPathInput(ct.getAtom("srclowpath").element, "1", "63");
            limitPathInput(ct.getAtom("snklowpath").element, "1", "63");
			/**
			 *      
			 */			
			srvPriElm.style.display = "none";
			
	    ptElm.style.display = "none";		
            break;
        default:
            break;
    }
    if ($("isAuto").checked) 
    {
        $("serviceid").value = "-";
    }
    else 
    {
        $("serviceid").value = "";
    }
    ct.getAtom("srclowpath").element.value = "";
    ct.getAtom("snklowpath").element.value = "";
	ct.getAtom("srclowpath").element.onblur = onLowChannelTextFocusLose;
    ct.getAtom("snklowpath").element.onblur = onLowChannelTextFocusLose;
    getPortAttr();
}

function setLowpathEnable(flg)
{
	ct.getAtom("srclowpath").element.disable = !flg;
	ct.getAtom("snklowpath").element.disable = !flg;
}

function changeSignType()
{
	var index = this.name;
    var signaltype = parseInt(this.value);
    var pwencaptype = pwct.getAtom("pwencaptype", index).element;
    var pwinlabel = pwct.getAtom("pwinlabel", index).element;
    var pwoutlabel = pwct.getAtom("pwoutlabel", index).element;
    
    if (this.value == "0") 
    {
        pwencaptype.disabled = false;
        pwinlabel.value = "";
        pwinlabel.disabled = false;
        pwoutlabel.value = "";
        pwoutlabel.disabled = false; 
    }
    else 
    {
        pwencaptype.selectedIndex = 0;
        pwencaptype.disabled = true;
        pwinlabel.value = "-";
        pwinlabel.disabled = true;
        pwoutlabel.value = "-";
        pwoutlabel.disabled = true;
    }
    
    changeRelatedParam(pwencaptype.value, index);
}

function changeEncapType()
{
    var index = this.name;
    var atom = pwct.getAtom("tunneltype", index);
    atom.clearOptions();
    if (this.value == 1) {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
        atom = pwct.getAtom("pwoutlabel", index);
        atom.setValue("");
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
        atom = pwct.getAtom("pwoutlabel", index);
        atom.setValue("");
        checkText(atom.element, "49153", "50176");
    }
}

function changeTunnelType(objid)
{
   if(objid.indexOf("egress")!=-1)
   {
   	   if ($("egressselectedtunnel") != null) 
    {
        $("egressselectedtunnel").value = "";
    }
    if ($("selectedEgresstunnel") != null) 
    {
        $("selectedEgresstunnel").value = "";
    }
   }
    else
   {
    
    if ($("selectedIngresstunnel") != null) 
    {
        $("selectedIngresstunnel").value = "";
    }
    if ($("ingresstunnelindex") != null) 
    {
        $("ingresstunnelindex").value = "";
    }
   
    if (pwct.getAtom("oppsitelsrid") != null) 
    {
        pwct.getAtom("oppsitelsrid").element.value = "";
    }
  }
    
   
}

function getPortRes()
{
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVAILABLEPORT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, portResCallBack, null, "inputdata=" + xml);
}

function portResCallBack(doc)
{
    portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = portObj;
    }
}

function refreshSnkBoardData()
{
    var atom = ct.getAtom("snkboard");
    atom.clearOptions();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var portObj = portRes[i];
        var str = portObj.boardName + "-" + portObj.portName;
        if (parseInt(portObj.slotId) != 0xFFFF) 
        {
            str = portObj.slotId + "-" + str;
        }
        atom.addOption(str, portObj.slotId + "-" + portObj.portId);
    }
}

function doAdvance()
{
    /**
     * RTN R3C02            
     * DTS2011062402520
     */
	 if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0330'))
	 {
		 xshowModalDialog("../cesmgr_u2kv1r3c00/pwadvanceattr_rtnr3c02.html", RESOURCE["advancedattr"], 580, 520, "../../../../../../images/");
	 }
	 else
	 {
		 xshowModalDialog("../cesmgr_u2kv1r3c00/pwadvanceattr.html", RESOURCE["advancedattr"], 580, 520, "../../../../../../images/");
	 }
}

function doSelectTunnel()
{
    var buttonIndex =  this.name;
    tunnelIndex = (buttonIndex > 1) ? buttonIndex - 2 : buttonIndex;
    var tunnelType = pwct.getAtom("tunneltype", tunnelIndex).getValue();
    var nodetype = -1;
    if (buttonIndex == 0 || buttonIndex == 1)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
        
        if ($("tunnesignaltype" + buttonIndex).value == "2")
        {
        	$("egresstunnel").style.display = "none";
        }
        else
        {
        	$("egresstunnel").style.display = "";
        }
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function changePWType()
{
    if (this.value == "21") 
    {
        $("src64ktimeslot").value = "1-31";
        $("src64ktimeslot").disabled = false;
        
    }
    else 
    {
        $("src64ktimeslot").value = "-";
        $("src64ktimeslot").disabled = true;
    }
    
    pwct.setAttrValue('pwtype', '1', this.value);
}

function changeFractionized()
{
    if (ct.getAtom("fractionized").element.options.selectedIndex == ENABLE) 
    {
        $("src64ktimeslot").value = "1-31";
        $("src64ktimeslot").disabled = false;
        $("snk64ktimeslot").value = "1-31";
        $("snk64ktimeslot").disabled = false;
        $("snk64ktimeslotBtn").disabled = false;
        $("src64ktimeslotBtn").disabled = false;
    }
    else 
    {
        $("src64ktimeslot").value = "-";
        $("src64ktimeslot").disabled = true;
        $("snk64ktimeslot").value = "-";
        $("snk64ktimeslot").disabled = true;
        $("snk64ktimeslotBtn").disabled = true;
        $("src64ktimeslotBtn").disabled = true;
    }
}

function onSelectTimeSlot()
{
    var param;
    if (this.id == "src64ktimeslotBtn") 
    {
        param = "src";
    }
    else 
    {
        param = "snk";
    }
    atom = ct.getAtom(param + "board");
    var boardPortString = atom.getValue();
    if (boardPortString != "") 
    {
        var portList = boardPortString.split("-");
        var slotid = parseInt(portList[0]);
        var usedport = -1;
        var lowpath = -1;
        if (portList.length > 1) 
        {
            usedport = parseInt(portList[1]);
            lowpath = 1;
        }
        xshowModalDialog("../cesmgr_u2kv1r3c00/timeslotselect.html?slotid=" + slotid + "&port=" + usedport + "&lowpath=" + lowpath + "&type=" + param, RESOURCE["confgmember"], 720, 400, "../../../../../../images/");
    }
}

/**
 *                
 *   CI:CR20100531028    
 *                                  
 */
function onLowChannelTextFocusLose()
{
	getPortAttr();
}

function changeProtecttype()
{
    var protectype = parseInt(ct.getAtom("protecttype").element.value);
    setSelectedEmbedTab("tab1div");
    switch (protectype) {
        case NO_PROTECT:
            setDisplay("50%", "none");
	    tabHeadList["tab4div"].style.display = "none";
	    tabHeadList["tab5div"].style.display = "none";
	    tabHeadList["tab6div"].style.display = "none";
	    var atom = pwct.getAtom("pwsignaltype", 0);
	    atom.clearOptions();
	    atom.addOption(RESOURCE["static"], "0");
	    if (isSupportDynamicPW)
	    {
	    	atom.addOption(RESOURCE["dynamic"], "1");
	    }
        break;
            
        case PW_APS:
            setDisplay("33%", "");
	    tabHeadList["tab4div"].style.display = "";
	    tabHeadList["tab5div"].style.display = "none";
	    tabHeadList["tab6div"].style.display = "";
	    var atom = pwct.getAtom("pwsignaltype", 0);
	    atom.clearOptions();
	    atom.addOption(RESOURCE["static"], "0");
            break;
            
        case PROTECT_PAIRS:
            setDisplay("33%", "");
            tabHeadList["tab4div"].style.display = "none";
	        tabHeadList["tab5div"].style.display = "";
	        tabHeadList["tab6div"].style.display = "none";
	        var atom = pwct.getAtom("pwsignaltype", 0);
	        atom.clearOptions();
	        atom.addOption(RESOURCE["static"], "0");
            break;
            
        default:
            break;
    }    
}

function changeRelatedParam(paramvalue, index){
    var atom = pwct.getAtom("tunneltype", index);
    atom.clearOptions();
    
    if (paramvalue == 1) {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        checkText(atom.element, "16", "1048575");
        atom = pwct.getAtom("pwoutlabel", index);
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel", index);
        checkText(atom.element, "49153", "50176");
        atom = pwct.getAtom("pwoutlabel", index);
        checkText(atom.element, "49153", "50176");
    }
}

function initPWProtectTable(){
    pwProtectCT = new CTable();
    pwProtectCT.element.id = "pwProtectCT";
    pwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("PW APS", "1");
    atom.element.disabled=true;
	pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
   
    
    atom = new Atom("text");
    checkText(atom.element, "1", "32");
    pwProtectCT.addAttrRow("protectid", RESOURCE["PROTECT_ID"], atom);
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["enabled"], "1");
    atom.addOption(RESOURCE["disabled"], "0");
    pwProtectCT.addAttrRow("isenable", RESOURCE["ISENABLE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("1:1", "1");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("protectmode", RESOURCE["PROTECT_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["SWTICH_MODE2"], "1");
    atom.addOption(RESOURCE["SWTICH_MODE1"], "0");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("swtichmode", RESOURCE["SWTICH_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["revertive"], "1");
    atom.addOption(RESOURCE["NO_RECOVERY_MODE"], "0");
    atom.element.onchange = function()
    {    	     	 
    	 var recoverytime = pwProtectCT.getAtom("recoverytime");
    	 if(pwProtectCT.getAtom("recoverymode").getValue() == "1")
    	 {
    	 	   recoverytime.element.disabled = false;
    	 	   recoverytime.element.value = "1";
    	 }else
    	 {
    	 	   recoverytime.element.disabled = true;
    	 	   recoverytime.element.value = "-";
    	 }   	 
    }
    pwProtectCT.addAttrRow("recoverymode", RESOURCE["RECOVERY_MODE"], atom);
    
    atom = new Atom("text");
    atom.element.value = 1;
    checkText(atom.element, "1", "12");
    pwProtectCT.addAttrRow("recoverytime", RESOURCE["RECOVERY_TIME"], atom);
    
    atom = new Atom("text");
    atom.element.value = 0;
    checkText(atom.element, "0", "100");
    pwProtectCT.addAttrRow("swtichtime", RESOURCE["DELAY_TIME"], atom);
    
    $("pwprotecttb").appendChild(pwProtectCT.getTable());
}

function initPairPWProtectTable()
{
    pairPwProtectCT = new CTable();
    pairPwProtectCT.element.id = "pairPwProtectCT";
    pairPwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["PROTECT_PAIRS"], "1");
    atom.element.disabled=true;
	pairPwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    
    atom = new Atom("span");
    pairPwProtectCT.addAttrRow("protectidspan", RESOURCE["PROTECT_ID"], atom);
    
    var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "protectidforpair";
    checkText(elem, "1", "32");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "protectidBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = function()
	{
		xshowModalDialog("../eline_u2kv1r3c00/selectaps.html", RESOURCE["resourceselected"], 720, 400, "../../../../../../images/");
	};
    atom.element.parentNode.appendChild(elem); 
 
    $("pairpwprotecttb").appendChild(pairPwProtectCT.getTable());
}

function initPWOamTable()
{
    pwOamCT = new CTable2();
    pwOamCT.element.id = "pwOamCT";
    pwOamCT.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]); 
    $("pwoamtb").appendChild(pwOamCT.getTable());   
    
    var atom1 = new Atom("select");
    var atom2 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["enabled"], "1");
    atom1.element.disabled = true;
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["enabled"], "1");
    atom2.element.disabled = true;
    pwOamCT.addAttrRow("pwoam_oamstatus", RESOURCE["OAM_STATUS"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["dtmode1"], "1");
    atom1.addOption(RESOURCE["dtmode2"], "2");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["dtmode1"], "1");
    atom2.addOption(RESOURCE["dtmode2"], "2");
    pwOamCT.addAttrRow("pwoam_dtmode", RESOURCE["DETECT_MODE"], atom1, atom2);
   
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.element.name = "0"
    atom1.element.onchange = changeDetPeriod;
    atom1.addOption(RESOURCE["dtpktype1"], "1");
    atom1.addOption(RESOURCE["dtpktype2"], "2");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.element.name = "1";
    atom2.element.onchange = changeDetPeriod;
    atom2.addOption(RESOURCE["dtpktype1"], "1");
    atom2.addOption(RESOURCE["dtpktype2"], "2");
    pwOamCT.addAttrRow("pwoam_dtpktype", RESOURCE["DETECT_PACKET_TYPE"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption("1000", "255");
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption("1000", "255");
    atom2.element.disabled = true;
    pwOamCT.addAttrRow("pwoam_dtpkpd", RESOURCE["DETECT_PACKET_PERIOD"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.name = "0";
    validateIp(atom1.element);
    atom2 = new Atom("text");
    atom2.element.name = "1";
    validateIp(atom2.element);
    pwOamCT.addAttrRow("pwoam_revlsrid", RESOURCE["LSRID_TOBERECIEVED"], atom1, atom2);
   
    atom1 = new Atom("text");
    atom1.element.name = "0";
    checkText(atom1.element, "1", "4294967295");
    atom2 = new Atom("text");
    atom2.element.name = "1";
    checkText(atom2.element, "1", "4294967295");
    pwOamCT.addAttrRow("pwoam_tstpwid", RESOURCE["TRANSMIT_PWID"], atom1, atom2);
}

function changeDetPeriod()
{
    var index = this.name;
    var atom = pwOamCT.getAtom("pwoam_dtpkpd", index);
    atom.clearOptions();
    if (this.value == 1) {
        atom.addOption("1000", "255");
        atom.element.disabled = true;
    }
    else 
    {
        atom.addOption("3.3", "1");
        atom.addOption("10", "2");
        atom.addOption("20", "3");
        atom.addOption("50", "4");
        atom.addOption("100", "5");
        atom.addOption("200", "6");
        atom.addOption("500", "7");
        atom.element.selectedIndex = 3;
        atom.element.disabled = false;
    }
}
