/**
 *        xml
 */
function createQueryAttrXml(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("pwIndex", pwIndex));//       
    rowparams.appendChild(createTagElement("pwdomain", "CES"));
    rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
    bussiness.appendChild(rowparams);
    
    var protectPwIndex = st.getCellStoreValue(st.getSelectedRows()[0], 'protectPwIndex', 'protectPwIndex');
    if(protectPwIndex != '' && protectPwIndex)
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", protectPwIndex));
        rowparams.appendChild(createTagElement("pwdomain", "CES"));
        rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQueryAttr()
{
    var selRows = st.getSelectedRows();
    if (selRows.length <= 0) 
    {
        attrst.clearTableData();
        return;
    }
    
    var pwIndex = st.getCellStoreValue(selRows[0], "pwIndex", "pwIndex");
    if (null == pwIndex || "" == pwIndex || "nbsp;" == pwIndex) 
    {
        attrst.clearTableData();
        return;
    }
    var pwID = st.getCellStoreValue(selRows[0], "pwID", "pwID");
    
    var xml = createQueryAttrXml(pwIndex);
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryAttrCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryAttrCallBack(doc)
{
    var data = EncapsulateData(doc);
    var workPwIndex1 = -1;
    for(var i=0;i<data.getDataRowLength();i++)
    {
    	if( i == 0 && data.rows[0].pwIndex != null )
    	{
    		workPwIndex1 = data.rows[0].pwIndex.value;
    	}
    	
    	if(data.rows[i].clockmode.value=="")
    	{
    		data.rows[i].clockmode.value=-1;
    	}
    }
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        attrst.clearTableData();
        createTableBody(attrst, window.tableconf[3], data, RESOURCE);
    }
    addListener(workPwIndex1);
    
    syncValue();
}

function addListener(workPwIndex1)
{
	
    var cell = null;
    var protectPwIndex = st.getCellCurrentValue(st.getSelectedRows()[0], "protectPwIndex", "protectPwIndex");

    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
		cell = attrst.getCellEdit(i, "cachtime").element;
        textCheckWithStepLen(cell, "375", "16000", "125");
		
		cell = attrst.getCellEdit(i, "loadtime").element;
        textCheck(cell, "125", "5000");
        
        var clockMode = attrst.getCellCurrentValue(i, "egressclockmode", "egressclockmode");
        if (null == clockMode) 
        {
            attrst.getCellShow(i, "egressclockmode").element.innerHTML = "-";
        }
        
        if(!isInValid(protectPwIndex))
        {
            var pwIndex = attrst.getCellCurrentValue(i, "pwIndex", "pwIndex");
            if(protectPwIndex == pwIndex)
            {
                attrst.setCellIsEdit(attrst.getCell(i, 'cesalarmtran'), 0);
                attrst.setCellIsEdit(attrst.getCell(i, 'thresholdenter'), 0);
                attrst.setCellIsEdit(attrst.getCell(i, 'thresholdexit'), 0);
                attrst.setCellIsEdit(attrst.getCell(i, 'serialMode'), 0);
            }
        }
       var tmpPwIndex = attrst.getCellStoreValue(i, 'pwIndex', 'pwIndex');
       if( tmpPwIndex != workPwIndex1 )//      pwIndex      PW  pwIndex     	 
       {
          attrst.setCellIsEdit(attrst.getCell(i, 'cachtime'), 0);
       }
       
        var editElem = attrst.getCellEdit(i, 'cesalarmtran');
        /**
         *      DTS2013043000110  DTS2010111902782 
         *                                                   
         */
        
        editElem = attrst.getCellEdit(i, 'thresholdenter');
        editElem.element.onblur = function()
        {
            numCellOnBlur(this, '1', '65535');
        };
        
        editElem = attrst.getCellEdit(i, 'thresholdexit');
        editElem.element.onblur = function()
        {
            numCellOnBlur(this, '1', '65535');
        };
        
        editElem = attrst.getCellEdit(i, 'serialMode');
        editElem.element.onchange = syncValue4;
    }
}

function createApplyAttrXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var pwId = st.getCellCurrentValue(st.getSelectedRows()[0], "pwID", "pwID");
    var flg = false;
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if (!attrst.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("pwIndex", attrst.getCellCurrentValue(i, "pwIndex", "pwIndex")));
		row.appendChild(createTagElement("pwid", pwId));
        
        if (attrst.getCellModify(i, "rtpEnableState")) 
        {
            row.appendChild(createTagElement("rtpEnableState", attrst.getCellCurrentValue(i, "rtpEnableState", "rtpEnableState")));
        }
        
        if (attrst.getCellModify(i, "cachtime")) 
        {
            row.appendChild(createTagElement("cachtime", attrst.getCellCurrentValue(i, "cachtime", "cachtime")));
        }
        
        if (attrst.getCellModify(i, "loadtime")) 
        {
            row.appendChild(createTagElement("loadtime", attrst.getCellCurrentValue(i, "loadtime", "loadtime")));
        }
        
        if (attrst.getCellModify(i, "cesalarmtran")) 
        {  
            flg = true;
            row.appendChild(createTagElement("cesalarmtran", attrst.getCellCurrentValue(i, "cesalarmtran", "cesalarmtran")));
        }
        
        if (attrst.getCellModify(i, "thresholdenter") || attrst.getCellModify(i, "thresholdexit")) 
        {
            flg = true;
            row.appendChild(createTagElement("thresholdenter", attrst.getCellCurrentValue(i, "thresholdenter", "thresholdenter")));
            row.appendChild(createTagElement("thresholdexit", attrst.getCellCurrentValue(i, "thresholdexit", "thresholdexit")));
        }
        
        if (attrst.getCellModify(i, "serialMode")) 
        {
            flg = true;
            row.appendChild(createTagElement("serialMode", attrst.getCellCurrentValue(i, "serialMode", "serialMode")));
        }
        
        if(flg)
        {
            row.appendChild(createTagElement("autoassign", '0'));
        }
        
        flg = false;
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApplyAttr()
{
	if (!confirm(RESOURCE["warning"]))
	{
		return;
	}
    $("applyattrbtn").disabled = true;
    
    var xml = createApplyAttrXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_IPPTN_SET_PW_ATTRIB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyAttrCallBack, null, "inputdata=" + xml);
}

function applyAttrCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(attrst, window.tableconf[3], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applyattrbtn").disabled = !btnRightArr.applybtn.right;
    }
}

function syncValue(param)
{
    var srcIndex = getDestIndexByPwindex();
    
    
    var srcSerialMode = attrst.getCellCurrentValue(srcIndex, "serialMode", "serialMode")
        srcSerialMode = RESOURCE[SNMode[srcSerialMode]];
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(i != srcIndex)
        {
            
        	var showElem = attrst.getCellShow(i, 'serialMode');
            showElem.element.innerText = srcSerialMode;
        }
    }
}


function syncValue1()
{
    var srcIndex = getDestIndexByPwindex();
    
    var srcCesalarmtran = RESOURCE[enable[attrst.getCellEdit(srcIndex, "cesalarmtran").element.value]];
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(i != srcIndex)
        {
            var showElem = attrst.getCellShow(i, 'cesalarmtran');
            showElem.element.innerText = srcCesalarmtran;
        }
    }
}

function syncValue2()
{
    var srcIndex = getDestIndexByPwindex();
    
    var thresholdenter = attrst.getCellEdit(srcIndex, "thresholdenter").element.value;
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(i != srcIndex)
        {
            var showElem = attrst.getCellShow(i, 'thresholdenter');
            showElem.element.innerText = thresholdenter;
        }
    }
}

function syncValue3()
{
    var srcIndex = getDestIndexByPwindex();
    
    var thresholdexit = attrst.getCellEdit(srcIndex, "thresholdexit").element.value;
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(i != srcIndex)
        {
            var showElem = attrst.getCellShow(i, 'thresholdexit');
            showElem.element.innerText = thresholdexit;
        }
    }
}

function syncValue4()
{
    var srcIndex = getDestIndexByPwindex();
    
    var serialMode = RESOURCE[SNMode[attrst.getCellEdit(srcIndex, "serialMode").element.value]];
    
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(i != srcIndex)
        {
            var showElem = attrst.getCellShow(i, 'serialMode');
            showElem.element.innerText = serialMode;
        }
    }
}

function getDestIndexByPwindex()
{
    var workPwIndex = st.getCellCurrentValue(st.getSelectedRows()[0], "pwIndex", "pwIndex");
    var srcIndex;
    for (var i = 0, m = attrst.getDataRowLength(); i < m; i++) 
    {
        if(workPwIndex == attrst.getCellCurrentValue(i, "pwIndex", "pwIndex"))
        {
            srcIndex = i;
        }
    }
    
    return srcIndex;
}
