loadXMLdoc("../../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../res/ethservice/eline_u2kv1r2c01/elinemgrres_" + SYSTEMCONF.getLanguage() + ".xml");
var st = null;
var BDTYPE_TND1CD1 = 1624;
var PORTTYPE_PTN_TU = "1797";
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var ENABLED = 1;//  
var DISABLED = 0;//   
var IPTYPE_USERSET = 1;
var IPTYPE_UNSET = 0xFF;

var enableFlag = [];
enableFlag[0] = RESOURCE["ID_DISABLE"];
enableFlag[1] = RESOURCE["ID_ENABLE"];

var ethportmode = [];
ethportmode[1] = RESOURCE["level1"];
ethportmode[2] = RESOURCE["level2"];
ethportmode[3] = RESOURCE["level3"];
ethportmode[4] = RESOURCE["level4"];

var encapType = [];
encapType[-1] = "-";
encapType[0] = "Null";
encapType[1] = "802.1Q";
encapType[2] = "QINQ";
encapType[4] = "ATM";
encapType[5] = "PPP";

var e1frm = [];
e1frm[-1] = "-";
e1frm[0] = RESOURCE["E1FRM0"];//   
e1frm[1] = RESOURCE["E1FRM1"];//Double 
e1frm[2] = RESOURCE["E1FRM2"];//CRC-4  
/**
 *          
 */
var isModifyFlg = false;
/*
 *        
 */
function initPortTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("portattrtb").appendChild(st.getTable());
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        st.setBodyHeight("270px");
    }
    else 
    {
        st.setBodyHeight("220px");
    }
    $("portattrtb").oncontextmenu = popupMenuHandler;
}

function cellEditHandler(param)
{
    isModifyFlg = true;
}

function processCellEditByBdtype(pos)
{
    var btName = st.getCellShow(pos, "portname").element.innerHTML;
    if (btName.split('-').contains("CD1")) 
    {
    
        st.setCellIsEdit(st.getCell(pos, "SDHPORT_ATTR_MODE"), 0);
        st.setCellIsEdit(st.getCell(pos, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"), 0);
        setCellButton(st.getCell(pos, "PTNIF_E1PORT_ATTR_E1FRM"), pos);
        setCellButton(st.getCell(pos, "PTNIF_E1PORT_ATTR_E1FRMMODE"), pos);
    }
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
    
        cell = st.getCell(i, "SDHPORT_ATTR_MODE");
        if (null != cell) 
        {
            var encaptype = "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE";
            var modevalue = st.getCellStoreValue(i, "SDHPORT_ATTR_MODE", "SDHPORT_ATTR_MODE");
            if (3 != modevalue) 
            {
                if (st.getCell(i, encaptype)) 
                {
                    st.setCellIsEdit(st.getCell(i, encaptype), 0);
                    st.getCell(i, encaptype).element.ondblclick = null;
                }
            }
            tagCellEvent(cell);
        }
        cell = st.getCellEdit(i, "PTNIF_E1PORT_ATTR_E1FRM");
        if (null != cell) 
        {
            cell.element["onchange"] = function()
            {
                e1FrmChanged(this);
            }
        }
        processCellEditByBdtype(i);
    }
}

/**
 *        button
 * @param cell
 * @return
 */
function setCellButton(cell, i)
{
    var elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.id = i;
    elem.style.width = "100%";
    cell.element.onclick = goButtonClick;
    st.setCellIsEdit(cell, false);
    cell.element.replaceChild(elem, cell.element.childNodes[0]);
}

/**
 *  CD1        
 * @return
 */
function goButtonClick()
{
    var rowindex = this.childNodes[0].id;
    var slotid = st.getCellStoreValue(rowindex, "slotid", "slotid");
    var obj = getNeProperty(self);
    xshowModalDialog("../../../../../../nemgr/sdh/page/pathcfg/pathcfg.html?nmUser=" + win.nmUser +
    "&nmUserName=" +
    win.nmUserName +
    "&neid=" +
    neid +
    "&neversion=" +
    obj.neversion +
    "&slotid=" +
    slotid +
    "&boardType=1624&boardname=CD1&neType=" +
    obj.neType +
    "&domain=rtn&funnodeid=8587&r=0.5508536811558593", RESOURCE["framconfg"], 720, 400, "../../../../../../images/");
}

/**
 * TAG       
 * @param cell    
 * @return  
 */
function tagCellEvent(cell)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        tabCellEditHandler(this);
    }
}

function setCellUnEdit(cellName, rowindex, value, displayValue)
{
    st.setCellValue(st.getCell(rowindex, cellName), cellName, value);
    st.setAtomValue(st.getCell(rowindex, cellName).element.showElement, displayValue);
    
    st.getCell(rowindex, cellName).element.modify = true;
    
    st.setCellIsEdit(st.getCell(rowindex, cellName), 1);
    st.getCell(rowindex, cellName).element.ondblclick = null;
}

/**
 *             
 * @param  
 * @return  
 */
function tabCellEditHandler(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
    
    var encaptype = "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE";
    var e1frm = "PTNIF_E1PORT_ATTR_E1FRM";
    var e1frmmode = "PTNIF_E1PORT_ATTR_E1FRMMODE";
    if ("SDHPORT_ATTR_MODE" == colid) 
    {
        encapTypeCell = st.getCell(rowindex, encaptype);
        if (value == 1 || value == 2) 
        {
            if (value == 1) 
            {
                setCellEdit(encapTypeCell, encaptype, "0", "NULL", DISABLED);
            }
            else//           ATM 	
             {
                setCellEdit(encapTypeCell, encaptype, "4", "ATM", DISABLED);
            }
        }
        else //        
         {
            setCellEdit(encapTypeCell, encaptype, "5", "PPP", ENABLED);
        }
    }
    else if (e1frm == colid) 
    {
        if (value == -1) 
        {
            st.setCellIsEdit(st.getCell(rowindex, e1frm), 0);
        }
    }
    
}

function convertPortName(port, portName)
{
    if (!portName || portName == "") 
    {
        portName = RESOURCE["port"] + "-" + port;
    }
    return port + "(" + portName + ")";
}

function doApplyPortAttr()
{
    if (isModifyFlg) 
    {
        var xmlData = createSetPortAttriXml();
        var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + nmUser;
        loadXMLdoc(urlstr, "POST", false, callbackSetPortAttri, null, "inputdata=" + xmlData);
        return !isModifyFlg;
    }
    else 
    {
        return true;
    }
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetPortAttriXml()
{

    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row;
    var param;
    
    var length = st.getDataRowLength();
    for (var i = 0; i < length; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st.getCellStoreValue(i, "slotid", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", st.getCellStoreValue(i, "port", "port"));
        row.appendChild(param);
        
        if (st.getCellModify(i, "SDHPORT_ATTR_MODE")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "SDHPORT_ATTR_MODE");
            param.setAttribute("value", st.getCellStoreValue(i, "SDHPORT_ATTR_MODE", "SDHPORT_ATTR_MODE"));
            row.appendChild(param);
        }
        if (st.getCellModify(i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
            param.setAttribute("value", st.getCellStoreValue(i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"));
            row.appendChild(param);
        }
        if (st.getCellModify(i, "PTNIF_E1PORT_ATTR_E1FRM")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "PTNIF_E1PORT_ATTR_E1FRM");
            param.setAttribute("value", st.getCellStoreValue(i, "PTNIF_E1PORT_ATTR_E1FRM", "PTNIF_E1PORT_ATTR_E1FRM"));
            row.appendChild(param);
        }
        if (st.getCellModify(i, "PTNIF_E1PORT_ATTR_E1FRMMODE")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "PTNIF_E1PORT_ATTR_E1FRMMODE");
            param.setAttribute("value", st.getCellStoreValue(i, "PTNIF_E1PORT_ATTR_E1FRMMODE", "PTNIF_E1PORT_ATTR_E1FRMMODE"));
            row.appendChild(param);
        }
        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}


function callbackSetPortAttri(doc)
{

    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    
    showErrorDialog(data);
    if (0 == errorCode) 
    {
        refreshTableState(st, window.tableconf[0], data);
        isModifyFlg = false;
    }
    else 
    {
        isModifyFlg = true;
    }
}

function getPortAttr()
{

    var xmlData = createGetPortAttriXml();
    st.clearTableData();
    if (xmlData != null) 
    {
        /**
         *         
         */
        setDocumentCursor("wait");
        var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + nmUser;
        loadXMLdoc(urlstr, "POST", true, callbackGetPortAttri, null, "inputdata=" + xmlData);
    }
    
}

/**
 *       
 */
function setDocumentCursor(curStatus)
{
    document.body.style.cursor = curStatus;
}

function createGetPortAttriXml()
{
    var isNeedQueryFromServer = false;
    var srcSlotid = null;
    var srcPortid = null;
    var snkSlotid = null;
    var snkPortid = null;
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

    var srcAtom = ct.getAtom("srcboard").element;
    if (srcAtom.options.length > 0) 
    {
        var srcboardport = srcAtom.value.split("-");
        srcSlotid = srcboardport[0];
        if (srcboardport.length > 1) 
        {
            srcPortid = srcboardport[1];
        }
        else 
        {
            srcPortid = ct.getAtom("srclowpath").getValue();
            if (srcPortid == "") 
            {
                srcPortid = undefined;
            }
        }
        if (srcPortid != undefined) 
        {
			var srcPortIDList=getLowPathList("src");
			for(var i=0;i<srcPortIDList.length;i++)
			{			
				var row = new tagElement("row-params");
			    
			    var param = new tagElement("param");
			    param.setAttribute("name", "neid");
			    param.setAttribute("value", neid);
			    row.appendChild(param);
			    
			    var param = new tagElement("param");
			    param.setAttribute("name", "porttype");
			    param.setAttribute("value", PORTTYPE_PTN_TU);
			    row.appendChild(param);
				
				param = new tagElement("param");
	            param.setAttribute("name", "slotid");
	            param.setAttribute("value", srcSlotid);
	            row.appendChild(param);
				
	            param = new tagElement("param");
	            param.setAttribute("name", "port");
	            param.setAttribute("value", srcPortIDList[i]);
	            row.appendChild(param);
				bussiness.appendChild(row);
			}
			
            isNeedQueryFromServer = true;
        }
        
    }
    
    
    var snkAtom = ct.getAtom("snkboard").element;
    var snkboardElm = ct.getAtom("snkboard").element.parentNode.parentNode;
    if (snkboardElm.style.display != "none" && snkAtom.options.length > 0) 
    {
    
        var snkboardport = snkAtom.value.split("-");
        snkSlotid = snkboardport[0];
        if (snkboardport.length > 1) 
        {
            snkPortid = snkboardport[1];
        }
        else 
        {
            snkPortid = ct.getAtom("snklowpath").getValue();
            if (snkPortid == "") 
            {
                snkPortid = undefined;
            }
        }
        if (snkPortid != undefined) 
        {
            if (snkAtom.value != srcAtom.value || snkPortid != srcPortid) 
            {
				var snkPortIDList=getLowPathList("snk");
				for(var i=0;i<snkPortIDList.length;i++)
				{
                    row = new tagElement("row-params");
                    var param = new tagElement("param");
                    param.setAttribute("name", "neid");
                    param.setAttribute("value", neid);
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "slotid");
                    param.setAttribute("value", snkSlotid);
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "port");
                    param.setAttribute("value", snkPortIDList[i]);
                    row.appendChild(param);
                    bussiness.appendChild(row);
				}

                isNeedQueryFromServer = true;
            }
        }
        
    }
    if (isNeedQueryFromServer) 
    {
        di.getRoot().appendChild(bussiness);
        return di.toString();
    }
    else 
    {
        return null;
    }
}

function callbackGetPortAttri(doc)
{
    isModifyFlg = false;
    st.clearTableData();
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellEvent();
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            if (null == data.getDataRowParam(i, "PTNIF_E1PORT_ATTR_E1FRMMODE") ||
            "/" == data.getDataRowParam(i, "PTNIF_E1PORT_ATTR_E1FRMMODE")) 
            {
                setCellEdit(st.getCell(i, "PTNIF_E1PORT_ATTR_E1FRMMODE"), "PTNIF_E1PORT_ATTR_E1FRMMODE", "255", "-", false);
                
            }
            if (null == data.getDataRowParam(i, "PTNIF_E1PORT_ATTR_E1FRM")) 
            {
                setCellEdit(st.getCell(i, "PTNIF_E1PORT_ATTR_E1FRM"), "PTNIF_E1PORT_ATTR_E1FRM", "30", "-", false);
            }
        }
    }
    /**
     *          
     */
    setDocumentCursor("auto");
    
}

/**
 *      
 * @param {Object} cell      
 * @param {Object} colId  ID
 * @param {Object} defaultValue       
 * @param {Object} defaultShow       
 */
function setCellEdit(cell, colId, defaultValue, defaultShow, isEdit)
{
    st.setCellIsEdit(cell, isEdit);
    if (isEdit == 0) 
    {
        cell.element.modify = false;
        cell.element.ondblclick = null;
        cell.element.style.backgroundColor = "";//        
    }
    else 
    {
        cell.element.modify = true;
        cell.element.ondblclick = cellondbclick;
        cell.element.style.backgroundColor = "#d0f946";//        
    }
    
    st.setCellValue(cell, colId, defaultValue);
    st.setAtomValue(cell.element.showElement, defaultShow);
}

function e1FrmChanged(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var e1FrmModeCell = st.getCell(rowindex, "PTNIF_E1PORT_ATTR_E1FRMMODE");//      
    var e1FrmMode = atom.value;//   
    if (e1FrmMode == 0)//               - 
    {
        setCellEdit(e1FrmModeCell, "PTNIF_E1PORT_ATTR_E1FRMMODE", "255", "-", false);
    }
    else 
    {
        setCellEdit(e1FrmModeCell, "PTNIF_E1PORT_ATTR_E1FRMMODE", "30", "30", true);
    }
}
