var ct = null;
var st = null;
var pwct = null;
var tab = null;
var portRes = null;
var pwAdvanceAttr = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var mode = UNI_NNI;
var selTunnel;
var ENABLE = 1;
var DISABLE = 0;

function init()
{
    initTable();
    initUI();
    initTabs();
    refreshBoardData("src");
    getPortRes();
    refreshSnkBoardData();
    initData();
}

function initData()
{
    pwAdvanceAttr = new Object();
    pwAdvanceAttr.rtpEnableState = 0;
    pwAdvanceAttr.cacheTime = 8000;
    pwAdvanceAttr.loadTime = 1000;
    pwAdvanceAttr.clockMode = 0;
    pwAdvanceAttr.ingressExp = 255;
    if (compare(win.neversion, "5.76.01.40") > 0 && compare(win.neversion, "5.76.01.99") < 0)
    {
        pwAdvanceAttr.controlchanneltype = 1;
        pwAdvanceAttr.vccv = 1;
    }
}

function iniUpCTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    var atom = new Atom("span");
    ct.addAttrRow("cesid", RESOURCE["serviceid"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "serviceid";
    checkText(elem, "1", "4294967295");
    elem.style.width = "44%";
    elem.disabled = true;
    elem.value = "-";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "checkbox";
    elem.id = "isAuto";
    elem.style.width = "10%";
    
    elem.onclick = function()
    {
        if ($("isAuto").checked) 
        {
            $("serviceid").disabled = true;
            $("serviceid").value = "-";
        }
        else 
        {
            $("serviceid").disabled = false;
            $("serviceid").value = "";
        }
    };
    atom.element.parentNode.appendChild(elem);
    
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["autoassign"];
    elem.style.width = "45%";
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("servicename", RESOURCE["servicename"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption("E1", 1);
    ct.addAttrRow("level", RESOURCE["level"], atom);
    
    atom = new Atom("select");
    atom.addOption("UNI-UNI", UNI_UNI);
    atom.addOption("UNI-NNI", UNI_NNI);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeMode;
    ct.addAttrRow("mode", RESOURCE["mode"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ID_DISABLE"], DISABLE);
    atom.addOption(RESOURCE["ID_ENABLE"], ENABLE);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeFractionized;
    ct.addAttrRow("fractionized", RESOURCE["fractionized"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "src");
    }
    ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("srchighpath", RESOURCE["srchighpath"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");
	atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("srclowpath", RESOURCE["srclowpath"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("srctimeslot", RESOURCE["src64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "src64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.id = "src64ktimeslotBtn";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        changeBoard(this.value, "snk");
    }
    ct.addAttrRow("snkboard", RESOURCE["snkboard"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("snkhighpath", RESOURCE["snkhighpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("text");
    checkText(atom.element, "1", "63");
    atom.element.onblur = onLowChannelTextFocusLose;
    ct.addAttrRow("snklowpath", RESOURCE["snklowpath"], atom);
    atom.element.parentNode.parentNode.style.display = "none";
    
    atom = new Atom("span");
    ct.addAttrRow("snktimeslot", RESOURCE["snk64ktimeslot"], atom);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "snk64ktimeslot";
    elem.value = "1-31";
    limitPathInput(elem, "1", "31");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "snk64ktimeslotBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = onSelectTimeSlot;
    atom.element.parentNode.appendChild(elem);
    
    atom.element.parentNode.parentNode.style.display = "none";
    
    $("tbdiv").appendChild(ct.getTable());
    $("isAuto").checked = true;
}


/**
 *    PW 
 * @return
 */
function initPWCTable()
{
    pwct = new CTable();
    pwct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    var atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["static"], "0");
    atom.addOption(RESOURCE["dynamic"], "1");
    atom.element.onchange = changeSignType;
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("CESoPSN", "21");
    atom.addOption("SATop", "17");
    atom.element.onchange = changePWType;
    
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["bidirectional"], "1");
    pwct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.element.onchange = changeTunnelType;
    pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom);
    
    atom = new Atom("span");
    pwct.addAttrRow("tunnel", "Tunnel", atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel";
    elem.onclick = function()
    {
        changeTunnelType();
        $("hadtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["newbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel";
    elem.onclick = function()
    {
        changeTunnelType();
        $("newtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["useexist"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    selTunnel = elem;
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    
    
    atom = new Atom("text");
    validateIp(atom.element);
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom);
    
    $("pwtb").appendChild(pwct.getTable());
    
    $("newtunnel").onclick();
}

function initTable()
{

    iniUpCTable();
    
    initPortTable();
    
    initPWCTable();
    
}

function initUI()
{
    
    $("advattrbtn").value = RESOURCE["advancedattr"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["configportattr"], $("tab1div"));
    
    tab.addEmbedTab("tab3div", RESOURCE["configpw"], $("tab3div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}


function refreshBoardData(param)
{
    var text = null;
    var value = null;
    var res = null;
    var tmpArr = new Array();
    var atom = ct.getAtom(param + "board");
    atom.clearOptions();
    for (var i = 0, m = win.resData.length; i < m; i++) 
    {
        res = win.resData[i];
        text = res.slotId + "-" + res.boardName;
        value = res.slotId;
        if (parseInt(res.isTUorLU) == CES_SDH) 
        {
            text += "-" + res.portName;
            value += "-" + res.portId + "-" + res.highChannelCount;
        }
        if (!tmpArr.contains(value)) 
        {
            atom.addOption(text, value);
            tmpArr[tmpArr.length] = value;
        }
    }
    changeBoard(atom.getValue(), param);
}

/**
 *                            null
 * @param param
 * @return
 */
function getHighpathValue(param)
{
    var atom = ct.getAtom(param + "highpath");
    if (!atom.element.disabled) 
    {
        return atom.getValue();
    }
    return "null";
}

function getLowpathValue(param)
{
    var latom = ct.getAtom(param + "lowpath");
    var hatom = ct.getAtom(param + "highpath");
    if (!hatom.element.disabled) 
    {
        return latom.getValue();
    }
    return "null";
}

function changeBoard(param1, param2)
{
    if (param2 == "snk" && parseInt(ct.getAtom("mode").getValue()) == UNI_NNI) 
    {
        var options = ct.getAtom("snkboard").element.options;
        var option = options[options.selectedIndex];
        if (null != tct) 
        {
            var atom = tct.getAtom("inboard", 1);
            atom.clearOptions();
            atom.addOption(option.text, option.value);
            atom = tct.getAtom("outboard", 0);
            atom.clearOptions();
            atom.addOption(option.text, option.value);
        }
        return;
    }
    
    var atom = ct.getAtom(param2 + "highpath");
    atom.clearOptions();
    if (param1.indexOf("-") > 0) 
    {
        atom.element.disabled = false;
        var highCount = parseInt(param1.split("-")[2]);
        for (var i = 1; i <= highCount; i++) 
        {
            atom.addOption("VC4-" + i, i);
        }
    }
    else 
    {
        atom.element.disabled = true;
    }
    
    if ($(param2 + "64ktimeslot").disabled) 
    {
        $(param2 + "64ktimeslot").value = "-";
    }
    else 
    {
        $(param2 + "64ktimeslot").value = "1-31";
    }
    ct.getAtom(param2 + "lowpath").element.value = "";
}


function setElementisEdit(isEdit)
{
    var atom = tct.getAtom("bandwidth", 0);
    atom.element.parent.selview.disabled = isEdit;
    atom.element.parent.txtview.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("nexthopaddr", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("snknode", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("exp", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("inlabel", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelid", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelid", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelname", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelname", 1);
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("staticroute");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("nexthop");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("dstipaddr");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("dstipmask");
    atom.element.disabled = isEdit;
    
    atom = ipct.getAtom("tunnelid");
    atom.element.disabled = isEdit;
    
}

function changeMode()
{

    var highElm = ct.getAtom("snkhighpath").element.parentNode.parentNode;
    var lowElm = ct.getAtom("snklowpath").element.parentNode.parentNode;
    var fractElm = ct.getAtom("fractionized").element.parentNode.parentNode;
    var snkboardElm = ct.getAtom("snkboard").element.parentNode.parentNode;
    switch (parseInt(this.value))
    {
        case UNI_NNI:
            if (isIE) 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.dialogHeight = "700px";
                }
                else 
                {
                    window.dialogHeight = "650px";
                }
            }
            else 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.parent.resizeTo(710);
                }
                else 
                {
                    window.parent.resizeTo(660);
                }
            }
            mode = UNI_NNI;
            refreshSnkBoardData();
            highElm.style.display = "none";
            lowElm.style.display = "none";
            fractElm.style.display = "none";
            $("snk64ktimeslot").parentNode.parentNode.style.display = "none";
            $("snk64ktimeslot").style.display = "none";
            snkboardElm.style.display = "none";
            tabHeadList["tab3div"].disabled = false;
            $("src64ktimeslot").value = "1-31";
            $("src64ktimeslot").disabled = false;
            $("src64ktimeslotBtn").disabled = false;
            checkText($("serviceid"), "1", "4294967295");
            checkText(ct.getAtom("srclowpath").element, "1", "63");
            checkText(ct.getAtom("snklowpath").element, "1", "63");
            ct.getAtom("srclowpath").element.onblur = onLowChannelTextFocusLose;
            break;
        case UNI_UNI:
            if (isIE) 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.dialogHeight = "815px";
                }
                else 
                {
                    window.dialogHeight = "765px";
                }
            }
            else 
            {
                if (SYSTEMCONF.getLanguage() == "en") 
                {
                    window.parent.resizeTo(825);
                }
                else 
                {
                    window.parent.resizeTo(785);
                }
            }
            mode = UNI_UNI;
            refreshBoardData("snk");
            highElm.style.display = "";
            lowElm.style.display = "";
            fractElm.style.display = "";
            ct.getAtom("fractionized").element.options.selectedIndex = 1;
            $("snk64ktimeslot").parentNode.parentNode.style.display = "";
            $("snk64ktimeslot").style.display = "";
            snkboardElm.style.display = "";
            setSelectedEmbedTab("tab1div");
            tabHeadList["tab3div"].disabled = true;
            changeFractionized();
            $("serviceid").onblur = function()
            {
            };
            limitPathInput($("serviceid"), "1", "4294967295");
            limitPathInput(ct.getAtom("srclowpath").element, "1", "63");
            limitPathInput(ct.getAtom("snklowpath").element, "1", "63");
            break;
        default:
            break;
    }
    if ($("isAuto").checked) 
    {
        $("serviceid").value = "-";
    }
    else 
    {
        $("serviceid").value = "";
    }
    ct.getAtom("srclowpath").element.value = "";
    ct.getAtom("snklowpath").element.value = "";
	ct.getAtom("srclowpath").element.onblur = onLowChannelTextFocusLose;
    ct.getAtom("snklowpath").element.onblur = onLowChannelTextFocusLose;
    getPortAttr();
}
function setLowpathEnable(flg)
{
	ct.getAtom("srclowpath").element.disable = !flg;
	ct.getAtom("snklowpath").element.disable = !flg;
}
function changeSignType()
{
    if (this.value == "1") 
    {
        var atom = pwct.getAtom("pwinlabel");
        atom.setValue("-");
        atom.element.disabled = true;
        atom = pwct.getAtom("pwoutlabel");
        atom.setValue("-");
        atom.element.disabled = true;
        
    }
    else 
    {
        var atom = pwct.getAtom("pwinlabel");
        atom.setValue("");
        atom.element.disabled = false;
        atom = pwct.getAtom("pwoutlabel");
        atom.setValue("");
        atom.element.disabled = false;
    }
}

function changeEncapType()
{
    changeTunnelType();
    var atom = pwct.getAtom("tunneltype");
    atom.clearOptions();
    var enctype = pwct.getAtom("pwencaptype");
    if (enctype.getValue() == 1) 
    {
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel");
        if (!atom.element.disabled) 
        {
            atom.setValue("");
        }
        checkText(atom.element, "16", "1048575");
        atom = pwct.getAtom("pwoutlabel");
        if (!atom.element.disabled) 
        {
            atom.setValue("");
        }
        checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
        atom = pwct.getAtom("pwinlabel");
        if (!atom.element.disabled) 
        {
            atom.setValue("");
        }
        checkText(atom.element, "49153", "50176");
        atom = pwct.getAtom("pwoutlabel");
        if (!atom.element.disabled) 
        {
            atom.setValue("");
        }
        checkText(atom.element, "49153", "50176");
    }
}

function changeTunnelType()
{

    if ($("selectedtunnel") != null) 
    {
        $("selectedtunnel").value = "";
    }
    if ($("tunnelindex") != null) 
    {
        $("tunnelindex").value = "";
    }
    if (pwct.getAtom("oppsitelsrid") != null) 
    {
        pwct.getAtom("oppsitelsrid").element.value = "";
    }
}

function getPortRes()
{
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVAILABLEPORT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, portResCallBack, null, "inputdata=" + xml);
}

function portResCallBack(doc)
{
    portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = portObj;
    }
}

function refreshSnkBoardData()
{
    var atom = ct.getAtom("snkboard");
    atom.clearOptions();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var portObj = portRes[i];
        var str = portObj.boardName + "-" + portObj.portName;
        if (parseInt(portObj.slotId) != 0xFFFF) 
        {
            str = portObj.slotId + "-" + str;
        }
        atom.addOption(str, portObj.slotId + "-" + portObj.portId);
    }
}

function doAdvance()
{
    xshowModalDialog("pwadvanceattr.html", RESOURCE["advancedattr"], 580, 400, "../../../../../../images/");
}

function doSelectTunnel()
{
    var tunnelType = pwct.getAtom("tunneltype").getValue();
    if ($("hadtunnel").checked) 
    {
        xshowModalDialog("../ethcommon/selecttunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../ethcommon/createmplstunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 600, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function changePWType()
{
    if (this.value == "21") 
    {
        $("src64ktimeslot").value = "1-31";
        $("src64ktimeslot").disabled = false;
        
    }
    else 
    {
        $("src64ktimeslot").value = "-";
        $("src64ktimeslot").disabled = true;
    }
}

function changeFractionized()
{
    if (ct.getAtom("fractionized").element.options.selectedIndex == ENABLE) 
    {
        $("src64ktimeslot").value = "1-31";
        $("src64ktimeslot").disabled = false;
        $("snk64ktimeslot").value = "1-31";
        $("snk64ktimeslot").disabled = false;
        $("snk64ktimeslotBtn").disabled = false;
        $("src64ktimeslotBtn").disabled = false;
    }
    else 
    {
        $("src64ktimeslot").value = "-";
        $("src64ktimeslot").disabled = true;
        $("snk64ktimeslot").value = "-";
        $("snk64ktimeslot").disabled = true;
        $("snk64ktimeslotBtn").disabled = true;
        $("src64ktimeslotBtn").disabled = true;
    }
}

function onSelectTimeSlot()
{
    var param;
    if (this.id == "src64ktimeslotBtn") 
    {
        param = "src";
    }
    else 
    {
        param = "snk";
    }
    atom = ct.getAtom(param + "board");
    var boardPortString = atom.getValue();
    if (boardPortString != "") 
    {
        var portList = boardPortString.split("-");
        var slotid = parseInt(portList[0]);
        var usedport = -1;
        var lowpath = -1;
        if (portList.length > 1) 
        {
            usedport = parseInt(portList[0]);
            lowpath = 1;
        }
        xshowModalDialog("timeslotselect.html?slotid=" + slotid + "&port=" + usedport + "&lowpath=" + lowpath + "&type=" + param, RESOURCE["confgmember"], 720, 400, "../../../../../../images/");
    }
}

/**
 *                
 *   CI:CR20100531028    
 *                                  
 */
function onLowChannelTextFocusLose()
{
	getPortAttr();
}
