
var st,throughputst,latencyst,packetlossst,longpacketlossst;

var serviceIndex;

var obj = getNeProperty(self);
var neid = obj["neid"];
var nmuser = obj["nmUser"]

var btnRightArr = new Object();

var autotestTab;

var ENDFLAG = new Object();
ENDFLAG[0] = "source";
ENDFLAG[1] = "sink";
var ENDFLAG_SOURCE = 0;
var ENDFLAG_SINK = 1;
var ENABLESTATUE = new Object();
ENABLESTATUE[0] = "disabled";
ENABLESTATUE[1] = "enabled";
var STATUES_ENABLE = 1;
var STATUES_DISABLE = 0;

var TEST_START = 1;
var TEST_STOP = 0;

var TEST_TYPE_NORMAL = 0;
var TEST_TYPE_LONG = 1;

var autoTestTimer = null;

var bQueryFlag = false;

var MAX_START_NUMBER = 5;

var UNI_TYPE = "1";
/**
 *              3    
 */
var QueryLongTimeOut = 4;
/**
 *            
 */
var queryLongTestTime = 0;

/**
 *          
 * @return void
 */
function init()
{
    initButton();
    initAutoTestTable();
    initTabTable();
    initTabPanel();
    
    $("totalrow").innerHTML = RESOURCE["countrows"];
    $("selrow").innerHTML = RESOURCE["seleterows"];
    
    if(btnRightArr.querybtn.right)
    {
    	queryAutoTest();
    }
}

/**
 *      
 * @return void
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybtn"];
    $("startTestbtn").value = RESOURCE["starttestbtn"];
    $("stopTestbtn").value = RESOURCE["stoptestbtn"];
    $("startLongTestbtn").value = RESOURCE["startlongtestbtn"];
    $("stopLongTestbtn").value = RESOURCE["stoplongtestbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    $("exportbtn").value = RESOURCE["exportbtn"];
    if(SYSTEMCONF.getLanguage() == "en")
	{
		$("startLongTestbtn").className = "buttonstyle9";
		$("stopLongTestbtn").className = "buttonstyle9";
		$("exportbtn").className = "buttonstyle3";
	}
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_ETHSRV_QUERY_AUTOTEST_PARAM);
    btnRightArr.startTestbtn = new BtnRightObj("startTestbtn", TECMDCODE_ETHSRV_OPERATE_AUTOTEST);
    btnRightArr.stopTestbtn = new BtnRightObj("stopTestbtn", TECMDCODE_ETHSRV_OPERATE_AUTOTEST);
    btnRightArr.startLongTestbtn = new BtnRightObj("startLongTestbtn", TECMDCODE_ETHSRV_OPERATE_LONGTERMTEST);
    btnRightArr.stopLongTestbtn = new BtnRightObj("stopLongTestbtn", TECMDCODE_ETHSRV_OPERATE_LONGTERMTEST);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_ETHSRV_SET_AUTOTEST_PARAM);
    btnRightArr.exportbtn = new BtnRightObj("exportbtn", TECMDCODE_ETHSRV_QUERY_AUTOTEST_RESULT);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
    $("startTestbtn").disabled = true;
    $("stopTestbtn").disabled = true;
    $("startLongTestbtn").disabled = true;
    $("stopLongTestbtn").disabled = true;
    $("exportbtn").disabled = true;
    $("applybtn").disabled = true;
}

/**
 *     Tab      
 * @return void
 */
function initTabTable()
{
    throughputst = new SortTable();
    throughputst.setImage("../../../../../../images/");
    createTableHead(throughputst, window.tableconf[1]);
    throughputst.setBodyHeight("180px");
    $("throughputcontainer").appendChild(throughputst.getTable());
    
    latencyst = new SortTable();
    latencyst.setImage("../../../../../../images/");
    createTableHead(latencyst, window.tableconf[2]);
    latencyst.setBodyHeight("180px");
    $("latencycontainer").appendChild(latencyst.getTable());
    
    packetlossst = new SortTable();
    packetlossst.setImage("../../../../../../images/");
    createTableHead(packetlossst, window.tableconf[3]);
    packetlossst.setBodyHeight("180px");
    $("packetlosscontainer").appendChild(packetlossst.getTable());
    
    longpacketlossst = new SortTable();
    longpacketlossst.setImage("../../../../../../images/");
    createTableHead(longpacketlossst, window.tableconf[4]);
    longpacketlossst.setBodyHeight("180px");
    $("longpacketlosscontainer").appendChild(longpacketlossst.getTable());
}

/**
 *             
 * @return void
 */
function initAutoTestTable()
{
    st = new SortTable();
    st.setSingleChoiceFlg(true);
    st.setImage("../../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getComponetHeight($("elinemgrtable"), 300) + "px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("elinemgrtable").appendChild(st.getTable());
    $("elinemgrtable").oncontextmenu = popupMenuHandler;
}

/**
 *    Tab  
 * @return void
 */
function initTabPanel()
{
    autotestTab = new EmbedTabs();
    autotestTab.addEmbedTab("throughputtab",RESOURCE["throughput"],$("throughputtab"));
    autotestTab.addEmbedTab("latencytab",RESOURCE["latency"],$("latencytab"));
    autotestTab.addEmbedTab("packetlosstab",RESOURCE["packetloss"],$("packetlosstab"));
    autotestTab.addEmbedTab("longpacketlosstab",RESOURCE["longpacketloss"],$("longpacketlosstab"));
    setSelectedEmbedTab("throughputtab");
    $("autotestcontainer").appendChild(autotestTab.view);
}

/**
 * Tab                       
 * @return void
 */
function embedTabSelectHandler(id)
{
	if(id == "throughputtab")
	{
		throughputst.adjustLayout(window.tableconf[1]);
	}
	else if(id == "latencytab")
	{
		latencyst.adjustLayout(window.tableconf[2]);
	}
	else if(id == "packetlosstab")
	{
		packetlossst.adjustLayout(window.tableconf[3])
	}
	else if(id == "longpacketlosstab")
	{
		longpacketlossst.adjustLayout(window.tableconf[4]);
	}
}

/**
 *       -1   -       %
 * @return void
 */
function convertProcess(/*String*/value)
{
	if(value == "" || value == "-1")
	{
		return "-";
	}
	return value + "%";
}

/**
 *              
 *              
 * @return void
 */
function rowSelectHandler()
{
    var selectedRows = st.getSelectedRows();
    $("selrownum").innerHTML = selectedRows.length;
    if(selectedRows.length > 0)
    {
    	var selectIndex = st.getCellStoreValue(selectedRows[0], "storeValue", "serviceIndex");
    	if(serviceIndex == selectIndex)
    	{
    		return;
    	}
    	serviceIndex = selectIndex;
    	longpacketlossst.clearTableData();
    	handleLongATParam();
    	handleTestBtnStatus();
		queryAutoTestResult(false);
    }
    else
    {
    	serviceIndex = -1;
    	$("startTestbtn").disabled = true;
	    $("stopTestbtn").disabled = true;
	    $("startLongTestbtn").disabled = true;
		$("stopLongTestbtn").disabled = true;
		longpacketlossst.clearTableData();
    }
}

function refreshFrameSize()
{
	var selectedRows = st.getSelectedRows();
	var specialfsize = st.getCellStoreValue(selectedRows[0], "storeValue", "specialfsize");
	if(specialfsize && specialfsize != "")
	{
		var title = RESOURCE["framesize"] + ":" + convertFrameSize(specialfsize);
		$("throughputfsizeTitle").innerHTML = title;
		$("latencyfsizeTitle").innerHTML = title;
		$("packetlossfsizeTitle").innerHTML = title;
	}
	else
	{
		$("throughputfsizeTitle").innerHTML = "";
		$("latencyfsizeTitle").innerHTML = "";
		$("packetlossfsizeTitle").innerHTML = "";
	}
}

function convertFrameSize(fsize)
{
	if(fsize == 0xFFFF)
	{
		return RESOURCE["allitems"];
	}
	return fsize;
}

/**
 *                  
 * @return void
 */
function handleTestBtnStatus()
{
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length <= 0)
	{
		return;
	}
	$("startTestbtn").disabled = true;
    $("stopTestbtn").disabled = true;
    $("startLongTestbtn").disabled = true;
	$("stopLongTestbtn").disabled = true;
	$("exportbtn").disabled = true;
	
	var process = st.getCellStoreValue(selectedRows[0],"process","process");
	var testtype = st.getCellStoreValue(selectedRows[0],"storeValue","testtype");
	var bStart = true;
	process = (process == ""? -1:parseInt(process));
	refreshFrameSize();
	if(process >= 0 && process < 100)
	{
		if(testtype == TEST_TYPE_NORMAL)
		{
			$("stopTestbtn").disabled = !btnRightArr.stopTestbtn.right;
		}
		if(testtype == TEST_TYPE_LONG)
		{
			$("stopLongTestbtn").disabled = !btnRightArr.stopLongTestbtn.right;
			longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"framesize"),0);
	    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"throughput"),0);
		}
		$("exportbtn").disabled = true;
	}
	else
	{
		var srcstatus = st.getCellStoreValue(selectedRows[0],"storeValue","sourcestatus");
		var sinkstatus = st.getCellStoreValue(selectedRows[0],"storeValue","sinkstatus");
		if(srcstatus == STATUES_ENABLE || sinkstatus == STATUES_ENABLE)
		{
			$("startTestbtn").disabled = !btnRightArr.startTestbtn.right;
			$("startLongTestbtn").disabled = !btnRightArr.startLongTestbtn.right;
			$("exportbtn").disabled = !btnRightArr.exportbtn.right;
			if(longpacketlossst.getDataRowLength() > 0)
			{
				longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"framesize"),1);
		    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"throughput"),1);
		    }
	    }
	}
	
}

/** 
 *              
 * @return void
 */
function handleLongATParam()
{
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length <= 0)
	{
		longpacketlossst.clearTableData();
		return;
	}
	var srcstatus = st.getCellStoreValue(selectedRows[0],"storeValue","sourcestatus");
	var sinkstatus = st.getCellStoreValue(selectedRows[0],"storeValue","sinkstatus");
	if(srcstatus == STATUES_ENABLE || sinkstatus == STATUES_ENABLE)
	{
		var framesize = st.getCellStoreValue(selectedRows[0],"storeValue","framesize");
		var thruputper = st.getCellStoreValue(selectedRows[0],"storeValue","thruputper");

		framesize = (framesize && framesize != "-1")?framesize:64;
		thruputper = (thruputper && thruputper != "-1")?thruputper:80;
		if(longpacketlossst.getDataRowLength() <= 0)
		{
			var data = new DataInterface();
			var eTag = new ErrorTag();
			eTag.code = "0";
			eTag.info = "";
			var allerror = new AllError();
			allerror.s_error = eTag;
			data.errObj = allerror;
			var obj = new Object();
			var ptag = new ParamTag();
			ptag.value=framesize;
			obj["framesize"] = ptag;
			
			ptag = new ParamTag();
			ptag.value=thruputper;
			obj["throughput"] = ptag;
			
			ptag = new ParamTag();
			ptag.value="/";
			obj["recpkt"] = ptag;
			
			ptag = new ParamTag();
			ptag.value="/";
			obj["sendpkt"] = ptag;
			
			ptag = new ParamTag();
			ptag.value="/";
			obj["longpacketloss"] = ptag;
			data.rows[0] = obj;
			
			createTableBody(longpacketlossst, window.tableconf[4], data, RESOURCE);
		}
		else
		{
			longpacketlossst.setCellValue(longpacketlossst.getCell(0,"framesize"),"framesize",framesize);
			longpacketlossst.getCellShow(0,"framesize").setValue(framesize);
			
			longpacketlossst.setCellValue(longpacketlossst.getCell(0,"throughput"),"throughput",thruputper);
			longpacketlossst.getCellShow(0,"throughput").setValue(thruputper);
		}
	}
	else
	{
		longpacketlossst.clearTableData();
	}
}

/**
 *                
 *                   
 * @param       
 * @return void
 */
function cellEditHandler(/*Object*/param)
{
	var rowindex = param.rowindex;
	
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
    	$("applybtn").disabled = !btnRightArr.applybtn.right;

    	if(param.colid == "sourcestatus")
		{
			var status = st.getCellStoreValue(rowindex,param.colid,param.colid);
			if(status == STATUES_ENABLE)
			{
				if(param.st.getCellStoreValue(rowindex,"sinkstatus","sinkstatus") == STATUES_ENABLE)
				{
					param.st.setCellModify(rowindex,"sinkstatus",true);
					param.st.setCellValue(param.st.getCell(rowindex,"sinkstatus"),"sinkstatus",STATUES_DISABLE);
					param.st.getCellShow(rowindex,"sinkstatus").setValue(RESOURCE[ENABLESTATUE[STATUES_DISABLE]]);
				}
				st.setCellIsEdit(st.getCell(rowindex,"testname"),1);
	    		st.setCellIsEdit(st.getCell(rowindex,"endflag"),1);
			}
			else
			{
				if(param.st.getCellStoreValue(rowindex,"sinkstatus","sinkstatus") == STATUES_DISABLE)
				{
					st.setCellIsEdit(st.getCell(rowindex,"testname"),0);
	    			st.setCellIsEdit(st.getCell(rowindex,"endflag"),0);
				}
			}
		}
		if(param.colid == "sinkstatus")
		{
			var status = st.getCellStoreValue(rowindex,param.colid,param.colid);
			if(status == STATUES_ENABLE)
			{
				if(param.st.getCellStoreValue(rowindex,"sourcestatus","sourcestatus") == STATUES_ENABLE)
				{
					param.st.setCellModify(rowindex,"sourcestatus",true);
					param.st.setCellValue(param.st.getCell(rowindex,"sourcestatus"),"sourcestatus",STATUES_DISABLE);
					param.st.getCellShow(rowindex,"sourcestatus").setValue(RESOURCE[ENABLESTATUE[STATUES_DISABLE]]);
				}
				st.setCellIsEdit(st.getCell(rowindex,"testname"),1);
	    		st.setCellIsEdit(st.getCell(rowindex,"endflag"),1);
			}
			else
			{
				if(param.st.getCellStoreValue(rowindex,"sourcestatus","sourcestatus") == STATUES_DISABLE)
				{
					st.setCellIsEdit(st.getCell(rowindex,"testname"),0);
	    			st.setCellIsEdit(st.getCell(rowindex,"endflag"),0);
				}
			}
		}
    }
}

/**
 *           
 */
function queryAutoTest()
{
	if(autoTestTimer != null)
	{
		window.clearInterval(autoTestTimer);
		autoTestTimer = null;
	}
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    $("exportbtn").disabled = true;
    $("startTestbtn").disabled = true;
    $("stopTestbtn").disabled = true;
    $("startLongTestbtn").disabled = true;
	$("stopLongTestbtn").disabled = true;
	LoadingProcess.showWaitStatus("../../../../../../images/");
    serviceIndex = -1;
    var xmldata = createQueryXml();
    bQueryFlag = true;
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_QUERY_AUTOTEST_PARAM + "" + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackQuery, null, "inputdata=" + xmldata);
}

/**
 *               XML
 * @return String
 */
function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    
    param = new tagElement("param","serviceIndex","0");
    row.appendChild(param);
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *               
 * @param doc    XML  
 * @return void
 */
function callbackQuery(/*XMLDOM*/doc)
{
	bQueryFlag = false;
	LoadingProcess.removeWaitStatus();
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    var data = EncapsulateData(doc);

    if(autoTestTimer == null)
	{
		autoTestTimer = window.setInterval(queryAutoTestInterval,10000);
	}
	
    if (data.getSErrorCode() < 2) 
    {
		var lastSelected = [];
		for(var i = 0,len = st.getDataRowLength();i < len;i++)
		{
			if (st.getRowSelFlag(i))
			{
				lastSelected[lastSelected.length] = st.getCellStoreValue(i, "storeValue","serviceIndex");
			}
		}
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);

        for(var i = 0,len = st.getDataRowLength();i < len;i++)
	    {
	    	var storevalue = st.getCellStoreValue(i, "storeValue","serviceIndex");
	    	
		  	if(lastSelected.contains(storevalue))
		  	{
		  		st.setRowSelect(i);
		  	}
		  	var process = st.getCellStoreValue(i,"process","process");
			setSourceStatusEdit(i);
	    	setSinkStatusEdit(i)
		  	if(process != "" && process > 0 && process < 100)
		  	{
		  		st.setCellIsEdit(st.getCell(i,"sourcestatus"),0);
	    		st.setCellIsEdit(st.getCell(i,"sinkstatus"),0);
		  	}
	    	st.setCellIsEdit(st.getCell(i,"testname"),0);
	    	st.setCellIsEdit(st.getCell(i,"endflag"),0);
    	}
    }
    var len = st.getDataRowLength();
    if (st.getSelectedRows().length == 0 && len > 0) 
    {
        st.setRowSelect(0);
    }
    rowSelectHandler();
    $("totalrownum").innerHTML = len;
    $("selrownum").innerHTML = len > 0 ? 1 : 0;
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    showErrorDialog(data);
}

function setSourceStatusEdit(rowIndex)
{
	var sourceType = st.getCellStoreValue(rowIndex, "storeValue","sourceunitype");
	if(sourceType != UNI_TYPE)
	{
		st.setCellIsEdit(st.getCell(rowIndex,"sourcestatus"),0);
	}
	else
	{
		st.setCellIsEdit(st.getCell(rowIndex,"sourcestatus"),1);
	}
}

function setSinkStatusEdit(rowIndex)
{
	var sinkType = st.getCellStoreValue(rowIndex, "storeValue","sinkunitype");
	if(sinkType != UNI_TYPE)
	{
		st.setCellIsEdit(st.getCell(rowIndex,"sinkstatus"),0);
	}
	else
	{
		st.setCellIsEdit(st.getCell(rowIndex,"sinkstatus"),1);
	}
}

/**
 *             
 *           
 */
function queryAutoTestInterval()
{
	var xmldata = createQueryATIntervalXML();
	if(bQueryFlag)
	{
		return;
	}
	bQueryFlag = true;
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_QUERY_AUTOTEST_PROGRESS + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackQueryInterval, null, "inputdata=" + xmldata);
}

function createQueryATIntervalXML()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    
    param = new tagElement("param","serviceIndex","0");
    row.appendChild(param);
    
    param = new tagElement("param","isLogFlag","0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryInterval(doc)
{
	bQueryFlag = false;
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) 
    {
    	var selectedSrvIndex = -1;
    	var selectedRows = st.getSelectedRows();
    	if(selectedRows.length > 0)
		{
			selectedSrvIndex = st.getCellStoreValue(selectedRows[0],"storeValue","serviceIndex");
		}
		for(var i = 0,len = st.getDataRowLength();i < len;i++)
		{
			var sIndex = st.getCellStoreValue(i,"storeValue","serviceIndex");
			var bExist = false;
			for(var j = 0,lenj = data.getDataRowLength();j < lenj;j++)
	    	{
		    	var srvIndex = data.getDataRowParam(j,"serviceIndex");
				var testtype = data.getDataRowParam(j,"testtype");
				var processtmp = data.getDataRowParam(j,"process");
				if(sIndex == srvIndex)
				{
					st.setCellValue(st.getCell(i,"process"),"process",processtmp);
					st.getCellShow(i,"process").setValue(convertProcess(processtmp));
					st.setCellValue(st.getCell(i,"storeValue"),"testtype",testtype);
					if(sIndex == selectedSrvIndex)
					{
						handleTestBtnStatus();
						queryAutoTestResult(true);
					}
					bExist = true;
					break;
				}
			}
			var process = st.getCellStoreValue(i,"process","process");
			if(!bExist && (process > 0 && process < 100))
			{
				st.setCellValue(st.getCell(i,"process"),"process",100);
				st.getCellShow(i,"process").setValue(convertProcess(100));
				if(sIndex == selectedSrvIndex)
				{
					handleTestBtnStatus();
					queryAutoTestResult(true);
				}
			}
			if(st.getCellStoreValue(i,"process","process") == "100")
			{
				if(st.getCellIsEdit(st.getCell(i,"sourcestatus")) != "1")
				{
					setSourceStatusEdit(i);
				}
				if(st.getCellIsEdit(st.getCell(i,"sinkstatus")) != "1")
				{
	    			setSinkStatusEdit(i);
	    		}
			}
		}
    }
}

/**
 *                     
 *                   
 *                        
 * @param bInterval       
 * @return void
 */
function queryAutoTestResult(/*boolean*/bInterval)
{
    var xmldata = createQueryResultXml(bInterval);
    if(xmldata == null)
    {
    	return;
    }
    if(!bInterval)
    {
    	LoadingProcess.showWaitStatus("../../../../../../images/");
    }
    bQueryFlag = true;
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_QUERY_AUTOTEST_RESULT + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackQueryResult, bInterval, "inputdata=" + xmldata);
}
/**
 *       
 */
function queryLongAutoTestResult(bFromNE)
{
	var xmldata = createQueryResultXml(true,bFromNE);
    if(xmldata == null)
    {
    	return;
    }
	queryLongTestTime++;
	LoadingProcess.showWaitStatus("../../../../../../images/");
	bQueryFlag = true;
	var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_QUERY_AUTOTEST_RESULT + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackQueryLongResult, bFromNE, "inputdata=" + xmldata);
}

/**
 *               XML
 * @param bInterval
 * @return void
 */
function createQueryResultXml(/*boolean*/bInterval,/*boolean*/bFromNE)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    var selectedRows = st.getSelectedRows();
    if(selectedRows.length > 0)
    {
    	var selectedSIndex = st.getCellStoreValue(selectedRows[0], "storeValue", "serviceIndex");
    	param = new tagElement("param","serviceIndex",selectedSIndex);
    	row.appendChild(param);
    	
    	param = new tagElement("param","framesize",st.getCellStoreValue(selectedRows[0], "storeValue", "framesize"));
    	row.appendChild(param);
    	
    	param = new tagElement("param","thruputper",st.getCellStoreValue(selectedRows[0], "storeValue", "thruputper"));
    	row.appendChild(param);
    }
    else
    {
    	return null;
    }
    if(bInterval)
    {
    	param = new tagElement("param","isLogFlag","0");
    	row.appendChild(param);
    }
	if(typeof(bFromNE) != "undefined" && bFromNE != null && bFromNE)
	{
		param = new tagElement("param","bFromNE","true");
    	row.appendChild(param);
	}
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackQueryLongResult(/*XMLDOM*/doc,/*boolean*/bFromNE)
{
	bQueryFlag = false;
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) 
	{
		var longpacketLossdata = new DataInterface();
    	longpacketLossdata.errObj = data.errObj;
    	
		for(var i = 0,len = data.getDataRowLength();i < len;i++)
		{
			var type = data.getDataRowParam(i,"type");
			if(type == "longpacketLoss")
			{
				longpacketLossdata.rows.append(data.getDataRow(i));
				data.removeDataRowAt(i);
				i--;
			}
		}
		if(longpacketLossdata.getDataRowLength() > 0)
		{
			LoadingProcess.removeWaitStatus();
			longpacketlossst.clearTableData();
			createTableBody(longpacketlossst, window.tableconf[4], longpacketLossdata, RESOURCE);
		}
		else 
		{
			if (bFromNE) 
			{
				LoadingProcess.removeWaitStatus();
			}
			else 
			{
				if (queryLongTestTime >= QueryLongTimeOut) 
				{
					queryLongAutoTestResult(true);
				}
				else 
				{
					window.setTimeout("queryLongAutoTestResult(false)", 3000);
				}
			}
		}
	}
	else
	{
		LoadingProcess.removeWaitStatus();
	}
}

/**
 *               
 *                    
 * @param doc    XML  
 * @param bInterval     
 * @return void
 */
function callbackQueryResult(/*XMLDOM*/doc,/*boolean*/bInterval)
{
	
	bQueryFlag = false;
	if(!bInterval)
	{
		LoadingProcess.removeWaitStatus();
	}
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) 
    {
    	var throughputdata = new DataInterface();
    	throughputdata.errObj = data.errObj;
    	var latencydata = new DataInterface();
    	latencydata.errObj = data.errObj;
    	var packetLossdata = new DataInterface();
    	packetLossdata.errObj = data.errObj;
    	var longpacketLossdata = new DataInterface();
    	longpacketLossdata.errObj = data.errObj;
    	
		for(var i = 0,len = data.getDataRowLength();i < len;i++)
		{
			var type = data.getDataRowParam(i,"type");
			if(type == "autotest")
			{
			}
			else if(type == "throughput")
			{
				throughputdata.rows.append(data.getDataRow(i));
				data.removeDataRowAt(i);
				i--;
			}
			else if(type == "latency")
			{
				latencydata.rows.append(data.getDataRow(i));
				data.removeDataRowAt(i);
				i--;
			}
			else if(type == "packetLoss")
			{
				packetLossdata.rows.append(data.getDataRow(i));
				data.removeDataRowAt(i);
				i--;
			}
			else if(type == "longpacketLoss")
			{
				longpacketLossdata.rows.append(data.getDataRow(i));
				data.removeDataRowAt(i);
				i--;
			}
		}
			throughputst.clearTableData();
			latencyst.clearTableData();
			packetlossst.clearTableData();
			createTableBody(throughputst, window.tableconf[1], throughputdata, RESOURCE);
			createTableBody(latencyst, window.tableconf[2], latencydata, RESOURCE);
			createTableBody(packetlossst, window.tableconf[3], packetLossdata, RESOURCE);
		if(!bInterval || ($("stopLongTestbtn").disabled == false && $("startLongTestbtn").disabled == true))
		{
			if(longpacketLossdata.getDataRowLength() > 0)
			{
				longpacketlossst.clearTableData();
				createTableBody(longpacketlossst, window.tableconf[4], longpacketLossdata, RESOURCE);
			}
		}
	}
}

/**
 *                        
 * @param serviceIndex     
 * @param testtype     
 * @param process   
 * @return void
 */
function refreshServiceStatus(serviceIndex,testtype,process)
{
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var sIndex = st.getCellStoreValue(i,"storeValue","serviceIndex");
		if(sIndex == serviceIndex)
		{
			st.setCellValue(st.getCell(i,"process"),"process",process);
			st.getCellShow(i,"process").setValue(convertProcess(process));
			st.setCellValue(st.getCell(i,"storeValue"),"testtype",testtype);
			break;
		}
	}
}

/**
 *          
 * @return void
 */
function startAutoTest()
{
	var startNum = 0;
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var process = st.getCellStoreValue(i,"process","process");
		var testtype = st.getCellStoreValue(i,"storeValue","testtype");
		if(process != "" && process >= 0 && process < 100 && testtype == TEST_TYPE_NORMAL)
		{
			startNum++;
		}
	}

	if(startNum >= MAX_START_NUMBER)
	{
		alert(RESOURCE["starterror"]);
		return;
	}
	var selectedRow = st.getSelectedRows();
    if(selectedRow.length == 0)
    {
    	return;
    }
    if(st.getModify(selectedRow[0]))
	{
		alert(RESOURCE["modifytitle"]);
		return;
	}
	if(SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_ETH_AUTOTEST","AUTOTEST_ATTR_SPECIAL_FRAMESIZE"))
	{
		xshowModalDialog("selectpkg.html?neid="+neid, RESOURCE["specifyframesize"], 400, 180, "../../../../../../images/");
	}
	else
	{
		if(!confirm(RESOURCE["starttitle"]))
		{
			return;
		}
		if(!confirm(RESOURCE["SERVICE_BREAK_WARN"]))
		{
			return;
		}
		operateAutoTest(TEST_START);
	}
}

/**
 *          
 * @return void
 */
function stopAutoTest()
{
	operateAutoTest(TEST_STOP);
}

/**
 *                
 *                           
 *               
 * @param testflag         
 * @return void
 */
function operateAutoTest(/*int*/testflag)
{
    $("startTestbtn").disabled = true;
    $("stopTestbtn").disabled = true;
    $("startLongTestbtn").disabled = true;
	$("stopLongTestbtn").disabled = true;
	window.clearInterval(autoTestTimer);
	autoTestTimer = null;
    var xmldata = createOperateAutoTestXml(testflag);
    LoadingProcess.showWaitStatus("../../../../../../images/");
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_OPERATE_AUTOTEST + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackOperateAutoTest, testflag, "inputdata=" + xmldata);
}

/**
 *                     XML  
 *                            
 * @param sIndex     
 * @param testflag     
 * @return void
 */
function createOperateAutoTestXml(/*int*/testflag)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    var selectedRows = st.getSelectedRows();
	param = new tagElement("param","serviceIndex",st.getCellStoreValue(selectedRows[0], "storeValue", "serviceIndex"));
	row.appendChild(param);
	param = new tagElement("param","serviceID",st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID"));
	row.appendChild(param);
	var serviceName = st.getCellStoreValue(selectedRows[0], "serviceName", "serviceName");
	serviceName = (typeof(serviceName) == "undefined" || serviceName == null)?"":serviceName;
	param = new tagElement("param","serviceName",serviceName);
	row.appendChild(param);
	
    param = new tagElement("param","testflag",testflag);
    row.appendChild(param);
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *               
 *                           
 *               
 * @param doc    XML  
 * @param testflag     
 * @return void
 */
function callbackOperateAutoTest(/*XMLDOM*/doc,/*int*/testflag)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	if(autoTestTimer == null)
	{
		autoTestTimer = window.setInterval(queryAutoTestInterval,10000);
	}
	if (data.getSErrorCode() == 0) 
    {
    	var selected = st.getSelectedRows();
    	if(testflag == TEST_START)
    	{
    		st.setCellValue(st.getCell(selected[0],"storeValue"),"testtype",TEST_TYPE_NORMAL);
    		st.setCellValue(st.getCell(selected[0],"process"),"process","0");
    		st.getCellShow(selected[0],"process").setValue(convertProcess("0"));
    		st.setCellIsEdit(st.getCell(selected[0],"sourcestatus"),0);
	    	st.setCellIsEdit(st.getCell(selected[0],"sinkstatus"),0);
	    	throughputst.clearTableData();
			latencyst.clearTableData();
			packetlossst.clearTableData();
    		$("stopTestbtn").disabled = !btnRightArr.stopTestbtn.right;
    		$("exportbtn").disabled = true;
    	}
    	if(testflag == TEST_STOP)
    	{
    		st.setCellValue(st.getCell(selected[0],"process"),"process","100");
    		st.getCellShow(selected[0],"process").setValue(convertProcess("100"));
    		setSourceStatusEdit(selected[0]);
    		setSinkStatusEdit(selected[0]);
    		$("startTestbtn").disabled = !btnRightArr.startTestbtn.right;
    		$("startLongTestbtn").disabled = !btnRightArr.startLongTestbtn.right;
    		$("exportbtn").disabled = !btnRightArr.exportbtn.right;
    	}
    }
    else
    {
    	if(testflag == TEST_START)
    	{
    		$("startTestbtn").disabled = !btnRightArr.startTestbtn.right;
    		$("startLongTestbtn").disabled = !btnRightArr.startLongTestbtn.right;
    		$("exportbtn").disabled = !btnRightArr.exportbtn.right;
    	}
    	if(testflag == TEST_STOP)
    	{
    		$("stopTestbtn").disabled = !btnRightArr.stopTestbtn.right;
    	}
    	showErrorDialog(data);
    }
}

/**
 *             
 * @return void
 */
function startLongAutoTest()
{
	var startNum = 0;
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var process = st.getCellStoreValue(i,"process","process");
		var testtype = st.getCellStoreValue(i,"storeValue","testtype");
		if(process != "" && process >= 0 && process < 100 && testtype == TEST_TYPE_LONG)
		{
			startNum++;
		}
	}
	if(startNum >= MAX_START_NUMBER)
	{
		alert(RESOURCE["starterror"]);
		return;
	}
	if(!confirm(RESOURCE["starttitle"]))
	{
		return;
	}
	if(!confirm(RESOURCE["SERVICE_BREAK_WARN"]))
	{
		return;
	}
	if(longpacketlossst.getDataRowLength() > 0
		&& longpacketlossst.getModify(0))
	{
		applyLongAutoTestParam();
	}
	else
	{
		operateLongAutoTest(TEST_START);
	}
}

/**
 *             
 * @return void
 */
function stopLongAutoTest()
{
	operateLongAutoTest(TEST_STOP);
}

/**
 *                   
 *                           
 *               
 * @param testflag         
 * @return void
 */
function operateLongAutoTest(testflag)
{
	var selectedRow = st.getSelectedRows();
    if(selectedRow.length == 0)
    {
    	return;
    }
    if(testflag == TEST_START && st.getModify(selectedRow[0]))
	{
		alert(RESOURCE["modifytitle"]);
		return;
	}
	window.clearInterval(autoTestTimer);
	autoTestTimer = null;
    $("startTestbtn").disabled = true;
    $("stopTestbtn").disabled = true;
    $("startLongTestbtn").disabled = true;
	$("stopLongTestbtn").disabled = true;
    var xmldata = createOperateAutoTestXml(testflag);
    LoadingProcess.showWaitStatus("../../../../../../images/");
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_OPERATE_LONGTERMTEST + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackLongOperateAutoTest, testflag, "inputdata=" + xmldata);
}

/**
 *                  
 *                           
 *               ,                     
 * @param doc    XML  
 * @param testflag     
 * @return void
 */
function callbackLongOperateAutoTest(doc,testflag)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	if(autoTestTimer == null)
	{
		autoTestTimer = window.setInterval(queryAutoTestInterval,10000);
	}
	if (data.getSErrorCode() == 0) 
    {
    	var selected = st.getSelectedRows();
    	if(testflag == TEST_START)
    	{
    		st.setCellValue(st.getCell(selected[0],"storeValue"),"testtype",TEST_TYPE_LONG);
    		st.setCellValue(st.getCell(selected[0],"process"),"process","1");
    		st.getCellShow(selected[0],"process").setValue(convertProcess("1"));
    		st.setCellIsEdit(st.getCell(selected[0],"sourcestatus"),0);
	    	st.setCellIsEdit(st.getCell(selected[0],"sinkstatus"),0);
	    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"framesize"),0);
	    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"throughput"),0);

			longpacketlossst.getCellShow(0,"recpkt").setValue("/");
			longpacketlossst.getCellShow(0,"sendpkt").setValue("/");
			longpacketlossst.getCellShow(0,"longpacketloss").setValue("/");
			$("startLongTestbtn").disabled = true;
    		$("stopLongTestbtn").disabled = !btnRightArr.stopLongTestbtn.right;
    		$("exportbtn").disabled = true;
    	}
    	if(testflag == TEST_STOP)
    	{
    		st.setCellValue(st.getCell(selected[0],"process"),"process","100");
    		st.getCellShow(selected[0],"process").setValue(convertProcess("100"));
    		setSourceStatusEdit(selected[0]);
    		setSinkStatusEdit(selected[0]);
	    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"framesize"),1);
	    	longpacketlossst.setCellIsEdit(longpacketlossst.getCell(0,"throughput"),1);
    		$("startTestbtn").disabled = !btnRightArr.startTestbtn.right;
    		$("startLongTestbtn").disabled = !btnRightArr.startLongTestbtn.right;
    		$("stopLongTestbtn").disabled = true;
    		$("exportbtn").disabled = !btnRightArr.exportbtn.right;

			LoadingProcess.showWaitStatus("../../../../../../images/");
			queryLongTestTime = 0;
    		window.setTimeout("queryLongAutoTestResult(false)",3000);
    	}
    }
    else
    {
    	if(testflag == TEST_START)
    	{
    		$("startTestbtn").disabled = !btnRightArr.startTestbtn.right;
    		$("startLongTestbtn").disabled = !btnRightArr.startLongTestbtn.right;
    		$("exportbtn").disabled = !btnRightArr.exportbtn.right;
    	}
    	if(testflag == TEST_STOP)
    	{
    		$("stopLongTestbtn").disabled = !btnRightArr.stopLongTestbtn.right;
    	}
    	showErrorDialog(data);
    }
}

/**
 *          
 * @return void
 */
function applyAutoTestParam()
{
    var xmldata = createApplyParamXml();
    if(xmldata == null)
    {
    	return;
    }
    $("applybtn").disabled = true;
    LoadingProcess.showWaitStatus("../../../../../../images/");
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_SET_AUTOTEST_PARAM + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackApplyParam, null, "inputdata=" + xmldata);
}

/**
 *               XML
 * @return String
 */
function createApplyParamXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");

    for(var i = 0,len = st.getDataRowLength();i < len;i++)
    {
    	if (!st.getModify(i))
    	{
    		continue;
    	}

    	var row = createApplyRow(i);
    	var srcstatus = st.getCellStoreValue(i,"sourcestatus","sourcestatus");
    	var sinkstatus = st.getCellStoreValue(i,"sinkstatus","sinkstatus");
    	var srcstatus_old = st.getCellStoreValue(i,"storeValue","sourcestatus");
    	var sinkstatus_old = st.getCellStoreValue(i,"storeValue","sinkstatus");
    	var testname = st.getCellShow(i,"testname").getValue();
    	if(testname.trim() == "" && (srcstatus == STATUES_ENABLE || sinkstatus == STATUES_ENABLE))
    	{
    		alert(RESOURCE["testnameerror"]);
    		return null;
    	}
    	if(srcstatus_old == STATUES_DISABLE && sinkstatus_old == STATUES_DISABLE)
    	{
    		if(srcstatus == STATUES_DISABLE && sinkstatus == STATUES_DISABLE)
    		{
    			var rowtemp = createApplyRow(i)
				param = new tagElement("param","vuniid",st.getCellStoreValue(i,"storeValue","sourceuniid"));
				rowtemp.appendChild(param);
				param = new tagElement("param","testnode",st.getCellShow(i,"sourceNode").getValue());
				rowtemp.appendChild(param);
				param = new tagElement("param","enablestatus",STATUES_DISABLE);
				rowtemp.appendChild(param);
				param = new tagElement("param","isNoLog","1");
				rowtemp.appendChild(param);
				business.appendChild(rowtemp);
				continue;
    		}
    	}
    	else
    	{
    		if(srcstatus_old != srcstatus || sinkstatus_old != sinkstatus)
    		{
    			if(srcstatus_old == STATUES_ENABLE)
				{
					var rowtemp = createApplyRow(i)
					param = new tagElement("param","vuniid",st.getCellStoreValue(i,"storeValue","sourceuniid"));
					rowtemp.appendChild(param);
					param = new tagElement("param","testnode",st.getCellShow(i,"sourceNode").getValue());
					rowtemp.appendChild(param);
					param = new tagElement("param","enablestatus",STATUES_DISABLE);
					rowtemp.appendChild(param);
					param = new tagElement("param","isNoLog","1");
					rowtemp.appendChild(param);
					business.appendChild(rowtemp);
				}
				else if(sinkstatus_old == STATUES_ENABLE)
				{
					var rowtemp = createApplyRow(i)
					param = new tagElement("param","vuniid",st.getCellStoreValue(i,"storeValue","sinkuniid"));
					rowtemp.appendChild(param);
					param = new tagElement("param","testnode",st.getCellShow(i,"sinkNode").getValue());
					rowtemp.appendChild(param);
					param = new tagElement("param","enablestatus",STATUES_DISABLE);
					rowtemp.appendChild(param);
					param = new tagElement("param","isNoLog","1");
					rowtemp.appendChild(param);
					business.appendChild(rowtemp);
				}
    		}
    	}
    	if(srcstatus == STATUES_ENABLE)
		{
			param = new tagElement("param","vuniid",st.getCellStoreValue(i,"storeValue","sourceuniid"));
			row.appendChild(param);
			param = new tagElement("param","testnode",st.getCellShow(i,"sourceNode").getValue());
			row.appendChild(param);
			param = new tagElement("param","enablestatus",STATUES_ENABLE);
			row.appendChild(param);
			business.appendChild(row);
		}
		else if(sinkstatus == STATUES_ENABLE)
		{
			param = new tagElement("param","vuniid",st.getCellStoreValue(i,"storeValue","sinkuniid"));
			row.appendChild(param);
			param = new tagElement("param","testnode",st.getCellShow(i,"sinkNode").getValue());
			row.appendChild(param);
			param = new tagElement("param","enablestatus",STATUES_ENABLE);
			row.appendChild(param);
			business.appendChild(row);
		}
    }
	if(0 == business.childNodes.length)
	{
		return null;
	}
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *        Row  
 * @param rowindex
 * @return void
 */
function createApplyRow(rowindex)
{
	var row = new tagElement("row-params");
	var param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","serviceID",st.getCellStoreValue(rowindex,"serviceID","serviceID"));
	row.appendChild(param);
	var serviceName = st.getCellStoreValue(rowindex,"serviceName","serviceName");
	serviceName = (typeof(serviceName) == "undefined" || serviceName == null)?"":serviceName;
	param = new tagElement("param","serviceName",serviceName);
	row.appendChild(param);
	param = new tagElement("param","serviceIndex",st.getCellStoreValue(rowindex,"storeValue","serviceIndex"));
	row.appendChild(param);
	param = new tagElement("param","testname",st.getCellShow(rowindex,"testname").getValue().trim());
	row.appendChild(param);
	param = new tagElement("param","endflag",st.getCellStoreValue(rowindex,"endflag","endflag"));
	row.appendChild(param);
	
	return row;
}

/**
 *               
 * @param doc    XML  
 * @return void
 */
function callbackApplyParam(/*XMLDOM*/doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) 
    {
    	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	    {
	    	if (!st.getModify(i))
	    	{
	    		continue;
	    	}
	    	var srcstatus = st.getCellStoreValue(i,"sourcestatus","sourcestatus");
	    	var sinkstatus = st.getCellStoreValue(i,"sinkstatus","sinkstatus");
	    	st.setCellValue(st.getCell(i,"storeValue"),"sourcestatus",srcstatus);
			if (SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_ETH_AUTOTEST", "AUTOTEST_ATTR_SPECIAL_FRAMESIZE")) 
			{
				st.setCellValue(st.getCell(i, "storeValue"), "specialfsize", 0xFFFF);
			}
	    	st.setCellValue(st.getCell(i,"storeValue"),"sinkstatus",sinkstatus);
	    	st.setCellIsEdit(st.getCell(i,"testname"),0);
	    	st.setCellIsEdit(st.getCell(i,"endflag"),0);
	    	if(srcstatus == STATUES_DISABLE && sinkstatus == STATUES_DISABLE)
	    	{
				st.setCellValue(st.getCell(i,"storeValue"),"specialfsize","");
	    		st.setCellValue(st.getCell(i,"testname"),"testname","");
	    		st.getCellShow(i,"testname").setValue("");
	    		st.setCellValue(st.getCell(i,"endflag"),"endflag",ENDFLAG_SOURCE);
	    		st.getCellShow(i,"endflag").setValue(RESOURCE[ENDFLAG[ENDFLAG_SOURCE]]);
	    	}
    	}
    	handleLongATParam();
    	handleTestBtnStatus();
    	refreshTableState(st, window.tableconf[0], data);
    }
    else
    {
    	$("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    showErrorDialog(data);
}

/**
 *            ,                          
 *                        
 * @return void
 */
function applyLongAutoTestParam()
{
    var xmldata = createLongApplyParamXml();

    if(xmldata == null)
    {
    	return;
    }
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ETHSRV_SET_AUTOTEST_PARAM + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackApplyLongParam, null, "inputdata=" + xmldata);
}

/**
 *               XML
 * @return String
 */
function createLongApplyParamXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var sIndex = -1;
    var sID = -1;
    var sName = "";
    if(st.getSelectedRows().length > 0)
    {
    	sIndex = st.getCellStoreValue(st.getSelectedRows()[0],"storeValue","serviceIndex");
    	sID = st.getCellStoreValue(st.getSelectedRows()[0],"serviceID","serviceID");
    	sName = st.getCellStoreValue(st.getSelectedRows()[0],"serviceName","serviceName");
    	sName = (typeof(sName) == "undefined" || sName == null)?"":sName;
    }
	for(var i = 0,len = longpacketlossst.getDataRowLength();i < len;i++)
    {
    	if (!longpacketlossst.getModify(i))
    	{
    		continue;
    	}
    	var row = new tagElement("row-params");
    	
    	var param = new tagElement("param","neid",neid);
		row.appendChild(param);
		param = new tagElement("param","serviceIndex",sIndex);
		row.appendChild(param);
		param = new tagElement("param","serviceID",sID);
		row.appendChild(param);
		param = new tagElement("param","serviceName",sName);
		row.appendChild(param);
		
		param = new tagElement("param","framesize",longpacketlossst.getCellStoreValue(i,"framesize","framesize"));
		row.appendChild(param);
		param = new tagElement("param","thruputper",longpacketlossst.getCellStoreValue(i,"throughput","throughput"));
		row.appendChild(param);
		business.appendChild(row);
    }
    if(0 == business.childNodes.length)
	{
		return null;
	}
	root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *               
 * @param doc
 * @return void
 */
function callbackApplyLongParam(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) 
    {
    	var selectedRows = st.getSelectedRows();
    	st.setCellValue(st.getCell(selectedRows[0],"storeValue"),"framesize",longpacketlossst.getCellStoreValue(0,"framesize","framesize"));
    	st.setCellValue(st.getCell(selectedRows[0],"storeValue"),"thruputper",longpacketlossst.getCellStoreValue(0,"throughput","throughput"));
    	
    	refreshTableState(longpacketlossst, window.tableconf[4], data);
    	operateLongAutoTest(TEST_START);
    }
    showErrorDialog(data);
}

/**
 *              
 * @param data    XML      Datainterface  
 * @return void
 */
function showErrorDialog(data)
{
    var errArr = [];
    var errorObj = null;
    selRows = st.getSelectedRows();
    var operObj;
    if (selRows.length <= 0) 
    {
        operObj = obj["nename"];
    }
    else 
    {
        var rowIndex = selRows[0];
        var serviceID = st.getCellStoreValue(rowIndex, "serviceID", "serviceID");
        var serviceName = st.getCellStoreValue(rowIndex, "serviceName", "serviceName");
        serviceName = (typeof(serviceName) == "undefined" || serviceName == null)?"":serviceName;
        operObj = RESOURCE["serviceid"] + ":" + serviceID + " " + RESOURCE["serviceName"] + ":" + serviceName;
    }
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = operObj;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *               
 */
function createPrintXML()
{
    var root = new inputxml("datainterface");//  xml      
    
    firstlevel = new tagElement("bussiness-params");    
    secondlevel = new tagElement("row-params");
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neID");
    thirdlevel.setAttribute("value",neid);
    secondlevel.appendChild(thirdlevel);
    var selectedRows = st.getSelectedRows();
    if(selectedRows.length <= 0)
    {
    	return null;
    }
    var selectedSIndex = st.getCellStoreValue(selectedRows[0], "storeValue", "serviceIndex");
	thirdlevel = new tagElement("param","serviceIndex",selectedSIndex);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","serviceID",st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID"));
	secondlevel.appendChild(thirdlevel);
	
	var serviceName = st.getCellCurrentValue(selectedRows[0], "serviceName", "serviceName");
	thirdlevel = new tagElement("param", "serviceName", serviceName == null? "" : serviceName);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","testname",st.getCellShow(selectedRows[0],"testname").getValue());
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","endflag",st.getCellShow(selectedRows[0],"endflag").getValue());
	secondlevel.appendChild(thirdlevel);
	
	var srcstatus = st.getCellStoreValue(selectedRows[0], "storeValue", "sourcestatus");
	var testnode = ""
	if(srcstatus == STATUES_ENABLE)
	{
		testnode = st.getCellShow(selectedRows[0],"sourceNode").getValue();
	}
	else
	{
		testnode = st.getCellShow(selectedRows[0],"sinkNode").getValue();
	}
	thirdlevel = new tagElement("param","testnode",testnode);
	secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","filepath");
    thirdlevel.setAttribute("value","ip/ptn/conf/ethservice/autotest/autotestmgr_" + SYSTEMCONF.getLanguage() + ".xml");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","captitle");
    thirdlevel.setAttribute("value","1234");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","filename");
    thirdlevel.setAttribute("value","autotestmgr");
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    
    var xml = root.toString();
    return xml;
}

/**
 *                     Text    
 * @return void
 */
function toPrint()
{
	if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    var printXML = createPrintXML();
	if(printXML == null)
	{
		$("exportbtn").disabled = true;
		return;
	}
    var postUrl = "../../../../../../atReportServlet?neid=" + neid + "&sfid="+TECMDCODE_ETHSRV_QUERY_AUTOTEST_RESULT+"&flag=0&nmUser=" + obj["nmUser"];
	/**
	 *      DTS2012102503049 
	 *       post   URL           URL             
	 */
    postUrl = postUrl+ "&r=" + Math.random();
	
    var postForm = document.createElement("form");//                 
	postForm.method="post";
	
	postForm.action = postUrl;
	postForm.target = "_self";
	var input = document.createElement("input");
	input.style.display = "none";
	input.setAttribute("name", "inputdata");
	input.setAttribute("value", printXML);
	postForm.appendChild(input);
	document.body.appendChild(postForm);
	postForm.submit();
	document.body.removeChild(postForm);
}
