function addCellListener()
{
    for (var i = 0, m = mtunionTable.getDataRowLength(); i < m; i++) 
    {
        var cell = mtunionTable.getCell(i, "megid");
	cell.element.editElement.element.maxLength = MEGID_MAX_LENGTH;
	/**
	 * 802.1ag   megid    
	 */
	if(mtunionTable.getCellStoreValue(i, "megidtype", "megidtype") != ICC_MODEL)
	{
		setInvalidValue(i, "megid",mtunionTable);
	}
	
	var megtypeCellEditor = mtunionTable.getCellEdit(i, "megidtype");
	if (null != megtypeCellEditor) 
	{
	    megtypeCellEditor.element.onchange = function()
	    {
		var rowIndex = this.parentNode.parentNode.rowIndex;
	        var megidtypeValue = parseInt(this.value);
		/**
		 *       802.1ag    MEG ID                   MEG ID     
		 */
		if (ICC_MODEL == megidtypeValue) 
		{
			var megidCellShow = mtunionTable.getCellShow(rowIndex, "megid");
			megidCellShow.setValue("");
			mtunionTable.setCellIsEdit(mtunionTable.getCellElement(rowIndex, "megid"), true);
		}
		else
		{
			setInvalidValue(rowIndex, "megid",mtunionTable);
		}
	    }
	}
    }
    
    var sertype = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0],"servicetype","servicetype");
    
    if(sertype == '2') //2                      rmepid    
    {
        for(var i = 0, len = mepTable.getDataRowLength(); i < len; i++)
        {
            mepTable.setCellEdit(i, 'rmepid', 0);
            mepTable.setCellEdit(i, 'pri', 0);
        }
        return;
    }

    if(mepTable.getDataRowLength() > 0)
    {
        var priCell = mepTable.getCellEdit(0, "pri");  
        
        limitPriInput(priCell.element, 0, 7, 255);
        
        var rmepIDCell = mepTable.getCellEdit(0, "rmepid");  
        textCheck(rmepIDCell.element, '1', '8191', 0);
    }
}

function apply()
{
    var needConfirm = false;
    for(var i = 0,len = mepTable.getDataRowLength();i < len;i++)
    {
        if(mepTable.getCellModify(i, 'pri'))
        {
            needConfirm = true;
            break;
        }
    }
   
    if(needConfirm && !confirm(RESOURCE['remoteconfirm']))
    {
        return;
    }

	$("applyBtn").disabled = true;
	
	var xml = createApplyXml();

    changeBtnStatus(true);
    
	var urlreq ="../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_SET_MA_PARA + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);

    refreshTableState(mtunionTable , window.tableconf[0], data);
    refreshTableState(mepTable, window.tableconf[1], data);
    if (isSupportTestID)
    {
    	refreshTableState(testidTable, window.tableconf[2], data);
    }
    
    if(0 != data.getSErrorCode()) 
    {
        $("applyBtn").disabled = false;
    }
    else
    {    
    	$("applyBtn").disabled = true;
    }
    
    changeBtnStatus(false);
}

function createApplyXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");    
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "isNoLog");
	param.setAttribute("value", "1");
	row.appendChild(param);
	bussiness.appendChild(row);
	
	appendMtunionModifyXML(bussiness);

    for(var i = 0,len = mepTable.getDataRowLength();i < len;i++)
    {
    	if(!mepTable.getModify(i))
    	{
    		continue;
    	}
    	var row = createCommonRow();
    	var param = new tagElement("param");
	    param.setAttribute("name","maid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maid", "maid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ccperiod");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "ccperiod", "ccperiod"));
	    row.appendChild(param);
		if(null != mepTable.element.datarows[i])
	    {
	        param = new tagElement("param");
	        param.setAttribute("name","blockMEP");
	        param.setAttribute("value","modifyMEP");
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","mepid");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'mepid', 'mepid'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","ccstatus");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'ccstatus', 'ccstatus'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","aisstatus");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'aisstatus', 'aisstatus'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","clientlevel");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'clientlevel', 'clientlevel'));
	        row.appendChild(param);

	        param = new tagElement("param");
	        param.setAttribute("name","aisperiod");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'aisperiod', 'aisperiod'));
	        row.appendChild(param);
	        

	        param = new tagElement("param");
	        param.setAttribute("name", "rmepid");
	        if(mepTable.getCellStoreValue(i, 'rmepid', 'rmepid'))
	        {
	            param.setAttribute("value", mepTable.getCellStoreValue(i, 'rmepid', 'rmepid'));
	        } else {
	            param.setAttribute("value", "");
	        }
	        row.appendChild(param);

	        param = new tagElement("param");
	        param.setAttribute("name", "pri");
	        if(mepTable.getCellStoreValue(i, 'pri', 'pri'))
	        {
	            param.setAttribute("value", mepTable.getCellStoreValue(i, 'pri', 'pri'));
	        } else {
	            param.setAttribute("value", "");
	        }
	        row.appendChild(param);

	        
	        bussiness.appendChild(row);
	    }
    }
    
    if (isSupportTestID)
    {
    	appendTestIDModifyXML(bussiness);
    }
   
    di.getRoot().appendChild(bussiness);

	return di.toString();
}


function limitPriInput(obj, minValue, maxValue, singleValue)
{
    var minvalue = minValue;
    var maxvalue = maxValue;
    
    obj.style.imeMode = "disabled";
    obj.onkeypress = function()
    {
        var evt = window.event;
        return restrictPri(obj, evt, minvalue, maxvalue, singleValue);
    };
    obj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = obj.value + pasteText;
        return priTextCheck(obj, pasteText, minvalue, maxvalue, singleValue);
        
    };
}

function restrictPri(field, event, minvalue, maxvalue, singleValue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' ||
    keychar == '[' ||
    keychar == ']' ||
    keychar == '\\' ||
    keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        
        if(!isValidForValue(tempvalue, minvalue, maxvalue, singleValue))
        {
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                if(vArr[i].indexOf('-') != -1)
                {
                    var indexArr = vArr[i].split("-");
                    var startIndex = (parseInt(indexArr[0]) <= parseInt(indexArr[1]) ? parseInt(indexArr[0]) : parseInt(indexArr[1]));
                    var endIndex = (parseInt(indexArr[0]) <= parseInt(indexArr[1]) ? parseInt(indexArr[1]) : parseInt(indexArr[0]));
                    
                    for (var va = startIndex; va <= endIndex; va++)
                    {
                        if(!isValidForValue(va, minvalue, maxvalue, singleValue))
                        {
                            return false;
                        }
                    }
                } else {
                    if(!isValidForValue(vArr[i], minvalue, maxvalue, singleValue))
                    {
                        return false;
                    }
                }
                
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') ||
            (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function priTextCheck(obj, inputText, limitLow, limitHigh, singleValue)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
  
    var inRange = false; //   min~max    
    var existSpValue = false;
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = (parseInt(range[0]) <= parseInt(range[1]) ? parseInt(range[0]) : parseInt(range[1]));
            var rangeEnd = (parseInt(range[0]) <= parseInt(range[1]) ? parseInt(range[1]) : parseInt(range[0]));
    
            for (var va = rangeStart; va <= rangeEnd; va++)
            {
                if ((parseInt(va) < limitLow || parseInt(va) > limitHigh) && (singleValue + '') != va) 
                {
                    obj.value = singleValue; 
                    alert(RESOURCE["limitinfo1"] + singleValue + RESOURCE["limitinfo2"] + limitLow + RESOURCE["limitinfo3"] + limitHigh + RESOURCE["limitinfo4"]);
                    return false;
                }
                
                if(parseInt(va) >= limitLow && parseInt(va) <= limitHigh)
                {
                    inRange = true;
                }
                
                if((singleValue + '') == va)
                {
                    existSpValue = true;
                }
            }
        }
        else 
        {
            if ((parseInt(str[i]) < limitLow || parseInt(str[i]) > limitHigh) && (singleValue + '') != str[i]) 
            {
                obj.value = singleValue; 
                alert(RESOURCE["limitinfo1"] + singleValue + RESOURCE["limitinfo2"] + limitLow + RESOURCE["limitinfo3"] + limitHigh + RESOURCE["limitinfo4"]);
                return false;
            }
            
            if(parseInt(va) >= limitLow && parseInt(va) <= limitHigh)
            {
                inRange = true;
            }
                
            if((singleValue + '') == str[i])
            {
                existSpValue = true;
            }

        }
    }
    
    if(inRange && existSpValue)
    {
        obj.value = singleValue; 
        alert(RESOURCE["limitinfo1"] + singleValue + RESOURCE["limitinfo2"] + limitLow + RESOURCE["limitinfo3"] + limitHigh + RESOURCE["limitinfo4"]);
        return false;
    }
    return true;
}

function isValidForValue(curValue, minvalue, maxvalue, singleValue)
{
    if ((parseInt(curValue) < minvalue || parseInt(curValue) > maxvalue) && (singleValue + '').indexOf(curValue) != 0) 
    {
        alert(RESOURCE["limitinfo1"] + singleValue + RESOURCE["limitinfo2"] + minvalue + RESOURCE["limitinfo3"] + maxvalue + RESOURCE["limitinfo4"]);
        return false;
    }
    
    if ((parseInt(curValue) >= minvalue && parseInt(curValue) <= maxvalue) && (singleValue + '') == curValue) 
    {
        alert(RESOURCE["limitinfo1"] + singleValue + RESOURCE["limitinfo2"] + minvalue + RESOURCE["limitinfo3"] + maxvalue + RESOURCE["limitinfo4"]);
        return false;
    }
    
    return true;
}

function cellonblur()
{
	var obj = this;
	if (arguments.length > 0 && arguments[0].tagName)
	{
		obj = arguments[0];
	}
	
	if(obj.parentNode.colid == 'pri')
	{
            priTextCheck(obj, obj.value, 0, 7, 255);
        }

	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);

	var pnode = obj.parentNode;

	if (obj.parentNode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == obj.parentNode.showElement.type)
			{
				obj.parentNode.showElement
						.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				obj.parentNode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}
			pnode.parent.setTdCellValue(pnode, hc.element.keys[0],
					obj.options[obj.selectedIndex].value);
		}
	}
	else if (obj.parentNode.editElement.type == "combobox")
	{
		window.curEditCell = null;
		if ("span" == obj.parentNode.showElement.type)
		{
			obj.parentNode.showElement
					.setValue(obj.parentNode.editElement.element.parent.txtview.value);
		}
		else
		{
			obj.parentNode.showElement
					.setValue(obj.parentNode.editElement.element.parent.value);
		}

		pnode.parent.setTdCellValue(pnode, hc.element.keys[0],
				pnode.editElement.element.parent.getValue());
	}
	else
	{
		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = obj.parentNode.offsetWidth;
		obj.parentNode.showElement.element.style.display = "";
		var rows = obj.parentNode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}

			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);
	pnode.showElement.element.style.display = "";
	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}
