/**
 * 
 * TRANSV1R8C00-2761 
 *     OAM        weblct
 *    OAM MA                    MEG ID
 *        ICC  /              
 *       ICC    MEG ID                   MEG ID     
 *      RTN905/910/950/980/950A/905 1C
 *     RTN900V1R5C01
 * NSCMD_ETHN_SET_ETHSRVOAM_STANDARD
 * NSCMD_ETHN_GET_ETHSRVOAM_STANDARD
 *
 */
var MEGID_MAX_LENGTH = 45;//MEGID    
var ICC_MODEL = 2;
var protocolStandardConvert = [];
protocolStandardConvert[1]="802.1ag";
protocolStandardConvert[2]="Y.1731";

function addCellListener()
{
    for (var i = 0, m = mtunionTable.getDataRowLength(); i < m; i++) 
    {
        var cell = mtunionTable.getCell(i, "megid");
		cell.element.editElement.element.maxLength = MEGID_MAX_LENGTH;
		/**
		 * 802.1ag   megid    
		 */
		if(mtunionTable.getCellStoreValue(i, "megidtype", "megidtype") != ICC_MODEL)
		{
			setInvalidValue(i, "megid",mtunionTable);
		}
		
		var megtypeCellEditor = mtunionTable.getCellEdit(i, "megidtype");
		if (null != megtypeCellEditor) 
		{
			megtypeCellEditor.element.onchange = function()
			{
				var rowIndex = this.parentNode.parentNode.rowIndex;
	            var megidtypeValue = parseInt(this.value);
				/**
	 			 *       802.1ag    MEG ID                   MEG ID     
				 */
				if (ICC_MODEL == megidtypeValue) 
				{
					var megidCellShow = mtunionTable.getCellShow(rowIndex, "megid");
					megidCellShow.setValue("");
					mtunionTable.setCellIsEdit(mtunionTable.getCellElement(rowIndex, "megid"), true);
				}
				else
				{
					setInvalidValue(rowIndex, "megid",mtunionTable);
				}
			}
		}
    }
}

function setInvalidValue(index, colid,st)
{
    var cell = st.getCellShow(index, colid).element;
    cell.innerHTML = "-";
	st.setCellIsEdit(st.getCellElement(index, colid), false);
}
/**
 *       
 */
function appendMtunionModifyXML(bussiness)
{
    for(var i = 0,len = mtunionTable.getDataRowLength();i < len;i++)
    {
    	if(!mtunionTable.getModify(i))
    	{
    		continue;
    	}
	    var row = createCommonRow();
	    
	    var param = new tagElement("param");
	    param.setAttribute("name","maid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "maid", "maid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ccperiod");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(i, "ccperiod", "ccperiod"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","block");
	    param.setAttribute("value","modifyMA");
	    row.appendChild(param);
		
		var megidtype = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "megidtype", "megidtype");		
	    param = new tagElement("param");
	    param.setAttribute("name","megidtype");
	    param.setAttribute("value", megidtype);
	    row.appendChild(param);		
		
	    param = new tagElement("param");
	    param.setAttribute("name","megid");
		var megid = "";
		if(ICC_MODEL == megidtype)
		{
			var tmp = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "megid", "megid");
			if((null != tmp) &&(undefined != tmp))
			{
				megid = tmp;
			}		
		}	
		param.setAttribute("value", megid);
		row.appendChild(param);	
		
	    bussiness.appendChild(row);
    }
}

/**
 *      create              
 * @param key
 * @return
 */
function create(key)
{
    hideMenu();
    var mdid, mdname, maid, maname;
    var diaWidth = 300;
    var diaHeight = 150;
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	diaWidth = 350; 
    	diaHeight = 200;
    }
	
    if(key == "MD")
    {
        xshowModalDialog("../serviceoam/createmd.html", RESOURCE["createMD"], diaWidth, diaHeight, "../../../../../../images/");
    } 
    else if(key == "MA")
    {
        diaWidth = 450; 
        diaHeight = 220;
        mdid = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdid", "mdid");
        mdname = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdname", "mdname");
        xshowModalDialog("../serviceoam_u2kv1r8/createma.html?mdid="+mdid+"&mdname="+mdname, RESOURCE["createMA"], diaWidth, diaHeight, "../../../../../../images/");
    } 
    else if(key == "MEP") 
    {
        diaWidth = 400; 
        diaHeight = 350;
        mdid = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdid", "mdid");
        mdname = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdname", "mdname");
        maid = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maid", "maid");
        maname = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maname", "maname");
        xshowModalDialog("../serviceoam/createmp.html?mdid="+mdid+"&mdname="+mdname+"&maid="+maid+"&maname="+maname, RESOURCE["createMEP"], diaWidth, diaHeight, "../../../../../../images/");
    }
    else if (key == "TestID")
    {
    	diaWidth = 400; 
        diaHeight = 350;
        mdid = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdid", "mdid");
        mdname = win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdname", "mdname");
        maid = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maid", "maid");
        maname = mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maname", "maname");
        var mepid = mepTable.getCellStoreValue(mepTable.getSelectedRows()[0],"mepid", "mepid");
        xshowModalDialog("../serviceoam/createtestid.html?mdid="+mdid+"&mdname="+mdname+"&maid="+maid+"&maname="+maname+"&mepid="+mepid, RESOURCE["createMEP"], diaWidth, diaHeight, "../../../../../../images/");
    }
}

function megidConvert(value)
{
	if( value == null || value == 'undefined' )
	{
		return "";
	}
	else
	{
		return value;
	}
}

function createApplyXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");    
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "isNoLog");
	param.setAttribute("value", "1");
	row.appendChild(param);
	bussiness.appendChild(row);
	
	appendMtunionModifyXML(bussiness);

    for(var i = 0,len = mepTable.getDataRowLength();i < len;i++)
    {
    	if(!mepTable.getModify(i))
    	{
    		continue;
    	}
    	var row = createCommonRow();
    	var param = new tagElement("param");
	    param.setAttribute("name","maid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "maid", "maid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ccperiod");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0], "ccperiod", "ccperiod"));
	    row.appendChild(param);
		if(null != mepTable.element.datarows[i])
	    {
	        param = new tagElement("param");
	        param.setAttribute("name","blockMEP");
	        param.setAttribute("value","modifyMEP");
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","mepid");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'mepid', 'mepid'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","ccstatus");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'ccstatus', 'ccstatus'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","aisstatus");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'aisstatus', 'aisstatus'));
	        row.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name","clientlevel");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'clientlevel', 'clientlevel'));
	        row.appendChild(param);

	        param = new tagElement("param");
	        param.setAttribute("name","aisperiod");
	        param.setAttribute("value", mepTable.getCellStoreValue(i, 'aisperiod', 'aisperiod'));
	        row.appendChild(param);
	        
	        bussiness.appendChild(row);
	    }
    }
    
    if (isSupportTestID)
    {
    	appendTestIDModifyXML(bussiness);
    }
   
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function appendTestIDModifyXML(bussiness)
{
    for(var i = 0,len = testidTable.getDataRowLength();i < len;i++)
    {
    	if(!testidTable.getModify(i))
    	{
    		continue;
    	}
	    var row = createCommonRow();
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name", "mdid");
	    param.setAttribute("value", win.st.getCellStoreValue(win.st.getSelectedRows()[0], "mdid", "mdid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","maid");
	    param.setAttribute("value", mtunionTable.getCellStoreValue(mtunionTable.getSelectedRows()[0],"maid", "maid"));
	    row.appendChild(param);
	    
		param = new tagElement("param");    
	    param.setAttribute("name","mepid");
	    param.setAttribute("value",mepTable.getCellStoreValue(mepTable.getSelectedRows()[0],"mepid", "mepid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","testid");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "testid", "testid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","rmepid");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "rmepid", "rmepid"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ingresspri");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "ingresspri", "ingresspri"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","egresspri");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "egresspri", "egresspri"));
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","forwardmacself");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "forwardmacself", "forwardmacself"));
	    row.appendChild(param);
	    
	    var tmpfwmac = replaceMac(testidTable.getCellStoreValue(i, "forwardmac", "forwardmac"));
	    param = new tagElement("param");
	    param.setAttribute("name","forwardmac");
	    param.setAttribute("value", tmpfwmac);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","backwardmacself");
	    param.setAttribute("value", testidTable.getCellStoreValue(i, "backwardmacself", "backwardmacself"));
	    row.appendChild(param);
	    
	    var tmpbwmac = replaceMac(testidTable.getCellStoreValue(i, "backwardmac", "backwardmac"));
	    param = new tagElement("param");
	    param.setAttribute("name","backwardmac");
	    param.setAttribute("value", tmpbwmac);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
        param.setAttribute("name","blockTestID");
        param.setAttribute("value","modifyTestID");
        row.appendChild(param);
	    
	    if (testidTable.getCellModify(i, "testidmode"))
	    {
	    	param = new tagElement("param");
		    param.setAttribute("name","testidmode");
		    param.setAttribute("value", testidTable.getCellStoreValue(i, "testidmode", "testidmode"));
		    row.appendChild(param);
	    }
	    
	    bussiness.appendChild(row);
    }
}
