var win = getParentWindow(); 
var neid = win["neid"];
var slot = win["slotid"];
var nmUser = win["nmUser"];
var defaultMac = "00-00-00-00-00-00";
var st;
var result = [];
result[0] = "successed";
result[1] = "failed";

function initPage()
{
	$("startlbbtn").value = RESOURCE["starttest"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	initTable();
	initData();
}

function initTable()
{
	st = new SortTable();
	
    st.setImage("../../../../../../images/");
    
    createTableHead(st, window.tableconf[0]);   
    st.setBodyHeight("250px");
    $("testresult").appendChild(st.getTable());

    
}

function initData()
{
    var mdname = win.win.st.getCellStoreValue(win.win.st.getSelectedRows()[0], "mdname", "mdname");
    var maname = win.mtunionTable.getCellStoreValue(win.mtunionTable.getSelectedRows()[0], "maname", "maname");
    var srcMepId = win.mepTable.getCellStoreValue(win.mepTable.getSelectedRows()[0], "mepid", "mepid");
	
    $("mdname").value = mdname;
    $("maname").value = maname;
    $("srcpoint").value = srcMepId;
    $("sinkpoint").value = "00-00-00-00-00-00";
    
    validateNum($("srcpoint"), 1, 8191, 4);
    validateMac($("sinkpoint"));
}

function startLTTest()
{	
    if(LBTEST_TYPE == "2" && !checkUniCastMAC($("sinkpoint").value))
	{
		$("sinkpoint").value = "00-00-00-00-00-00";
		return;
	}
	
	$("startlbbtn").disabled = true;	
	$("cancelbtn").disabled = true;
	var xml = createLTTestXML();
	var url = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_START_LTTEST+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, callBackHandler, null, "inputdata=" + xml);
}

function createLTTestXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value", win.win.st.getCellStoreValue(win.win.st.getSelectedRows()[0], "mdid", "mdid"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", win.mtunionTable.getCellStoreValue(win.mtunionTable.getSelectedRows()[0], "maid", "maid"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mepid");
	thirdlevel.setAttribute("value", win.mepTable.getCellStoreValue(win.mepTable.getSelectedRows()[0], "mepid", "mepid"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "sinkmtype");
	thirdlevel.setAttribute("value", LBTEST_TYPE);
	secondlevel.appendChild(thirdlevel);
	
	var snkmp = $("sinkpoint").value;
	var snkmpArr = snkmp.split("-");
	var snkmpStr = snkmpArr[0];
	if(snkmpArr.length >=5)
	{
		snkmpStr = snkmpArr[0] + snkmpArr[1] + snkmpArr[2] + snkmpArr[3] + snkmpArr[4] + snkmpArr[5];
	}
	else
	{
		var snkmpStrTmp = "0000" + tenToHex(snkmp);
		snkmpStr = snkmpStrTmp.substr(snkmpStrTmp.length - 4,4) + "FFFFFFFF";
	}

	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "addrr");
	thirdlevel.setAttribute("value", snkmpStr);
	secondlevel.appendChild(thirdlevel);	
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function callBackHandler(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);

    if (0 == data.getSErrorCode())
    {
        st.clearTableData();

        for(var i=0,size= data.getDataRowLength();i<size;i++)
        {
        	var sinkmepid = data.rows[i].sinkmepid;
        	
        	if(sinkmepid)
        	{
        		var temp = "";
        		if(LBTEST_TYPE == "1")
        		{
        			var str = sinkmepid.value.substring(0,4);
        			temp = parseInt(str,16);
        		}
        		else
        		{
	        		for(var j=0;j<12;j+=2)
	        		{
	        			var str = sinkmepid.value.substring(j,j+2);
	        			temp = temp+str;
	        			if(j!=10)
	        			 {
	        			 	temp=temp+"-";
	        			 }
	        		}
        		}
        		data.rows[i].sinkmepid.value = temp;
        	}
        	
        	
        }
        createTableBody(st, window.tableconf[0], data, RESOURCE);

    }
    $("startlbbtn").disabled = false;
    $("cancelbtn").disabled = false;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *   MAC       
 */
function checkUniCastMAC(macStr)
{
	var mac = macStr.toUpperCase().split("-");
	firstMac = parseInt(mac[0],16);

	if (firstMac%2 == 0)
	{
	    for(var i = 0, len = mac.length; i < len; i++)
	    {
	        if(parseInt(mac[i]) != 0)
	        {
	            return true;
	        }
	    }
	}
	
	alert(RESOURCE["unicasterralert"]);
	return false;		
}

function convertMac(val)
{
    var str = "";
    for(var i = 0, len = val.length; i < len; i = i + 2)
    {
         str = str + val.substring(i, i + 2) + ("-");
    }
    return str.substring(0, str.length - 1);
}

function cvtValHop(val)
{
    if(parseInt(val) >= 255)
    {
        return "/";
    }
    return val;
}
var LBTEST_TYPE = "2";

function switchSelect(evt)
{
	var ev = evt?evt:window.event;
	var el = ev.target || ev.srcElement;
	LBTEST_TYPE = el.value;
	$("sinkpoint").onkeypress = null;
	$("sinkpoint").onblur = null;
	$("sinkpoint").onkeyup = null;
	if(el.value == "2")
	{
		$("mpmactitlespan").innerText = RESOURCE["snkMPMACTitle"];
		$('sinkpoint').value = "00-00-00-00-00-00";
		
		validateMac($('sinkpoint'));
	}
	else
	{
		$("mpmactitlespan").innerText = RESOURCE["snkmpid"];
		$('sinkpoint').value = "1";
		validateNum($('sinkpoint'), 1, 8191, 4);
	}
}
