var win = getParentWindow();
var neid = win["neid"];
var slot = win["slotid"];
var nmUser = win["nmUser"];
var outtime = 0; // LB      
var defaultMac = "00-00-00-00-00-00";
var intervalID;

function initPage()
{
	$("startlbbtn").value = RESOURCE["starttest"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("stoplbbtn").value = RESOURCE["stoptest"];
	initText();
}

function initText()
{
	var mdname = win.win.st.getCellStoreValue(win.win.st.getSelectedRows()[0],
			"mdname", "mdname");
	var maname = win.mtunionTable.getCellStoreValue(win.mtunionTable
			.getSelectedRows()[0], "maname", "maname");
	var srcMepId = win.mepTable.getCellStoreValue(win.mepTable
			.getSelectedRows()[0], "mepid", "mepid");

	$("mdname").value = mdname;
	$("maname").value = maname;
	$("srcpoint").value = srcMepId;
	$("sinkpoint").value = "00-00-00-00-00-00";
	$("tdpgnum").value = "3";
	$("tspglen").value = "64";
	$("pri").value = "7";

	validateNum($("srcpoint"), 1, 8191, 4);
	validateMac($("sinkpoint"));
	/**
	 * OP201203210003:       RTN900  LB OAM   Transmiited packet count   
	 *               
	 */
	validateNum($("tdpgnum"), 1, 65535, 5);
	validateNum($("tspglen"), 64, 65535, 5);
	validateNum($("pri"), 0, 7, 1);
}

function startLBTest()
{
	if (LBTEST_TYPE == "2" && !checkUniCastMAC($("sinkpoint").value))
	{
		$("sinkpoint").value = "00-00-00-00-00-00";
		return;
	}

	$("startlbbtn").disabled = true;
	$("stoplbbtn").disabled = false;
	var xml = createLBTestXML();

	var url = "../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_IPPTN_ETH_OAM_START_LBTEST + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, callBackHandler, null, "inputdata=" + xml);
}

function createLBTestXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");

	var secondlevel = new tagElement("row-params");
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", "1");
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value", win.win.st.getCellStoreValue(win.win.st
			.getSelectedRows()[0], "mdid", "mdid"));
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", win.mtunionTable.getCellStoreValue(
			win.mtunionTable.getSelectedRows()[0], "maid", "maid"));
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "mepid");
	thirdlevel.setAttribute("value", $("srcpoint").value);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "sinkmtype");
	thirdlevel.setAttribute("value", LBTEST_TYPE);
	secondlevel.appendChild(thirdlevel);

	var snkmp = $("sinkpoint").value;
	var snkmpArr = snkmp.split("-");
	var snkmpStr = snkmpArr[0];
	if(snkmpArr.length >=5)
	{
		snkmpStr = snkmpArr[0] + snkmpArr[1] + snkmpArr[2] + snkmpArr[3] + snkmpArr[4] + snkmpArr[5];
	}
	else
	{
		var snkmpStrTmp = "0000" + tenToHex(snkmp);
		snkmpStr = snkmpStrTmp.substr(snkmpStrTmp.length - 4,4) + "FFFFFFFF";
	}
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "addrr");
	thirdlevel.setAttribute("value", snkmpStr);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "framenum");
	thirdlevel.setAttribute("value", $("tdpgnum").value);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "framelen");
	thirdlevel.setAttribute("value", $("tspglen").value);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "framepri");
	thirdlevel.setAttribute("value", $("pri").value);
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function callBackHandler(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);

	if (0 == data.getSErrorCode())
	{
		intervalID = setInterval(refreshResult, 3000);
	}
	else
	{
		$("startlbbtn").disabled = false;
		$("stoplbbtn").disabled = true;
	}
}

function refreshResult()
{
	var xml = createRereshXML();
	var url = "../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_IPPTN_ETH_OAM_LB_NOTIFY + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
}

function createRereshXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");

	var secondlevel = new tagElement("row-params");
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", "2");
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function refreshBackHandler(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);

	if (0 == data.getSErrorCode())
	{
		if (data.getDataRowParam(0, "endFlg") == "1")
		{
			clearInterval(intervalID);

			$("startlbbtn").disabled = false;
			$("stoplbbtn").disabled = true;
		}

		$("testresult").value = data.getDataRowParam(0, "content");
	}
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../../../page/", data.getError(), errArr);
}

function stopLBTest()
{
	var xml = createLBStopTestXML();
	var url = "../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_IPPTN_ETH_OAM_STOP_LBTEST + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, callStopHandler, null, "inputdata=" + xml);
}

function createLBStopTestXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");

	var secondlevel = new tagElement("row-params");
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", "3");
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value", win.win.st.getCellStoreValue(win.win.st
			.getSelectedRows()[0], "mdid", "mdid"));
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", win.mtunionTable.getCellStoreValue(
			win.mtunionTable.getSelectedRows()[0], "maid", "maid"));
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "mepid");
	thirdlevel.setAttribute("value", win.mepTable.getCellStoreValue(
			win.mepTable.getSelectedRows()[0], "mepid", "mepid"));
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function callStopHandler(doc)
{
	var data = EncapsulateData(doc);
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *   MAC       
 */
function checkUniCastMAC(macStr)
{
	var mac = macStr.toUpperCase().split("-");
	firstMac = parseInt(mac[0], 16);

	if (firstMac % 2 == 0)
	{
		for ( var i = 0, len = mac.length; i < len; i++)
		{
			if (parseInt(mac[i]) != 0)
			{
				return true;
			}
		}
	}

	alert(RESOURCE["unicasterralert"]);
	return false;
}
var LBTEST_TYPE = "2";

function switchSelect(evt)
{
	var ev = evt?evt:window.event;
	var el = ev.target || ev.srcElement;
	LBTEST_TYPE = el.value;
	$("sinkpoint").onkeypress = null;
	$("sinkpoint").onblur = null;
	$("sinkpoint").onkeyup = null;
	if(el.value == "2")
	{
		$("mpmactitlespan").innerText = RESOURCE["snkMPMACTitle"];
		$('sinkpoint').value = "00-00-00-00-00-00";
		
		validateMac($('sinkpoint'));
	}
	else
	{
		$("mpmactitlespan").innerText = RESOURCE["snkmpid"];
		$('sinkpoint').value = "1";
		validateNum($('sinkpoint'), 1, 8191, 4);
	}
}
