document.title = RESOURCE["createMEP"];
var MIN_MAID = 1;
var MAX_MAID = 8191;
var parentWin = getParentWindow(); 
var resources = [];
if (!isIE)
{
	parentWin = parentWin.frames[0];// ["popupFrame0"];
}

var st = parentWin.mtunionTable;
var winurlobj = getNeProperty(self);
var mdList = parentWin.win.mdList;  
var maIDList = parentWin.win.maIDList;  
var mdid = winurlobj["mdid"];
var maid = winurlobj["maid"];

function initPage()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
	
	var atom = new Atom("span");
	atom.setValue(winurlobj["mdname"]);
	ct.addAttrRow("mdName", RESOURCE["mdName"], atom);
	
	atom = new Atom("span");
	atom.setValue(winurlobj["maname"]);
	ct.addAttrRow("maName", RESOURCE["maName"], atom);
		
	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element.onchange = refreshSelects;	
	atom.element.id = "board";
	ct.addAttrRow("board", RESOURCE["board"], atom);
	
	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element.onchange = refreshSelects;	
	atom.element.id = "port";
	ct.addAttrRow("port", RESOURCE["port"], atom);
	
	atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("vlan", RESOURCE["vlan"], atom);
		
    atom = new Atom("text");
	atom.element.style.width = "100%";
	ct.addAttrRow("mepid", RESOURCE["mepid"], atom);
	validateNum(atom.element, MIN_MAID, MAX_MAID, 4);
	
	atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("direction", RESOURCE["direction"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["direction1"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["direction2"], 2);
	
        atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("ccstatus", RESOURCE["ccstatus"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["active"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["inactive"], 0);
	
	/**
	atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("aisstatus", RESOURCE["AIS_STATUS"], atom);	
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["active"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["inactive"], 0);
	atom.element.options[1].selected = "selected"
	
	atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("clientlevel", RESOURCE["CLIENT_LEVEL"], atom);
	atom.element.options[atom.element.options.length] = new Option("1", 1);
	atom.element.options[atom.element.options.length] = new Option("2", 2);
	atom.element.options[atom.element.options.length] = new Option("3", 3);
	atom.element.options[atom.element.options.length] = new Option("4", 4);
	atom.element.options[atom.element.options.length] = new Option("5", 5);
	atom.element.options[atom.element.options.length] = new Option("6", 6);
	atom.element.options[atom.element.options.length] = new Option("7", 7);
	atom.element.options[6].selected = "selected";

	atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("aisperiod", RESOURCE["AIS_PERIOD"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE['second'], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE['minute'], 2);**/
	
	$("tablecomponent").appendChild(ct.getTable());
	
	$("okbutton").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	queryResource();
}

function queryResource()
{
    var xmlstr = createQueryResourceXML();    
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_GET_LOGIC_PORT + "&nmUser=" + parentWin.nmUser;     
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryResourceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ethType");
    param.setAttribute("value", st.getCellStoreValue(st.getSelectedRows()[0], "servicetype", "servicetype"));
    row.appendChild(param); 

    param = new tagElement("param");
    param.setAttribute("name", "serviceIndex");
    param.setAttribute("value", st.getCellStoreValue(st.getSelectedRows()[0], "serviceid", "serviceid"));
    row.appendChild(param);   
    
    param = new tagElement("param");
    param.setAttribute("name", "vuniID");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vnniID");
    param.setAttribute("value", "0");
    row.appendChild(param); 
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{
    var data = EncapsulateData(doc);
    var boardSel = ct.attrArray["board"];
    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
    	var slotid = data.getDataRowParam(i, "slotid");
    	var boardname = data.getDataRowParam(i, "boardname");
    	
        var resource = new Object();
        resource.slotid = slotid;
        resource.board = slotid + "-" + boardname;
        resource.ports = new Array();
        
        var portResource = new Object();
        resource.ports.push(portResource);
        portResource.port = data.getDataRowParam(i, "portid");
        portResource.logictype = data.getDataRowParam(i, "logicinftype");
        portResource.niid = data.getDataRowParam(i, "vuniid");
        portResource.portname = data.getDataRowParam(i, "port");
        portResource.vResource = data.getDataRowParam(i, "vlan").split(",");
         
        if(resources[slotid] == null || typeof(resources[slotid]) == "undefined")
        {
            resources[slotid] = resource;
            boardSel.addOption(resource.board, resource.slotid);     
        } 
        else 
        {
        	var oldResource = resources[slotid];
        	oldResource.ports.push(portResource);
        	resources[slotid] = oldResource;
        } 
    }
    
    initSelects();
}

function refreshSelects()
{
    var element = window.event.srcElement;

    if(element.id == "board")
    {
        var resource = resources[element.value];
        var ports = resource.ports;
        var portSel = ct.attrArray["port"];
        portSel.clearOptions();
		
		var tmpPort = [];
		var portResources = [];
		var port0 = ports[0].port;
        for(var j = 0, jLen = ports.length; j < jLen; j++)
        {
            var portResource = ports[j];
			var port = portResource.port;
			if (!tmpPort.contains(port)) 
			{
				tmpPort[tmpPort.length] = port;
				portSel.addOption(portResource.portname, port);
			}
			if (port == port0) 
			{
				portResources[portResources.length] = portResource;
			}
        }   
        ct.attrArray["port"].element.options[0].selected = true; 

        var vlanSel = ct.attrArray["vlan"];
        vlanSel.clearOptions();
        for(var k = 0, kLen = portResources.length; k < kLen; k++)
        {
			var portResource = portResources[k];
			for (var m = 0, mLen = portResource.vResource.length; m < mLen; m++) 
			{
				if (portResource.vResource[m] == '65535' || portResource.vResource[m] == '') 
				{
					vlanSel.addOption('-', portResource.logictype + ":" + portResource.niid + ":" + '-');
					vlanSel.element.disabled = true;
				}
				else 
				{
					vlanSel.addOption(portResource.vResource[m], portResource.logictype + ":" + portResource.niid + ":" + portResource.vResource[m]);
				}
			}
        }
        ct.attrArray["vlan"].element.options[0].selected = true;   
    } 
    else if(element.id == "port")
    {
        var resource = resources[ct.attrArray["board"].element.value];
        var ports= resource.ports;
        var portResources = getObjFromArr(ports, element.value);
        
        var vlanSel = ct.attrArray["vlan"];
        vlanSel.clearOptions();
		for (var i = 0, iLen = portResources.length; i < iLen; i++) 
		{
			var portResource = portResources[i];
			for (var k = 0, kLen = portResource.vResource.length; k < kLen; k++) 
			{
				if (portResource.vResource[k] == '65535' || portResource.vResource[k] == '') 
				{
					vlanSel.addOption('-', portResource.logictype + ":" + portResource.niid + ":" + '-');
					vlanSel.element.disabled = true;
				}
				else 
				{
					vlanSel.addOption(portResource.vResource[k], portResource.logictype + ":" + portResource.niid + ":" + portResource.vResource[k]);
				}
			}
		}
        ct.attrArray["vlan"].element.options[0].selected = true;
    }
}

function initSelects()
{
    if(ct.attrArray["board"].element.options.length == 0)
    {
        return;
    }
    ct.attrArray["board"].element.options[0].selected = true;
    ct.attrArray["board"].element.fireEvent("onchange");
}

function getObjFromArr(arr, val)
{
	var objs = [];
    for(var i = 0, len = arr.length; i < len; i++)
    {
        var obj = arr[i];
        if(obj.port == val)
        {
            objs[objs.length] = obj;
        }
    }
	return objs;
}

/**
 *       
 */
function createMP(isApply)
{
	if("" == ct.getAttrValue("mepid"))
	{
		alert(RESOURCE["PLEASE_INPUT_MEPID"]);
		return;
	}
	$("okbutton").disabled = true;
        $("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xml = createMpXml();
	var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_CREATE_MEP + "&nmUser=" + parentWin.neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, createMPCallBack, isApply, "inputdata=" + xml);
}

function createMpXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "auto1");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "mdid");
    param.setAttribute("value", mdid);
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name", "auto2");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "maid");
    param.setAttribute("value", maid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "mepid");
    param.setAttribute("value", ct.getAttrValue("mepid").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "direction");
    param.setAttribute("value", ct.getAttrValue("direction").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "auto3");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceid");
    param.setAttribute("value", st.getCellStoreValue(st.getSelectedRows()[0], "serviceid", "serviceid"));
    row.appendChild(param);
	
	var vlans = ct.getAttrValue("vlan").trim().split(":");
    
    param = new tagElement("param");
    param.setAttribute("name", "porttype");
    param.setAttribute("value", vlans[0]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "niid");
    param.setAttribute("value", vlans[1]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vid");
    var vlan = vlans[2];
    if (vlan == "" || vlan == "-")
    {
    	vlan = "65535";
    }
    param.setAttribute("value", vlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ccstatus");
    param.setAttribute("value", ct.getAttrValue("ccstatus").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "aisstatus");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "clientlevel");
    param.setAttribute("value", "7");
    row.appendChild(param);
    
    /**param = new tagElement("param");
    param.setAttribute("name", "aisperiod");
    param.setAttribute("value", '0');
    row.appendChild(param);**/
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function createMPCallBack(doc, isApply)
{
    $("okbutton").disabled = false;
    $("cancelbtn").disabled = false;
    $("applybtn").disabled = false;	
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr.push("nename");
    openErrPage("../../../../../../page/", data.getError(), errArr);
    var errorCode = data.getSErrorCode();

    if(0 == errorCode) 
    { 
        parentWin.changeBtnStatus(true);
    	parentWin.doQuery("2");
    	
    	if(!isApply)
    	{
    		xcloseDialog();
    	}
    }
}
