document.title = RESOURCE["crtmipp"];
var MIN_MAID = 1;
var MAX_MAID = 4294967040;
var parentWin = getParentWindow(); 
var resources = [];

if (!isIE)
{
	parentWin = parentWin.frames[0];// ["popupFrame0"];
}

function initPage()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"],RESOURCE["getvalue"]);
	
	var atom = new Atom("span");
	atom.setValue(parentWin.win.st.getCellStoreValue(parentWin.win.st.getSelectedRows()[0], "mdname", "mdname"));
	ct.addAttrRow("mdName",RESOURCE["mdName"], atom);
	
	var atom = new Atom("select");
	atom.element.style.width="100%";	
	ct.addAttrRow("board",RESOURCE["board"], atom);
	atom.element.onchange = refreshSelects;
	
	var atom = new Atom("select");
	atom.element.style.width="100%";	
	ct.addAttrRow("port",RESOURCE["port"], atom);
		
    atom = new Atom("text");
	atom.element.style.width="100%";
	ct.addAttrRow("mipid", RESOURCE["mipid"], atom);
	validateNum(atom.element, 1, 8191, 4);
        
	$("tablecomponent").appendChild(ct.getTable());
	
	$("okbutton").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	queryResource();
}

function queryResource()
{
    var xmlstr = createQueryResourceXML();    
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_GET_MIP_PORT + "&nmUser=" + parentWin.win.nmUser;    
    loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryResourceXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.win.neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","mdid");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","mipid");
    param.setAttribute("value","0");
    row.appendChild(param);
        
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function handleBackQuery(doc)
{
    var data = EncapsulateData(doc);
    var board = ct.attrArray['board'];
    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
        var resource = new Object();
        var slotid = data.getDataRowParam(i, "slotid");
        resource.slotid = slotid;
        resource.boardname = slotid + "-" + data.getDataRowParam(i, "boardname");
        resource.ports = new Array();
        var portResource = new Object();
        resource.ports.push(portResource);
        portResource.port = data.getDataRowParam(i, "port");
        portResource.portname = data.getDataRowParam(i, "portname");
         
        if(resources[slotid] == null || typeof(resources[slotid]) == "undefined")
        {
            resources[slotid] = resource;
            board.addOption(resource.boardname, resource.slotid);     
        } 
        else 
        {
        	var oldResource = resources[slotid];
        	oldResource.ports.push(portResource);
        	resources[slotid] = oldResource;
        } 
    }
    
    initSelects();
}

function initSelects()
{
    if(ct.attrArray["board"].element.options.length == 0)
    {
        return;
    }
    ct.attrArray["board"].element.options[0].selected = true;
    ct.attrArray["board"].element.fireEvent("onchange");
}

function refreshSelects()
{
    var resource = resources[window.event.srcElement.value];
    var port = ct.attrArray["port"];
    port.clearOptions();
    for(var j = 0, len = resource.ports.length; j < len; j++)
    {
        var portResource = resource.ports[j];
       
        port.addOption(portResource.portname, portResource.port);            
    }   
    
    ct.attrArray["port"].element.options[0].selected = true; 
}

function createMip(isApply)
{
	if("" == ct.getAttrValue("mipid"))
	{
		alert(RESOURCE["PLEASE_INPUT_MIPID"]);
		return;
	}

	$("okbutton").disabled = true;
    $("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xml = createMipXml();
	var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETH_OAM_CREATE_MIP + "&nmUser=" + parentWin.win.nmUser;
	loadXMLdoc(urlreq, "POST", true, createCallBack, isApply, "inputdata="+xml);
}

function createMipXml()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.win.neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","auto1");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mdid");
    param.setAttribute("value",parentWin.win.st.getCellStoreValue(parentWin.win.st.getSelectedRows()[0], "mdid", "mdid"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","mipid");
    param.setAttribute("value", ct.getAttrValue("mipid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value", ct.getAttrValue("board"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","port");
    param.setAttribute("value", ct.getAttrValue("port"));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function createCallBack(doc,isApply)
{
    $("okbutton").disabled = false;
    $("cancelbtn").disabled = false;
    $("applybtn").disabled = false;	
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr.push("nename");
    openErrPage("../../../../../../page/", data.getError(), errArr);
    var errorCode = data.getSErrorCode();

    if(0 == errorCode) 
    { 
    	parentWin.doQuery();
    	
    	if(!isApply)
    	{
    		xcloseDialog();
    	}
    }
}
