/**
 * RTN600\900                  
 * R7  
 * @param netype
 * @param boardname
 * @param portnumstr
 * @param cellEdit
 * @return
 */
function initWorkMode(netype, boardname, portnumstr, cellEdit, cursorMenu, elem)
 {
	if(isRTN900NE(netype))
	{
		switch (boardname)
		{
		case "CXPA":
			processFor900CXPA(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "CXPB":
			processFor900CXPB(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EF8T":
			processFor900EF8T(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EF8F":
			processFor900EF8F(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EG2":
			processFor900EG2(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "CXPG":
			processFor900CXPG(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "CXPH":
			processFor900CXPH(portnumstr, cellEdit, cursorMenu, elem);
			break;						
		case "EM6T":
			processFor900EM6T(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM6F":
			processFor900EM6F(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM4T":
			processFor900EM4T(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM4F":
			processFor900EM4F(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM6FA":
			processFor900EM6FA(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM6TA":
			processFor900EM6TA(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EG2D":
			processFor900EG2D(portnumstr, cellEdit, cursorMenu, elem);
			break;						
		case "EM6X":
			processFor900EM6X(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM6TB":
			processFor900EM6TB(portnumstr, cellEdit, cursorMenu, elem);
			break;			
		case "EFP8":
			processFor900EFP8(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EMS6":
			processFor900EMS6(portnumstr, cellEdit, cursorMenu, elem);
			break;
		default:
			break;
		}
	}else
	{
		switch (boardname)
		{
		case "EFT4":
			processFor600EFT4(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EMS":
			processFor600EMS(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "IFH2":
			processFor600IFH2(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EMS4":
			processFor600EMS4(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EFP6":
			processFor600EFP6(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EM4T":
			processFor600EM4T(portnumstr, cellEdit, cursorMenu, elem);
			break;
		case "EGS4":
			processFor600EGS4(portnumstr, cellEdit, cursorMenu, elem);
			break;	
		default:
			break;
		}
	}
}

/**
 *          RTN600  
 * @param netype
 * @return
 */
function isRTN600NE(netype)
{
	return netype == '54' || netype == '55' || netype == '60';
}

/**
 *          RTN900  
 * @param netype
 * @return
 */
function isRTN900NE(netype)
{
	return netype == '76' || netype == '77' || netype == '83' ;
}

function processFor900CXPA(portnumstr, cellEdit, cursorMenu, elem)
 {
	switch (portnumstr) {
	case "17":
	case "18":
	case "19":
	case "20":
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [ RESOURCE["MAC_WORKMODE_auto"], 0, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem ]));
		}
		break;
	default:
		break;
	}
}

function processFor900CXPB(portnumstr, cellEdit, cursorMenu, elem)
{	
	processFor900CXPA(portnumstr, cellEdit, cursorMenu, elem);		
}

function processFor900EF8T(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
	case "5":
	case "6":
	case "7":
	case "8":
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [ RESOURCE["MAC_WORKMODE_auto"], 0, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem ]));
		}		
		break;
	default:
		break;
	}
}
	
function processFor900EF8F(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
	case "5":
	case "6":
	case "7":
	case "8":	
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem ]));
		}
		break;
	default:
		break;
	}
}
	
function processFor900EG2(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [ RESOURCE["MAC_WORKMODE_auto"], 0, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		
		break;
	default:
		break;
	}
}	

function processFor900CXPG(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "17":
	case "18":
	case "19":
	case "20":
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [ RESOURCE["MAC_WORKMODE_auto"], 0, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem ]));
		}	
		break;
	case "21":
	case "22":
		if (null == cursorMenu) {
			cellEdit.clearOptions();
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mhalf"], "5");
			cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		} else {
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [ RESOURCE["MAC_WORKMODE_auto"], 0, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem ]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mhalf"], 5, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}	
		
		break;
	default:
		break;
	}	
}

function processFor900CXPH(portnumstr, cellEdit, cursorMenu, elem)
{
	processFor900CXPG(portnumstr, cellEdit, cursorMenu, elem);
}

function processFor900EM6T(portnumstr, cellEdit, cursorMenu, elem)
 {
	switch (portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu) 
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	default:
		break;
	}
}			


function processFor900EM6F(portnumstr, cellEdit, cursorMenu, elem)
 {
	switch (portnumstr) {
	case "1":
	case "2":
		if (null == cursorMenu) 
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	default:
		break;
	}
}

function processFor900EM4T(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));	
		}
		break;
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	default:
		break;
	}
}

function processFor900EM4F(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EM6FA(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EM6TA(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EG2D(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");		
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EM6X(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");		
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EM6TB(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			}
		break;
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");	
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{			
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;
	default:
		break;
	}	
}

function processFor900EFP8(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
	case "5":
	case "6":
	case "7":
	case "8":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;	
	default:
		break;
	}	
}


function processFor900EMS6(portnumstr, cellEdit, cursorMenu, elem)
{
	processFor900EM6F(portnumstr, cellEdit, cursorMenu, elem);
}

function processFor600EFT4(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));;
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;	
	default:
		break;
	}	
}

function processFor600EMS(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
		}
		break;	
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;	
	default:
		break;
	}	
}

function processFor600IFH2(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			 cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;	
	default:
		break;
	}	
}

function processFor600EMS4(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
		      cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
				}
		break;	
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mhalf"], "5");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mhalf"], 5, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;	
	default:
		break;
	}	
}

function processFor600EFP6(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
				
		}
		break;	
	default:
		break;
	}	
}

function processFor600EM4T(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
				
		}
		break;	
	case "3":
	case "4":
	case "5":
	case "6":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		}
		break;	
	default:
		break;
	}	
}

function processFor600EGS4(portnumstr, cellEdit, cursorMenu, elem)
{
	switch(portnumstr)
	{
	case "1":
	case "2":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mhalf"], "1");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_10mfull"], "2");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mhalf"], "3");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_100mfull"], "4");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mhalf"], 1, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_10mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_10mfull"], 2, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mhalf"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mhalf"], 3, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_100mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_100mfull"], 4, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		
		}
		break;	
	case "3":
	case "4":
		if (null == cursorMenu)
		{
		cellEdit.clearOptions();
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_auto"], "0");
		cellEdit.addOption(RESOURCE["MAC_WORKMODE_1000mfull"], "6");
		}else{
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_auto"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_auto"], 0, elem]));
			  cursorMenu.addMenuItem(new menuItem(RESOURCE["MAC_WORKMODE_1000mfull"], "", setOptionValue, [RESOURCE["MAC_WORKMODE_1000mfull"], 6, elem]));
		
		}
		break;	
	default:
		break;
	}	
}
