var erpsid = null;

var mastererpsid = null;

var MenuStatus = {Clear:"0",
		ManualSwitchEast:"1",
		ManualSwitchWest:"2",
		ForceSwitchEast:"3",
		ForceSwitchWest:"4"
	}

var isSupportEth = false;

/**
 *         
 */
function initPage()
{

   isSupportEth = SpecialAttrMgr.isNESupport(winurlobj["neid"], "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");	
   if(isSupportEth == false)
   {	
	   var ethdomain = window.tableconf[0].getColFromColId("ethdomain");
	   ethdomain.setWidth("0");
   }
   var erpsIDs = SpecialAttrMgr.getNEAttrListValue(winurlobj["neid"],"TE_FUNC_ERPS","TE_ATTR_ERPS_ID_RANGE");
   if(erpsIDs != null && erpsIDs.length > 1)
   {
		ERPS_ID_MIN = erpsIDs[0];
		ERPS_ID_MAX = erpsIDs[1];
   }
   
   initTopSortTable();
   initLeftCTable();
   initRightCTable();
   initButton();
    
    if (btnRight.querybtn.right)
    {
        queryERPS(); 
    }
    else
    {
    	$("querybtn").disabled = true;
    	$("applybtn").disabled = true;
    	$("deletebtn").disabled = true;
    	$("createbtn").disabled = true;
    	$("vlanswitchbtn").disabled = true;
    }    	
}

/**
 *               
 */
function initRightCTable()
{
    rightCTable = new CTable();
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption("01:00", 1);
    cTableAtom.addOption("02:00", 2);
    cTableAtom.addOption("03:00", 3);
    cTableAtom.addOption("04:00", 4);
    cTableAtom.addOption("05:00", 5);
    cTableAtom.addOption("06:00", 6);
    cTableAtom.addOption("07:00", 7);
    cTableAtom.addOption("08:00", 8);
    cTableAtom.addOption("09:00", 9);
    cTableAtom.addOption("10:00", 10);
    cTableAtom.addOption("11:00", 11);
    cTableAtom.addOption("12:00", 12);
    cTableAtomEle = cTableAtom.element;
    EventUtil.addEventHandler(cTableAtomEle, "change", changeWtrTime);
    function changeWtrTime()
    {
        setModifyFlag("wtrTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = !btnRight.applybtn.right;
        }
    }
    rightCTable.addAttrRow("wtrTime", RESOURCE["wtrTime"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, SEND_INTERVAL_MIN, SEND_INTERVAL_MAX);
    EventUtil.addEventHandler(cTableAtomEle, "blur", changeSendInterval);    
    function changeSendInterval()
    {
        setModifyFlag("sendInterval");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = !btnRight.applybtn.right;
        }
    }
    rightCTable.addAttrRow("sendInterval",  RESOURCE["sendInterval"], cTableAtom); 
    
    
    
    cTableAtom = new Atom("select");
    for (var i = 1, len = LAST_REQ_ERPS.length; i < len; i ++)
    {
        cTableAtom.addOption(LAST_REQ_ERPS[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("lastReqERPS", RESOURCE["lastReqERPS"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_DNF.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_DNF[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("erpsDNF", RESOURCE["erpsDNF"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("reqNodeAddr", RESOURCE["reqNodeAddr"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption(RESOURCE["block"], 0);
    cTableAtom.addOption(RESOURCE["unblock"], 1);
    cTableAtomEle = cTableAtom.element;
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("wportstate", RESOURCE["wportstate"], cTableAtom);
    
    $("rightCTableDiv").appendChild(rightCTable.getTable());
}

/**
 *         
 */
function initButton()
{
		$("querybtn").value =  RESOURCE["querybutton"];
		$("createbtn").value = RESOURCE["newbutton"];
		$("deletebtn").value = RESOURCE["deletebutton"];
		$("applybtn").value = RESOURCE["applybutton"];
		$("switchbtn").value = RESOURCE["switchbutton"];
		$("vlanswitchbtn").value = RESOURCE["vlanlistshort"];
		$("vlanswitchbtn").title = RESOURCE["vlanlist"];
		$("printbtn").value = RESOURCE["printbutton"];
		
		$("querybtn").onclick = queryERPS;
		$("createbtn").onclick = createERPS;
		$("deletebtn").onclick = deleteERPS;
		$("applybtn").onclick = modifyERPS;
		$("switchbtn").onclick = switchERPSBtn;
		$("vlanswitchbtn").onclick = doOpenVlanSwitich;
		$("printbtn").onclick = doPrint;
		
		$("applybtn").disabled = true;
		$("vlanswitchbtn").disabled = true;
		$("switchbtn").disabled = true;
		
		getAllBtnRight();
}

/**
 *             
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.querybtn = new BtnRightObj("querybtn", TECMDCODE_ERPS_GET_ENTITY);    
    btnRight.createbtn = new BtnRightObj("createbtn", TECMDCODE_ERPS_CRT_ENTITY);
    btnRight.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_ERPS_DEL_ENTITY);
    btnRight.applybtn = new BtnRightObj("applybtn", TECMDCODE_ERPS_MODIFY_ENTITY);
    btnRight.printbtn = new BtnRightObj("printbtn", TECMDCODE_ERPS_GET_ENTITY);
    btnRight.switchbtn = new BtnRightObj("switchbtn", TECMDCODE_ERPS_SET_SWITCH);
    btnRight.vlanswitchbtn = new BtnRightObj("vlanswitchbtn", TECMDCODE_NE_ERPS_GET_VLAN_SWITCH);
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

function popupMenuHandler(evt) 
{
	if (!evt) {
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur) {
		elem.blur();
	}

	while (elem != null) {
		if (elem.tagName == 'TD') {
			break;
		} else {
			elem = elem.parentNode;
		}
	}
	
	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
	return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if(btnRight.switchbtn.right == false)
	{
		return;
	}
	
	if (rows.contains(rowid))
	{
		createFuncPopupMenu(rows, evt);
	}
}

/**
 *             
 */
function switchERPSBtn(evt)
{
	if($("switchbtn").disabled == true)
	{
		return;
	}
	if (!evt)
	{
		evt = window.event;
	}
	evt.cancelBubble=true;
	createSwitchMenu();
	showMenu(event);
}

/**
 *          
 */
function createSwitchMenu()
{
	removejsDOMmenu();
	var cursorMenu1 = new jsDOMenu(170);
	
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_0"], "",switchERPS, MenuStatus.Clear, MenuStatus.Clear));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_1"], "",switchERPS, MenuStatus.ManualSwitchEast, MenuStatus.ManualSwitchEast));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_2"], "",switchERPS, MenuStatus.ManualSwitchWest, MenuStatus.ManualSwitchWest));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_3"], "",switchERPS, MenuStatus.ForceSwitchEast, MenuStatus.ForceSwitchEast));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_4"], "",switchERPS, MenuStatus.ForceSwitchWest, MenuStatus.ForceSwitchWest));
	setPopUpMenu(cursorMenu1);
}

/**
 *    ERPS
 */
function switchERPS(/*string*/switchtype)
{
	removejsDOMmenu();
	var selectedRows = erpsListTable.getSelectedRows();
	if (0 == selectedRows.length)
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	if (!confirm(RESOURCE["deletealarm"]))
	{
			return;
	}
	if (!confirm(RESOURCE["SERVICE_BREAK_WARN"]))
	{
			return;
	}

    var xml = createSwitchERPSXML(switchtype);
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_NE_ERPS_SET_SWITCH +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, switchERPSBack, null, "inputdata=" + xml);
}

/**
 *       ERPS  ML   
 */
function createSwitchERPSXML(switchtype)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    var selectedRows = erpsListTable.getSelectedRows();
    var rowid = selectedRows[0];
	var erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "switchtype");
    param.setAttribute("value", switchtype);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);    
    return root.toString();
}

/**
 *    ERPS      
 */
function switchERPSBack(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == OPERATION_SUCCESS)
	{
		alert(RESOURCE["ID_OPERATE_SUCCESS"]);
		return;
	}
	showErrorDialog(data);
}

/**
 *    ERPS   
 */
function queryERPS()
{	

    if(!btnRight.querybtn.right)
    {
      alert(RESOURCE["RightUnvalid"]);
      return;
    }
    setBtnDisabled();
    lastSelectedRowIndex = -1;
    var xml = queryERPSXML();
    
    var sfid = TECMDCODE_NE_ERPS_GET_V2;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, queryERPSBack, null, "inputdata=" + xml);
}

/**
 *    ERPS      
 */
function queryERPSBack(doc)
{

    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var btnIDArr = null;
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }

    erpsListTable.clearTableData();
    
    createTableBody(erpsListTable, window.tableconf[0], data, RESOURCE);         
    adpterLoopDetect(); 
    adjustToCurrSortStatus();  
    
    var mstErpsId;
    
	for ( var i = 0, len = erpsListTable.getDataRowLength(); i < len; i++)
	{
		 mstErpsId = erpsListTable.getCellStoreValue(i, "mastererpsid", "mastererpsid");

		 if(mstErpsId == "-")
		 {
			 erpsListTable.setCellIsEdit(erpsListTable.getCell(i, "mastererpsid"), 0);
			 erpsListTable.getCellElement(i, "mastererpsid").ondblclick = null;
		 }
	}		 
	 
    if (0 == erpsListTable.getSelectedRowCount() && 0 != erpsListTable.getDataRowLength())
    {
        erpsListTable.setRowSelect(0);
        rowSelectHandler();
    }
    else
    {
        setBtnStatusOnRowSelect();
    }  
}



function adpterLoopDetect()
{
	for ( var i = 0, len = erpsListTable.getDataRowLength(); i < len; i++)
	{
		var loopDetectCell = erpsListTable.getCell(i, "W32NE_ATTR_ERPS_LOOPDETECT");
		if(loopDetectCell != null)
		{
			var loopDetectValue = erpsListTable.getCellStoreValue(i, "W32NE_ATTR_ERPS_LOOPDETECT","W32NE_ATTR_ERPS_LOOPDETECT");
			if(null == loopDetectValue ||
			    "" == loopDetectValue ||
			    "-" == loopDetectValue)
			{
				erpsListTable.setCellIsEdit(loopDetectCell, false);			
				erpsListTable.setAtomValue(loopDetectCell.element.showElement,"-");
				loopDetectCell.element.ondblclick = null;
			}
		}
		
	}
}


/**
 *   VLAN
 * @param param
 * @return
 */
function cellEditHandler(param)
{
	var cell = null;
	var eastPort = erpsListTable.getCellStoreValue(param.rowindex,"eastPortId","eastPortId");
	var westPort = erpsListTable.getCellStoreValue(param.rowindex,"westPortId","westPortId");
	var ver = erpsListTable.getCellStoreValue(param.rowindex, "compatibleVersion", "compatibleVersion");
	var resumeMode = erpsListTable.getCellStoreValue(param.rowindex, "resumeMode","resumeMode");
	var isOwnerFlag = erpsListTable.getCellStoreValue(param.rowindex,"isRPLOwnerFlag","isRPLOwnerFlag");
	var chnstatus = erpsListTable.getCellStoreValue(param.rowindex, "chnstatus","chnstatus");
	var virtualVlanID = erpsListTable.getCellStoreValue(param.rowindex, "virtualVlanID","virtualVlanID");
	if (param.colid == "ctrlVlan"  && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		cell = erpsListTable.getCell(param.rowindex, "ctrlVlan");	
		textCheck(cell.element.editElement.element, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
	}
	
    
    if (param.colid == "compatibleVersion") 
    {
        if (2 == ver) 
        {
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "chnstatus"), 1);
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "virtualVlanID"), 1);
            if (1 == isOwnerFlag) 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "resumeMode"), 1);
                if (typeof(resumeMode) == undefined || resumeMode == null) 
                {
                    erpsListTable.getCellShow(param.rowindex, "resumeMode").setValue(RESOURCE["ResumeMode_1"]);
                    erpsListTable.setCellValue(erpsListTable.getCell(param.rowindex, "resumeMode"), "resumeMode", 1);
                }
                else 
                {
                    erpsListTable.getCellShow(param.rowindex, "resumeMode").setValue(RESOURCE["ResumeMode_" + resumeMode]);
                }
            }
            else 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "resumeMode"), 0);
                erpsListTable.getCellShow(param.rowindex, "resumeMode").setValue("-");
                
            }
            $("switchbtn").disabled = !btnRight.switchbtn.right;
        }
        else if (1 == ver) 
        {
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "resumeMode"), 0);
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "chnstatus"), 0);
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "virtualVlanID"), 0);
            if (1 == isOwnerFlag) 
            {
                erpsListTable.getCellShow(param.rowindex, "resumeMode").setValue(RESOURCE["ResumeMode_1"]);
                erpsListTable.setCellValue(erpsListTable.getCell(param.rowindex, "resumeMode"), "resumeMode", 1);
            }
            else 
            {
                erpsListTable.getCellShow(param.rowindex, "resumeMode").setValue("-");
            }
            $("switchbtn").disabled = true;
        }
    }
	
    
    if (param.colid == "chnstatus") 
    {
        if ((1 == chnstatus) && ((typeof(virtualVlanID) == "undefined") || ("" == virtualVlanID)) && (typeof(eastPort) != "undefined") && (typeof(westPort) != "undefined")) 
        {
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 1);
        }
        else 
        {
            erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 0);
        }
    }
	
    
    if (param.colid == "virtualVlanID") 
    {
        cell = erpsListTable.getCellElement(param.rowindex, "virtualVlanID");
        if (cell != null) 
        {
            if ((1 == chnstatus) && (typeof(eastPort) != "undefined") && (typeof(westPort) != "undefined") && ("" == virtualVlanID)) 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 1);
            }
            else 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 0);
            }
            cell.editElement.element.style.imeMode = "disabled";
            cell.editElement.element["onkeypress"] = function(evt)
            {
				evt = evt?evt:window.event;
                return checkData(this, evt, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
            }
            
            cell.editElement.element.onpaste = function()
            {
                return false;
            }
        }
        else 
        {
            if ((1 == chnstatus) && (typeof(eastPort) != "undefined") && (typeof(westPort) != "undefined")) 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 1);
            }
            else 
            {
                erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex, "compatibleVersion"), 0);
            }
            
        }
    }
	
	if (param.colid == "mastererpsid"  && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		cell = erpsListTable.getCell(param.rowindex, "mastererpsid");	
		textCheck(cell.element.editElement.element, ERPS_ID_MIN, ERPS_ID_MAX);
	}
	
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRight.applybtn.right;
	}
}

/**
 *            
 */
function rowSelectHandler()
{
    clearModifyFlag();
    
    var selectedRows = erpsListTable.getSelectedRows();
    $("selrows").innerHTML = selectedRows.length;
	  $("totalrows").innerHTML = erpsListTable.getDataRowLength();   

    if (0 == selectedRows.length)
    {
		lastSelectedRowIndex = -1;
        clearERPSDetail();
        setBtnStatusOnRowSelect();
        return;
    }
    var rowid = selectedRows[0];
    if(lastSelectedRowIndex == rowid)
	{
		return;
	}
	lastSelectedRowIndex = rowid;
    clearERPSDetail();
    erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    mastererpsid =  erpsListTable.getCellStoreValue(rowid, "mastererpsid", "mastererpsid");
    
    if ((mastererpsid == "/") || (mastererpsid == "-")) 
    {
        $("vlanswitchbtn").disabled = true;
    }
    else 
    {
        $("vlanswitchbtn").disabled = false;
    }
    queryERPSDetail(erpsid);
}


/**
 *    modify ERPS  
 */
function modifyERPS()
{

    if(!btnRight.applybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }

    var cellModifyFlag = false;
    var selectedRows = erpsListTable.getSelectedRows();
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (i != selectedRows[0] && !erpsListTable.getModify(i))
        {
            continue;
        }
        
        cellModifyFlag = erpsListTable.getCellModify(i, "chnstatus");
    	if(cellModifyFlag)
    	{
    		 if (!confirm(RESOURCE["modifyVirChn"]))//    
    	        {
    	            return;
    	        }
    	}
    }
    setBtnDisabled();
    
    var xml = modifyERPSXML();
    
    var sfid = TECMDCODE_NE_ERPS_MODIFY_V2;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, modifyERPSBack, null, "inputdata=" + xml);
}

/**
 *     ERPS XML
 */
function modifyERPSXML()
{

    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    var selectedRows = erpsListTable.getSelectedRows();
    var cellModifyFlag = false;

    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (i != selectedRows[0] && !erpsListTable.getModify(i))
        {
            continue;
        }
        
        row = new tagElement("row-params");
    
        param = new tagElement("param", "neid", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param", "erpsid", erpsListTable.getCellStoreValue(i, "erpsid", "erpsid"));
        row.appendChild(param);
                
    	cellModifyFlag = erpsListTable.getCellModify(i, "ctrlVlan");
    	if(cellModifyFlag)
    	{
    		param = new tagElement("param", "ctrlVlan", erpsListTable.getCellStoreValue(i, "ctrlVlan", "ctrlVlan"));
            row.appendChild(param);

            param = new tagElement("param", "desMacAddr", erpsListTable.getCellStoreValue(i, "desMacAddr", "desMacAddr"));
            row.appendChild(param);
    	}
        
    	cellModifyFlag = erpsListTable.getCellModify(i, "resumeMode");
    	if(cellModifyFlag)
    	{
    		param = new tagElement("param", "resumeMode", erpsListTable.getCellStoreValue(i, "resumeMode", "resumeMode"));
            row.appendChild(param);
    	}
    	
    	cellModifyFlag = erpsListTable.getCellModify(i, "compatibleVersion");
    	if(cellModifyFlag)
    	{
    		param = new tagElement("param", "compatibleVersion", erpsListTable.getCellStoreValue(i, "compatibleVersion", "compatibleVersion"));
            row.appendChild(param);
    	}
    	
    	cellModifyFlag = erpsListTable.getCellModify(i, "chnstatus");
    	if(cellModifyFlag)
    	{
            param = new tagElement("param", "chnstatus", erpsListTable.getCellStoreValue(i, "chnstatus", "chnstatus"));
            row.appendChild(param);
    	}
    	
    	cellModifyFlag = erpsListTable.getCellModify(i, "virtualVlanID");
    	if(cellModifyFlag)
    	{
    		param = new tagElement("param", "vlanidcount", "0");
            row.appendChild(param);
            
            param = new tagElement("param", "vlanidlist", erpsListTable.getCellStoreValue(i, "virtualVlanID", "virtualVlanID"));
            row.appendChild(param);
            
            param = new tagElement("param", "cmdFlag", "NSCMD_CFG_ETHN_ERPS_SET_VCHANNEL_VLAN");
            row.appendChild(param);
    	}
    	
    	
    	cellModifyFlag = erpsListTable.getCellModify(i, "mastererpsid");
    	if(cellModifyFlag)
    	{
            param = new tagElement("param", "mastererpsid", erpsListTable.getCellStoreValue(i, "mastererpsid", "mastererpsid"));
            row.appendChild(param);
    	}  
    	
    	if (erpsListTable.getCell(i, "W32NE_ATTR_ERPS_LOOPDETECT")!= null && erpsListTable.getCellModify(i, "W32NE_ATTR_ERPS_LOOPDETECT"))
		{
			param = new tagElement("param");
			param.setAttribute("name", "W32NE_ATTR_ERPS_LOOPDETECT");
			param.setAttribute("value", erpsListTable.getCellCurrentValue(i,"W32NE_ATTR_ERPS_LOOPDETECT", "W32NE_ATTR_ERPS_LOOPDETECT"));
			row.appendChild(param);
		}   	        
            
    	if(isSupportEth)                     //eth domain
    	{
        	cellModifyFlag = erpsListTable.getCellModify(i, "ethdomain");
        	if(cellModifyFlag )
        	{
                param = new tagElement("param", "ethdomain", erpsListTable.getCellStoreValue(i, "ethdomain", "ethdomain"));
                row.appendChild(param);
        	}     		   		
    	}	
   	
        if (i == selectedRows[0])
        {
			appendAttributeParam(row);
        }
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function appendAttributeParam(row)
{
	var param = null;
    if (modifyFlagArray["holdoffTime"])
    {
        param = new tagElement("param", "holdoffTime", leftCTable.getAttrValue("holdoffTime"));
        row.appendChild(param);
    }
        
    if (modifyFlagArray["wtrTime"])
    {
        param = new tagElement("param", "wtrTime", rightCTable.getAttrValue("wtrTime"));
        row.appendChild(param);
    }
    
    if (modifyFlagArray["guardTime"])
    {
        param = new tagElement("param", "guardTime", leftCTable.getAttrValue("guardTime"));
        row.appendChild(param);
    }
    
    if (modifyFlagArray["entityLevel"] || modifyFlagArray["sendInterval"])
    {
        param = new tagElement("param", "entityLevel", leftCTable.getAttrValue("entityLevel"));
        row.appendChild(param);            
        
        param = new tagElement("param", "sendInterval", rightCTable.getAttrValue("sendInterval"));
        row.appendChild(param);
    }
}

/**
 *    ERPS
 */
function deleteERPS()
{
    if(!btnRight.deletebtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    
    var selectedRows = erpsListTable.getSelectedRows();
    
		if (0 == selectedRows.length)
		{
		    alert(RESOURCE["ID_SELECT"]);
				return;
		}
	
		if (!confirm(RESOURCE["ID_DELSURE"]))
		{
				return;
		}
	
		var rowid = selectedRows[0];
		var erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    setBtnDisabled();
    
    var xml = deleteERPSXML(erpsid);
    var sfid = TECMDCODE_NE_ERPS_DEL_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, deleteERPSBack, rowid, "inputdata=" + xml);
}

function doOpenVlanSwitich()
{
    var URL = "vlanswitch.html?neid=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
    xshowModalDialog(URL, RESOURCE["vlanlist"], 600, 400, "../../../../../images/");
}

function setBtnDisabled()
{
	$("querybtn").disabled = true;
    $("printbtn").disabled = true;
    $("createbtn").disabled = true;
	$("switchbtn").disabled = true;
    $("applybtn").disabled = true;
    $("deletebtn").disabled = true;
    $("vlanswitchbtn").disabled = true;
    var atom = leftCTable.getAtom("holdoffTime");
    setSelectDisabled(atom.element);
    
    atom = leftCTable.getAtom("guardTime");
    setSelectDisabled(atom.element);
    
    atom = leftCTable.getAtom("entityLevel");
    setSelectDisabled(atom.element);

    atom = rightCTable.getAtom("wtrTime");
    setSelectDisabled(atom.element);
    
    atom = rightCTable.getAtom("sendInterval");
    setSelectDisabled(atom.element);
}

/**
 *                     
 */
function setBtnStatusOnRowSelect()
{
	 $("querybtn").disabled = !btnRight.querybtn.right;
     $("printbtn").disabled = !btnRight.printbtn.right;
     
     $("createbtn").disabled = !btnRight.createbtn.right;
     $("deletebtn").disabled = !btnRight.deletebtn.right;
     $("vlanswitchbtn").disabled = !btnRight.vlanswitchbtn.right;
    var selectedRows = erpsListTable.getSelectedRows();
    if (0 == selectedRows.length)
    {
        $("deletebtn").disabled = true;
        $("switchbtn").disabled = true;
        $("vlanswitchbtn").disabled = true;
    }else{
    	var rowid = selectedRows[0];
        mastererpsid =  erpsListTable.getCellStoreValue(rowid, "mastererpsid", "mastererpsid");
        if((mastererpsid == "/") || (mastererpsid == "-"))
        {
        	$("vlanswitchbtn").disabled = true;
        }else{
        	$("vlanswitchbtn").disabled = false;
        }
        
        var ver = erpsListTable.getCellStoreValue(rowid, "compatibleVersion", "compatibleVersion");
        if (1 == ver)
        {
        	$("switchbtn").disabled = true;
        }
        else
        {
        	$("switchbtn").disabled = !btnRight.switchbtn.right;
        }
    }
    
    if (0 >= selectedRows.length) 
    {
    	setSelectDisabled(leftCTable.getAtom("holdoffTime").element);
    	setSelectDisabled(leftCTable.getAtom("guardTime").element);
    	setSelectDisabled(leftCTable.getAtom("entityLevel").element);
    	setSelectDisabled(rightCTable.getAtom("sendInterval").element);
    	setSelectDisabled(rightCTable.getAtom("wtrTime").element);
    }
    else 
    {
        var atom = leftCTable.getAtom("holdoffTime");
        setSelectEnabled(atom.element);
        
        atom = leftCTable.getAtom("guardTime");
        setSelectEnabled(atom.element);
        
        atom = leftCTable.getAtom("entityLevel");
        setSelectEnabled(atom.element);
        
        atom = rightCTable.getAtom("sendInterval");
        setSelectEnabled(atom.element);
        
        var isRPLOwnerFlag = null;
        atom = rightCTable.getAtom("wtrTime");
        atom.removeOption(""); 
        if (0 != selectedRows.length) 
        {
            isRPLOwnerFlag = erpsListTable.getCellStoreValue(selectedRows[0], "isRPLOwnerFlag", "isRPLOwnerFlag");
            if (RPL_OWNER_FLAG_VALUE[0] == isRPLOwnerFlag) 
            {
                atom.addOption(" ", "");
                atom.element.value="";
		setSelectDisabled(atom.element);
            }
            else 
            {           	
            	setSelectEnabled(atom.element);           
            	atom.removeOption("");    
            }
        }
        else 
        {     
        	atom.removeOption("");       
                setSelectEnabled(atom.element);
        }
    }
}
/*
 *   Value  select   Option 
 */
Atom.prototype.removeOption = function(value)
{
	if (this.type == "select")
	{
		for ( var i = 0, m = this.element.options.length; i < m; i++)
		{
			var option = this.element.options[i];
			if (option.value == value)
			{
				this.element.options[i] = null;//   IE firefox         
			}
		}
	}
	else if (this.type == "combo-button")
	{
		this.element.parent.removeOption(value);
	}
	else if(this.type == "combobox")
	{
		for ( var i = 0, m = this.element.parent.getLength(); i < m; i++)
		{
			var option = this.element.parent.getOption(i);
			if(option.value == value)
			{
				this.element.parent.remove(i);
				break;
			}
		}
	}
}

function createFuncPopupMenu(rows, evt)
{
	createSwitchMenu()
	showMenu(evt);
}

function adjustToCurrSortStatus()
{
    if(!erpsListTable.element.colsArray.selectedId)
    {
  	   erpsListTable.element.colsArray.selectedId = "erpsid";
  	   erpsListTable.element.colsArray.imgflag = 1;
    }
    
    var td = erpsListTable.element.headRow.element.cols[erpsListTable.element.colsArray.selectedId].element; 
    erpsListTable.sortRows(td, erpsListTable.element.colsArray.imgflag);
    var erpsID;
    var resumeMode;
    var compatibleVer;
    var isOwnerFlag;
    var eastPort;
    var westPort;
    var chnstatus;
    var virtualVlanID;
    var mastererpsid;
    for(var i = 0,len = erpsListTable.getDataRowLength();i < len;i++)
    {
    	erpsID = erpsListTable.getCellStoreValue(i,"erpsid","erpsid");
    	resumeMode = erpsListTable.getCellStoreValue(i,"resumeMode","resumeMode");
    	compatibleVer = erpsListTable.getCellStoreValue(i,"compatibleVersion","compatibleVersion");
    	isOwnerFlag = erpsListTable.getCellStoreValue(i,"isRPLOwnerFlag","isRPLOwnerFlag");
        eastPort = erpsListTable.getCellStoreValue(i,"eastPortId","eastPortId");
        westPort = erpsListTable.getCellStoreValue(i,"westPortId","westPortId");
        chnstatus = erpsListTable.getCellStoreValue(i,"chnstatus","chnstatus");
        virtualVlanID = erpsListTable.getCellStoreValue(i,"virtualVlanID","virtualVlanID");
        mastererpsid = erpsListTable.getCellStoreValue(i,"mastererpsid","mastererpsid");
    	if((2 == compatibleVer) && (0 != isOwnerFlag))
    	{
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"resumeMode"),1);
    	}
    	else
    	{
        	erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"resumeMode"),0);
    	}
    	

    	if(typeof(resumeMode) == "undefined" || resumeMode == null)
    	{
    		erpsListTable.getCellShow(i,"resumeMode").setValue("-");
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"resumeMode"),0);
    	}
    	else
    	{
    		erpsListTable.getCellShow(i,"resumeMode").setValue(RESOURCE["ResumeMode_" + resumeMode]);
    	}
    	
    	if((typeof(eastPort) == "undefined" ) || (typeof(westPort) == "undefined" ))//   ERPS      VER1          
    	{
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"compatibleVersion"),0);
    	}
    	
    	if(2 == compatibleVer)//                   VLAN ID      VER1          
    	{
    		if((0 == chnstatus) || (typeof(virtualVlanID) != "undefined" ) )
    		{
    			erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"compatibleVersion"),0);
    		}
    	}else{
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"chnstatus"),0);
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"virtualVlanID"),0);
    	}
    }
}
