var RPL_OWNER_FLAG = [];
RPL_OWNER_FLAG[0] = "IsNotRPLOwner";//RESOURCE["IsNotRPLOwner"];
RPL_OWNER_FLAG[1] = "IsRPLOwner";//RESOURCE["IsRPLOwner"];
RPL_OWNER_FLAG[2] = "IsNeighbourPortRPLOwner";//RPL Neighbour Port
RPL_OWNER_FLAG[3] = "IsNextNeighbourPortRPLOwner";//RPL Next Neighbour Port

var RPL_OWNER_FLAG_VALUE = [];
RPL_OWNER_FLAG_VALUE[0] = 0;
RPL_OWNER_FLAG_VALUE[1] = 1;
RPL_OWNER_FLAG_VALUE[2] = 2;
RPL_OWNER_FLAG_VALUE[3] = 3;

var virtualChnStatus = [];
virtualChnStatus[0] = RESOURCE["status_disable"];
virtualChnStatus[1] = RESOURCE["status_enable"];

var convertLoopDetect = [];
convertLoopDetect[0] = "loopdetect_0";
convertLoopDetect[1] = "loopdetect_1";

var VER_STATUS = [];
VER_STATUS[0] = "0";
VER_STATUS[1] = "1";


var ETH_TYPE_MODE = [];
ETH_TYPE_MODE[0] = RESOURCE["ethtypemode_0"];
ETH_TYPE_MODE[1] = RESOURCE["ethtypemode_1"];

var VER_ETH_STARTUS = [];
VER_ETH_STARTUS[0] = "34825";     //0x8809     
VER_ETH_STARTUS[1] = "35074";	  //0x8902      

var GUARD_TIME_MAX = "10000";//       


function convertEthType(status)
{
	var ethType = "-";
	switch(status)
	{
	  case VER_ETH_STARTUS[0]:
           ethType = ETH_TYPE_MODE[0];
	       break;
	  case VER_ETH_STARTUS[1]:
           ethType = ETH_TYPE_MODE[1];
	       break;	
	  default:
          ethType = ETH_TYPE_MODE[0];		  	
	}
	return ethType;
}


function convertVlanStatus(status)
{
	var vlanStatus = "-";
	switch(status)
	{
	case VER_STATUS[0]:
		vlanStatus = virtualChnStatus[0];
		break;
	case VER_STATUS[1]:
		vlanStatus = virtualChnStatus[1];
		break;
	default:
		vlanStatus = virtualChnStatus[0];	
	}
	return vlanStatus;
}

function checkData(obj,event,min,max)
{ 
    var code = event.keyCode!=0?event.keyCode:event.charCode;
    var codeValue = String.fromCharCode(code);	 
    var index = digitalTag_getPos(obj);   
    var lastValue2 = obj.value;
    var thisValue2 = obj.value.substring(0,index) + codeValue + obj.value.substring(index);	
    var rep2 = /-/gi;
    var value2 = thisValue2.replace(rep2,",");
    var values2 = value2.split(",");
    
    var bol2 = chkCVlan(obj,event,min,max);    	
    if(bol2)
    {
          var length = 0;
          var str = thisValue2.split(",");
          for(var i = 0; i < str.length; i++)
          {
               var b = str[i].indexOf("-")!=-1;
               if(b)
               {
                  var range=str[i].split("-");
                  var rangeStart=parseInt(range[0]);
                  var rangeEnd=parseInt(range[1]);
                  if(!(isNaN(rangeStart) || isNaN(rangeEnd)))
                  {
                  length = length+(rangeEnd - rangeStart)+1;
                  }
               }
               else
               {
                   if(!isNaN(parseInt(str[i])))
                   {
                   length = length+1;
                   }
               }
          }
        
          if(length > 4094)
          {
          bol2 = false;
          }
          else
          {
          lastValue2 = thisValue2;
          }
    }
    return bol2;
}

function chkCVlan(obj,event,min,max)
{
	var code=(event.keyCode!=0?event.keyCode:event.charCode);
	var ch = String.fromCharCode(code);
   if(code == 8 || code == 37 || code == 39)
    {
    	return true; 
    }
   
    if(!restrict(obj, event, "0123456789,-"))
    {
        return false;
    }
    
     
    var value=obj.value;
    pos=digitalTag_getPos(obj);                

    var valueArr = value.substring(0,pos).split(",");
    valueArr = valueArr[valueArr.length - 1].split("-");
    if(valueArr[valueArr.length - 1]=='0' && pos>0 && ch != ',' && ch != '-')
    {
        return false;
    }
    
    var newVal = value.substring(0,pos) + ch + value.substring(pos+selectionLen(obj));  
        
    if(!isCVlan(newVal,min,max))
    {
        return false;
    }
    return true;
}

function isCVlan(newVal,min,max)
{         
    var text= newVal;
    
    if(!text || "" == text)
    {
        return true;
    }
    
    var str = text.split(",");
    
    for(var i = 0; i < str.length; i++)
    {
        var b = str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);

            if((rangeStart > max) || (rangeEnd > max)
                ||(rangeStart < min) ||(rangeEnd < min))
            {
       	        alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>max || parseInt(str[i])<min)
           {
           	    alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
           }
        }
    }
    return true;        
}
