var MenuStatus = {Clear:"0",
					ManualSwitchEast:"1",
					ManualSwitchWest:"2",
					ForceSwitchEast:"3",
					ForceSwitchWest:"4"
				}

var isSupportEth = false;

function initPage()
{
   isSupportEth = SpecialAttrMgr.isNESupport(winurlobj["neid"], "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");	
   if(isSupportEth == false)
   {	
	   var ethdomain = window.tableconf[0].getColFromColId("ethdomain");
	   ethdomain.setWidth("0");
   }
   
    var erpsIDs = SpecialAttrMgr.getNEAttrListValue(winurlobj["neid"],"TE_FUNC_ERPS","TE_ATTR_ERPS_ID_RANGE");
    if(erpsIDs != null && erpsIDs.length > 1)
    {
		ERPS_ID_MIN = erpsIDs[0];
		ERPS_ID_MAX = erpsIDs[1];
    }
    initTopSortTable();
    initLeftCTable();
    initRightCTable();
    initButton();
    
    if (btnRight.querybtn.right)
    {
        queryERPS(); 
    }
    else
    {
    	$("querybtn").disabled = true;
    	$("applybtn").disabled = true;
    	$("deletebtn").disabled = true;
    	$("createbtn").disabled = true;
    }
}

function popupMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if(btnRight.switchbtn.right == false)
	{
		return;
	}
	if (rows.contains(rowid))
	{
		createFuncPopupMenu(rows, evt);
	}
}

/**
 *             
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.querybtn = new BtnRightObj("querybtn", TECMDCODE_ERPS_GET_ENTITY);    
    btnRight.createbtn = new BtnRightObj("createbtn", TECMDCODE_ERPS_CRT_ENTITY);
    btnRight.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_ERPS_DEL_ENTITY);
    btnRight.applybtn = new BtnRightObj("applybtn", TECMDCODE_ERPS_MODIFY_ENTITY);
    btnRight.printbtn = new BtnRightObj("printbtn", TECMDCODE_ERPS_GET_ENTITY);
    btnRight.switchbtn = new BtnRightObj("switchbtn", TECMDCODE_ERPS_SET_SWITCH);
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

/**
 *                     
 */
function setBtnStatusOnRowSelect()
{
    var selectedRows = erpsListTable.getSelectedRows();
    if (0 == selectedRows.length)
    {
        $("querybtn").disabled = !btnRight.querybtn.right;
        $("printbtn").disabled = !btnRight.printbtn.right;
        $("switchbtn").disabled = true;
        $("createbtn").disabled = !btnRight.createbtn.right;
        $("deletebtn").disabled = true;
    }
    else
    {
        $("querybtn").disabled = !btnRight.querybtn.right;
        $("printbtn").disabled = !btnRight.printbtn.right;
        $("createbtn").disabled = !btnRight.createbtn.right;
        $("deletebtn").disabled = !btnRight.deletebtn.right;
        
        for (var i = 0; i < selectedRows.length; i++)
        {
        	var ver = erpsListTable.getCellStoreValue(selectedRows[i], "compatibleVersion", "compatibleVersion");
            if (1 == ver)
            {
            	$("switchbtn").disabled = true;
            }
            else
            {
            	$("switchbtn").disabled = !btnRight.switchbtn.right;
            }
        }       
    }
    if (0 >= selectedRows.length) 
	{
    	setSelectDisabled(leftCTable.getAtom("holdoffTime").element);
		setSelectDisabled(leftCTable.getAtom("guardTime").element);
		setSelectDisabled(leftCTable.getAtom("entityLevel").element);
		setSelectDisabled(rightCTable.getAtom("sendInterval").element);
		setSelectDisabled(rightCTable.getAtom("wtrTime").element);
	}
	else 
	{
		var atom = leftCTable.getAtom("holdoffTime");
		setSelectEnabled(atom.element);
		
		atom = leftCTable.getAtom("guardTime");
		setSelectEnabled(atom.element);
		
		atom = leftCTable.getAtom("entityLevel");
		setSelectEnabled(atom.element);
		
		atom = rightCTable.getAtom("sendInterval");
		setSelectEnabled(atom.element);
		
		var isRPLOwnerFlag = null;
		atom = rightCTable.getAtom("wtrTime");
		if (0 != selectedRows.length) 
		{
			isRPLOwnerFlag = erpsListTable.getCellStoreValue(selectedRows[0], "isRPLOwnerFlag", "isRPLOwnerFlag");
			if (RPL_OWNER_FLAG_VALUE[0] == isRPLOwnerFlag) 
			{
				atom.element.value = "-";
				setSelectDisabled(atom.element);
			}
			else 
			{
				setSelectEnabled(atom.element);
			}
		}
		else 
		{
			setSelectEnabled(atom.element);
		}
	}
}

function createFuncPopupMenu(rows, evt)
{
	createSwitchMenu()
	showMenu(evt);
}

/**
 *         
 */
function initButton()
{
	$("querybtn").value =  RESOURCE["querybutton"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	$("switchbtn").value = RESOURCE["switchbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("printbtn").value = RESOURCE["printbutton"];
	
	$("querybtn").onclick = queryERPS;
	$("createbtn").onclick = createERPS;
	$("deletebtn").onclick = deleteERPS;
	$("switchbtn").onclick = switchERPSBtn;
	$("applybtn").onclick = modifyERPS;
	$("printbtn").onclick = doPrint;
	
	$("applybtn").disabled = true;
	
	getAllBtnRight();
}

/**
 *             
 */
function switchERPSBtn(evt)
{
	if($("switchbtn").disabled == true)
	{
		return;
	}
	if (!evt)
	{
		evt = window.event;
	}
	evt.cancelBubble=true;
	createSwitchMenu();
	showMenu(event);
}

/**
 *          
 */
function createSwitchMenu()
{
	removejsDOMmenu();
	var cursorMenu1 = new jsDOMenu(170);
	
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_0"], "",switchERPS, MenuStatus.Clear, MenuStatus.Clear));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_1"], "",switchERPS, MenuStatus.ManualSwitchEast, MenuStatus.ManualSwitchEast));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_2"], "",switchERPS, MenuStatus.ManualSwitchWest, MenuStatus.ManualSwitchWest));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_3"], "",switchERPS, MenuStatus.ForceSwitchEast, MenuStatus.ForceSwitchEast));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["switchbutton_4"], "",switchERPS, MenuStatus.ForceSwitchWest, MenuStatus.ForceSwitchWest));
	setPopUpMenu(cursorMenu1);
}

/**
 *    ERPS
 */
function switchERPS(/*string*/switchtype)
{
	removejsDOMmenu();
	var selectedRows = erpsListTable.getSelectedRows();
	if (0 == selectedRows.length)
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	if (!confirm(RESOURCE["deletealarm"]))
	{
			return;
	}
	if (!confirm(RESOURCE["SERVICE_BREAK_WARN"]))
	{
			return;
	}

    var xml = createSwitchERPSXML(switchtype);
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_NE_ERPS_SET_SWITCH +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, switchERPSBack, null, "inputdata=" + xml);
}

/**
 *       ERPS  ML   
 */
function createSwitchERPSXML(switchtype)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    var selectedRows = erpsListTable.getSelectedRows();
    var rowid = selectedRows[0];
	var erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "switchtype");
    param.setAttribute("value", switchtype);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);    
    return root.toString();
}

/**
 *    ERPS      
 */
function switchERPSBack(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == OPERATION_SUCCESS)
	{
		alert(RESOURCE["ID_OPERATE_SUCCESS"]);
		return;
	}
	showErrorDialog(data);
}

/**
 *       ERPS     
 */
function createERPS()
{
    var applybtnStatus = $("applybtn").disabled;
    setBtnDisabled();
    var URL = "../erps_u2kv1r6c00/erpscreate.html?neid=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
    xshowModalDialog(URL, RESOURCE["createERPS"], 500, 260, "../../../../../images/");
    setBtnStatusOnRowSelect();
    $("applybtn").disabled = applybtnStatus;
}

/**
 *                     
 */
function cellEditHandler(param)
{
	var cell = null;
	
	if (param.colid == "ctrlVlan")
	{
		cell = erpsListTable.getCell(param.rowindex, "ctrlVlan");	
		textCheck(cell.element.editElement.element, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
		$("applybtn").disabled = !btnRight.applybtn.right;
	}

	if (param.colid == "resumeMode")
	{
		$("applybtn").disabled = !btnRight.applybtn.right;
	}
	
	if (param.colid == "W32NE_ATTR_ERPS_LOOPDETECT")
	{		
		$("applybtn").disabled = !btnRight.applybtn.right;
	}
	if (param.colid == "compatibleVersion")
	{
		$("applybtn").disabled = !btnRight.applybtn.right;
		var ver = erpsListTable.getCellStoreValue(param.rowindex, "compatibleVersion", "compatibleVersion");
		var resumeMode = erpsListTable.getCellStoreValue(param.rowindex, "resumeMode","resumeMode");
		var isOwnerFlag = erpsListTable.getCellStoreValue(param.rowindex,"isRPLOwnerFlag","isRPLOwnerFlag");
		
		if(2 == ver)
		{
			if(1 == isOwnerFlag)
			{
				erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex,"resumeMode"),1);
				if(typeof(resumeMode) == undefined || resumeMode == null)
				{
					erpsListTable.getCellShow(param.rowindex,"resumeMode").setValue(RESOURCE["ResumeMode_1"]);
					erpsListTable.setCellValue(erpsListTable.getCell(param.rowindex, "resumeMode"),"resumeMode",1);
				}
				else
				{
					erpsListTable.getCellShow(param.rowindex,"resumeMode").setValue(RESOURCE["ResumeMode_" + resumeMode]);
				}
			}
			else
			{
				erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex,"resumeMode"),0);
				erpsListTable.getCellShow(param.rowindex,"resumeMode").setValue("-");
				
			}
			$("switchbtn").disabled = !btnRight.switchbtn.right;
		}
		else if(1 == ver)
		{
			erpsListTable.setCellIsEdit(erpsListTable.getCell(param.rowindex,"resumeMode"),0);
			if(1 == isOwnerFlag)
			{
				erpsListTable.getCellShow(param.rowindex,"resumeMode").setValue(RESOURCE["ResumeMode_1"]);
				erpsListTable.setCellValue(erpsListTable.getCell(param.rowindex, "resumeMode"),"resumeMode",1);
			}
			else
			{
				erpsListTable.getCellShow(param.rowindex,"resumeMode").setValue("-");
			}
			$("switchbtn").disabled = true;
		}
	}
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRight.applybtn.right;
	}
}

/**
 *       ERPS     ML   
 */
function modifyERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    var selectedRows = erpsListTable.getSelectedRows();
    var cellModifyFlag = false;
        
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (i != selectedRows[0] && !erpsListTable.getModify(i))
        {
            continue;
        }
        row = new tagElement("row-params");
    
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "erpsid");
        param.setAttribute("value", erpsListTable.getCellStoreValue(i, "erpsid", "erpsid"));
        row.appendChild(param);
        
        cellModifyFlag = erpsListTable.getCellModify(i, "ctrlVlan");
        if (cellModifyFlag && 0 != selectedRows.length && i == selectedRows[0])
        {
            param = new tagElement("param");
            param.setAttribute("name", "ctrlVlan");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "ctrlVlan", "ctrlVlan"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "desMacAddr");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "desMacAddr", "desMacAddr"));
            row.appendChild(param);
        }
        
        cellModifyFlag = erpsListTable.getCellModify(i, "resumeMode");
        if (cellModifyFlag && 0 != selectedRows.length && i == selectedRows[0])
        {
            param = new tagElement("param");
            param.setAttribute("name", "resumeMode");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "resumeMode", "resumeMode"));
            row.appendChild(param);
        }
        
        cellModifyFlag = erpsListTable.getCellModify(i, "compatibleVersion");
        if (cellModifyFlag && 0 != selectedRows.length && i == selectedRows[0])
        {
            param = new tagElement("param");
            param.setAttribute("name", "compatibleVersion");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "compatibleVersion", "compatibleVersion"));
            row.appendChild(param);
        }
        
        if (erpsListTable.getCell(i, "W32NE_ATTR_ERPS_LOOPDETECT")!= null && erpsListTable.getCellModify(i, "W32NE_ATTR_ERPS_LOOPDETECT"))
		{
			param = new tagElement("param");
			param.setAttribute("name", "W32NE_ATTR_ERPS_LOOPDETECT");
			param.setAttribute("value", erpsListTable.getCellCurrentValue(i,"W32NE_ATTR_ERPS_LOOPDETECT", "W32NE_ATTR_ERPS_LOOPDETECT"));
			row.appendChild(param);
		}   	        
        
        if(isSupportEth)                     //eth domain
    	{
        	cellModifyFlag = erpsListTable.getCellModify(i, "ethdomain");
        	if(cellModifyFlag )
        	{
                param = new tagElement("param", "ethdomain", erpsListTable.getCellStoreValue(i, "ethdomain", "ethdomain"));
                row.appendChild(param);
        	}     		   		
    	}
        
        if (i == selectedRows[0])
        {
			appendAttributeParam(row);
        }

        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *               
 */
function adjustToCurrSortStatus()
{
    if(!erpsListTable.element.colsArray.selectedId)
    {
  	   erpsListTable.element.colsArray.selectedId = "erpsid";
  	   erpsListTable.element.colsArray.imgflag = 1;
    }
    
    var td = erpsListTable.element.headRow.element.cols[erpsListTable.element.colsArray.selectedId].element; 
    erpsListTable.sortRows(td, erpsListTable.element.colsArray.imgflag);

    for(var i = 0,len = erpsListTable.getDataRowLength();i < len;i++)
    {
    	var resumeMode = erpsListTable.getCellStoreValue(i,"resumeMode","resumeMode");
    	var compatibleVer = erpsListTable.getCellStoreValue(i,"compatibleVersion","compatibleVersion");
    	var isOwnerFlag = erpsListTable.getCellStoreValue(i,"isRPLOwnerFlag","isRPLOwnerFlag");

    	if(2 == compatibleVer && 1 == isOwnerFlag)
    	{
    		erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"resumeMode"),1);
    	}
    	else
    	{
        	erpsListTable.setCellIsEdit(erpsListTable.getCell(i,"resumeMode"),0);
    	}
    	
    	if(typeof(resumeMode) == "undefined" || resumeMode == null)
    	{
    		erpsListTable.getCellShow(i,"resumeMode").setValue("-");
    	}
    	else
    	{
    		erpsListTable.getCellShow(i,"resumeMode").setValue(RESOURCE["ResumeMode_" + resumeMode]);
    	}
    }
}
