
/**
 *         
 */
function initTable()
{
    erpsTable = new CTable();
    
    erpsTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    addERPSIDAttr(erpsTable);
    
    addEastPortAttr(erpsTable);
    
    addWestPortAttr(erpsTable);
    
    addRPLFlagAttr(erpsTable);
    
    addRPLPortAttr(erpsTable);
    
    addResumeModeAttr(erpsTable);

    addCtrlVlanAttr(erpsTable);
    
    addDesMacAttr(erpsTable);
    
    addLoopDetectAttr(erpsTable);
    
    $("erpsTableDiv").appendChild(erpsTable.getTable());
}

/**
 *    RPLOwner            
 **/
function addResumeModeAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    cTableAtom.element.disabled = true;
    table.addAttrRow("resumeMode", RESOURCE["ResumeMode"], cTableAtom); 
}

function initResumeMode()
{
    erpsTable.getAtom("resumeMode").addOption(RESOURCE[ResumeMode[0]], "0");
    erpsTable.getAtom("resumeMode").addOption(RESOURCE[ResumeMode[1]], "1");
    
    erpsTable.getAtom("resumeMode").element.selectedIndex = 1;
    
}

function RPLFlag_onChange()
{
    $("okbtn").disabled = false;
    $("applybtn").disabled = false;
    if (RPL_OWNER_FLAG_VALUE[1] == this.value)
    {
        initRPLPort();
        erpsTable.getAtom("rplPortId").element.disabled = false;
   	    initResumeMode();
        erpsTable.getAtom("resumeMode").element.disabled = false;  
        
        if(isSupportLoopDetect())
        {
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.options.length = 0;
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.disabled = false;
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption(RESOURCE["loopdetect_0"], 0);
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption(RESOURCE["loopdetect_1"], 1);
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.value = 1;
        }
    }
    else
    {
        erpsTable.getAtom("rplPortId").element.options.length = 0;
        erpsTable.getAtom("rplPortId").element.disabled = true;
        erpsTable.getAtom("resumeMode").element.disabled = true;
        erpsTable.getAtom("resumeMode").element.options.length = 0;
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.options.length = 0;
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.disabled = true;
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption("-", "-");
    }
}


/**
 * 2013/06/09 17:13 chuhongtao 00168335                    
 * RTN910	5.76.03.47
 * RTN950	5.76.03.47
 * RTN980	5.83.03.47
 * @return
 */
function isSupportLoopDetect()
{
	 var isSupportLoop = SpecialAttrMgr.isNESupport(winurlobj["neid"], "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_LOOPDETECT");	
 	 return isSupportLoop;		   
}

/**
 *    ERPS           
 **/
function addLoopDetectAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtom.addOption("-", "-");
    cTableAtomEle.disabled = true;
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    table.addAttrRow("W32NE_ATTR_ERPS_LOOPDETECT", RESOURCE["W32NE_ATTR_ERPS_LOOPDETECT"], cTableAtom); 
}

/**
 *       ERPS  ML   
 */
function createERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var erpsid = erpsTable.getAttrValue("erpsid");
    
    var eastPort = erpsTable.getAttrValue("eastPortId");
    var westPort = erpsTable.getAttrValue("westPortId");
    
    var isRPLOwnerFlag = erpsTable.getAttrValue("isRPLOwnerFlag");
    var rplPort = null;
    
    if (RPL_OWNER_FLAG_VALUE[1] == isRPLOwnerFlag)
    {
        rplPort = erpsTable.getAttrValue("rplPortId");
    }
    else
    {
        rplPort = RPL_PORT_ID_UNVALID;
    }
    
    if(rplPort == "-")
    {
    	rplPort = "65535-65535";
    }
    
    var ctrlVlan = erpsTable.getAttrValue("ctrlVlan");
    var desMacAddr = erpsTable.getAttrValue("desMacAddr");
    desMacAddr = neMacAddr(desMacAddr);
    
    var resumeMode = erpsTable.getAttrValue("resumeMode");
    
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastslotid");
    param.setAttribute("value", getSlotid(eastPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastPortId");
    param.setAttribute("value", getPortid(eastPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westslotid");
    param.setAttribute("value", getSlotid(westPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westPortId");
    param.setAttribute("value", getPortid(westPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "rplslotid");
    param.setAttribute("value", isRPLOwnerFlag == 0 ? "65535" : getSlotid(rplPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "rplPortId");
    param.setAttribute("value", isRPLOwnerFlag == 0 ? "65535" : getPortid(rplPort));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "isRPLOwnerFlag");
    param.setAttribute("value", isRPLOwnerFlag);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ctrlVlan");
    param.setAttribute("value", ctrlVlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddr");
    param.setAttribute("value", desMacAddr);
    row.appendChild(param);
    
    if(1 == isRPLOwnerFlag)
    {
	    param = new tagElement("param");
	    param.setAttribute("name", "resumeMode");
	    param.setAttribute("value", resumeMode);
	    row.appendChild(param);
    }
    if(erpsTable.getAttrValue("W32NE_ATTR_ERPS_LOOPDETECT") != '-')
    {
	    param = new tagElement("param");
	    param.setAttribute("name", "W32NE_ATTR_ERPS_LOOPDETECT");
	    param.setAttribute("value", erpsTable.getAttrValue("W32NE_ATTR_ERPS_LOOPDETECT"));
	    row.appendChild(param);
    }
    
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *             
 * @param data:         
 * @return   
 */
function fillTableData(data)
{
    win.queryERPS();
}
