
var winurlobj = getNeProperty(self);
var win = getParentWindow();
var neObj = getNeProperty(win);


var btnRight = null;

var erpsTable = null;

document.title = RESOURCE["createERPS"];


var neType = neObj.neType;
var nevr = neObj.neversion.split('.');

/**
 *      
 */
function initPage()
{
    initTable();
    initButton();
    initPort();
}

/**
 *      
 */
function initTable()
{
    erpsTable = new CTable();
    
    erpsTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    addERPSIDAttr(erpsTable);
    
    addEastPortAttr(erpsTable);
    
    addWestPortAttr(erpsTable);
    
    addRPLFlagAttr(erpsTable);
    
    addRPLPortAttr(erpsTable);

    addCtrlVlanAttr(erpsTable);
    
    addDesMacAttr(erpsTable);
    
    addLoopDetectAttr(erpsTable);
    
    $("erpsTableDiv").appendChild(erpsTable.getTable());
}

/**
 *   ERPSID   
 **/
function addERPSIDAttr(table)
{
    var cTableAtom = new Atom("text");
    var cTableAtomEle = cTableAtom.element; 
    var erpsIDs = SpecialAttrMgr.getNEAttrListValue(winurlobj["neid"],"TE_FUNC_ERPS","TE_ATTR_ERPS_ID_RANGE");
    if(erpsIDs != null && erpsIDs.length > 1)
    {
		ERPS_ID_MIN = erpsIDs[0];
		ERPS_ID_MAX = erpsIDs[1];
    	checkText(cTableAtomEle, erpsIDs[0], erpsIDs[1]);
    }
    else
    {
    	checkText(cTableAtomEle, ERPS_ID_MIN, ERPS_ID_MAX);
    }
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    table.addAttrRow("erpsid", RESOURCE["erpsid"], cTableAtom); 
}

/**
 *           
 **/
function addEastPortAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        initRPLPort();
    }
    table.addAttrRow("eastPortId", RESOURCE["eastPortId"], cTableAtom); 
}

/**
 *           
 **/
function addWestPortAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        initRPLPort();
    }
    table.addAttrRow("westPortId", RESOURCE["westPortId"], cTableAtom); 
}

/**
 *   RPLOwner        
 **/
function addRPLFlagAttr(table)
{
    var cTableAtom = new Atom("select");
    cTableAtom.addOption(RESOURCE[RPL_OWNER_FLAG[0]], RPL_OWNER_FLAG_VALUE[0]);
    cTableAtom.addOption(RESOURCE[RPL_OWNER_FLAG[1]], RPL_OWNER_FLAG_VALUE[1]);
    var cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = RPLFlag_onChange;
    
    table.addAttrRow("isRPLOwnerFlag", RESOURCE["isRPLOwnerFlag"], cTableAtom); 
}

function RPLFlag_onChange()
{
    $("okbtn").disabled = false;
    $("applybtn").disabled = false;
    if (RPL_OWNER_FLAG_VALUE[1] == this.value)
    {
        initRPLPort();
        erpsTable.getAtom("rplPortId").element.disabled = false;
        
        if(isSupportLoopDetect())
        {
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.options.length = 0;
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.disabled = false;
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption(RESOURCE["loopdetect_0"], 0);
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption(RESOURCE["loopdetect_1"], 1);
	        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.value = 1;
        }
        
    }
    else
    {
        erpsTable.getAtom("rplPortId").element.options.length = 0;
        erpsTable.getAtom("rplPortId").element.disabled = true;
        
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.options.length = 0;
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").element.disabled = true;
        erpsTable.getAtom("W32NE_ATTR_ERPS_LOOPDETECT").addOption("-", "-");
    }
}


/**
 * 2013/06/09 17:13 chuhongtao 00168335               
 * RTN910	5.76.03.47
 * RTN950	5.76.03.47
 * RTN980	5.83.03.47
 * @return
 */
function isSupportLoopDetect()
{
	var isSupportLoop = SpecialAttrMgr.isNESupport(winurlobj["neid"], "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_LOOPDETECT");	
	 return isSupportLoop;
		   
}

/**
 *   ERPS       
 **/
function addLoopDetectAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtom.addOption("-", "-");
    cTableAtomEle.disabled = true;
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    table.addAttrRow("W32NE_ATTR_ERPS_LOOPDETECT", RESOURCE["W32NE_ATTR_ERPS_LOOPDETECT"], cTableAtom); 
}

/**
 *   RPL      
 **/
function addRPLPortAttr(table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.disabled = true;
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    table.addAttrRow("rplPortId", RESOURCE["rplPortId"], cTableAtom); 
}

/**
 *     VLAN   
 **/
function addCtrlVlanAttr(table)
{
    var cTableAtom = new Atom("text");
    var cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    table.addAttrRow("ctrlVlan", RESOURCE["ctrlVlan"], cTableAtom); 
}

/**
 *          
 **/
function addDesMacAttr(table)
{
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.value = DES_MAC_ADDR_DEFALT_VALUE; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    cTableAtomEle.disabled = true;
    table.addAttrRow("desMacAddr", RESOURCE["desMacAddr"], cTableAtom); 
}


/**
 *      
 */
function initButton()
{
		$("okbtn").value =  RESOURCE["okbutton"];
		$("applybtn").value = RESOURCE["applybutton"];
		$("cancelbtn").value = RESOURCE["cancelbutton"];
		
		$("cancelbtn").onclick = doCancel;
}

/**
 *        
 */
function initPort()
{
    getPortList();
}

/**
 *   ERPS
 */
function createERPS(okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {
        var eastPortId = erpsTable.getAttrValue("eastPortId");
        var westPortId = erpsTable.getAttrValue("westPortId");
        var result = validateOnSubmit(erpsTable.getAtom("erpsid").element, ERPS_ID_MIN, ERPS_ID_MAX);
        if (!result)
        {
        	  alert(RESOURCE["inputerror"]);
            return;
        }
        
        if (null == eastPortId || null == westPortId)
        {
            return;
        }
        
        result = validateOnSubmit(erpsTable.getAtom("ctrlVlan").element, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
        if (!result)
        {
            return;
        }
        
        setBtnDisabled(true);
        
        var xml = createERPSXML();

        var sfid = TECMDCODE_NE_ERPS_CRT_ENTITY;
        
        var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
       	loadXMLdoc(URL, "POST", false, createERPSBack, okFlag, "inputdata=" + xml);
    }
}

/**
 *     ERPS XML  
 */
function createERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var erpsid = erpsTable.getAttrValue("erpsid");
    
    var eastPort = erpsTable.getAttrValue("eastPortId");
    var westPort = erpsTable.getAttrValue("westPortId");
    
    var isRPLOwnerFlag = erpsTable.getAttrValue("isRPLOwnerFlag");
    var rplPort = null;
    
    if (RPL_OWNER_FLAG_VALUE[1] == isRPLOwnerFlag)
    {
        rplPort = erpsTable.getAttrValue("rplPortId");
    }
    else
    {
        rplPort = RPL_PORT_ID_UNVALID;
    }
    
    if(rplPort == "-")
    {
    	rplPort = "65535-65535";
    }
    
    var ctrlVlan = erpsTable.getAttrValue("ctrlVlan");
    var desMacAddr = erpsTable.getAttrValue("desMacAddr");
    desMacAddr = neMacAddr(desMacAddr);
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastslotid");
    param.setAttribute("value", getSlotid(eastPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastPortId");
    param.setAttribute("value", getPortid(eastPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westslotid");
    param.setAttribute("value", getSlotid(westPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westPortId");
    param.setAttribute("value", getPortid(westPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "rplslotid");
    param.setAttribute("value", isRPLOwnerFlag == 0 ? "65535" : getSlotid(rplPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "rplPortId");
    param.setAttribute("value", isRPLOwnerFlag == 0 ? "65535" : getPortid(rplPort));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "isRPLOwnerFlag");
    param.setAttribute("value", isRPLOwnerFlag);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ctrlVlan");
    param.setAttribute("value", ctrlVlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddr");
    param.setAttribute("value", desMacAddr);
    row.appendChild(param);
    
    if(erpsTable.getAttrValue("W32NE_ATTR_ERPS_LOOPDETECT") != '-')
    {
	    param = new tagElement("param");
	    param.setAttribute("name", "W32NE_ATTR_ERPS_LOOPDETECT");
	    param.setAttribute("value", erpsTable.getAttrValue("W32NE_ATTR_ERPS_LOOPDETECT"));
	    row.appendChild(param);
    }
    
    
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS
 */

function createERPSBack(doc, okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
    	getParentWindow().queryERPS();
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        $("applybtn").disabled = true;
        if (okFlag)
        {
            xcloseDialog();
            return;
        }
    }
}

/**
 *         
 * @param data:      
 * @return  
 */
function fillTableData(data)
{
	 win.queryERPS();
}


/**
 *       
 */
function getPortList(portFlag)
{
    setBtnDisabled(true);
    
    var xml = getPortListXML();
    
    var sfid = TECMDCODE_NE_ERPS_GET_PORT_LIST;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, getPortListBack, portFlag, "inputdata=" + xml);
}

/**
 *        XML
 */
function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *           
 */
function getPortListBack(doc, portFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var portinfo = null;
    var portvalue = null;
    var portAtom = null;

    if (OPERATE_SUCCESS == smallErrorCode)
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portinfo = data.getDataRowParam(i, "port", "port");
            portvalue = data.getDataRowParam(i, "portvalue", "portvalue");
            
            if (null != arguments[1])
            {
                portAtom = erpsTable.getAtom(portFlag);
                portAtom.addOption(portinfo, portvalue);
            }
            else
            {
                portAtom = erpsTable.getAtom("eastPortId");
                portAtom.addOption(portinfo, portvalue);
                
                portAtom = erpsTable.getAtom("westPortId");
                portAtom.addOption(portinfo, portvalue);
            }
        }
    }
    
    setBtnDisabled(false);
}

/**
 *    RPL    
 */
function initRPLPort()
{
    if (RPL_OWNER_FLAG_VALUE[0] == erpsTable.getAttrValue("isRPLOwnerFlag"))
    {
        return;
    }
    var selectAtom = erpsTable.getAtom("rplPortId");
    var eastPortId = erpsTable.getAttrValue("eastPortId");
    var westPortId = erpsTable.getAttrValue("westPortId");
    
    var eastPortIdAtom = erpsTable.getAtom("eastPortId").element;
    var westPortIdAtom = erpsTable.getAtom("westPortId").element;
    
    selectAtom.element.options.length = 0;
    if (null != eastPortId)
    {
    	var eastOption = eastPortIdAtom.options[eastPortIdAtom.selectedIndex];
        selectAtom.addOption(eastOption.text, eastOption.value);
    }
    if ((null != westPortId) && (westPortId != eastPortId))
    {
    	var westOption = westPortIdAtom.options[westPortIdAtom.selectedIndex];
        selectAtom.addOption(westOption.text, westOption.value);
    }
}

/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 */
function setBtnDisabled(flag)
{
    $("okbtn").disabled = flag;
    $("applybtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

function getSlotid(portinfo)
{
		var portary = portinfo.split("-");
		return portary[0];
}

function getPortid(portinfo)
{
		var portary = portinfo.split("-");
		return portary[1];
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}
