/**
 *  ERPS       js  :      convert  
 *   :     00104334
 *   : 2009-01-14
 */
 
var OPERATE_SUCCESS = 0;

var OPERATE_PART_SUCCESS = 1;

var OPERATE_FAIL = 2;

var ERPS_ID_MIN = "1";//   
var ERPS_ID_MAX = "8";//   

var CTRL_VLAN_MIN = "1";//   
var CTRL_VLAN_MAX = "4094";//   

var HOLDOFF_TIME_MIN = "0";//   
var HOLDOFF_TIME_MAX = "10000";//   
var HOLDOFF_TIME_STEP_LEN = 100;//  

var WTRTIME_MIN = "5";//   
var WTRTIME_MAX = "12";//   

var GUARD_TIME_MIN = "10";//   
var GUARD_TIME_MAX = "10000";//   
var GUARD_TIME_STEP_LEN = "10";//  

var SEND_INTERVAL_MIN = "1";
var SEND_INTERVAL_MAX = "10";

var LAST_REQ_ERPS = [];
LAST_REQ_ERPS[1] = RESOURCE["Raps_NR"];
LAST_REQ_ERPS[2] = RESOURCE["Raps_NR_RB"];
LAST_REQ_ERPS[3] = RESOURCE["WTR_Running"];
LAST_REQ_ERPS[4] = RESOURCE["WTR_Expires"];
LAST_REQ_ERPS[5] = RESOURCE["Rasp_SF"];
LAST_REQ_ERPS[6] = RESOURCE["Local_SF"];
LAST_REQ_ERPS[7] = RESOURCE["Local_Clear_SF"];
LAST_REQ_ERPS[8] = RESOURCE["Initial_Request"];
LAST_REQ_ERPS[9] = RESOURCE["Clear"];
LAST_REQ_ERPS[10] = RESOURCE["FS"];
LAST_REQ_ERPS[11] = RESOURCE["Raps_FS"];
LAST_REQ_ERPS[12] = RESOURCE["Raps_MS"];
LAST_REQ_ERPS[13] = RESOURCE["MS"];
LAST_REQ_ERPS[14] = RESOURCE["WTB_Running"];
LAST_REQ_ERPS[15] = RESOURCE["WTB_Expires"];

var ERPS_RB = [];
ERPS_RB[0] = RESOURCE["noRB"];
ERPS_RB[1] = RESOURCE["RB"];

var ERPS_FSM_STATE = [];
ERPS_FSM_STATE[0] = RESOURCE["Idle"];//   
ERPS_FSM_STATE[1] = RESOURCE["Protection"];//   
ERPS_FSM_STATE[3] = RESOURCE["ManualSwitch"];//    
ERPS_FSM_STATE[2] = RESOURCE["ForceSwitch"];//    
ERPS_FSM_STATE[4] = RESOURCE["Pending"];//  

var RPL_OWNER_FLAG = [];
RPL_OWNER_FLAG[0] = "IsNotRPLOwner";//RESOURCE["IsNotRPLOwner"];// 
RPL_OWNER_FLAG[1] = "IsRPLOwner";//RESOURCE["IsRPLOwner"];// 

var RPL_OWNER_FLAG_VALUE = [];
RPL_OWNER_FLAG_VALUE[0] = 0;
RPL_OWNER_FLAG_VALUE[1] = 1;

var ResumeMode = [];
ResumeMode[0] = "ResumeMode_0";
ResumeMode[1] = "ResumeMode_1";

var CompatibleVersion = [];
CompatibleVersion[0] = RESOURCE["ver_1"];
CompatibleVersion[1] = RESOURCE["ver_2"];


var convertLoopDetect = [];
convertLoopDetect[0] = "loopdetect_0";
convertLoopDetect[1] = "loopdetect_1";

var VER_VALUE = [];
VER_VALUE[0] = "1";
VER_VALUE[1] = "2";

var RPL_PORT_ID_UNVALID = 65535;

var PORT_ID_UNVALID = 65535;

var VCTRUNK_FLAG = 32768;

var ERPS_DNF = [];
ERPS_DNF[0] = RESOURCE["noDNF"];
ERPS_DNF[1] = RESOURCE["DNF"];

var DES_MAC_ADDR_DEFALT_VALUE = "01-19-A7-00-00-01";

var ENTITY_MAX_COUNT = 8;

/**
 *     ,           1 
 */
function textCheckWithStepLen(obj,min,max,stepLen)
{
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	}
	
	obj.onblur = function()
	{
		numCellOnBlurWithStepLen(obj, min, max,stepLen);   
    }
    
    obj.onkeypress = function()
    {
		var evt= EventUtil.getEvent();
        return digitalCheckWithStepLen(obj, min, max,stepLen, null, evt);    	
    }
}

/**
 *             ,    
 */
function numCellOnBlurWithStepLen(obj,min,max,stepLen)
{
	blurValidateWithStepLen(obj,min,max,stepLen);
}

/**********************************
 *       convertMsg   
 *                                   
***********************************/
function convertMsg(resobj,	cvtobj,	cvtvalue)
{
	if("function" == typeof cvtobj)
	{
	    return cvtobj(cvtvalue);
	}
	
	if(cvtvalue == "-")
	{
      return cvtvalue;
	}
	return resobj[cvtobj[cvtvalue]];
}

/**********************************
 *Mac   convert              
***********************************/
function convertMacAddr(macAddrStr)
{
	var showMACStr = "";
    for(var i = 0, len = 12; i < len;)
    {
        if(showMACStr != "")
        {
            showMACStr += "-";
        }
        showMACStr += macAddrStr.substring(i, i + 2);
        i += 2; 
    }
    return showMACStr;
}

/**********************************
 * Mac                        
***********************************/
function neMacAddr(macAddrStr)
{
	var macStr = "";
    for(var i = 0, len = 17; i < len; i += 3)
    {
        macStr += macAddrStr.substring(i, i + 2);
    }
    return macStr;
}

/*************************************
 *          
 ************************************/
function convertVersion(verid)
{
	var verStr = "";
	switch(verid)
	{
	case VER_VALUE[0]:
		verStr = CompatibleVersion[0];
		break;
	case VER_VALUE[1]:
		verStr = CompatibleVersion[1];
		break;
	default:
		verStr = CompatibleVersion[0];	
	}
	return verStr;
}

/**
 *     ID       
 */
function convertPort(portid)
{
    if (null == portid)
    {
        return;
    }
    var portName = null;
    if (portid > VCTRUNK_FLAG)
    {
        if (portid == PORT_ID_UNVALID)
        {
            portName = "-";
        }
        else
        {
            portName = "VCTRUNK" + (portid - VCTRUNK_FLAG);
        }
    }
    else
    {
       portName = "PORT" + portid;
    }
    return portName;
}

/**
 *            
 *    validate.js    
 */
function validateOnSubmit(obj,min,max,decimalCount)
{
    var containInegalChar = false;
    var pattern = /^[-.0-9]{1,15}$/;
    if(!pattern.test(obj.value))   
    {   
    	containInegalChar = true;
    }    
    
    if(containInegalChar||obj.value == ""||obj.value == "-")
    {
    	obj.value = min;
    	alertDialog(min,max);
    	return false;
    }
	
	if(decimalCount == null)
	{
	    decimalCount = 1;
	}
	
	if((min.indexOf(".") != -1||max.indexOf(".")!= -1)&&obj.value.indexOf(".") == -1)
	{
	    var zeroStr = ".";
	    for(var i = 0; i < decimalCount; i++)
	    {
	         zeroStr += "0";
	    }
	    obj.value = obj.value + zeroStr;	
	}
	
	var dotPos = obj.value.indexOf(".");
	var valueSubstr = "";
	if(dotPos != -1)
	{
	    valueSubstr = obj.value.substring(dotPos + 1);
	    if(valueSubstr.length >= decimalCount)
	    {
	        obj.value = obj.value.substring(0, dotPos + decimalCount + 1)
	    }
  }
		
	if(obj.value.charAt(obj.value.length-1) == ".")
	{
		  var zeroStr = "";
		  for(var i = 0; i < decimalCount; i++)
	    {
	         zeroStr += "0";
	    }
	    obj.value = obj.value + zeroStr;
	}
	
	valueSubstr = obj.value.substring(dotPos + 1);
	if(valueSubstr.length < decimalCount)
	{
	    var diffCount = parseInt(decimalCount) - valueSubstr.length;
	    var zeroStr = "";
	    for(var i = 0; i < diffCount; i++)
	    {
	        zeroStr += "0";
	    }
	    obj.value = obj.value + zeroStr;
	}
	
	var objValue;
	var minValue;
	var maxValue;
	if(min.indexOf(".") != -1||max.indexOf(".") != -1)
	{
		objValue = parseFloat(obj.value);
		minValue = parseFloat(min);
		maxValue = parseFloat(max);
	}
	else
	{
		objValue = parseInt(obj.value);
		minValue = parseInt(min);
		maxValue = parseInt(max);
	}
	
	if(objValue < minValue)
	{
		obj.value = min;
		alertDialog(min,max);
		return false;
	}
	else if(objValue > maxValue)
	{
		obj.value = max;
		alertDialog(min,max);
		return false;
	}
	else
	{
	    return true;
	}
}
