var win = getParentWindow();
var winobj = getNeProperty(self);

var resourceList = new Array(); //              
var addPortList = null; //                  
var delPortList = null; //                  
var undelPortList = null; //                   
var isApplyBtn = false;

var isIFPorts = new Object(); //                   true      false 

var NE_SHAREHASH = -1;//  SHAREHASH  

var VALUE_INVALID = -1;

if (winobj.action == 0) 
{
    document.title = RESOURCE["createlag"];
}
else 
{
    document.title = RESOURCE["modifylag"];
}

function initPage()
{	
    initText();
    
    $("leftButton").disabled = true;
    $("rightButton").disabled = true;
    
    initData();
    
    if (winobj.action == 0) 
    {
        initCreate();
    }
    else 
    {
        initModify();
    }
}

function initText()
{
    $("attrsetting").innerHTML = RESOURCE["attrsetting"];
    $("lagnolabel").innerHTML = RESOURCE["lagno"];
    $("autoflaglabel").innerHTML = RESOURCE["autoassign"];
    $("lagnamelabel").innerHTML = RESOURCE["lagname"];
    $("lagtypelabel").innerHTML = RESOURCE["lagtype"];
    $("revmodelabel").innerHTML = RESOURCE["revmode"];
    $("loadsharinglabel").innerHTML = RESOURCE["loadsharing"];
    $("sharinghashlabel").innerHTML = RESOURCE["sharinghash"];
    $("sysprioritylabel").innerHTML = RESOURCE["systempriority"];
    $("wtrtimelabel").innerHTML = RESOURCE["wtrtime"];
    $("lagsdconditionlabel").innerHTML = RESOURCE["lagsdconditionlabel"];
	
    $("portsetting").innerHTML = RESOURCE["portsetting"];
    $("mainboardlabel").innerHTML = RESOURCE["mainboard"];
    $("mainportlabel").innerHTML = RESOURCE["mainport"];
    $("availableportlabel").innerHTML = RESOURCE["availableport"];
    $("slaveboardlabel").innerHTML = RESOURCE["slaveboard"];
    $("slaveportlabel").innerHTML = RESOURCE["slaveport"];
    $("selectedportlabel").innerHTML = RESOURCE["selectedport"];
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initData()
{
	var defauleLagNo = getDefaultLagNo();
    checkText($("lagno"), "1", defauleLagNo);
    checkText($("syspriority"), "0", "65535");
    checkText($("wtrtime"), "0", "30");
    checkTextData($("lagname"), 63);
	
    getAllResource();
	
    $("loadsharing").onchange = function()
    {
        changeLoadSharing(this.value);
        changerevMode(this.value);
		changeWTRTime(this.value);
		
		$("applybtn").disabled = false;
    };
    
    $("lagtype").options[$("lagtype").options.length] = new Option(RESOURCE["manual"], 0);
    $("lagtype").options[$("lagtype").options.length] = new Option(RESOURCE["static"], 1);
    
    $("revmode").options[$("revmode").options.length] = new Option(RESOURCE["nonrevmode"], 0);
    $("revmode").options[$("revmode").options.length] = new Option(RESOURCE["revmode"], 1);
    
    $("loadsharing").options[$("loadsharing").options.length] = new Option(RESOURCE["SharingType"], 0);
    $("loadsharing").options[$("loadsharing").options.length] = new Option(RESOURCE["NoSharingType"], 1);
    
    $("mainboard").onchange = changeMainBoard;
    $("mainport").onchange = changeMainPort;
    $("slaveboard").onchange = changeSlaveBoard;
    
	$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["disabled"], 0);
    $("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["enabled"], 1);
	
	$("revmode").onchange = function()
    {
        changeWTRTime(this.value);
        $("applybtn").disabled = false;
    };
    
    var attrArray = new Array(
    		"lagno",
			"lagname",
			"lagtype",
			"sharinghash",
			"syspriority",
			"wtrtime",
			"lagsdcondition"
		);

    for( var i = 0; i < attrArray.length; i++ )
    {
    	$(attrArray[i]).onchange = function()
    	{
    		$("applybtn").disabled = false;
    	}
    }
}

function changeWTRTime(type)
{		
	if(1==type)
	{
		$("wtrtime").disabled = false;
		$("wtrtime").value = 10;
	}
	else
	{
		$("wtrtime").disabled = true;
		$("wtrtime").value = RESOURCE["none"];
	}		
}

function changerevMode(type)
{
	$("revmode").options.length=0;
	
	
	if(1==type)
	{
	    option = document.createElement("option");
	    option.appendChild(document.createTextNode(RESOURCE["nonrevmode"]));
	    option.value = 0;
	    $("revmode").appendChild(option);
	    option = document.createElement("option");
	    option.appendChild(document.createTextNode(RESOURCE["revmode"]));
	    option.value = 1;
	    $("revmode").appendChild(option);
		$("revmode").disabled = false;
		$("revmode").options[1].setAttribute("selected","true");
	}
	else
	{
		$("revmode").options[$("revmode").options.length] = new Option(RESOURCE["none"], -1);
		$("revmode").disabled = true;
	}
}

function getAllResource()
{
    var resData = win.resource;
	NE_SHAREHASH = resData.getDataRowParam(0, "sharinghash")
    for (var i = 1, m = resData.getDataRowLength(); i < m; i++) 
    {
        var slotID = resData.getDataRowParam(i, "slotid");
        var boardName = resData.getDataRowParam(i, "boardname");
        var ports = new Array();
        var unusednum = 0;
        var portsType = resData.getDataRowOptions(i,"portType");
        var port = null;
        var portType = false;
        var unUsedPorts = resData.getDataRowOptions(i, "unusedport");

        if (null != unUsedPorts && null != portsType) 
        {
            unusednum = unUsedPorts.length;
            for (var j = 0, n = unUsedPorts.length; j < n; j++) 
            {
                port = new Port(unUsedPorts[j], false, false);
                portType = portsType[j];
                getPortsInfo(port,slotID,ports,portType);
            }
        }
        
        var usedPorts = resData.getDataRowOptions(i, "usedport");
        if (null != usedPorts && null != portsType) 
        {
            for (var k = 0, mn = usedPorts.length; k < mn; k++) 
            {
                port = new Port(usedPorts[k], true, false);
                portType = portsType[k];
                getPortsInfo(port,slotID,ports,portType);
            }
        }
        
        var servicedPorts = resData.getDataRowOptions(i, "servicedport");
        if (null != servicedPorts && null != portsType) 
        {
            unusednum = servicedPorts.length;
            for (var s = 0, t = servicedPorts.length; s < t; s++) 
            {
                port = new Port(servicedPorts[s], false, true);
                portType = portsType[s];
                getPortsInfo(port,slotID,ports,portType);
            }
        }
        
        var usedAndServicePorts = resData.getDataRowOptions(i, "usedandservicedport");
        if (null != usedAndServicePorts && null != portsType) 
        {
            for (var x = 0, y = usedAndServicePorts.length; x < y; x++) 
            {
                port = new Port(usedAndServicePorts[x], true, true);
                portType = portsType[x];
                getPortsInfo(port,slotID,ports,portType);
            }
        }
        
        addResource(slotID, boardName, ports, unusednum);
    }
}

function addResource(slotID, boardName, ports, unusednum)
{
    var isExist = false;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        if (slotID == resourceList[i].slotid) 
        {
            isExist = true;
            resourceList[i].ports = resourceList[i].ports.concat(ports);
            resourceList[i].ports.sort(sortFunction);
            if (unusednum != 0) 
            {
                resourceList[i].unusednum += unusednum;
            }
            break;
        }
    }
    if (!isExist) 
    {
        ports.sort(sortFunction);
        resourceList[resourceList.length] = new Resource(slotID, boardName, ports, unusednum);
    }
}

/**
 *     
 */
function initCreate()
{	
    $("lagtype").options.selectedIndex = 1;
    
		$("lagsdcondition").options.length = 0;
		$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["none"],VALUE_INVALID);
		$("lagsdcondition").disabled = true;
	       
        
    $("revmode").options.selectedIndex = 1;
    $("wtrtime").disabled = false;
	$("wtrtime").value = 10;
    $("loadsharing").options.selectedIndex = 1;
	
    changeLoadSharing($("loadsharing").options[$("loadsharing").options.selectedIndex].value);
    $("syspriority").value = 32768;
    
    
    var res = null;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        res = resourceList[i];
        if (res.unusednum > 0) 
        {
            $("mainboard").options[$("mainboard").options.length] = new Option(res.slotid + "-" + res.boardname, res.slotid);
            $("slaveboard").options[$("slaveboard").options.length] = new Option(res.slotid + "-" + res.boardname, res.slotid);
        }
    }
    changeMainBoard();
}

function initModify()
{

    var index = win.stup.getSelectedRows()[0];
    var lagNo = win.stup.getCellStoreValue(index, "lagno", "lagno");
	var lagsd = win.stup.getCellStoreValue(index, "lagsdcondition", "lagsdcondition");
    $("lagno").value = lagNo;
    $("autoflag").disabled = true;
	if(VALUE_INVALID == lagsd)
	{
		$("lagsdcondition").options.length = 0;
		$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["none"],VALUE_INVALID);
		$("lagsdcondition").disabled = true;
	}else
	{
		$("lagsdcondition").options.selectedIndex = lagsd;
	}
	
    var lagName = win.stup.getCellStoreValue(index, "lagname", "lagname");
    if (!lagName) 
    {
        lagName = "";
    }
    $("lagname").value = lagName;
    
    var lagType = win.stup.getCellStoreValue(index, "lagtype", "lagtype");
    $("lagtype").options.selectedIndex = lagType;

    var revMode = win.stup.getCellStoreValue(index, "revmode", "revmode");
    $("revmode").options.selectedIndex = revMode;

    var loadSharing = win.stup.getCellStoreValue(index, "loadsharing", "loadsharing");
    $("loadsharing").options.selectedIndex = loadSharing;
    changeLoadSharing(loadSharing);
    
	if(loadSharing == 0)
	{
		$("revmode").options.length = 0;		
		$("revmode").options[$("revmode").options.length] = new Option(RESOURCE["none"], -1);
		$("revmode").disabled = true;
	}
    else
    {    
    	var revMode = win.stup.getCellStoreValue(index, "revmode", "revmode");
    	$("revmode").options.selectedIndex = revMode;
    }
    
    $("syspriority").value = win.stup.getCellStoreValue(index, "syspriority", "syspriority");
    
    var mainSlot = win.stup.getCellStoreValue(index, "mainport", "slotid");
    var mainBdName = win.stup.getCellStoreValue(index, "mainport", "boardname");
    var portName = win.stup.getCellStoreValue(index, "mainport", "portname");
    
    $("mainboard").options[$("mainboard").options.length] = new Option(mainSlot + "-" + mainBdName, mainSlot);
    $("mainboard").disabled = true;
    $("mainport").options[$("mainport").options.length] = new Option(portName, portName.substring(0, portName.indexOf("(")));
    $("mainport").disabled = true;
    
    var slavePort = win.stup.getCellStoreValue(index, "slaveport", "slaveport");
    if (slavePort != null && "" != slavePort) 
    {
        var slavePorts = slavePort.split(",");
        for (var i = 0, m = slavePorts.length; i < m; i++) 
        {
            var tmp = slavePorts[i].split("-");
            $("selectedport").options[$("selectedport").options.length] = new Option(slavePorts[i], tmp[0] + "-" + tmp[2].substring(0, tmp[2].indexOf("(")));
        }
    }
    
    var res = null;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        res = resourceList[i];
        if (res.unusednum > 0) 
        {
            $("slaveboard").options[$("slaveboard").options.length] = new Option(res.slotid + "-" + res.boardname, res.slotid);
        }
    }

    var wtrtime = win.stup.getCellStoreValue(index, "wtrtime", "wtrtime");
    if( wtrtime != null && wtrtime!="-" && wtrtime!= "-1")
    {
    	  $("wtrtime").value = wtrtime;
    }
    else
    {
    	 $("wtrtime").value = RESOURCE["none"];
    	 $("wtrtime").disabled = true;
    }
    
    changeSlaveBoard();
}

function check(e)
{
    if (e.checked) 
    {
        $("lagno").disabled = true;
    }
    else 
    {
        $("lagno").disabled = false;
    }
    
    $("applybtn").disabled = false;
}

function changeLoadSharing(type)
{
    $("sharinghash").options.length = 0;
    $("sharinghash").onchange = null;
    $("sharinghash").disabled = true;
    if (type != 0 || win.isRTNNotSupport()) 
    {
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["none"], -1);
    }
    else if (0 == type) 
    {
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["auto"], 0);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["none"], -1);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["srcmac"], 1);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["snkmac"], 2);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["srcsnkmac"], 3);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["srcip"], 4);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["snkip"], 5);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["srcsnkip"], 6);
        $("sharinghash").options[$("sharinghash").options.length] = new Option(RESOURCE["mpls"], 10);        
        
        var selectedIndex = 0;
		
        $("sharinghash").options.selectedIndex = selectedIndex;
		
        $("sharinghash").onchange = function()
        {
            $("applybtn").disabled = false;
        };
    }
}

var searchSelectedIndex = function(optionObj,value)
{
	if(!optionObj){return 0;}
	var tempOption = optionObj.options;
	var selectedIndex = 0;
	for(var index = 0,len = tempOption.length;index<len;index++)
	{
		if(value == tempOption[index].value)
		{
			selectedIndex = index;
			break;
		}
	}
	return selectedIndex;
}

function changeMainBoard()
{	
    $("mainport").options.length = 0;
    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].value;
    var res = null;
    var port = null;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        res = resourceList[i];
        if (res.slotid == mainBoard) 
        {
            for (var j = 0, n = res.ports.length; j < n; j++) 
            {
                port = res.ports[j];
                if (!port.isused) 
                {
                    $("mainport").options[$("mainport").options.length] = new Option(port.portname, port.portid);
                }
            }
            break;
        }
    }

    $("slaveboard").options.length = 0;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        res = resourceList[i];
        if (res.unusednum > 0) 
        {
            $("slaveboard").options[$("slaveboard").options.length] = new Option(res.slotid + "-" + res.boardname, res.slotid);
        }
    }
    
    filterSlaveBoards();
    
    changeMainPort();
    
    $("applybtn").disabled = false;
}

function changeMainPort()
{
    changeSlaveBoard();

    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].value;
    var mainPort = $("mainport").options[$("mainport").options.selectedIndex].value;
    var mainBoardName = $("mainboard").options[$("mainboard").options.selectedIndex].outerText;
    var index = mainBoardName.split("-");
    var portString = index[0] + "_" + mainPort;
    var mainPortType = isIFPorts[portString];
    var isSelected = false;
    
	$("lagsdcondition").options.length = 0;
	if("true" == mainPortType)
	{
		$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["disabled"], 0);
		$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["enabled"], 1);
		$("lagsdcondition").disabled = false;
	}
	else
	{
		$("lagsdcondition").options[$("lagsdcondition").options.length] = new Option(RESOURCE["none"],VALUE_INVALID);
		$("lagsdcondition").disabled = true;
	}
	
    for (var k = $("selectedport").options.length - 1; k >= 0; k--) 
    {
        if ((mainBoard + "-" + mainPort) == $("selectedport").options[k].value) 
        {
            $("selectedport").options[k] = null;
            break;
        }
    }
    
    $("applybtn").disabled = false;
}

function changeSlaveBoard()
{
    $("availableport").options.length = 0;
    
    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].value;
    var mainPort = $("mainport").options[$("mainport").options.selectedIndex].value;
    var slaveBoard = -1;
    if ($("slaveboard").options.length > 0) 
    {
        slaveBoard = $("slaveboard").options[$("slaveboard").options.selectedIndex].value;
    }
    
    var res = null;
    var port = null;
    var tmp = null;
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        res = resourceList[i];
        if (res.slotid == slaveBoard) 
        {
            for (var j = 0, n = res.ports.length; j < n; j++) 
            {
                port = res.ports[j];
                tmp = res.slotid + "-" + port.portid;
                
                var isSelected = false;
                for (var k = 0, mn = $("selectedport").options.length; k < mn; k++) 
                {
                    if (tmp == $("selectedport").options[k].value) 
                    {
                        isSelected = true;
                        break;
                    }
                }
                
                if (!port.isused && !port.service && tmp != (mainBoard + "-" + mainPort) && !isSelected) 
                {
                    $("availableport").options[$("availableport").options.length] = new Option(res.slotid + "-" + res.boardname + "-" + port.portname, tmp);
                }
            }
            break;
        }
    }
    
    /**if($("availableport").options.length == 0 && $("slaveboard").options.length > 0)
    {
        $("slaveboard").options.remove(0);
        changeSlaveBoard();
    }**/
    
    $("applybtn").disabled = false;
}

/**
 *       
 */
function enableRightbtn()
{
    for (var i = 0, len = $("availableport").options.length; i < len; i++) 
    {
        if ($("availableport").options[i].selected) 
        {
            $("rightButton").disabled = false;
            break;
        }
    }
    
    $("applybtn").disabled = false;
}

/**
 *       
 */
function enableLeftbtn()
{
    for (var i = 0, len = $("selectedport").options.length; i < len; i++) 
    {
        if ($("selectedport").options[i].selected) 
        {
            $("leftButton").disabled = false;
            break;
        }
    }
    
    $("applybtn").disabled = false;
}

/**
 *   
 */
function right()
{
    var availablePort = $("availableport").options;
    var selectedPort = $("selectedport").options;
    for (var i = availablePort.length - 1; i >= 0; i--) 
    {
        if (availablePort[i].selected) 
        {
            refreshOptions(selectedPort, availablePort[i].text, availablePort[i].value);
            availablePort[i] = null;
            if (availablePort.length <= 0) 
            {
                $("slaveboard").options[$("slaveboard").options.selectedIndex] = null;
                $("slaveboard").options.selectedIndex = 0;
                changeSlaveBoard();
            }
        }
    }
    
    $("rightButton").disabled = true;
    if ($("applybtn").disabled) 
    {
        $("applybtn").disabled = false;
        $("okbtn").disabled = false;
    }
}

/**
 *   
 */
function left()
{
    var availablePort = $("availableport").options;
    var selectedPort = $("selectedport").options;
    var slotId = -1;
    if ($("slaveboard").options.length > 0) 
    {
        slotId = $("slaveboard").options[$("slaveboard").options.selectedIndex].value;
    }
    
    for (var i = selectedPort.length - 1; i >= 0; i--) 
    {
        if (selectedPort[i].selected) 
        {
            var v = selectedPort[i].text.split("-");
            var tmpSlotId = v[0];
            if (parseInt(slotId) != parseInt(tmpSlotId)) 
            {
                var isExist = false;
                for (var j = 0, m = $("slaveboard").options.length; j < m; j++) 
                {
                    if ($("slaveboard").options[j].value == tmpSlotId) 
                    {
                        isExist = true;
                        break;
                    }
                }
                if (!isExist) 
                {
                    refreshOptions($("slaveboard").options, tmpSlotId + "-" + v[1], tmpSlotId);
                    slotId = $("slaveboard").options[$("slaveboard").options.selectedIndex].value;
                }
            }
            
            if (parseInt(slotId) == parseInt(tmpSlotId)) 
            {
                refreshOptions(availablePort, selectedPort[i].text, selectedPort[i].value);
            }
            
            selectedPort[i] = null;
        }
    }
    $("leftButton").disabled = true;
    if ($("applybtn").disabled) 
    {
        $("applybtn").disabled = false;
        $("okbtn").disabled = false;
    }
}

function refreshOptions(elem, txt, v)
{
    var index = getInsertIndex(elem, v);
    for (var i = elem.length - 1; i >= index; i--) 
    {
        elem[i + 1] = new Option(elem[i].text, elem[i].value);
    }
    elem[index] = new Option(txt, v);
}

function getInsertIndex(elem, v)
{
    if (elem.length <= 0) 
    {
        return 0;
    }
    
    var va = v.split("-");
    var i = 0;
    var m = elem.length;
    for (; i < m; i++) 
    {
        var value = elem[i].value;
        var tmp = value.split("-");
        if (parseInt(va[0]) < parseInt(tmp[0])) 
        {
            return i;
        }
        else if (parseInt(va[0]) == parseInt(tmp[0])) 
        {
            if (parseInt(va[1]) < parseInt(tmp[1])) 
            {
                return i;
            }
        }
    }
    if (i == m) 
    {
        return i;
    }
}

/**
 *     
 */
function sendInfo(arg)
{
    if (winobj.action == 0) 
    {
        sendCreateLAGInfo(arg);
    }
    else 
    {
        sendModifyLAGInfo(arg);
    }
}

function createCreateLAGXML()
{
    var lagNo = $("lagno").value;
    var lagName = $("lagname").value;
    var lagType = $("lagtype").options[$("lagtype").options.selectedIndex].value;
    var revMode = $("revmode").options[$("revmode").options.selectedIndex].value;
    var loadSharing = $("loadsharing").options[$("loadsharing").options.selectedIndex].value;
    var sharingHash = $("sharinghash").options[$("sharinghash").options.selectedIndex].value;
    var sysPriority = $("syspriority").value;
    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].value;
    var mainPort = $("mainport").options[$("mainport").options.selectedIndex].value;
    var wtrtime = $("wtrtime").value;
    var lagsdcon = $("lagsdcondition").value;
	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", winobj.neid));
    if ($("autoflag").checked) 
    {
        lagNo = 0;
        rowparams.appendChild(createTagElement("autoflag", "1")); // Automatically
        rowparams.appendChild(createTagElement("autoflagex", "2"));
    }
    else 
    {
        rowparams.appendChild(createTagElement("autoflag", "0"));
        rowparams.appendChild(createTagElement("autoflagex", "0"));
    }
    
    rowparams.appendChild(createTagElement("lagno", lagNo));
    rowparams.appendChild(createTagElement("lagname", lagName));
    rowparams.appendChild(createTagElement("lagtype", lagType));

    if(loadSharing != 0)
    {
    	rowparams.appendChild(createTagElement("revmode", revMode));
		
	    if("1" == revMode)
	    {
	    	  rowparams.appendChild(createTagElement("wtrtime", wtrtime));
	    }
    }
    rowparams.appendChild(createTagElement("loadsharing", loadSharing));
    /*
    if (parseInt(loadSharing) == 0 && parseInt(sharingHash) >= 0) 
    {
        rowparams.appendChild(createTagElement("sharinghash", sharingHash));//      LAG       sharinghash  
    }
	*/
    rowparams.appendChild(createTagElement("syspriority", sysPriority));
    rowparams.appendChild(createTagElement("slotid", mainBoard));
    rowparams.appendChild(createTagElement("port", mainPort));
    rowparams.appendChild(createTagElement("slaveportnum", $("selectedport").options.length));
    
    var slavePorts = new Array();
    for (var i = 0, m = $("selectedport").options.length; i < m; i++) 
    {
        slavePorts[slavePorts.length] = $("selectedport").options[i].text;
    }
    rowparams.appendChild(createTagElement("slaveport", linkSlotPort(slavePorts)));
    

	if (VALUE_INVALID != lagsdcon) 
	{
		rowparams.appendChild(createTagElement("lagsdcondition", lagsdcon));
	}
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function sendCreateLAGInfo(arg)
{

	if( $("applybtn").disabled == true )
	{
		xcloseDialog();
		return;
	}
	
	$("okbtn").disabled = true;
	$("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
    var xml = createCreateLAGXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_LAG_CREATE + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, createCallBack, arg, "inputdata=" + xml);
}

/**
 *          
 */
function createCallBack(doc, arg)
{
    var data = EncapsulateData(doc);
    showErrorDialog(0, data);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        var lagNo = data.getDataRowParam(0, "lagno");
        refreshTable(lagNo, data);
        if (arg == 0) // Enter button
        {
            xcloseDialog();
        }
        else 
        {
            var mainSlot = $("mainboard").options[$("mainboard").options.selectedIndex].value;
            var mainPort = $("mainport").options[$("mainport").options.selectedIndex].value;
            setPortUsed(mainSlot, mainPort, true);
            
            for (var i = 0, m = $("selectedport").options.length; i < m; i++) 
            {
                var slave = $(selectedport).options[i].value;
                var slotport = slave.split("-");
                setPortUsed(slotport[0], slotport[1], true);
                
                if (slotport[0] == mainSlot) 
                {
                    for (var j = $("mainport").options.length - 1; j >= 0; j--) 
                    {
                        if ($("mainport").options[j].value == slotport[1]) 
                        {
                            $("mainport").options[j] = null;
                        }
                    }
                }
            }
            $("selectedport").options.length = 0;
            
            if ($("mainport").options.length > 1) 
            {
                $("mainport").options[$("mainport").options.selectedIndex] = null;
                $("mainport").options.selectedIndex = 0;
                changeMainPort();
            }
            else 
            {
                $("mainboard").options[$("mainboard").options.selectedIndex] = null;
                $("mainboard").options.selectedIndex = 0;
                changeMainBoard();
            }
            
            $("applybtn").disabled = true;
        }
    }
    else
    {
    	$("applybtn").disabled = false;
    }
    
	$("okbtn").disabled = false;
	$("cancelbtn").disabled = false;
}

function refreshTable(id, data)
{
    for (var i = win.stup.getDataRowLength() - 1; i >= 0; i--) 
    {
        var lagNo = parseInt(win.stup.getCellStoreValue(i, "lagno", "lagno"));
        if (id == lagNo) 
        {
            win.stup.deleteRow(i);
            win.stup.adjustDataRows();
            break;
        }
    }
    
    var di = document.createElement("datainterface");
    var bussiness = document.createElement("bussiness-params");
    var rowparams = document.createElement("row-params");
    
    rowparams.appendChild(createElement("lagno", id));
    rowparams.appendChild(createElement("lagname", $("lagname").value));
    rowparams.appendChild(createElement("lagtype", $("lagtype").options[$("lagtype").options.selectedIndex].value));
    if($("loadsharing").value == 0)
    {
    	rowparams.appendChild(createElement("revmode", RESOURCE["none"]));
    }
    else
    {
    	rowparams.appendChild(createElement("revmode", $("revmode").options[$("revmode").options.selectedIndex].value));
    }
    rowparams.appendChild(createElement("loadsharing", $("loadsharing").options[$("loadsharing").options.selectedIndex].value));
    rowparams.appendChild(createElement("sharinghash", $("sharinghash").options[$("sharinghash").options.selectedIndex].value));
    rowparams.appendChild(createElement("syspriority", $("syspriority").value));
    rowparams.appendChild(createElement("wtrtime", $("wtrtime").value));
	rowparams.appendChild(createElement("lagsdcondition", $("lagsdcondition").value));
	
    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].text.split("-");
    rowparams.appendChild(createElement("slotid", mainBoard[0]));
    rowparams.appendChild(createElement("boardname", mainBoard[1]));
    rowparams.appendChild(createElement("portname", $("mainport").options[$("mainport").options.selectedIndex].text));
    rowparams.appendChild(createElement("mainportstatus", "255")); //                 
    var selectedPorts = $("selectedport").options;
    if (selectedPorts.length > 0) 
    {
        var port = "";
        for (var i = 0, m = selectedPorts.length; i < m; i++) 
        {
            port += selectedPorts[i].text + ",";
        }
        port = port.substring(0, port.length - 1);
        rowparams.appendChild(createElement("slaveport", port));
        rowparams.appendChild(createElement("slaveportstatus", "255"));
    }
    
    bussiness.appendChild(rowparams);
    di.appendChild(bussiness);
    createTableBody(win.stup, win.window.tableconf[0], EncapsulateData(di), RESOURCE);
    
	var selectedIndexes = win.stup.getSelectedRows();
    for (var j = 0, n = selectedIndexes.length; j < n; j++) 
    {
        win.stup.setRowNoneSelect(selectedIndexes[j]);
    }
    win.stup.setRowSelect(win.stup.getDataRowLength() - 1);
    
    if (!win.stup.element.colsArray.selectedId) 
    {
        win.stup.element.colsArray.selectedId = "lagno";
        win.stup.element.colsArray.imgflag = 1;
    }
    var td = win.stup.element.headRow.element.cols[win.stup.element.colsArray.selectedId].element;
    win.stup.sortRows(td, win.stup.element.colsArray.imgflag);
    
    win.countObj.setTotalCount(win.stup.getDataRowLength());
    win.rowSelectHandler();
}

function createModifyLAGXML()
{
    var isChange = false;
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", winobj.neid));
    rowparams.appendChild(createTagElement("autoflagex", "0"));
    rowparams.appendChild(createTagElement("lagno", $("lagno").value));
    
    var index = win.stup.getSelectedRows()[0];
    if (win.stup.getCellStoreValue(index, "lagname", "lagname") != $("lagname").value
    	&& !(typeof(win.stup.getCellStoreValue(index, "lagname", "lagname")) == "undefined" && $("lagname").value == "")) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("lagname", $("lagname").value));
    }
    
    var lagType = $("lagtype").options[$("lagtype").options.selectedIndex].value;
    if (win.stup.getCellStoreValue(index, "lagtype", "lagtype") != lagType) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("lagtype", lagType));
    }
    
    var loadSharing = $("loadsharing").options[$("loadsharing").options.selectedIndex].value;
    if (win.stup.getCellStoreValue(index, "loadsharing", "loadsharing") != loadSharing) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("loadsharing", loadSharing));
    }
    
    var revMode = $("revmode").options[$("revmode").options.selectedIndex].value;
    if (win.stup.getCellStoreValue(index, "revmode", "revmode") != revMode) 
    {
        isChange = true;        
		if("1" == loadSharing && "-" != loadSharing)
		{
			rowparams.appendChild(createTagElement("revmode", revMode));
		}   
    }
    
    if (win.stup.getCellStoreValue(index, "syspriority", "syspriority") != $("syspriority").value) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("syspriority", $("syspriority").value));
    }

    if (win.stup.getCellStoreValue(index, "wtrtime", "wtrtime") != $("wtrtime").value) 
    {
        isChange = true;
		var wrt = $("wtrtime").value;
		if("1" == revMode && "-" != wrt)
		{
        	rowparams.appendChild(createTagElement("wtrtime", wrt));
		}
    }

	if (win.stup.getCellStoreValue(index, "lagsdcondition", "lagsdcondition") != $("lagsdcondition").value) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("lagsdcondition", $("lagsdcondition").value));
    }
	
    var slavePort = win.stup.getCellStoreValue(index, "slaveport", "slaveport");
    delPortList = new Array();
    if (null != slavePort) 
    {
        delPortList = win.stup.getCellStoreValue(index, "slaveport", "slaveport").split(",");
    }
    
    addPortList = new Array();
    for (var i = 0, m = $("selectedport").options.length; i < m; i++) 
    {
        addPortList[addPortList.length] = $("selectedport").options[i].text;
    }
    
    undelPortList = new Array();
    for (var j = addPortList.length - 1; j >= 0; j--) 
    {
        for (var k = delPortList.length - 1; k >= 0; k--) 
        {
            if (addPortList[j] == delPortList[k]) 
            {
                undelPortList[undelPortList.length] = addPortList[j];
                addPortList.splice(j, 1);
                delPortList.splice(k, 1);
                break;
            }
        }
    }
    
    if (addPortList.length > 0) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("addportnum", addPortList.length));
        rowparams.appendChild(createTagElement("addports", linkSlotPort(addPortList)));
    }
    
    if (delPortList.length > 0) 
    {
        isChange = true;
        rowparams.appendChild(createTagElement("delportnum", delPortList.length));
        rowparams.appendChild(createTagElement("delports", linkSlotPort(delPortList)));
    }
    
    if (!isChange) 
    {
        return null;
    }
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *       
 */
function sendModifyLAGInfo(arg)
{
    var xml = createModifyLAGXML();
    if (null == xml) 
    {
        if (arg == 0 && isApplyBtn) 
        {
            xcloseDialog();
        }
        alert(RESOURCE["nomodify"]);
        return;
    }
    
    if (!confirm(RESOURCE["LAG_CONFIRM"])) 
    {
        return;
    }
    
	$("okbtn").disabled = true;
	$("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
    
    if (arg == 1) 
    {
        isApplyBtn = true;
    }
    
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_LAG_MODIFY + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, modifyCallBack, arg, "inputdata=" + xml);
}

/**
 *          
 */
function modifyCallBack(doc, arg)
{
    var data = EncapsulateData(doc);
    showErrorDialog(1, data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        var changeName = true;
        var changeType = true;
        var changeMode = true;
        var changeSharing = true;
        var changeHash = true;
        var changePriority = true;
        var addPort = true;
        var delPort = true;
        var modifyPort = false;
        var changeWtrtime = true;
        var lagsdcondition = true;
		
        var oError = data.getError();
        for (var i = 0, m = data.getBErrLength(); i < m; i++) 
        {
            if (null != oError.getRowKey(i, "lagname")) 
            {
                changeName = false;
            }
            
            if (null != oError.getRowKey(i, "lagtype")) 
            {
                changeType = false;
            }
            
            if (null != oError.getRowKey(i, "revmode")) 
            {
                changeMode = false;
            }
            
             if (null != oError.getRowKey(i, "changeWtrtime")) 
            {
                changeWtrtime = false;
            }
			
			if (null != oError.getRowKey(i, "lagsdcondition")) 
            {
                lagsdcondition = false;
            }
            
            if (null != oError.getRowKey(i, "loadsharing")) 
            {
                changeSharing = false;
            }
            
            if (null != oError.getRowKey(i, "sharinghash")) 
            {
                changeHash = false;
            }
            
            if (null != oError.getRowKey(i, "syspriority")) 
            {
                changePriority = false;
            }
            
            if (null != oError.getRowKey(i, "addports") && "" != oError.getRowKey(i, "addports")) 
            {
                addPort = false;
            }
            
            if (null != oError.getRowKey(i, "delports") && "" != oError.getRowKey(i, "delports")) 
            {
                delPort = false;
            }
        }
        
        var slavePorts = "";
        if (addPort && addPortList.length > 0) 
        {
            modifyPort = true;
            slavePorts += addPortList.toString() + ",";
            for (var j = 0, n = addPortList.length; j < n; j++) 
            {
                var slotPort = addPortList[j].split("-");
                setPortUsed(slotPort[0], slotPort[2].substring(0, slotPort[2].indexOf("(")), true);
            }
        }
        
        if (delPort && delPortList.length > 0) 
        {
            modifyPort = true;
            for (var k = 0, mn = delPortList.length; k < mn; k++) 
            {
                var slotPort = delPortList[k].split("-");
                setPortUsed(slotPort[0], slotPort[2].substring(0, slotPort[2].indexOf("(")), false);
            }
            
            var selectedSlot = $("slaveboard").value;
            $("slaveboard").options.length = 0;
            
            var res = null;
            for (var i = 0, m = resourceList.length; i < m; i++) 
            {
                res = resourceList[i];
                if (res.unusednum > 0) 
                {
                    $("slaveboard").options[$("slaveboard").options.length] = new Option(res.slotid + "-" + res.boardname, res.slotid);
                    if (res.slotid == selectedSlot) 
                    {
                        $("slaveboard").options.selectedIndex = $("slaveboard").options.length - 1;
                    }
                }
            }
            changeSlaveBoard();
        }
        
        if (!delPort && delPortList.length > 0) 
        {
            slavePorts += delPortList.toString() + ",";
        }
        
        if (undelPortList.length > 0) 
        {
            slavePorts += undelPortList.toString() + ",";
        }
        
        if (slavePorts != "") 
        {
            slavePorts = slavePorts.substring(0, slavePorts.length - 1);
        }
        
        var st = win.stup;
        var index = st.getSelectedRows()[0];
        if (modifyPort) 
        {
            st.setCellValue(st.getCell(index, "mainportstatus"), "mainportstatus", "255");
            st.getCellShow(index, "mainportstatus").element.innerText = RESOURCE["unknown"];
            st.setCellValue(st.getCell(index, "slaveportstatus"), "slaveportstatus", "255");
            st.setCellValue(st.getCell(index, "slaveport"), "slaveport", slavePorts);
        }

        if (changeName) 
        {
            st.setCellValue(st.getCell(index, "lagname"), "lagname", $("lagname").value);
            st.getCellShow(index, "lagname").element.innerText = $("lagname").value;
        }
        
        if (changeWtrtime) 
        {
            st.setCellValue(st.getCell(index, "wtrtime"), "wtrtime", $("wtrtime").value);
            st.getCellShow(index, "wtrtime").element.innerText = $("wtrtime").value;
        }
        
		if (lagsdcondition) 
        {
            st.setCellValue(st.getCell(index, "lagsdcondition"), "lagsdcondition", $("lagsdcondition").options[$("lagsdcondition").options.selectedIndex].value);
            st.getCellShow(index, "lagsdcondition").element.innerText = $("lagsdcondition").options[$("lagsdcondition").options.selectedIndex].text;
        }
		
        if (changeType) 
        {
            st.setCellValue(st.getCell(index, "lagtype"), "lagtype", $("lagtype").options[$("lagtype").options.selectedIndex].value);
            st.getCellShow(index, "lagtype").element.innerText = $("lagtype").options[$("lagtype").options.selectedIndex].text;
        }
        
        if (changeMode) 
        {
        	if($("loadsharing").value == 0)
        	{
        		st.setCellValue(st.getCell(index, "revmode"), "revmode", "-");
        		st.getCellShow(index, "revmode").element.innerText = RESOURCE["none"];
        	}
        	else
        	{
        		st.setCellValue(st.getCell(index, "revmode"), "revmode", $("revmode").options[$("revmode").options.selectedIndex].value);
        		st.getCellShow(index, "revmode").element.innerText = $("revmode").options[$("revmode").options.selectedIndex].text;
        	}
        }
        
        if (changeSharing) 
        {
            st.setCellValue(st.getCell(index, "loadsharing"), "loadsharing", $("loadsharing").options[$("loadsharing").options.selectedIndex].value);
            st.getCellShow(index, "loadsharing").element.innerText = $("loadsharing").options[$("loadsharing").options.selectedIndex].text;
        }
        
        if (changeHash) 
        {
            st.setCellValue(st.getCell(index, "sharinghash"), "sharinghash", $("sharinghash").options[$("sharinghash").options.selectedIndex].value);
            st.getCellShow(index, "sharinghash").element.innerText = $("sharinghash").options[$("sharinghash").options.selectedIndex].text;
        }
        
        if (changePriority) 
        {
            st.setCellValue(st.getCell(index, "syspriority"), "syspriority", $("syspriority").value);
            st.getCellShow(index, "syspriority").element.innerText = $("syspriority").value;
        }
        
        win.refreshDownTable();
        
        $("applybtn").disabled = true;
        
        if (arg == 0 && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
    }
    else
    {
    	$("applybtn").disabled = false;
    }
	$("okbtn").disabled = false;
	$("cancelbtn").disabled = false;
}

function showErrorDialog(action, data)
{
    var errArr = [];
    errArr[0] = "nename";
    if (action != 0) 
    {
        errArr[1] = "lagno";
    }
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function checkTextData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    };
    
    obj.onkeydown = function()
    {
        var letterFlg = forbidSignInput();
        if (!letterFlg) 
        {
            return letterFlg;
        }
        var code = event.keyCode != 0 ? event.keyCode : event.charCode;
        if (!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16)) 
        {
            $("applybtn").disabled = false;
        }
    };
}

function setPortUsed(slotid, portid, isused)
{
    for (var i = 0, m = resourceList.length; i < m; i++) 
    {
        if (resourceList[i].slotid == slotid) 
        {
            for (var j = 0, n = resourceList[i].ports.length; j < n; j++) 
            {
                if (resourceList[i].ports[j].portid == portid) 
                {
                    resourceList[i].ports[j].isused = isused;
                }
            }
            if (isused) 
            {
                resourceList[i].unusednum -= 1;
            }
            else 
            {
                resourceList[i].unusednum += 1;
            }
        }
    }
}

function forbidSignInput()
{
    var key = event.keyCode != 0 ? event.keyCode : event.charCode;
    
    if (event.shiftKey) 
    {
        if (key == 188 || key == 222) 
        {
            return false;
        }
    }
    return true;
}

function sortFunction(param1, param2)
{
    return param1.portid - param2.portid;
}

function Resource(slotid, boardname, ports, unusednum)
{
    this.slotid = slotid;
    this.boardname = boardname;
    this.ports = ports;
    this.unusednum = unusednum;
}

function Port(portname, isused, service)
{
    this.portid = parseInt(portname.substring(0, portname.indexOf("(")));
    this.portname = portname;
    this.isused = isused;
    this.service = service;
}

/**                                                  
 */
function filterSlaveBoards()
{
    var res = null;
    var mainBdPortCount = 0;
    var ports, port;
    var mainBoard = $("mainboard").options[$("mainboard").options.selectedIndex].value;
    for (var i = 0, len = resourceList.length; i < len; i++) 
    {
        res = resourceList[i];
        if(res.slotid == mainBoard)
        {
/*          ports = res.ports;
            
            for(var j = 0, jlen = ports.length; j < jlen; j++)
            {
                port = ports[j];
                if(!port.isused)
                {
                    mainBdCount++;
                }
            }
         
            if(mainBdPortCount > 0)
            {
                break;
            }
 */            
            mainBdPortCount = res.unusednum;
            break;
        }
    }
    if(1 == mainBdPortCount)
    {
        var slaveBds = $("slaveboard").options;
        for (var i = 0; i < slaveBds.length; i++) 
        {
            if(slaveBds[i].value == mainBoard)
            {
                $("slaveboard").remove(i);
                i--;
            }
        }
    }
}

function getDefaultLagNo()
{
	var defauleLagNo = 65535;
	var netype = parseInt(win.winobj.neType);
	switch(netype)
	{
		case NETYPE_RTN_910:
			defauleLagNo=8;
			break;
		case NETYPE_RTN_910_NA:
    		defauleLagNo=8;
    		break;
		case NETYPE_RTN_950:
			defauleLagNo=16;
    		break;
		case NETYPE_RTN_950_NA:
			defauleLagNo=16;
			break;
		case NETYPE_RTN_980:
			defauleLagNo=20;
			break;
		default:
			var maxLagId = SpecialAttrMgr.getNEAttrIntValue(win.winobj.neid,"TE_FUNC_PTN_CFG_LAG","PTNLAG_ATTR_MAX_LAGID");
			if(maxLagId != null)
			{
				defauleLagNo = maxLagId;		
			}
			break;
	}
	return defauleLagNo;
}

function getPortsInfo(port,slotid,ports,portType)
{
    port.isIFPort = portType;
    ports[ports.length] = port;
    var portString = slotid + "_" + port.portid;
    isIFPorts[portString] = portType;	
}
