
var win = getParentWindow();
var winurlobj = getNeProperty(win);
var neid = winurlobj["neid"];
var netype = winurlobj.neType;
var nmUser = winurlobj.nmUser;
var shelfType = winurlobj.shelfType;

var INVALID_0XFF = "255";
var INVALID_0XFFFF = "65535";
var DEFAULT_PATH_MAX = 63;
var CES_SDH = 0;
var CES_PDH = 1;

var highcountArr = new Array();
var portArr = new Array();
var portList = new Array();//      
function PortInfo()
{ 
	var slotid;
	var boardname;
	var portname;
	var portid;
	var istuorlu;
	var highchannelcount;
}


function isSupportAllF()
{
	if(!SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CES_CLK", "TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK"))
	{
		return false;
	}
	var supportShelfList = SpecialAttrMgr.getNEAttrListValue(neid, "TE_FUNC_CES_CLK", "TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK");
	
	if(supportShelfList == null || supportShelfList.length == 0)
	{
		return false;
	}
	for (var i = 0; i < supportShelfList.length; i++)
	{
		if(supportShelfList[i] == shelfType)
		{
			return true;
		}
	}
	return false;
}

var btnRight = null;

var e1clockTable = null;

document.title = RESOURCE["createE1clock"];


var OPERATE_SUCCESS = 0;

var OPERATE_PART_SUCCESS = 1;

var OPERATE_FAIL = 2;

var E1CLOCK_ID_MIN = "1";//   
var E1CLOCK_ID_MAX = "12";//   

/**
 *      
 */
function initPage()
{
    initTable();
    initButton();
    initPort();
}

/**
 *      
 */
function initTable()
{
	e1clockTable = new CTable();
    
	e1clockTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
	var atom = new Atom("select");
    atom.element.style.width = "100%";
	atom.element.id = "e1clkboard";
	if(isSupportAllF())
	{
		atom.addOption("-", INVALID_0XFFFF);
	}else
	{
	    atom.element["onchange"] = function()
        {    
            getPort();
        }
	}
	e1clockTable.addAttrRow("e1clkboard", RESOURCE["e1clkboard"], atom);
    
    atom = new Atom("text");
	checkText(atom.element, 1, 12);
	e1clockTable.addAttrRow("e1clkid", RESOURCE["e1clkid"], atom);
	
	atom = new Atom("select");
	atom.element.style.width = "100%";
	atom.element.onchange = function()
	{
	    changeBoard();
	}
	e1clockTable.addAttrRow("portid", RESOURCE["portid"], atom);
	
	atom = new Atom("select");
	atom.element.style.width = "100%";
	e1clockTable.addAttrRow("hightpathid", RESOURCE["hightpathid"], atom);
	
	atom = new Atom("text");
	atom.element.style.width = "100%";
	e1clockTable.addAttrRow("lowpathid", RESOURCE["lowpathid"], atom);
    
    $("e1clockTableDiv").appendChild(e1clockTable.getTable());
}

/**
 *      
 */
function initButton()
{
		$("okbtn").value =  RESOURCE["okbutton"];
		$("applybtn").value = RESOURCE["applybutton"];
		$("cancelbtn").value = RESOURCE["cancelbutton"];
		
		$("cancelbtn").onclick = doCancel;
}

/**
 *        
 */
function initPort()
{
    getPortList();
}



/**
 *       
 */
function getPortList(portFlag)
{
    setBtnDisabled(true);
    
    var xml = getPortListXML();
    
    var sfid = TE_CMD_E1CLOCK_GET_AVAILABLEPORT;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, getPortListBack, portFlag, "inputdata=" + xml);
}

/**
 *        XML
 */
function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *           
 */
function getPortListBack(doc, portFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var tmpclkArr = new Array();
    var boardAtom = e1clockTable.getAtom("e1clkboard");//     
    var text=null;
    var value=null;
    var tmpArr = new Array();
    var atom = e1clockTable.getAtom("portid");
    atom.clearOptions();
    if (OPERATE_SUCCESS == smallErrorCode)
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
        	 var slotId = data.getDataRowParam(i, "slotid", "slotid");
             var boardName = data.getDataRowParam(i, "boardname", "boardname");
             var portName = data.getDataRowParam(i, "portname", "portname");
             var portId = data.getDataRowParam(i, "portid", "portid");
             var isTUorLU = data.getDataRowParam(i, "istuorlu", "istuorlu");
             var highChannelCount = data.getDataRowParam(i, "highchannelcount", "highchannelcount");
       
             text = slotId + "-" + boardName;
             value = slotId;
             
             if(!isSupportAllF()&&!tmpclkArr.contains(value))
         	{
            	 boardAtom.addOption(text, value);
            	 tmpclkArr[tmpclkArr.length] = value;
        	}                  
             {
                 text += "-" + portName;
                 value += "-" + portId;
             }
             if (!tmpArr.contains(value)) 
             {
                 atom.addOption(text, value);
                 tmpArr[tmpArr.length] = value;
                 highcountArr[highcountArr.length] = highChannelCount;
                 portArr[portArr.length] = value;
                 var port = new PortInfo();
                 port.slotid = slotId;
                 port.boardname = boardName;
                 port.portname = portName;
                 port.portid = portId;
                 port.istuorlu = isTUorLU;
                 port.highchannelcount = highChannelCount;
                 portList[portList.length] = port;
             }


        }
    }
    changeBoard();
    if(!isSupportAllF())
    {
        getPort();
    }
    setBtnDisabled(false);
}

function getHighCount(value)
{
	for(var i =0;i< portArr.length;i++)
	{
		if(portArr[i]==value)
		{
			return highcountArr[i];
		}
	}
	return 0;
}

function getPort()
{   
    var e1clkboard=e1clockTable.getAttrValue("e1clkboard"); //     
    var portatom = e1clockTable.getAtom("portid");//  
    portatom.clearOptions();
    for(var i =0;i< portList.length;i++)
	{  
    	var text = portList[i].slotid + "-" + portList[i].boardname+"-"+portList[i].portname;
        var value = portList[i].slotid;
		if(e1clkboard==value)
		{     
			value+="-"+portList[i].portid;
 			portatom.addOption(text, value);
		}
	}
}



function changeBoard()
{
    var hightatom = e1clockTable.getAtom("hightpathid");
    var lowatom = e1clockTable.getAtom("lowpathid");
    hightatom.clearOptions();
    var value=e1clockTable.getAttrValue("portid"); 
    var highCount = getHighCount(value);
    var slotid = getSlotid(value);
    if(highCount>0)
    {
    	hightatom.element.disabled = false;
        for (var i = 1; i <= highCount; i++) 
        {
        	hightatom.addOption("VC4-" + i, i);
        }
        lowatom.element.disabled = false;
    	lowatom.element.value = "";
    }
    else 
    {
    	hightatom.addOption("-", INVALID_0XFFFF);
    	hightatom.element.disabled = true;
    	lowatom.element.disabled = true;
    	lowatom.element.value = "-";
    }
    var maxlowpath = SpecialAttrMgr.getCPAttrIntValue(neid,slotid,"TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK","ETH_ATTR_MAX_PATH");
	if(maxlowpath == null)
	{
		maxlowpath = DEFAULT_PATH_MAX;		
	}
	checkText(lowatom.element, "1", maxlowpath);
}


/**
 * 
 */
function createE1clock(okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {         		
    	 if(confirm(RESOURCE["confirmCreate"]))
        {
        var xml = createXML();
        if(xml == null)
        {
        	return;
        }

        var sfid = TECMDCODE_CREATE_E1CLOCK;
        
        var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
       	loadXMLdoc(URL, "POST", false, createBack, okFlag, "inputdata=" + xml);
        }
    }
}

/**
 *     ERPS XML  
 */
function createXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var e1clkslot = e1clockTable.getAttrValue("e1clkboard");     
    var e1clockid = e1clockTable.getAttrValue("e1clkid");   
    var port = e1clockTable.getAttrValue("portid");   
    var hightpathid = e1clockTable.getAttrValue("hightpathid");
    var lowpathid = e1clockTable.getAttrValue("lowpathid");
    if(port=="")
    {
    	alert(RESOURCE["nores"]);
	    return null; 	
    }
    if(e1clockid == "")
    {
    	alert(RESOURCE["inputelclkid"]);
    	return null;
    }
    if(lowpathid == "")
    {
    	alert(RESOURCE["inputlowpathid"]);
    	return null;
    }

    
    if(e1clkslot=="-")
    {
    	e1clkslot=INVALID_0XFFFF;
    }
    if(hightpathid=="-")
    {
    	hightpathid=INVALID_0XFFFF;
    }
    if(lowpathid=="-")
    {
    	lowpathid=INVALID_0XFFFF;
    }   
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "e1clkslot");
    param.setAttribute("value", getSlotid(e1clkslot));
    row.appendChild(param);  
    param = new tagElement("param");
    param.setAttribute("name", "e1clkid");
    param.setAttribute("value", e1clockid);
    row.appendChild(param);   
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", getSlotid(port));
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", getPortid(port));
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "hightpathid");
    param.setAttribute("value", hightpathid);
    row.appendChild(param);   
    param = new tagElement("param");
    param.setAttribute("name", "lowpathid");
    param.setAttribute("value", lowpathid);
    row.appendChild(param);   
    
    
    var selectedIndex=e1clockTable.getAtom("e1clkboard").element.options.selectedIndex;
    param = new tagElement("param");
    param.setAttribute("name", "e1clkslotlog");
    param.setAttribute("value",  e1clockTable.getAtom("e1clkboard").element.options[selectedIndex].text);
    row.appendChild(param); 
    
    selectedIndex=e1clockTable.getAtom("portid").element.options.selectedIndex;
    param = new tagElement("param");
    param.setAttribute("name", "portidlog");
    param.setAttribute("value",  e1clockTable.getAtom("portid").element.options[selectedIndex].text);
    row.appendChild(param); 
    
    selectedIndex=e1clockTable.getAtom("hightpathid").element.options.selectedIndex;
    param = new tagElement("param");
    param.setAttribute("name", "hightpathlog");
    param.setAttribute("value",  e1clockTable.getAtom("hightpathid").element.options[selectedIndex].text);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name", "lowpathlog");
    param.setAttribute("value", e1clockTable.getAttrValue("lowpathid"));
    row.appendChild(param); 
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   E1  
 */

function createBack(doc, okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
    	getParentWindow().queryE1clock();
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        if (okFlag)
        {
            xcloseDialog();
            return;
        }
    }
}

/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 */
function setBtnDisabled(flag)
{
    $("okbtn").disabled = flag;
    $("applybtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

function getSlotid(portinfo)
{
		var portary = portinfo.split("-");
		return portary[0];
}

function getPortid(portinfo)
{
		var portary = portinfo.split("-");
		return portary[1];
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}
