function fillSortTable(st, tc, rows, defVal)
{
    for (var i = 0; i < rows; i++) 
    {
        constructRow(st, tc, defVal[i]);
    }
    
    adjustTableLayout(st, tc, rows);
}

function constructRow(st, tc, defaultVal)
{
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            atom.element.onclick = stopEventPropagation;
            atom.element.ondblclick = stopEventPropagation;
            atom.element.onblur = cellonblur;
            
            st.editdom[colid] = atom;
            
            st.addCellEdit(cell, st.editdom[colid]);
            st.addCell(row, colid, cell);
        }
        
        var cellwidth = tc.getColWidth(j);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

function editElementRemove(st, row, colid)
{
    var cell = st.getCell(row, colid);
    st.setCellIsEdit(cell, 0);
    cell.element.modify = false;
    if (!st.getRowSelFlag(row)) 
    {
        cell.element.style.backgroundColor = "#E3E8E6";
    }
    st.setCellValue(cell, colid, "");
    cell.element.showElement.setValue("");
}

function editElementAdd(st, row, colid, type, opts, val)
{
    var cell = st.getCell(row, colid);
    var atom = st.createAtom(type);
    if (type == "select") 
    {
        for (var i = 0; i < opts.length; i++) 
        {
            atom.addOptionObj(opts[i]);
        }
        
        st.setCellValue(cell, colid, opts[val].value);
        cell.element.showElement.setValue(opts[val].text);
    }
    else 
    {
        st.setCellValue(cell, colid, "");
        cell.element.showElement.setValue("");
    }
    
    if (cell.element.childNodes.length > 1) 
    {
        cell.element.removeChild(cell.element.childNodes[1]);
    }
    
    st.setCellIsEdit(cell, 1);
    cell.element.modify = false;
    cell.element.editElement = atom;
    
    atom.element.onclick = stopEventPropagation;
    atom.element.ondblclick = stopEventPropagation;
    atom.element.style.display = "none";
    
    cell.element.appendChild(atom.element);
    cell.element.style.cursor = "pointer";
    cell.element.style.cursor = "hand";
    cell.element.ondblclick = ptnCellondbclick;
    
    atom.element.onblur = ptnCellonblur;
}

function ptnCellondbclick()
{
    mozillaComboboxDiv = 0;
    
    this.style.backgroundColor = "#d0f946";
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none";
    this.editElement.element.style.display = "";
    
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
    
    if (this.editElement.type == "text") 
    {
        this.editElement.setValue(this.showElement.getValue());
        this.editElement.element.focus();
    }
    else if (this.editElement.type == "select") 
    {
        for (i = 0; i < this.editElement.element.options.length; i++) 
        {
            if (this.editElement.element.options[i].text == this.showElement.getValue()) 
            {
                this.editElement.element.options[i].selected = true;
                this.editElement.element.focus();
            }
        }
    }
    else if (this.editElement.type == "combobox") 
    {
        window.curEditCell = this.editElement.element;
        
        var comboObj = this.editElement.element.parent;
        var eleTd = this.editElement.element.parentNode;
        var eleTable = eleTd.offsetParent;
        
        var wdt = eleTd.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";
        
        comboObj.txtview.style.width = wdt;
        comboObj.selview.style.width = wdt;
        comboObj.selview.style.clip = clip;
        
        if (isIE) 
        {
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
        }
        else 
        {
            comboObj.txtview.style.position = "fixed";
            
            var theadHeight = eleTable.offsetParent.offsetParent.firstChild.offsetHeight;
            
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
        }
        
        var showVal = this.showElement.getValue();
        var len = comboObj.selview.options.length;
        
        for (var k = 0; k < len; k++) 
        {
            if (comboObj.selview.options[k].value == showVal ||
            comboObj.selview.options[k].text == showVal) 
            {
                comboObj.setSelectedIndex(k);
                comboObj.txtview.focus();
                break;
            }
        }
        
        comboObj.txtview.focus();
    }
}


/*
 Onblur handler for editElement of cell
 */
function ptnCellonblur()
{
    var hc = this.parentNode.parent.getHeadCell(this.parentNode.colid);
    
    if (this.parentNode.editElement.type == "select") 
    {
        if (this.selectedIndex > -1) 
        {
            if ("span" == this.parentNode.showElement.type) 
            {
                this.parentNode.showElement.setValue(this.options[this.selectedIndex].text);
            }
            else 
            {
                this.parentNode.showElement.setValue(this.options[this.selectedIndex].value);
            }
            
            this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.options[this.selectedIndex].value);
        }
    }
    else if (this.parentNode.editElement.type == "combobox") 
    {
        if (!isIE && mozillaComboboxDiv == 0) 
        {
            mozillaComboboxDiv++;
            return;
        }
        
        window.curEditCell = null;
        if ("span" == this.parentNode.showElement.type) 
        {
            this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.txtview.value);
        }
        else 
        {
            this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.value);
        }
        
        this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.parentNode.editElement.element.parent.value);
    }
    else 
    {
        this.style.position = "static";
        this.style.border = "1px solid #999999";
        this.style.width = this.parentNode.offsetWidth;
        this.parentNode.showElement.element.style.display = "";
        var rows = this.parentNode.parent.getSelectedRows();
        for (var j = 0; j < rows.length; j++) 
        {
            var cell = this.parentNode.parent.getCell(rows[j], this.parentNode.colid);
            if (null == cell.element.editElement || cell.element.isEdit == 0) 
            {
                continue;
            }
            cell.element.showElement.setValue(this.value);
            
            cell.element.modify = true;
            cell.element.parentNode.modify = true;
            cell.element.style.backgroundColor = "#d0f946";
            cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);
            cell.element.showElement.element.style.display = "";
            handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
        }
    }
    
    this.style.display = "none";
    this.parentNode.showElement.element.style.display = "";
    
    handleCellEdit(this.parentNode, TABLE_CONSTANT.AFTEREDIT);
}


function setCellColor(st, row, colid)
{
    var cell = st.getCellElement(row, colid);
    var color = color_desel;
    
    if (st.getRowSelFlag(row)) 
    {
        color = color_select;
    }
    else if (cell.isEdit == 0) 
    {
        color = color_nonedit;
    }
    else if (cell.modify) 
    {
        color = color_edited;
    }
    
    cell.style.backgroundColor = color;
}

function mozillaSort(st, key)
{
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = key;
        st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    st.sortRows(td, st.element.colsArray.imgflag);
}

String.prototype.trim = function()
{
    return this.replace(/(^\s*)|(\s*$)/g, "");
}

