var winurlobj = window.parent;
var neversion = winurlobj.neversion;
var netype = winurlobj.netype;
var tc;
var st;
var MIN_INPUT = "0";
var MAX_INPUT_DEI = "15";
var MAX_INPUT_IP = "63";
var MAX_INPUT = "7";
var LEVEL_AMOUNT = 16;

if (isHybridRtn(neversion))
{
    loadXMLdoc("../../conf/diffserv/rtn900_expcostable.xml", "GET", false, EncapsulateTable);
}
else 
{
    if(isR3Ver(neversion))
    {
        loadXMLdoc("../../conf/diffserv/rtn900r3_expcostable.xml", "GET", false, EncapsulateTable);
    } else {
        loadXMLdoc("../../conf/diffserv/expcostable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
    } 
}

/*
 create route table
 */
function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_expcoscrt");
    st.body.setAttribute("id", "htmlTable_STBody_expcoscrt");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    $("expcostable").appendChild(st.getTable());
    $("expcostable").oncontextmenu = popupMenuHandler;
    st.setBodyHeight("95px");
    
    var dinterface = new DataInterface();
    if (netype == "114" || winurlobj.newDiff_SupportMplsExp)
    {
    	constructData(dinterface, "0", "0", "0,8", "0-7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41-45,47,49-55,57-63", "0", "1");
	    constructData(dinterface, "1", "1", "1", "8,10", "1", "2");
	    constructData(dinterface, "", "", "", "12", "", "3");
	    constructData(dinterface, "", "", "9", "14", "", "4");
	    constructData(dinterface, "2", "2", "2", "16,18", "2", "5");
	    constructData(dinterface, "", "", "", "20", "", "6");
	    constructData(dinterface, "", "", "10", "22", "", "7");
	    constructData(dinterface, "3", "3", "3", "24,26", "3", "8");
	    constructData(dinterface, "", "", "", "28", "", "9");
	    constructData(dinterface, "", "", "11", "30", "", "10");
	    constructData(dinterface, "4", "4", "4", "32,34", "4", "11");
	    constructData(dinterface, "", "", "", "36", "", "12");
	    constructData(dinterface, "", "", "12", "38", "", "13");
	    constructData(dinterface, "5", "5", "5,13", "40,46", "5", "14");
	    constructData(dinterface, "6", "6", "6,14", "48", "6", "15");
	    constructData(dinterface, "7", "7", "7,15", "56", "7", "16");
    }
    else
    {
	    constructData(dinterface, "0", "0", "0,8", "0-7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41-45,47,49-55,57-63", "-", "1");
	    constructData(dinterface, "1", "1", "1", "8,10", "-", "2");
	    constructData(dinterface, "", "", "", "12", "-", "3");
	    constructData(dinterface, "", "", "9", "14", "-", "4");
	    constructData(dinterface, "2", "2", "2", "16,18", "-", "5");
	    constructData(dinterface, "", "", "", "20", "-", "6");
	    constructData(dinterface, "", "", "10", "22", "-", "7");
	    constructData(dinterface, "3", "3", "3", "24,26", "-", "8");
	    constructData(dinterface, "", "", "", "28", "-", "9");
	    constructData(dinterface, "", "", "11", "30", "-", "10");
	    constructData(dinterface, "4", "4", "4", "32,34", "-", "11");
	    constructData(dinterface, "", "", "", "36", "-", "12");
	    constructData(dinterface, "", "", "12", "38", "-", "13");
	    constructData(dinterface, "5", "5", "5,13", "40,46", "-", "14");
	    constructData(dinterface, "6", "6", "6,14", "48", "-", "15");
	    constructData(dinterface, "7", "7", "7,15", "56", "-", "16");
    }
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    
    if(isR3Ver(neversion) && netype != "114" && !winurlobj.newDiff_SupportMplsExp)
    {
        setExpDisable();
    }
    
    addCellEvent();
}

function constructData(dinterface, cvlan, svlan, deisvlan, ipdscp, mplsexp, cos)
{
    var obj = new Object();
    dinterface.rows[dinterface.rows.length] = obj;
    
    var ptag = new ParamTag();
    ptag.value = cvlan;
    obj["cvlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = svlan;
    obj["svlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = deisvlan;
    obj["deisvlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = ipdscp;
    obj["ipdscp"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = mplsexp;
    obj["mplsexp"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = cos;
    obj["cos"] = ptag;
}

function cellEditHandler()
{
    winurlobj.$("applybtn").disabled = false;
}

function fillSortTable(st, tc, rows, defVal)
{
    for (var i = 0; i < rows; i++) 
    {
        constructRow(st, tc, defVal[i]);
    }
}

function constructRow(st, tc, defaultVal)
{
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            st.addCellEdit(cell, atom);
            st.addCell(row, colid, cell);
            
            var dom = st.editdom;
            dom[colid] = atom;
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCellElement(i, "cvlan");
        cell.editElement.element.style.imeMode = "disabled";
        cell.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, MIN_INPUT, MAX_INPUT);
        }
        cell.editElement.element["onblur"] = function()
        {
            return isValidateInput(this);
        }
        cell.editElement.element.onpaste = function()
        {
            return false;
        }
        
        cell = st.getCellElement(i, "svlan");
        cell.editElement.element.style.imeMode = "disabled";
        cell.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, MIN_INPUT, MAX_INPUT);
        }
        cell.editElement.element["onblur"] = function()
        {
            return isValidateInput(this);
        }
        cell.editElement.element.onpaste = function()
        {
            return false;
        }
        
        cell = st.getCellElement(i, "ipdscp");
        cell.editElement.element.style.imeMode = "disabled";
        cell.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, MIN_INPUT, MAX_INPUT_IP);
        }
        cell.editElement.element["onblur"] = function()
        {
            return isValidateInput(this);
        }
        cell.editElement.element.onpaste = function()
        {
            return false;
        }
        
            cell = st.getCellElement(i, "deisvlan");
            cell.editElement.element.style.imeMode = "disabled";
            cell.editElement.element["onkeypress"] = function()
            {
                return checkData(this, event, MIN_INPUT, MAX_INPUT_DEI);
            }
            cell.editElement.element["onblur"] = function()
            {
                return isValidateInput(this);
            }
            cell.editElement.element.onpaste = function()
            {
                return false;
            }
            
            cell = st.getCellElement(i, "mplsexp");
            cell.editElement.element.style.imeMode = "disabled";
            cell.editElement.element["onkeypress"] = function()
            {
                return checkData(this, event, MIN_INPUT, MAX_INPUT);
            }
            cell.editElement.element["onblur"] = function()
            {
                return isValidateInput(this);
            }
            cell.editElement.element.onpaste = function()
            {
                return false;
            }
    }
}

/*
 window onload handler
 */
window.onload = function()
{
    createTable();
}

/**
 * because this is second tab,it would be invisible untill the second tab is selected.
 * it cause the ajustLayout don't work properly.
 * au9d41653
 */
function tabSelectHandler()
{
    adjustTableLayout(st, tc, st.getDataRowLength());
}

function setExpDisable()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.setCellIsEdit(st.getCell(i, "mplsexp"), 0);
    }
}
