var cos = new Object();
cos["1"] = "BE";
cos["2"] = "AF11";
cos["3"] = "AF12";
cos["4"] = "AF13";
cos["5"] = "AF21";
cos["6"] = "AF22";
cos["7"] = "AF23";
cos["8"] = "AF31";
cos["9"] = "AF32";
cos["10"] = "AF33";
cos["11"] = "AF41";
cos["12"] = "AF42";
cos["13"] = "AF43";
cos["14"] = "EF";
cos["15"] = "CS6";
cos["16"] = "CS7";

var INVALID_SLOTID = "65535";
var INVALID_SUBSLOTID = "255";


var ETHERNET_PORT = 17;
function checkData(obj, event, min, max)
{
    if (!restrict(obj, event, "0123456789,-")) 
    {
        return false;
    }
    
    var code = event.keyCode != 0 ? event.keyCode : event.charCode;
    var codeValue = String.fromCharCode(code);
    var index = digitalTag_getPos(obj);
    var lastValue2 = obj.value;
    var thisValue2 = obj.value.substring(0, index) + codeValue + obj.value.substring(index);
    var rep2 = /-/gi;
    var value2 = thisValue2.replace(rep2, ",");
    var values2 = value2.split(",");
    
    var bol2 = chkCVlan(obj, event, min, max);
    if (bol2) 
    {
        lastValue2 = thisValue2;
    }
    return bol2;
}

function chkCVlan(obj, event, min, max)
{
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    var ch = String.fromCharCode(code);
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    if (code == 13) 
    {
        event.srcElement.blur();
        return false;
    }
    if (!restrict(obj, event, "0123456789,-")) 
    {
        return false;
    }
    
    var value = obj.value;
    pos = digitalTag_getPos(obj);
    
    var valueArr = value.substring(0, pos).split(",");
    valueArr = valueArr[valueArr.length - 1].split("-");
    
    if (valueArr[valueArr.length - 1] == '0' && pos > 0 && ch != ',' && ch != '-') 
    {
        return false;
    }
    
    var newVal = value.substring(0, pos) + ch + value.substring(pos + selectionLen(obj));
    
    if (!isCVlan(newVal, min, max)) 
    {
        return false;
    }
    return true;
}

function isCVlan(newVal, min, max)
{
    var text = newVal;
    
    if (!text || "" == text) 
    {
        return true;
    }
    
    var str = text.split(",");
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > max) || (rangeEnd > max) ||
            (rangeStart < min) ||
            (rangeEnd < min)) 
            {
                alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > max || parseInt(str[i]) < min) 
            {
                alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
    }
    return true;
}

function isValidateInput(obj)
{
    var str = obj.value.split(",");
    if ("" != str) 
    {
        var pattern1 = new RegExp("^\\d+$", "i");
        var pattern2 = new RegExp("^\\d+-\\d+$", "i");
        
        for (var i = 0; i < str.length; i++) 
        {
            var b = str[i].indexOf("-") != -1;
            if (b) 
            {
                if (!pattern2.test(str[i])) 
                {
                    alert(RESOURCE["inputFormat"]);
                    break;
                }
            }
            else 
            {
                if (!pattern1.test(str[i])) 
                {
                    alert(RESOURCE["inputFormat"]);
                    break;
                }
            }
        }
        
        for (var i = 0; i < str.length; i++) 
        {
            var b = str[i].indexOf("-") != -1;
            if (b) 
            {
                var range = str[i].split("-");
                var rangeStart = parseInt(range[0]);
                var rangeEnd = parseInt(range[1]);
                
                if (rangeEnd < rangeStart) 
                {
                    alert(RESOURCE["startEnd"]);
                    break;
                }
            }
        }
    }
    
    var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);
    
    var pnode = obj.parentNode;
    
    obj.style.position = "static";
    obj.style.border = "1px solid #999999";
    obj.style.width = obj.parentNode.offsetWidth;
    obj.parentNode.showElement.element.style.display = "";
    var rows = obj.parentNode.parent.getSelectedRows();
    for (var j = 0; j < rows.length; j++) 
    {
        var cell = pnode.parent.getCell(rows[j], pnode.colid);
        
        if (null == cell.element.editElement || cell.element.isEdit == 0) 
        {
            continue;
        }
        
        cell.element.showElement.setValue(obj.value);
        
        cell.element.modify = true;
        cell.element.parentNode.modify = true;
        cell.element.style.backgroundColor = "#d0f946";
        cell.element.parent.setTdCellValue(cell.element, pnode.colid, obj.value);
        cell.element.showElement.element.style.display = "";
        
        handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
    }
    
    pnode.removeChild(pnode.lastChild);
    pnode.showElement.element.style.display = "";
    
    handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}

function restrict(field, event, strallow)
{
    var key, keychar;
    key = (event.keyCode != 0 ? event.keyCode : event.charCode);
    keychar = String.fromCharCode(key);
    
    if ((key == null) || (key == 0) || (key == 8) || (key == 9) || (key == 13) || (key == 27)) 
    {
        return true;
    }
    else if ((strallow.indexOf(keychar) != -1)) 
    {
        return true;
    }
    else 
    {
        return false;
    }
}


function getPorts()
{
    var xmlstr = createGetPortsXML();
    
    var urlreq = "../../../../../neExlorerServlet?sfid=" + TE_QUERY_AVAILABLE_PORT_RESOURCE + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackgetPorts, null, "inputdata=" + xmlstr);
}

function createGetPortsXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "pppFlag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    /**
     * DS  PORTTYPE_PTN_ETH PORTTYPE_PTN_IF          
     * var PORTTYPE_PTN_ETH = 1799; //PTN    :PORT
	 *	var PORTTYPE_PTN_IF = 1802;      //PTN   ----PTN       
     */
    var param = new tagElement("param");
    param.setAttribute("name", "PortType");
    param.setAttribute("value", "1799,1802");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackgetPorts(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        handleInit(data);
        initBoardSelectBox();
    }
}

function handleInit(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
		var boardName = data.getDataRowParam(i , "boardName");
		if (null == boardName || "SHD4" == boardName || "CD1" == boardName || "SHD4I" == boardName)
		{
			continue;
		}
        var usableBd = new TEUsableBoard();
        usableBd.slotid = data.getDataRowParam(i, "slotid");
        usableBd.boardType = data.getDataRowParam(i, "boardType");
        usableBd.boardName = data.getDataRowParam(i, "boardName");
        usableBd.subslotid = data.getDataRowParam(i, "subslotid");
        usableBd.subBoardName = data.getDataRowParam(i, "subBoardName");
        usableBd.portid = data.getDataRowParam(i, "portid");
        usableBd.portidArr = data.getDataRowOptions(i, "portid");
        usableBd.portName = data.getDataRowParam(i, "portName");
        usableBd.portNameArr = data.getDataRowOptions(i, "portName");
        usableBoardArr.push(usableBd);
    }
}

function TEUsableBoard()
{
    this.slotid = null;
    this.boardType = null;
    this.boardName = null;
    this.subslotid = null;
    this.subBoardName = null;
    this.portid = null;
    this.portidArr = null
    this.portName = null;
    this.portNameArr = null;
}

function initBoardSelectBox()
{
    $("boardSelectBox").length = 0;
    for (var i = 0, len = usableBoardArr.length; i < len; i++) 
    {
        var temString = "";
        var slotid = usableBoardArr[i].slotid;
        
        if (INVALID_SLOTID == slotid) 
        {
            temString = usableBoardArr[i].boardName;
        }
        else 
        {
            temString = usableBoardArr[i].slotid + "-" + usableBoardArr[i].boardName;
        }
        
        if (usableBoardArr[i].subBoardid && usableBoardArr[i].subBoardid > 0) 
        {
            temString += ("-" + usableBoardArr[i].subBoardid + "-" + usableBoardArr[i].subBoardName);
        }
        
        $("boardSelectBox").options[$("boardSelectBox").options.length] = new Option(temString, i);
    }
    
    if ($("boardSelectBox").length > 0) 
    {
        boardChanged($("boardSelectBox"));
    }
}

function boardChanged(selectCombox)
{
    var key = selectCombox.value;
    var board = usableBoardArr[key];
    var oOption = document.createElement("OPTION");
	   var rightPort = $("right").options;	      
		  $("left").options.length = 0;
		  var rightPortFlag = false;
	   
	   var thisNeType = "";
	   try {
	    thisNeType = getNeProperty(getParentWindow().parent).netype;
	   }
	   catch(e)
	   {
	   	thisNeType = "";
	   }
	   if ("CXPA" != board.boardName || (thisNeType == "76" || thisNeType == "77") )	//RTN900    CXPA            
		  {	      
    if (INVALID_SLOTID == board.slotid) 
    {
        oOption.text = "";
    }
    else 
    {
        oOption.text = board.slotid + "-" + board.boardName + "-";
    }
    
	       if ("0" != board.subslotid && INVALID_SUBSLOTID != board.subslotid)
    {
        oOption.text += board.subslotid + "-" + board.subBoardName + "-";
    }
    oOption.text += board.portName;
    oOption.value = board.portid;

    for (var i = 0, len = rightPort.length; i < len; i++) 
    {
        if (oOption.text == rightPort[i].text) 
        {
            rightPortFlag = true;
            break;
        }
    }
    if (!rightPortFlag) 
    {
        $("left").options.add(oOption);
    }
		  }
    
    if (null != board.portNameArr) 
    {
        for (var i = 0, len = board.portNameArr.length; i < len; i++) 
        {
		          if ("CXPA" == board.boardName && parseInt(board.portidArr[i]) < ETHERNET_PORT)
		          {
		          	if( thisNeType == "76" && thisNeType == "77" )
		          	{
		          	}
		          	else
		          	{
		          		continue;
		          	}
		          }
            rightPortFlag = false;
            oOption = document.createElement("OPTION");
            if (INVALID_SLOTID == board.slotid) 
            {
                oOption.text = "";
            }
            else 
            {
                oOption.text = board.slotid + "-" + board.boardName + "-";
            }
            
	           if ("0" != board.subslotid && INVALID_SUBSLOTID != board.subslotid)
            {
                oOption.text += board.subslotid + "-" + board.subBoardName + "-";
            }
            oOption.text += board.portNameArr[i];
            oOption.value = board.portidArr[i];

            for (var j = 0, lenRight = rightPort.length; j < lenRight; j++) 
            {
                if (oOption.text == rightPort[j].text) 
                {
                    rightPortFlag = true;
                    break;
                }
            }
            if (!rightPortFlag) 
            {
                $("left").options.add(oOption);
            }
        }
    }
}

function compare(value1, value2)
{
    var v1 = value1.substring(0, value1.indexOf("-"));
    var v2 = value2.substring(0, value2.indexOf("-"));
    if (parseInt(v1) == parseInt(v2)) 
    {
        var v11 = value1.substring(value1.lastIndexOf("-") + 1, value1.indexOf("("));
        var v22 = value2.substring(value2.lastIndexOf("-") + 1, value2.indexOf("("));
        return v11 - v22;
    }
    return v1 - v2;
}

function isLeftSelect()
{
    if(typeof(winurlobj.cosID) != "undefined" && winurlobj.cosID == "1")
    {
    	return;
    }
    var flag = false;
    var slt1 = document.getElementById("left");
    for (var i = 0; i < slt1.options.length; i++) 
    {
        if (slt1.options[i].selected) 
        {
            flag = true;
            document.getElementById("rightmovebtn").disabled = false;
            break;
        }
    }

    if (!flag) 
    {
        document.getElementById("rightmovebtn").disabled = true;
    }
}

function isRightSelect()
{
	  if(typeof(winurlobj.cosID) != "undefined" && winurlobj.cosID == "1")
    {
    	return;
    }
    var flag = false;
    var slt2 = document.getElementById("right");
    for (var i = 0; i < slt2.options.length; i++) 
    {
        if (slt2.options[i].selected) 
        {
            flag = true;
            document.getElementById("leftmovebtn").disabled = false;
            break;
        }
    }

    if (!flag) 
    {
        document.getElementById("leftmovebtn").disabled = true;
    }
}

function isHybridRtn(neversion)
{
	var hybridver = neversion.split(".")[0]+"."+neversion.split(".")[1]+"."+"02.10";
	var ver1 = neversion.split(".")[0]+"."+neversion.split(".")[1]+"."+"03.10";
	
	if (neversion >= hybridver && neversion < ver1)
	{
		return true;
	} 
	else
	{
		return false;
	}
}

function isR3Ver(neversion)
{
	var ver = neversion.split(".")[0]+"."+neversion.split(".")[1]+"."+"03.10";
	
	if (neversion >= ver)
	{
		return true;
	} 
	else
	{
		return false;
	}
}

var inCosType = new Object();
inCosType["cvlan"] = "1";
inCosType["svlan"] = "2";
inCosType["deisvlan"] = "3";
inCosType["ipdscp"] = "4";
inCosType["mplsexp"] = "5";

