var winurlobj = getParentWindow();
var neid = winurlobj.neid;
var neversion = winurlobj.neversion;
var netype = winurlobj.netype;
var OPRSUCC = 0;
var OPRPART = 1;
var MAX_NAMELENGTH = 32;
var MIN_COSID = 2;
var MAX_COSID = 8;
var MIN_INPUT = "0";
var MAX_INPUT_DEI = "15";
var MAX_INPUT_IP = "63";
var MAX_INPUT = "7";
var tc;
var ct;
var tab;
var usableBoardArr = new Array();
var okFlag = false;
var mapRelationIDArr = new Array();
var id;
var INVALID_SLOTID = winurlobj.INVALID_SLOTID;
var portSelectTable;

var packageTypeArray = new Array();
packageTypeArray["CVLAN"]=1;
packageTypeArray["SVLAN"]=2;
packageTypeArray["IP-DSCP"]=4;
packageTypeArray["MPLS-EXP"]=5;
packageTypeArray["1"]=1;
packageTypeArray["2"]=2;
packageTypeArray["3"]=4;
packageTypeArray["4"]=5;

var newDiff_SupportMplsExp = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIBUTE", "QOS_NEW_DIFF_SUPPORT_MPLSEXP");

function createCTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
	
	var atom = new Atom("text");
	atom.element.setAttribute("id", "htmlText_cosIDCrtcos");
	checkText(atom.element, MIN_COSID + "", MAX_COSID + "");
	atom.element.onkeydown = function()
	{
		$("applybtn").disabled = false;
	}
	atom.setValue(getMapRelationID());
	ct.addAttrRow("cosID", RESOURCE["cosID"], atom);
	
	atom = new Atom("text");
	atom.element.setAttribute("id", "htmlText_cosNameCrtcos");
	atom.element.maxLength = MAX_NAMELENGTH;
	checkInputData(atom.element, MAX_NAMELENGTH);
	ct.addAttrRow("cosName", RESOURCE["cosName"], atom);
	
	/*
	atom = new Atom("select");
	atom.element.setAttribute("id", "htmlSelect_cosTypeCrtcos");
	ct.addAttrRow("cosType", RESOURCE["packageType"], atom);
	atom.element.options.add(new Option("CVLAN", "1"));
	atom.element.options.add(new Option("SVLAN", "2"));
	atom.element.options.add(new Option("IP-DSCP", "4"));
	
	if (!isHybridRtn(neversion)) 
	{
		atom.element.options.add(new Option("MPLS-EXP", "5"));
	}*/
	
	document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function getMapRelationID()
{
    if (0 == mapRelationIDArr.length) 
    {
        var st = winurlobj.st;
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            mapRelationIDArr.push(st.getCellStoreValue(i, "cosID", "cosID"));
        }
    }
    
    for (var i = MIN_COSID; i <= MAX_COSID; i++) 
    {
        if (!mapRelationIDArr.contains(i + "")) 
        {
            return i;
        }
    }
    
    alert(RESOURCE["fillService"]);
    xcloseDialog();
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        $("applybtn").disabled = false;
        return calStrSinoLen(this, maxlen);
    }
}

function createTabPanel()
{
    tab = new Tabs();
    tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    tab.addTab("expcostable", RESOURCE["expcostitle"], "expcostablecrt.html");
    tab.addTab("cosexptable", RESOURCE["cosexptitle"], "cosexptablecrt.html");
    $("cosexptable").appendChild(tab.getTabs());
    
    window.setTimeout("selectTabNode()", 200);
}

function selectTabNode()
{
    tab.selectTab("expcostable");
}

/*
 window onload handler
 */
window.onload = function()
{
    getPorts();
    createCTable();
    createTable();
    createTabPanel();
    initButtonText();
	  window.onresize;
}

function createTable()
{
    portSelectTable = new SortTable();
    portSelectTable.setImage("../../../../../images/");
    createTableHead(portSelectTable, window.tableconf[0]);
    portSelectTable.setBodyHeight("105px");
    $("aa").appendChild(portSelectTable.getTable());
    portSelectTable.setSingleChoiceFlg(false);
    portSelectTable.setOnRowSelectHandler(rowSelectHandler);
    
    var tc = window.tableconf[0]; 
	var colslength = tc.getColsLength();
    if (portSelectTable.editdom == null)
	{
		portSelectTable.editdom = new Array();
		for ( var i = 0; i < colslength; i++)
		{
			if (tc.hasEditElement(i))
			{
				var atom = portSelectTable.createAtom(tc.getColEditType(i));
				var options = tc.getColEditOptions(i);
				var editobj = tc.getColEdit(i);
				if (options.length > 0)
				{
					for ( var k = 0; k < options.length; k++)
					{
						atom.addOption(options[k].getName(), options[k]
								.getValue());
					}
				}

				atom.element.onclick = stopEventPropagation;
				atom.element.onmousedown = atomOnMouseDownHandle;
				atom.element.ondblclick = stopEventPropagation;
				atom.element.onblur = cellonblur;

				if (editobj.verify)
				{
					var verifyobj = editobj.verify;
					if (verifyobj.type == "num")
					{
						textCheck(atom.element, verifyobj.min, verifyobj.max,null,verifyobj.other);
					}
					else if (verifyobj.type == "string")
					{
						atom.element.maxLength = verifyobj.length;
					}
	      	else if(verifyobj.type == "func")
	      	{	   
	      		var tmpelement = atom.element;
	      		var maxLength = verifyobj.length;
	      		atom.element.title = maxLength;
	      		atom.element.onkeyup =  function()
	      		{
	      			  checkLength(this);
	      		}  
	      	}
	      }

				var dom = portSelectTable.editdom;
				dom[tc.getColId(i)] = atom;
			}
		}
	}
}

function initButtonText()
{
    $("board").innerHTML = RESOURCE["board"];
    $("interres").innerHTML = RESOURCE["interres"];
    $("intersel").innerHTML = RESOURCE["intersel"];
    $("applyport").innerHTML = RESOURCE["applyport"];
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    $("applybtn").disabled = true;
    $("rightmovebtn").disabled = true;
    $("leftmovebtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled) 
    {
        xcloseDialog();
        return;
    }
    
    id = ct.getAttrValue("cosID");
    var name = ct.getAttrValue("cosName");
    
    if (mapRelationIDArr.contains(id)) 
    {
        alert(RESOURCE["relationID"]);
        return;
    }
    
    if (name == "") 
    {
        alert(RESOURCE["relationName"]);
        return;
    }
    
    var xmlstr = createXML();
    if (null == xmlstr) 
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TE_CREATE_DIFFSERV_CMD + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackCreate, null, "inputdata=" + xmlstr);
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "operateFlag");
    param.setAttribute("value", "createMap");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosID");
    param.setAttribute("value", ct.getAttrValue("cosID"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosName");
    param.setAttribute("value", ct.getAttrValue("cosName"));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    var ingress = tab.getTabWindow("expcostable");
    var egress = tab.getTabWindow("cosexptable");
    
    for (var i = 0, len = ingress.st.getDataRowLength(); i < len; i++) 
    {
        if (ingress.st.getModify(i)) 
        {
            for (var colindex = 0, collen = ingress.st.getColumnCount(); colindex < collen; colindex++) 
            {
                colid = ingress.tc.getColId(colindex);
                if (ingress.st.getCellModify(i, colid)) 
                {
                    var cellString = ingress.st.getCellStoreValue(i, colid, colid);
                    if ("deisvlan" == colid) 
                    {
                        if (!checkCellStr(cellString, parseInt(MIN_INPUT), parseInt(MAX_INPUT_DEI))) 
                        {
                            return null;
                        }
                    }
                    else if ("ipdscp" == colid) 
                    {
                        if (!checkCellStr(cellString, parseInt(MIN_INPUT), parseInt(MAX_INPUT_IP))) 
                        {
                            return null;
                        }
                    }
                    else 
                    {
                        if (!checkCellStr(cellString, parseInt(MIN_INPUT), parseInt(MAX_INPUT))) 
                        {
                            return null;
                        }
                    }
                    
                    var cellStringArray = getStringArray(cellString);
                    if (null == cellStringArray) 
                    {
                        continue;
                    }
                    
                    for (var index = 0, strlen = cellStringArray.length; index < strlen; index++) 
                    {
                        row = new tagElement("row-params");
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "operateFlag");
                        param.setAttribute("value", "modifyIngressMap");
                        row.appendChild(param);
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "neid");
                        param.setAttribute("value", neid);
                        row.appendChild(param);
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "cosID");
                        param.setAttribute("value", ct.getAttrValue("cosID"));
                        row.appendChild(param);
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "cosMapType");
                        param.setAttribute("value", inCosType[colid]);
                        row.appendChild(param);
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "encapsValue");
                        param.setAttribute("value", cellStringArray[index]);
                        row.appendChild(param);
                        
                        param = new tagElement("param");
                        param.setAttribute("name", "cos");
                        param.setAttribute("value", ingress.st.getCellStoreValue(i, "cos", "cos"));
                        row.appendChild(param);
                        
                        bussiness.appendChild(row);
                    }
                }
            }
        }
    }
    
    for (var i = 0, len = egress.st.getDataRowLength(); i < len; i++) 
    {
        if (egress.st.getModify(i)) 
        {
            for (var colindex = 0, collen = egress.st.getColumnCount(); colindex < collen; colindex++) 
            {
                colid = egress.tc.getColId(colindex);
                if (egress.st.getCellModify(i, colid)) 
                {
                    var cellString = egress.st.getCellStoreValue(i, colid, colid);
                    
                    if ("" == cellString) 
                    {
                        continue;
                    }
                    row = new tagElement("row-params");
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "operateFlag");
                    param.setAttribute("value", "modifyEngressMap");
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "neid");
                    param.setAttribute("value", neid);
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "cosID");
                    param.setAttribute("value", ct.getAttrValue("cosID"));
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "cosMapType");
                    param.setAttribute("value", colindex);
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "encapsValue");
                    param.setAttribute("value", cellString);
                    row.appendChild(param);
                    
                    param = new tagElement("param");
                    param.setAttribute("name", "cos");
                    param.setAttribute("value", egress.st.getCellStoreValue(i, "cos", "cos"));
                    row.appendChild(param);
                    
                    bussiness.appendChild(row);
                }
            }
        }
    }
    
    for (var i = 0; i < portSelectTable.getDataRowLength(); i++) 
    {
        var sSelectPort =  portSelectTable.getCellShow(i, "port").getValue();
        var args = sSelectPort.split("-"); 
        var slotid = args[0]; 
        var subBoardid = 255;
        if (0 < slotid.indexOf("MP") || 0 < slotid.indexOf("VEther")) 
        {
            slotid = INVALID_SLOTID;
        }
       var portid = portSelectTable.getCellCurrentValue(i, "portid", "port");
      if(portid == null)
      {
      	 portid = portSelectTable.getCellShow(i,"portid").getValue();
      }
        var cosTypeCurrentValue = portSelectTable.getCellCurrentValue(i, "cosType", "cosType");
        if(cosTypeCurrentValue == null)
        {
        	 cosTypeCurrentValue = portSelectTable.getCellShow(i,"cosType").getValue();
        }
        var cosType = packageTypeArray[cosTypeCurrentValue];
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "operateFlag");
        param.setAttribute("value", "setPorts");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosID");
        param.setAttribute("value", ct.getAttrValue("cosID"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosType");
        param.setAttribute("value",cosType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subBaordid");
        param.setAttribute("value", subBoardid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portid);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled = false;
    $("cancelbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["createcostitle"];
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || OPRPART == data.getSErrorCode()) 
    {
        winurlobj.sendQueryInfo();
        
        if (okFlag) 
        {
            xcloseDialog();
        }
        else 
        {
            mapRelationIDArr.push(id);
            ct.setAttrValue("cosID", getMapRelationID());
        }
    }
    else 
    {
        $("applybtn").disabled = false;
    }
}

function getStringArray(str)
{
    var resultArray = new Array();
    
    if ("" == str || "-" == str) 
    {
        return null;
    }
    var str = str.split(",");
    for (var i = 0, len = str.length; i < len; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            for (var j = rangeStart; j <= rangeEnd; j++) 
            {
                resultArray.push("" + j);
            }
        }
        else 
        {
            resultArray.push(str[i]);
        }
    }
    return resultArray;
}

function checkCellStr(cellStr, min, max)
{
    var str = cellStr.split(",");
    if ("" == str) 
    {
        return true;
    }
    var pattern1 = new RegExp("^\\d+$", "i");
    var pattern2 = new RegExp("^\\d+-\\d+$", "i");
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            if (!pattern2.test(str[i])) 
            {
                alert(RESOURCE["inputFormat"]);
                return false;
            }
        }
        else 
        {
            if (!pattern1.test(str[i])) 
            {
                alert(RESOURCE["inputFormat"]);
                return false;
            }
        }
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if (rangeEnd < rangeStart) 
            {
                alert(RESOURCE["startEnd"]);
                return false;
            }
            
            if ((rangeStart < min) || (rangeStart > max) ||
            (rangeEnd < min) ||
            (rangeEnd > max)) 
            {
                alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
        else 
        {
            var value = parseInt(str[i]);
            if ((value < min) || (value > max)) 
            {
                alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
    }
    return true;
}

function toRight()
{
    var slt1 = document.getElementById("left");
    var slt2 = document.getElementById("right");
    var btn1 = document.getElementById("rightmovebtn");
    var btn2 = document.getElementById("leftmovebtn");
    fnSelect(slt1, slt2, btn1, btn2);
    document.getElementById("applybtn").disabled = false;
}

function fnSelect(field1, field2, button1, button2)
{
    var value = new Array();
    var text = new Array();
    var selectedValue = new Array();
    for (var i = field1.options.length - 1, j = 0; i >= 0; i--) 
    {
        if (field1.options[i].selected) 
        {
            value[j] = field1.options[i].value;
            text[j] = field1.options[i].text;
            field1.remove(i);
            j++;
        }
    }
    
    for (k = value.length - 1; k >= 0; k--) 
    {
        var oOption = document.createElement("OPTION");
        oOption.text = text[k];
        oOption.value = value[k];
        
        field2.options.add(oOption);
        
        
        var row = portSelectTable.createRow();
        var portCell = portSelectTable.createCell();
    		atom = portSelectTable.createAtom("span");
   		 	atom.setValue(text[k]);
    		portSelectTable.addCellShow(portCell, atom);
    		
    		var portidCell = portSelectTable.createCell();
    		atom = portSelectTable.createAtom("hidden");
   		 	atom.setValue(value[k]);
    		portSelectTable.addCellShow(portidCell, atom);
    		
    		var cosTypeCell = portSelectTable.createCell();
    		var atom = portSelectTable.createAtom("span");
    		atom.setValue("CVLAN");
    		portSelectTable.addCellShow(cosTypeCell, atom);
    		var editatom = portSelectTable.createAtom("select");
    		editatom.addOption("CVLAN", "1");
    		editatom.addOption("SVLAN", "2");
    		editatom.addOption("IP-DSCP", "3");
    		editatom.addOption("MPLS-EXP", "4");
    		portSelectTable.addCellEdit(cosTypeCell, editatom);	
    		
    		portSelectTable.addCell(row, "port", portCell);
				portSelectTable.addCell(row, "portid", portidCell);  
    		portSelectTable.addCell(row, "cosType", cosTypeCell);
    		portSelectTable.setCellIsEdit(cosTypeCell, "1");
    		portSelectTable.addRow(row);

    }
    
    button1.disabled = true;
}

function toLeft()
{
    var slt1 = document.getElementById("left");
    var slt2 = document.getElementById("right");
    var btn1 = document.getElementById("rightmovebtn");
    var btn2 = document.getElementById("leftmovebtn");
    toLeftfnSelect(slt2, slt1, btn2, btn1);
    document.getElementById("applybtn").disabled = false;
}

function toLeftfnSelect(field1, field2, button1, button2)
{
     var selectRows = portSelectTable.getSelectedRows();
     for(var i = portSelectTable.getSelectedRows().length-1;i>=0;i--)
    {
    	var index = selectRows[i];
    	var portname = portSelectTable.getCellShow(index, "port").getValue();
    	for (var k = field1.options.length - 1; k >= 0; k--) 
    	{
    		 if(portname == field1.options[k].innerText)
    		 {
    		 	 field1.options[k].selected = true;
    		 	 portSelectTable.deleteRow(index);
    		 }
    	}
    }
    portSelectTable.adjustDataRows();

    
    var boardoptions = $("boardSelectBox").options;
    var boardSelected = boardoptions[boardoptions.selectedIndex].text;
    var value = new Array();
    var text = new Array();
    var selectedValue = new Array();
    for (var i = field1.options.length - 1, j = 0; i >= 0; i--) 
    {
        if (field1.options[i].selected) 
        {
            value[j] = field1.options[i].value;
            text[j] = field1.options[i].text;
            field1.remove(i);
            j++;
        }
    }
    
    for (k = value.length - 1; k >= 0; k--) 
    {
        if ((0 <= text[k].indexOf(boardSelected)) ||
        (-1 != text[k].indexOf("MP") && -1 != boardSelected.indexOf("ML")) ||
        (-1 != text[k].indexOf("VEther") && -1 != boardSelected.indexOf("Virtual"))) 
        {
            var oOption = document.createElement("OPTION");
            oOption.text = text[k];
            oOption.value = value[k];
            
            field2.options.add(oOption);
        }
    }
    
    button1.disabled = true;
}

function changeTabPage()
{
    window.tabs[0].selectTab(this.tid);
    return false;
}

function tabMouseOver()
{
    this.style.cursor = "hand";
}

function tabMouseOut()
{
    this.style.cursor = "normal";
}

function Tabs()
{
    this.id = window.tabs.length;
    window.tabs[this.id] = this;
    this.TabHead = document.createElement("div");
    this.TabHead.appendChild(document.createElement("ul"));
    this.TabBody = document.createElement("div");
    this.TabBody.setAttribute("align", "center");
    this.selectTabid;
    this.selectTabClass = "";
    this.t_headClass = "";
    this.t_bodyClass = "";
    this.tabNodes = new Object();
    
    this.getAllTabsID = function()
    {
        var result = [];
        for (var key in this.tabNodes) 
        {
            result.push(key);
        }
        return result;
    }
    
    this.addTab = function(tid, headstr, burl)
    {
    
        if (typeof this.tabNodes[tid] == "undefined") 
        {
            this.add(tid, headstr, burl);
        }
        else 
        {
            this.removeTabNode(tid);
            this.add(tid, headstr, burl)
        }
    }
    
    this.getTab = function(tid)
    {
        if (typeof this.tabNodes[tid] == "undefined") 
        {
            alert("not found " + tid + " page");
            return;
        }
        else 
        {
            return this.tabNodes[tid];
        }
    }
    
    this.add = function(tid, headstr, burl)
    {
        var t = new Tab(tid, headstr, burl)
        this.tabNodes[tid] = t;
        if (typeof this.selectTabid != "undefined") 
        {
            this.tabNodes[this.selectTabid].head.className = this.t_headClass;
            this.tabNodes[this.selectTabid].body.style.display = "none";
        }
        this.selectTabid = tid;
        this.tabNodes[tid].head.className = this.selectTabClass;
        this.tabNodes[tid].body.className = this.t_bodyClass;
        this.tabNodes[tid].body.style.display = "";
        this.TabHead.firstChild.appendChild(this.tabNodes[tid].head);
        this.TabBody.appendChild(this.tabNodes[tid].body);
        this.tabNodes[tid].head.firstChild.tid = tid;
        this.tabNodes[tid].head.firstChild.onclick = changeTabPage;
        this.tabNodes[tid].head.firstChild.onmouseover = tabMouseOver;
        this.tabNodes[tid].head.firstChild.onmouseout = tabMouseOut;
    }
    
    this.setClass = function(theadstr, tbodystr, hcontentstr, t_hstr, t_bstr, t_selectstr)
    {
        this.TabHead.className = theadstr;
        this.TabBody.className = tbodystr;
        this.TabHead.firstChild.className = hcontentstr;
        this.t_headClass = t_hstr;
        this.t_bodyClass = t_bstr;
        this.selectTabClass = t_selectstr;
    }
    
    this.selectTab = function(key)
    {
        if (this.tabNodes[this.selectTabid]) 
        {
            this.tabNodes[this.selectTabid].head.className = this.t_headClass;
            this.tabNodes[this.selectTabid].head.firstChild.style.color = "#000000";
            this.tabNodes[this.selectTabid].body.style.display = "none";
            var oldTabWin = this.getTabWindow(this.selectTabid);
            if (oldTabWin && oldTabWin.hideMenu) 
            {
                oldTabWin.hideMenu();
            }
        }
        
        this.selectTabid = key;
        this.tabNodes[key].head.className = this.selectTabClass;
        this.tabNodes[this.selectTabid].head.firstChild.style.color = "#0000FF";
        this.tabNodes[key].body.style.display = "";
        
        var tabWin = this.getTabWindow(key);
        if (tabWin && tabWin.tabSelectHandler) 
        {
            tabWin.tabSelectHandler();
        }
        
    }
    
    this.getTabWindow = function(key)
    {
        var frameIndex = -1;
        var iframeArray = document.getElementsByTagName("iframe");
        for (var i = 0; i < iframeArray.length; i++) 
        {
            if (iframeArray[i].name == key) 
            {
                frameIndex = i;
                break;
            }
        }
        return window.frames[frameIndex];
    }    
    
    this.closeTab = function(key)
    {
        var sibling;
        if ((key != this.selectTabid) || (!(this.tabNodes[key].head.nextSibling) && !(this.tabNodes[key].head.previousSibling))) 
        {
            this.removeTabNode(key);
        }
        else if ((sibling = this.tabNodes[key].head.nextSibling) || (sibling = this.tabNodes[key].head.previousSibling)) 
        {
            var t_id = sibling.id.substring(9);
            this.removeTabNode(key);
            this.selectTabid = t_id;
            this.tabNodes[t_id].head.className = this.selectTabClass;
            this.tabNodes[t_id].body.style.display = "";
        }
    }
    
    this.removeTabNode = function(key)
    {
        this.TabHead.firstChild.removeChild(this.tabNodes[key].head);
        this.TabBody.removeChild(this.tabNodes[key].body);
        delete this.tabNodes[key];
        if (this.selectTabid == key) 
        {
            delete this.selectTabid;
        }
    }
    
    this.getTabs = function()
    {
        var div = document.createElement("div");
        div.appendChild(this.TabHead);
        div.appendChild(this.TabBody);
        return div;
    }
    function focusHandler()
    {
        this.blur();
    }
    
    function Tab(tid, headstr, burl)
    {
        this.id = tid;
        this.head = document.createElement("li");
        this.head.setAttribute("id", "tab_head_" + tid)
        var anchor = document.createElement("a");
        anchor.onfocus = focusHandler;
        anchor.setAttribute("target", "_self");
        anchor.appendChild(document.createTextNode(headstr));
        this.head.appendChild(anchor);
        this.body = document.createElement("iframe");
        this.body.setAttribute("name", this.id);
        this.body.setAttribute("align", "center");
        this.body.setAttribute("id", "tab_body_" + tid);
        this.body.src = burl;
        
        this.body.style.display = "none";
        
        this.getID = function()
        {
            return this.id;
        }
        
        this.getHead = function()
        {
            return this.head;
        }
        
        this.getBody = function()
        {
            return this.body;
        }
    }
    
    this.setCloseImage = function(path)
    {
        Tab.imagesrc = path;
    }
}



function createTableHead(st, tc)
{
	window.sortTableArray[window.sortTableArray.length] = [ st, tc ];

	var row = st.createRow();
	st.setRowCss(row, "");
  	var appendWidth = 100;
  	var adjustWidth = 10;
	for (i = 0; i < tc.getColsLength(); i++)
	{
    	var cellwidth = 0;
    	var headWidth = 0;
    	var colWidth = tc.getColWidth(i) + "";
    	if (colWidth.indexOf("%") != -1)
    	{
      		cellwidth = adjustWidth * parseInt(tc.getColWidth(i))/100;
      		if ((cellwidth + "") != "0")
      		{
        		headWidth = cellwidth + appendWidth + "px";
      		}
    	}
    	else
    	{
      		if (colWidth != "0" && colWidth != "0px")
      		{
        		headWidth = colWidth + "px";
      		}
    	}
    	var hc = null;
    	if (st.isUsedForSelectList)
    	{
		  	hc = st.createHeadCell(tc.getColId(i), tc.getColName(i), tc
				  .getColWidth(i));
		}
    	else
    	{
      		hc = st.createHeadCell(tc.getColId(i), tc.getColName(i), headWidth);
    	}

		for ( var j = 0; j < tc.getColKeyArray(i).length; j++)
		{
			hc.element.keys[j] = tc.getColKeyArray(i)[j].getName();
			if (tc.getColKeyArray(i)[j].getConvert())
			{
				hc.element.convertObj[hc.element.keys[j]] = tc
						.getColKeyArray(i)[j].getConvert();
			}
		}
		var cellwidth = tc.getColWidth(i);
		if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
		{
			hc.element.style.display = "none";
		}

		var sortShow = tc.getColIsSortShow(i);
		if (sortShow == null)
		{
			sortShow = 1;
		}
		st.setHCAttribute(hc, tc.getColIsSort(i), sortShow, eval(tc
				.getColCompare(i)));

		st.setHeadRow(row);
		st.addHeadCell(row, hc);
	}
	st.addHead(row);
	
	
}


function rowSelectHandler()
{
    var selectedRowCount = portSelectTable.getSelectedRowCount();
    
    if (selectedRowCount > 0) 
    {
       $("leftmovebtn").disabled = false;
    } 
}
