var winurlobj = window.parent;
var neversion = winurlobj.neversion;
var netype = winurlobj.netype;
var tc;
var st;
var MIN_INPUT = "0";
var MAX_INPUT_DEI = "15";
var MAX_INPUT_IP = "63";
var MAX_INPUT = "7";
var LEVEL_AMOUNT = 16;

if (isHybridRtn(neversion)) 
{
    loadXMLdoc("../../conf/diffserv/rtn900_cosexptable.xml", "GET", false, EncapsulateTable);
}
else 
{
    if(isR3Ver(neversion))
    {
        loadXMLdoc("../../conf/diffserv/rtn900r3_cosexptable.xml", "GET", false, EncapsulateTable);
    } else {
        loadXMLdoc("../../conf/diffserv/cosexptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
    }  
}

/*
 create route table
 */
function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_cosexpcrt");
    st.body.setAttribute("id", "htmlTable_STBody_cosexpcrt");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    $("cosexptable").appendChild(st.getTable());
    $("cosexptable").oncontextmenu = popupMenuHandler;
    st.setBodyHeight("95px");
    
    var dinterface = new DataInterface();
    if (netype == "114" || winurlobj.newDiff_SupportMplsExp)
    {
    	constructData(dinterface, "1", "0", "0", "0", "0", "0");
	    constructData(dinterface, "2", "1", "1", "1", "8", "1");
	    constructData(dinterface, "3", "1", "1", "1", "12", "1");
	    constructData(dinterface, "4", "1", "1", "9", "14", "1");
	    constructData(dinterface, "5", "2", "2", "2", "16", "2");
	    constructData(dinterface, "6", "2", "2", "2", "20", "2");
	    constructData(dinterface, "7", "2", "2", "10", "22", "2");
	    constructData(dinterface, "8", "3", "3", "3", "24", "3");
	    constructData(dinterface, "9", "3", "3", "3", "28", "3");
	    constructData(dinterface, "10", "3", "3", "11", "30", "3");
	    constructData(dinterface, "11", "4", "4", "4", "32", "4");
	    constructData(dinterface, "12", "4", "4", "4", "36", "4");
	    constructData(dinterface, "13", "4", "4", "12", "38", "4");
	    constructData(dinterface, "14", "5", "5", "5", "40", "5");
	    constructData(dinterface, "15", "6", "6", "6", "48", "6");
	    constructData(dinterface, "16", "7", "7", "7", "56", "7");
    }
    else
    {
    	constructData(dinterface, "1", "0", "0", "0", "0", "-");
	    constructData(dinterface, "2", "1", "1", "1", "8", "-");
	    constructData(dinterface, "3", "1", "1", "1", "12", "-");
	    constructData(dinterface, "4", "1", "1", "9", "14", "-");
	    constructData(dinterface, "5", "2", "2", "2", "16", "-");
	    constructData(dinterface, "6", "2", "2", "2", "20", "-");
	    constructData(dinterface, "7", "2", "2", "10", "22", "-");
	    constructData(dinterface, "8", "3", "3", "3", "24", "-");
	    constructData(dinterface, "9", "3", "3", "3", "28", "-");
	    constructData(dinterface, "10", "3", "3", "11", "30", "-");
	    constructData(dinterface, "11", "4", "4", "4", "32", "-");
	    constructData(dinterface, "12", "4", "4", "4", "36", "-");
	    constructData(dinterface, "13", "4", "4", "12", "38", "-");
	    constructData(dinterface, "14", "5", "5", "5", "40", "-");
	    constructData(dinterface, "15", "6", "6", "6", "48", "-");
	    constructData(dinterface, "16", "7", "7", "7", "56", "-");
    }
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    
    if(isR3Ver(neversion) && netype != "114" && !winurlobj.newDiff_SupportMplsExp)
    {
        setExpDisable();
    }
    
    addCellEvent();
}

function constructData(dinterface, cos, cvlan, svlan, deisvlan, ipdscp, mplsexp)
{
    var obj = new Object();
    dinterface.rows[dinterface.rows.length] = obj;
    
    var ptag = new ParamTag();
    ptag.value = cos;
    obj["cos"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = cvlan;
    obj["cvlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = svlan;
    obj["svlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = deisvlan;
    obj["deisvlan"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = ipdscp;
    obj["ipdscp"] = ptag;
    
    var ptag = new ParamTag();
    ptag.value = mplsexp;
    obj["mplsexp"] = ptag;
}

function cellEditHandler()
{

    winurlobj.$("applybtn").disabled = false;
}

function fillSortTable(st, tc, rows, defVal)
{
    for (var i = 0; i < rows; i++) 
    {
        constructRow(st, tc, defVal[i]);
    }
}

function constructRow(st, tc, defaultVal)
{
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            st.addCellEdit(cell, atom);
            st.addCell(row, colid, cell);
            
            var dom = st.editdom;
            dom[colid] = atom;
            
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCellElement(i, "cvlan");
        cell.editElement.element.style.imeMode = "disabled";
        textCheck(cell.editElement.element, MIN_INPUT, MAX_INPUT);
        
        cell = st.getCellElement(i, "svlan");
        cell.editElement.element.style.imeMode = "disabled";
        textCheck(cell.editElement.element, MIN_INPUT, MAX_INPUT);
        
        cell = st.getCellElement(i, "ipdscp");
        cell.editElement.element.style.imeMode = "disabled";
        textCheck(cell.editElement.element, MIN_INPUT, MAX_INPUT_IP);
            cell = st.getCellElement(i, "deisvlan");
            cell.editElement.element.style.imeMode = "disabled";
            textCheck(cell.editElement.element, MIN_INPUT, MAX_INPUT_DEI);
            
            cell = st.getCellElement(i, "mplsexp");
            cell.editElement.element.style.imeMode = "disabled";
            textCheck(cell.editElement.element, MIN_INPUT, MAX_INPUT);
    }
}

function blurValidate(obj, min, max)
{
    var containInegalChar = false;
    var pattern = /^[-.0-9]{1,15}$/;
    if (!pattern.test(obj.value)) 
    {
        containInegalChar = true;
    }
    
    if ((min.indexOf(".") != -1 || max.indexOf(".") != -1) && obj.value.indexOf(".") == -1) 
    {
        obj.value = obj.value + ".0";
    }
    
    
    if (obj.value.charAt(obj.value.length - 1) == ".") 
    {
        obj.value = obj.value + "0";
    }
    
    var objValue;
    var minValue;
    var maxValue;
    if (min.indexOf(".") != -1 || max.indexOf(".") != -1) 
    {
        objValue = parseFloat(obj.value);
        minValue = parseFloat(min);
        maxValue = parseFloat(max);
    }
    else 
    {
        objValue = parseInt(obj.value);
        minValue = parseInt(min);
        maxValue = parseInt(max);
    }
    
    if (objValue < minValue) 
    {
        obj.value = min;
        return alertDialog(min, max);
    }
    else if (objValue > maxValue) 
    {
        obj.value = max;
        return alertDialog(min, max);
    }
}

/*
 window onload handler
 */
window.onload = function()
{
    createTable();
}

/**
 * because this is second tab,it would be invisible untill the second tab is selected.
 * it cause the ajustLayout don't work properly.
 * au9d41653
 */
function tabSelectHandler()
{
    adjustTableLayout(st, tc, st.getDataRowLength());
}

function setExpDisable()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.setCellIsEdit(st.getCell(i, "mplsexp"), 0);
    }
}
