var ct, st, cosIdList, addingCosid, addingCosname;
var parobj = getParentWindow();
var obj = parobj.obj;
var neid = parobj.neid;
var flag = true;
var neVersion = obj["neversion"];
var neType = obj["neType"];
var TECMDCODE_CRT_ATMCOSMAP = TECMDCODE_ATMSERV_CREATE_COSMAP;
var COS_MAP_ROWS = 5;

if (neVersion >= "5.76.03.10" || neType == 114) 
{
    COS_MAP_ROWS = 6;       
}

var MAX_LENGTH_COS_NAME = 32;
var MIN_COS_ID = "2";
var MAX_COS_ID = "8";

window.onload = function(){
    fillCosIdList();
    
    initTable();
    initButton();
}

function initTable(){
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_cosidCrtatmcosmap");
    checkText(atom.element, MIN_COS_ID, MAX_COS_ID);
    ct.addAttrRow("cosid", RESOURCE["cosID"], atom);
    ct.setAttrValue("cosid", getShowingCosId());
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_cosnameCrtatmcosmap");
    atom.element.maxLength = MAX_LENGTH_COS_NAME;
    checkInputData(atom.element, MAX_LENGTH_COS_NAME);
    ct.addAttrRow("cosname", RESOURCE["cosName"], atom);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["cosid"].element.onkeydown = cellEditHandler;
    ct.attrArray["cosname"].element.onkeydown = cellEditHandler;
    
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_atmcosmapcrt");
    st.body.setAttribute("id", "htmlTable_STBody_atmcosmapcrt");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("126px");
    st.setOnCellEditHandler(cellEditHandler);
    $("cosmap").appendChild(st.getTable());
    $("cosmap").oncontextmenu = popupMenuHandler;
    
    var defaultVal = new Array();
    defaultVal[0] = new Array(1, 1);
    defaultVal[1] = new Array(2, 14);
    defaultVal[2] = new Array(3, 8);
    defaultVal[3] = new Array(4, 5);
    defaultVal[4] = new Array(5, 2);
 
    if (neVersion >= "5.76.03.10" || neType == 114) 
	{
        defaultVal[5] = new Array(6, 1);        
    }   
    
    fillSortTable(st, window.tableconf[0], COS_MAP_ROWS, defaultVal);
}

function checkInputData(obj, maxlen){
    obj.onkeyup = function(){
        $("applybtn").disabled = false;
        return calStrSinoLen(this, maxlen);
    }
}

function initButton(){
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("applybtn").disabled = true;
}

function cellEditHandler(){
    flag = false;
    $("applybtn").disabled = false;
}

function newAtmCosMap(param){
    if (param && flag) {
        xcloseDialog();
        return;
    }
    
    if (ct.getAttrValue("cosname").trim() == "") {
        alert(RESOURCE["relationName"]);
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
    
    var xmldata = createNewXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CRT_ATMCOSMAP + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackNew, param, "inputdata=" + xmldata);
}

function createNewXml(){
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    addingCosid = ct.getAttrValue("cosid");
    addingCosname = ct.getAttrValue("cosname");
    
    var detailsModified = false;
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosid");
    param.setAttribute("value", addingCosid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosname");
    param.setAttribute("value", addingCosname);
    row.appendChild(param);
    
    business.appendChild(row);
    
    for (var i = 0; i < COS_MAP_ROWS; i++) {
        if (!st.getModify(i)) {
            continue;
        }
        
        detailsModified = true;
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosid");
        param.setAttribute("value", addingCosid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "encaps");
        param.setAttribute("value", i + 1);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", st.getCellStoreValue(i, "cos", "cos"));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackNew(doc, param){
    $("okbtn").disabled = false;
    $("cancelbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    showErrorDialog(data);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) {
        var obj = new Object();
        var ptag = new ParamTag();
        ptag.value = ct.getAttrValue("cosid");
        obj["cosid"] = ptag;
        data.rows[data.rows.length] = obj;
        
        ptag = new ParamTag();
        ptag.value = ct.getAttrValue("cosname");
        obj["cosname"] = ptag;
        
        parobj.createTable(data);
        
        if (param) {
            xcloseDialog();
            return;
        }
        else {
            flag = true;
            cosIdList.push(addingCosid);
            ct.setAttrValue("cosid", getShowingCosId());
        }
    }
    else {
        $("applybtn").disabled = false;
    }
}

function fillCosIdList(){
    cosIdList = new Array();
    var parSt = parobj.st;
    
    for (var i = 0, len = parSt.getDataRowLength(); i < len; i++) {
        cosIdList.push(parSt.getCellStoreValue(i, "cosid", "cosid"));
    }
}

function getShowingCosId(){
    for (var i = MIN_COS_ID; i < MAX_COS_ID; i++) {
        if (!cosIdList.contains(i)) {
            return i;
        }
    }
    return MAX_COS_ID;
}

function showErrorDialog(di){
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = RESOURCE["cosID"] + ":" + errorObj["cosid"] + "," + RESOURCE["cosName"] + ":" + errorObj["cosname"];
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

/**
 * Chinese occupy 2 bytes
 */
function checkInputData(obj, maxlen){
    obj.onkeyup = function(){
        return calStrSinoLen(this, maxlen);
    }
}
