
var obj, neid, st, st1;

var TECMDCODE_GET_ATMCOSNAME = TECMDCODE_ATMSERV_GET_COSMAP_NAME;
var TECMDCODE_GET_ATMCOSMAP = TECMDCODE_ATMSERV_GET_COSMAP;
var TECMDCODE_DEL_ATMCOSNAME = TECMDCODE_DEL_ATMCOSNAME;
var TECMDCODE_DEL_ATMCOSMAP = TECMDCODE_DEL_ATMCOSMAP;
var TECMDCODE_MOD_ATMCOSMAP = TECMDCODE_MOD_ATMCOSMAP;

var MAX_LENGTH_COS_NAME = 32;
var MAX_COS_LENGTH = 8;

var btnRightArr = new Object();
var INEXISTENCE = "42227";

window.onload = function()
{
    obj = getNeProperty(self);
    neid = obj["neid"];
    
    initTable();
    initButton();
    if (btnRightArr.querybtn.right) 
    {
        atmCosQuery();
    }
}

function initTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_atmcommap");
    st.body.setAttribute("id", "htmlTable_STBody_atmcommap");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getComponetHeight($("cosname"), 100) * 0.65 + "px");
    window.onresize = function()
    {
        st.setBodyHeight(getComponetHeight($("cosname"), 100) + "px");
    };
    st.setOnRowSelectHandler(selectCosHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("cosname").appendChild(st.getTable());
    $("cosname").oncontextmenu = popupMenuHandler;
    
    st1 = new SortTable();
    st1.head.setAttribute("id", "htmlTable_STHead_atmcommap1");
    st1.body.setAttribute("id", "htmlTable_STBody_atmcommap1");
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    st1.setBodyHeight("160px");
    st1.setOnRowSelectHandler(selectMapHandler);
    st1.setOnCellEditHandler(cellEditHandler);
    $("cosmap").appendChild(st1.getTable());
    $("cosmap").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    $("cosmapinfo").innerHTML = RESOURCE["atmcosmapinfo"];
    
    $("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("delmapbtn").value = RESOURCE["delmapbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_ATMCOSNAME);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_GET_ATMCOSMAP);
    btnRightArr.delmapbtn = new BtnRightObj("delmapbtn", TECMDCODE_DEL_ATMCOSNAME);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DEL_ATMCOSMAP);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MOD_ATMCOSMAP);
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        atmCosQuery();
    }
}

function selectCosHandler(rows)
{
    if (!rows || 0 == rows.length) 
    {
        st1.clearTableData();
        return;
    }
    refreshCountDiv();
    atmMapQuery(st.getCellStoreValue(rows[0], "cosid", "cosid"));
}

function selectMapHandler(rows)
{
    if (!rows || 0 == rows.length) 
    {
        $("delmapbtn").disabled = true;
        return;
    }
    
    var rowIndex = st.getSelectedRows()[0];
    if ("1" == st.getCellStoreValue(rowIndex, "cosid", "cosid")) 
    {
        $("delmapbtn").disabled = true;
        return;
    }
    
    $("delmapbtn").disabled = !btnRightArr.delmapbtn.right;
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function atmCosQuery()
{
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("delmapbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createQueryCosXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ATMCOSNAME + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQueryCos, null, "inputdata=" + xmldata);
}

function createQueryCosXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryCos(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
    
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var cosid = st.getCellStoreValue(i, "cosid", "cosid");
        if (cosid == 1) 
        {
            setCellStatus(st, i, new Array("cosname"), 0, "#e3e8e6", null);
        }
        else 
        {
            var cell = st.getCellElement(i, "cosname");
            checkInputData(cell.editElement.element, MAX_LENGTH_COS_NAME);
        }
    }
    
    if (len > 0) 
    {
        st.setRowSelect(0);
        var cosid = st.getCellStoreValue(0, "cosid", "cosid");
        atmMapQuery(cosid);
    }
    else 
    {
        st1.clearTableData();
        
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("createbtn").disabled = !btnRightArr.createbtn.right;
    }
    refreshCountDiv();
    
    showErrorDialog(data);
}

function createTable(tableData)
{
    createTableBody(st, window.tableconf[0], tableData, RESOURCE);
}

function atmMapQuery(cosid)
{
    var xmldata = createQueryMapXml(cosid);
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ATMCOSMAP + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQueryMap, cosid, "inputdata=" + xmldata);
}

function createQueryMapXml(cosid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "cosid");
    param.setAttribute("value", cosid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "encaps");
    param.setAttribute("value", "255");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryMap(doc, cosid)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st1.clearTableData();
        createTableBody(st1, window.tableconf[1], data, RESOURCE);
    }
    
    if (cosid == "1") 
    {
        for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
        {
            var colsAry = new Array("encaps", "cos");
            setCellStatus(st1, i, colsAry, 0, "#e3e8e6", null);
            
            $("deletebtn").disabled = true;
            $("delmapbtn").disabled = true;
        }
    }
    
    showErrorDialog(data);
}

function atmCosCreate()
{
    var len = st.getDataRowLength();
    if (len == MAX_COS_LENGTH) 
    {
        alert(RESOURCE["fillService"]);
        return;
    }
    
    xshowModalDialog("atmcosmapcreate.html", RESOURCE["createatmcosmaptitle"], 500, 280, "../../../../../images/");
}

function atmCosDelete()
{
    if (st.getSelectedRows().length <= 0) 
    {
        alert(RESOURCE["dataselcheck"]);
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("delmapbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createDeleteCosXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_ATMCOSNAME + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackDeleteCos, null, "inputdata=" + xmldata);
}

function createDeleteCosXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        var cosid = st.getCellStoreValue(selRows[i], "cosid", "cosid");
        if (cosid == "1") 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosid");
        param.setAttribute("value", cosid);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackDeleteCos(doc)
{
    var data = EncapsulateData(doc);
    var globalErr = data.getSErrorCode();
    if (0 != globalErr) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (INEXISTENCE == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (1 == globalErr || 2 == globalErr)) 
        {
            data.errObj.s_error.code = 0;
            globalErr = 0;
        }
    }
    showErrorDialog(data);
    
    atmCosQuery();
}

function atmMapDelete()
{
    var selRow = st.getSelectedRows()[0];
    var cosid = st.getCellStoreValue(selRow, "cosid", "cosid");
    if (cosid == "0") 
    {
        return;
    }
    
    if (st1.getDataRowLength() <= 0) 
    {
        return;
    }
    
    if (st1.getSelectedRows().length <= 0) 
    {
        alert(RESOURCE["dataselcheck"]);
        return;
    }
    
    var xmldata = createDeleteMapXml(cosid);
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_ATMCOSMAP + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackDeleteMap, cosid, "inputdata=" + xmldata);
}

function createDeleteMapXml(cosid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var selRows = st1.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosid");
        param.setAttribute("value", cosid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "encaps");
        param.setAttribute("value", st1.getCellStoreValue(selRows[i], "encaps", "encaps"));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackDeleteMap(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        var cosid = st.getCellStoreValue(st.getSelectedRows(0), "cosid", "cosid");
        atmMapQuery(cosid);
    }
    
    showErrorDialog(data);
}

function atmCosModify()
{
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("delmapbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createModifyXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MOD_ATMCOSMAP + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackModify, null, "inputdata=" + xmldata);
}

function createModifyXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var rows = st.getDataRowLength();
    for (var i = 0; i < rows; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosid");
        param.setAttribute("value", st.getCellStoreValue(i, "cosid", "cosid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosname");
        param.setAttribute("value", st.getCellStoreValue(i, "cosname", "cosname"));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    rows = st1.getDataRowLength();
    var cosid = st.getCellStoreValue(st.getSelectedRows()[0], "cosid", "cosid");
    for (var i = 0; i < rows; i++) 
    {
        if (!st1.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cosid");
        param.setAttribute("value", cosid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "encaps");
        param.setAttribute("value", st1.getCellStoreValue(i, "encaps", "encaps"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", st1.getCellStoreValue(i, "cos", "cos"));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackModify(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshTableState(st, window.tableconf[0], data);
        refreshTableState(st1, window.tableconf[1], data);
    }
    else 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    
    showErrorDialog(data);
}

function setCellStatus(st, row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
        st.setCellIsEdit(st.getCellElement(row, colAry[i]), isEdit);
    }
}

function showErrorDialog(di)
{
    if (st.getDataRowLength() <= 0) 
    {
        return;
    }
    
    var errArr = [];
    var errorObj = null;
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        
        var row = st.getDataRowLength();
        var cosid = errorObj["cosid"];
        var cosname = "";
        for (var i = 0; i < row; i++) 
        {
            if (st.getCellStoreValue(i, "cosid", "cosid") == cosid) 
            {
                cosname = st.getCellStoreValue(i, "cosname", "cosname");
                break;
            }
        }
        
        errorObj["operationObj"] = RESOURCE["cosID"] + ":" + cosid +
        ";" +
        RESOURCE["cosName"] +
        ":" +
        cosname;
    }
    
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

/**
 * Chinese occupy 2 bytes
 */
function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}

function refreshCountDiv()
{
    $("count").innerHTML = RESOURCE["total"] + "  " + st.getDataRowLength() +
    "  " +
    RESOURCE["row"] +
    "  " +
    RESOURCE["selected"] +
    "  " +
    st.getSelectedRowCount() +
    "  " +
    RESOURCE["row"] +
    "</br>";
}
