var st = new SortTable();

var winobj = getNeProperty(self);

var nmUser = winobj["nmUser"];

var neID = winobj.neid;

var btnRightArr = new Object();
var deleteRight = false;
var queryRight = false;
var modifyRight = false;
var createRight = false;
var oprSucc = 0;
var oprFail = 2;

var TIMEOUT = 1090650120;

var QUERYSFID = TECMDCODE_GET_LDP_IP;
var QUERYSFID2 = TECMDCODE_GET_RSVP_CONF;
var SENDSFID = TECMDCODE_MODIFY_RSVP_CONF;
var servInfoArray = null;
var modifyInfoArray = [];
var INVALID_SOLTID = "65535";
var INVALID_SUBSOLTID = "255";

var qpath = "../../../../../../";
var hpath = "../../../../../../";
var MLPPP = 4096;
var SerialPort = 6144;
var VIRTUAL_PORT = 0x2800;
var MIN_TIME = "1";
var MAX_TIME = "2147483647";
var MIN_ctimer = "500";
var MAX_ctimer = "3000";
var MIN_czlb = "0";
var MAX_czlb = "100";
var MIN_dzcb = "3";
var MAX_dzcb = "255";
var MIN_stimerrefresh = "5000";
var MAX_stimerrefresh = "2147483647";
var MIN_stimercb = "3";
var MAX_stimercb = "255";
var MIN_hellosendintertime = "1";
var MAX_hellosendintertime = "60";
var MIN_hellopaglost = "3";
var MAX_hellopaglost = "255";
var MAX_TIME = "2147483647";
var frrcChange = false;
var MAX_CODELENGTH = 24;

var rowSelectedRow;
var passwordColid;


function ServiceInfo()
{
    this.data = new Object();
    this.torowparamXML = function()
    {
        var row = new tagElement("row-params");
        
        colsArr = st.getTable().colsArray;
        
        for (var i = 0; i < colsArr.length; i++) 
        {
            colid = window.tableconf[0].getColId(i);
            if(colid == "certpas")
            {
            	this.addParam(row, colid, EncryptUtils.encrypt(this.data[colid]));
            }
            else
            {
            	this.addParam(row, colid, this.data[colid]);
            }
            
        }
        
        return row;
    }
    
    this.addParam = function(row, name, value)
    {
        var param = new tagElement("param");
        param.setAttribute("name", name);
		if ("certpas" == name) 
		{
			param.setAttribute("isPassword", true);
		}
		param.setAttribute("value", value);
        row.appendChild(param);
    }
}

function initpage()
{
    st.head.setAttribute("id", "htmlTableRsvpTHead");
    st.body.setAttribute("id", "htmlTableRsvpTBody");
    st.setOnRowSelectHandler(rowSelected);
    st.setOnCellEditHandler(cellEditHandler);
    st.setImage(qpath + "images/");
    
    createTableHead(st, window.tableconf[0]);
    
    $("tablecomponent").appendChild(st.getTable());
    st.setBodyWidth(window.tableconf[0].width, window.tableconf[0].percent, 0);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
    
    initButton();
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    document.getElementById("applybtn").value = RESOURCE["applybtn"];
    document.getElementById("querybtn").value = RESOURCE["querybtn"];
    
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_RSVP_CONF);
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_RSVP_CONF);
    
    sendRightInfo(btnRightArr);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    queryRight = btnRightArr.querybtn.right;
    modifyRight = btnRightArr.applybtn.right;
}

function doQuery()
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xml = createQueryRequest();
    
    var URL = hpath + "neExlorerServlet?sfid=" + QUERYSFID2 + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", false, processQueryResponse2, null, "inputdata=" + xml);
    
    var URL = hpath + "neExlorerServlet?sfid=" + QUERYSFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", false, processQueryResponse, null, "inputdata=" + xml);
}

/**
 * create query XML request
 */
function createQueryRequest()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "operObj";
    var size = dinterface.getBErrLength();
    for (var i = 0; i < size; i++) 
    {
        var tempObj = dinterface.getError().rowErrors[i].errorObj;
        tempObj["operObj"] = "Query MPLS-RSVP Configuration";
    }
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
        var flag = true;
        var len = dinterface.errObj.rowErrors.length
        for (var i = 0; i < len; i++) 
        {
            if ("41917" != dinterface.errObj.rowErrors[i].error.code) 
            {
                flag = false;
                break;
            }
        }
        if (flag && TIMEOUT != dinterface.errObj.s_error.code) 
        {
            dinterface.errObj.s_error.code = oprSucc;
        }
    }
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    
    if (oprFail == dinterface.getError().getGlobleECode() ||
    TIMEOUT == dinterface.getError().getGlobleECode()) 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        document.getElementById("applybtn").disabled = true;        
        return;
    }
    
    for (var i = 0; i < dinterface.getDataRowLength(); i++) 
    {
        var row = dinterface.rows[i];
        if (INVALID_SUBSOLTID == row["subslotid"].value) 
        {
            row["subslotid"].value = "";
        }
        
        if (MLPPP <= row["port"].value && SerialPort > row["port"].value) 
        {
            row["slotid"].value = "";
            row["subslotid"].value = "";
            row["boardname"].value = "";
            
            var ptag = null;
            ptag = new ParamTag();
            ptag.value = "";
            row["subboardname"] = ptag;
            
            var portid = row["port"].value - MLPPP;
        }
        if (SerialPort <= row["port"].value && VIRTUAL_PORT > row["port"].value) 
        {
            row["portname"].value = (row["port"].value - SerialPort) + "(" + "Serial-" + (row["port"].value - SerialPort) + ")";
        }
        if (VIRTUAL_PORT <= row["port"].value) 
        {
            row["slotid"].value = "";
            row["subslotid"].value = "";
            row["boardname"].value = "";
            row["subboardname"].value = "";
            var portid = (row["port"].value - VIRTUAL_PORT);
            row["portname"].value = portid + "(VEther-" + portid + ")";            
        }
    }
    
    clearTable();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = "port";
        st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    st.sortRows(td, st.element.colsArray.imgflag);
    
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("applybtn").disabled = true;
    
    addCellEvent();
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {    
        var value = st.getCellStoreValue(i, "certtype", "certtype");
        var cpcell = st.getCell(i, "certpas");
        if (value == "0") 
        {
            cpcell.element.showElement.setValue("");
            cpcell.element.ondblclick = null;
            cpcell.element.style.backgroundColor = "#E3E8E6";
            cpcell.element.style.cursor = "point";
            cpcell.element.isEdit = "0";
        }        
    }
}

function processQueryResponse2(doc)
{
    var dinterface = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "operateObj";
    var size = dinterface.getBErrLength();
    for (var i = 0; i < size; i++) 
    {
        var tempObj = dinterface.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = "Query MPLS-RSVP Configuration";
    }
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
        var flag = true;
        var len = dinterface.errObj.rowErrors.length
        for (var i = 0; i < len; i++) 
        {
            if ("41917" != dinterface.errObj.rowErrors[i].error.code) 
            {
                flag = false;
                break;
            }
        }
        if (flag && TIMEOUT != dinterface.errObj.s_error.code) 
        {
            dinterface.errObj.s_error.code = oprSucc;
        }
    }
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    
    if (0 < dinterface.getDataRowLength()) 
    {
        document.getElementById("FRRctimer").value = dinterface.getDataRowParam(0, "FRRctimer");
    }
}

/**
 * remove all the table rows
 */
function clearTable()
{
    for (var i = 0; i < st.getDataRowLength(); ++i) 
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();    
}

/**
 * do apply
 */
function doApply()
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    sreahModify();    
    
    if (!validepass()) 
    {    
        document.getElementById("querybtn").disabled = false;
        document.getElementById("applybtn").disabled = false;
        return;
    }
    var xml = createSendXml();
    if (null == xml) 
    {
        return;
    }
    
    if (modifyInfoArray.length > 0) 
    {
        sendXmlData(xml);
    }
    var xml2 = createSendXml2();
    if (null == xml2) 
    {
        return;
    }
    
    if (frrcChange) 
    {
        sendXmlData2(xml2);
    }
}

function createSendXml()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < modifyInfoArray.length; i++) 
    {
        var servInfo = modifyInfoArray[i];
        servInfo.data["neid"] = neID;
		
        var row = servInfo.torowparamXML();
        bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    var xml = root.toString();    
    return xml;    
}

function createSendXml2()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");    
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "FRRctimer");
    param.setAttribute("value", $("FRRctimer").value);
    row.appendChild(param);
    
    business.appendChild(row);    
    root.getRoot().appendChild(business);
    return root.toString();
}

function sendXmlData(xml)
{
    var url = hpath + "neExlorerServlet?sfid=" + SENDSFID + "&flag=1&nmUser=" + nmUser;    
    loadXMLdoc(url, "POST", true, PostCallBackHandler, null, "inputdata=" + xml);
}

function sendXmlData2(xml)
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    var url = hpath + "neExlorerServlet?sfid=" + SENDSFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, PostCallBackHandler2, null, "inputdata=" + xml);
}

function PostCallBackHandler(doc)
{
    var dinterface = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    refreshTableState(st, window.tableconf[0], dinterface);
    
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("applybtn").disabled = true;
}

function PostCallBackHandler2(doc)
{
    var dinterface = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    openErrPage(qpath + "page/", dinterface.getError(), errArr);    
    
    frrcChange = false;
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("applybtn").disabled = true;
}

function cellEditHandler()
{
    if (btnRightArr.applybtn.right) 
    {
        $("applybtn").disabled = false;
    }
}

function showShareChanged()
{
    sharedFlag = false;
    doQuery();
}

function queryLink()
{
    doQuery();
}

function applyLink()
{
    doApply();
}

function BtnRightObj(btnId, sfid)
{
    if (null != btnId) 
    {
        this.btnId = btnId;
    }
    else 
    {
        this.btnId = "";
    }
    
    if (isNaN(parseInt(sfid))) 
    {
        this.sfid = -1;
    }
    else 
    {
        this.sfid = sfid;
    }
    
    this.right = true;
}

function sendRightInfo()
{
    var url = hpath + "securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    var thirdlevel = null;
    
    for (var btnrightobj in btnRightArr) 
    {
        secondlevel = new tagElement("row-params"); //bean         	
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "btnID");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "sfid");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++)
     {
        var right = data.getDataRowParam(i, "right");        
        if (0 == right) 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = false;
        }
        else 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = true;
        }
    }
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
}

window.onload = function()
{
    initpage();    
}

/**
 * table selection change
 */
function rowSelected(rows)
{    
    if (null == rows || 0 >= rows.length) 
    {
        document.getElementById("applybtn").disabled = true;        
        return;
    }
    
    if (1 < rows.length) 
    {
        document.getElementById("applybtn").disabled = true;        
    }    
    
    servInfoArray = [];
    for (var i = 0; i < rows.length; i++) 
    {
        var servInfo = new ServiceInfo();
        colsArr = st.getTable().colsArray
        
        for (var j = 0; j < colsArr.length; j++) 
        {
            colid = window.tableconf[0].getColId(j);            
            servInfo.data[colid] = st.getCellStoreValue(rows[i], colid, colid);            
        }
        
        servInfoArray[servInfoArray.length] = servInfo;
    }    
}

function rightClickEvent()
{
    rightClickHandler();
}

function validepass()
{
    var cell = null;
    var result = true;
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
    	 var certtype = st.getCellStoreValue(i, "certtype", "certtype");
    	 var pcell = st.getCell(i, "certpas");    
         if (certtype != "0") 
        {
        	  if (!IsNotNullWithoutAlert(pcell.element.showElement.getValue())) 
              {        
                  result = false;            
              } 
        }
          
      
    }
    
    if( result == false )
    {
    	alert(RESOURCE["putAuthenticationKey"]);
    }
    
    return result;    
}

function addCellEvent()
{
    var cell = null;
    var pcell = null;    
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCell(i, "ctimer");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_ctimer, MAX_ctimer);
        }        
        
        cell = st.getCell(i, "czlb");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_czlb, MAX_czlb);
        }
        
        cell = st.getCell(i, "dzcb");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_dzcb, MAX_dzcb);
        }
        
        cell = st.getCell(i, "stimerrefresh");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_stimerrefresh, MAX_stimerrefresh);
        }
        
        cell = st.getCell(i, "stimercb");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_stimercb, MAX_stimercb);
        }
        
      
        
        pcell = st.getCell(i, "certpas");        
        if (null != pcell) 
        {            
        	pcell.element.editElement.element.maxLength = MAX_CODELENGTH;
            checkInputData(pcell.element.editElement.element, MAX_CODELENGTH);
            if (pcell.element.isEdit == 1)
            {
            	pcell.element.ondblclick = setPassword;
            }            
        }
        
        cell = st.getCell(i, "certtype");
        if (null != cell) 
        {
            var atom = cell.element.editElement.element
            atom["onchange"] = function()
            {
                var rowindex = this.parentNode.parentNode.rowIndex;
                
                var cpcell = st.getCell(rowindex, "certpas");
                if (this.value == "0") 
                {
                    cpcell.element.showElement.setValue("");
                    cpcell.element.ondblclick = null;
                    cpcell.element.style.backgroundColor = "#E3E8E6";
                    cpcell.element.style.cursor = "point"
                    cpcell.element.isEdit = "0";
                }
                else 
                {
                    cpcell.element.ondblclick = cellondbclick;
                    cpcell.element.style.backgroundColor = "#ffffff";
                    cpcell.element.style.cursor = "hand";
                    cpcell.element.isEdit = "1";
                    cpcell.element.showElement.setValue("");    
                    cpcell.element.ondblclick = setPassword;
                }
            }
        }    
        
       
        
        cell = st.getCell(i, "hellosendintertime");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_hellosendintertime, MAX_hellosendintertime);
        }
        
        cell = st.getCell(i, "hellopaglost");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_hellopaglost, MAX_hellopaglost);
        }        
    }
    var frrcAtom = document.getElementById("FRRctimer");
    checkText(frrcAtom, MIN_TIME, MAX_TIME);
    frrcAtom["onkeydown"] = function()
    {
        frrcChange = true;
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}



function setPassword()
{
	rowSelectedRow = this.parentNode.rowIndex;
	passwordColid = this.colid;
	
	var cpcell = st.getCellElement(rowSelectedRow, passwordColid);
	cpcell.modify = true;
	if(btnRightArr.applybtn.right)
    {
        $("applybtn").disabled = false; 
    }
	cpcell.showElement.setValue("");
	cpcell.storeValue[passwordColid] = "";
	
	showSetPwdPage(RESOURCE["setpwd"],"../../../../../../",false,MAX_CODELENGTH);
}

function setpwdpageHandler(value)
{
	var cpcell = st.getCellElement(rowSelectedRow, passwordColid);
	cpcell.showElement.setValue(value);
	cpcell.storeValue[passwordColid] = value;
	cpcell.modify = true;
	cpcell.parentNode.modify = true;
	cpcell.style.backgroundColor = "#d0f946";
	
	if(btnRightArr.applybtn.right)
    {
        $("applybtn").disabled = false; 
    }
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}

function IsNotNull(checkItem)
{
    var item = checkItem.trim();
    if (item.length == 0 || item == "") 
    {
        alert(RESOURCE["putAuthenticationKey"]);
        return false;
    }
    else 
    {
        return true;
    }
}

function IsNotNullWithoutAlert(checkItem)
{
    var item = checkItem.trim();
    if (item.length == 0 || item == "") 
    {
        return false;
    }
    else 
    {
        return true;
    }
}

function maxlength(textinput, maxlen)
{
    textinput.style.imeMode = "disabled";
    var code = event.keyCode;
    
    var ch = String.fromCharCode(code);
    
    if (code == 13) 
    {
        event.srcElement.blur();
        return false;
    }
    
    if (event.ctrlKey) 
    {
        if (ch == 'X' || ch == 'C' || ch == 'A') 
        {
            return true;
        }
        else 
        {
            return false;
        }
    }
    
    if (code > 36 && code < 41) 
    {
        return true;
    }
    
    if (code == 8 || code == 46) 
    {
        return true; //DEL   
    }
    
    textcontent = textinput.value;
    if (textcontent.length + 1 > maxlen) 
    {
        var str = RESOURCE["ID_NUMLEFT"] + 1 + RESOURCE["ID_NUMMIDDLE"] + maxlen + RESOURCE["Bytesstr"];
        alert(str);
        return false;
    }
    else 
    {
        return true;
    }
}

function checkDataCellEvent(atom, minvalue, maxvalue, defaultvalue)
{
    atom.style.imeMode = "disabled";
    if (null == defaultvalue) 
    {
        defaultvalue = minvalue;
    }
    atom.onpaste = function()
    {
        return false;
    }
    
    atom["onchange"] = function()
    {
        if (!checkDataRange(this, minvalue, maxvalue)) 
        {
            this.value = defaultvalue;
        }
    }
    
    var str = RESOURCE["ID_NUMLEFT"] + minvalue + RESOURCE["ID_NUMMIDDLE"] + maxvalue + RESOURCE["ID_NUMRIGHT"];
    
    atom["onkeypress"] = function()
    {
        if (str) 
        {
            return digitalTag_checkDown(this, maxvalue, checkDataRange, true, "", str);
        }
        else 
        {
            return digitalTag_checkDown(this, maxvalue, checkDataRange);
        }
    }
    
    atom["onkeydown"] = function()
    {
        if (modifyRight) 
        {
            document.getElementById("applybtn").disabled = false;
        }
        if (str) 
        {
            return digitalTag_checkDown(this, maxvalue, checkDataRange, true, "", str);
        }
        else 
        {
            return digitalTag_checkDown(this, maxvalue, checkDataRange);
        }
    }    
}

/**
 * TAG
 * @param cell
 * @return
 */
function tagCellEvent(cell)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {    
        tabCellEditHandler(this);
    }
    atom.element["onkeydown"] = function()
    {
    
    }    
}

function tabCellEditHandler(atom)
{
    if (modifyRight) 
    {
        document.getElementById("applybtn").disabled = false;
    }
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
	
    st.getCell(rowindex, colid).element.style.background = "#d0f946";
    st.getCell(rowindex, colid).element.isEdit = 1;
    st.getCell(rowindex, colid).element.ondblclick = cellondbclick;
	
    modifyInfoArray.length = 0;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {    
        if (st.getRow(i).element.modify) 
        {        
            var servInfo = new ServiceInfo();            
            colsArr = st.getTable().colsArray
            
            for (var j = 0; j < colsArr.length; j++) 
            {
                colid = window.tableconf[0].getColId(j);
                
                var cellValue = st.getCellStoreValue(rows[i], colid, colid);
                if ("dport" == colid) 
                {
                    cellValue = "0";
                }
                else if ("certpas" == colid && undefined == cellValue) 
                {
                    cellValue = "";
                }
                else if ("subslotid" == colid && undefined == cellValue) 
                {
                    cellValue = INVALID_SUBSOLTID;
                }
                
                servInfo.data[colid] = cellValue;                
            }
            
            modifyInfoArray[modifyInfoArray.length] = servInfo;
        }
    }    
}

function sreahModify()
{
    modifyInfoArray.length = 0;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {    
        if (st.getRow(i).element.modify) 
        {
            var servInfo = new ServiceInfo();            
            colsArr = st.getTable().colsArray
            
            for (var j = 0; j < colsArr.length; j++) 
            {
                colid = window.tableconf[0].getColId(j);
                var cellValue = st.getCellStoreValue(i, colid, colid);
                
                if ("dport" == colid) 
                {
                    cellValue = "0";
                }
                else if ("certpas" == colid && undefined == cellValue) 
                {
                    cellValue = "";
                }
                else if ("subslotid" == colid && undefined == cellValue) 
                {
                    cellValue = INVALID_SUBSOLTID;
                }
                else if ("slotid" == colid && undefined == cellValue) 
                {
                    cellValue = INVALID_SOLTID;
                }
                servInfo.data[colid] = cellValue;                
            }
            
            modifyInfoArray[modifyInfoArray.length] = servInfo;
        }
    }    
}
