var ct = null;
var portRes = null;

var win = getParentWindow();

var neid = win.neid;

function init()
{
    initTable();
    initButton();
    getPortRes();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("Port", 1);
    atom.element.disabled = true;
    ct.addAttrRow("boundtype", RESOURCE["boundtype"], atom);
    
    atom = new Atom("select");
    atom.addOption("/", INVALID_VALUE);
    atom.element.onchange = changeBoard;
    ct.addAttrRow("board", RESOURCE["board"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption("/", INVALID_VALUE);
    ct.addAttrRow("port", RESOURCE["port"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function changeBoard()
{
    var atom = ct.getAtom("port");
    atom.clearOptions();
    
    if (this.value == INVALID_VALUE) 
    {
        atom.element.disabled = true;
        atom.addOption("/", INVALID_VALUE);
    }
    else 
    {
        atom.element.disabled = false;
        for (var i = 0, m = portRes.length; i < m; i++) 
        {
            var port = portRes[i];
            if (port.slotId == this.value) 
            {
                for (var j = 0, n = port.portArr.length; j < n; j++) 
                {
                    atom.addOption(port.portArr[j].portName, port.portArr[j].portId);
                }
				break;
            }
        }
    }
}

function getPortRes()
{
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BFD_BAND_PORT_RES;
    loadXMLdoc(url, "POST", false, getPortResCallBack, null, "inputdata=" + xml);
}

function getPortResCallBack(doc)
{
    portRes = [];
    
    var atom = ct.getAtom("board");
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var slotId = data.getDataRowParam(i, "slotid");
        var boardName = data.getDataRowParam(i, "boardname");
        var portOptions = data.getDataRowOptions(i, "port");
        var nameOptions = data.getDataRowOptions(i, "portname");
        if (null != portOptions && null != nameOptions && portOptions.length == nameOptions.length) 
        {
            var portArr = [];
            for (var j = 0, n = portOptions.length; j < n; j++) 
            {
                var portObj = new Object();
                portObj.portId = portOptions[j];
                portObj.portName = nameOptions[j];
                portArr[portArr.length] = portObj;
            }
            
            var port = new Object();
            port.slotId = slotId;
            port.boardName = boardName;
            port.portArr = portArr;
            
            portRes[portRes.length] = port;
            
            atom.addOption(slotId + "-" + boardName, slotId);
        }
    }
}

function doBind()
{
    var cell = null;
	var options = ct.getAtom("board").element.options;
	var option = options[options.selectedIndex];
    var slotId = option.value;
	var boardName = option.text.split("-")[1];	
	
	options = ct.getAtom("port").element.options;
	option = options[options.selectedIndex];
	var portId = option.value;
	var portName = option.text;
	
	var boundPort = slotId + "-" + boardName + "-" + portName;
	if (slotId == INVALID_VALUE)
	{
		boardName = "/";
		boundPort = "/";
	}
	
    var indexes = win.st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        cell = win.st.getCell(indexes[i], "boundport");
        win.st.setCellValue(cell, "boundslot", slotId);
        win.st.setCellValue(cell, "boundboardname", boardName);
        win.st.setCellValue(cell, "boundportname", portName);
        win.st.setHiddenCellValue(cell, "boundport", portId);
        win.st.getCellShow(indexes[i], "boundport").element.innerHTML = boundPort;
		
        cell.element.modify = true;
        cell.element.parentNode.modify = true;
        cell.element.style.backgroundColor = "#d0f946";
    }
    win.$("applybtn").disabled = !win.btnRightArr.applybtn.right;
    xcloseDialog();
}
