var st = null;
var countObj = null;

var btnRightArr = new Object();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

var sessionType = new Array();
sessionType[0] = "singlehop";
sessionType[1] = "multihop";

var adminStatus = new Array();
adminStatus[0] = "down";
adminStatus[1] = "up";

var sessionStatus = new Array();
sessionStatus[0] = "admindown";
sessionStatus[1] = "down";
sessionStatus[2] = "init";
sessionStatus[3] = "up";

function init()
{
    initTable();
    initCountObj();
    initButton();
    
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_BFD);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_CREATE_BFD);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DELETE_BFD);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_BFD);
    
    getRightInfo(winobj, btnRightArr);
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    else 
    {
        $("deletebtn").disabled = true;
    }
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_BFD + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        
        var ptag = null;
        var sessionStatus = -1;
        for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
        {
            ptag = new ParamTag();
            ptag.value = "0";
            sessionStatus = parseInt(data.getDataRowParam(i, "sessionstatus"));
            if (sessionStatus != 0) 
            {
                ptag.value = "1";
            }
            data.rows[i]["adminstatus"] = ptag;
        }
        
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
        }
        rowSelectHandler();
    }
}

function addCellListener()
{
    var cell = null;
    var boundPort = null;
    var tunnel = null;
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        cell = st.getCell(i, "boundport");
        boundPort = st.getCellStoreValue(i, "boundport", "boundslot");
        if (boundPort == null || boundPort == "") 
        {
            st.setCellValue(cell, "boundslot", INVALID_VALUE);
            st.setCellValue(cell, "boundboardname", "/");
            st.setCellValue(cell, "boundportname", "/");
            st.setHiddenCellValue(cell, "boundport", INVALID_VALUE);
            st.getCellShow(i, "boundport").element.innerHTML = "/";
        }
        
        cell = st.getCellElement(i, "boundport");
        cell.ondblclick = openDialog;
        
        cell = st.getCellElement(i, "sendinterval");
        textCheck(cell.editElement.element, MIN_INTERVAL, MAX_INTERVAL);
        
        cell = st.getCellElement(i, "receiveinterval");
        textCheck(cell.editElement.element, MIN_INTERVAL, MAX_INTERVAL);
        
        cell = st.getCellElement(i, "detectmultiple");
        textCheck(cell.editElement.element, MIN_DETECTMULTIPLE, MAX_DETECTMULTIPLE);
    }
}

/*
 * Add table popupmenu handler
 */
function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent ||
    elem.editElement == null) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            if (colid == "boundport") 
            {
                openDialog();
                return;
            }
            createTablePopupMenu(elem, evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                if (colid == "boundport") 
                {
                    openDialog();
                    return;
                }
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
    }
}

function openDialog()
{
    if (st.getSelectedRowCount() > 1) 
    {
        return;
    }
    xshowModalDialog("bindport.html", RESOURCE["bindingport"], 480, 220, "../../../../../images/");
}

function doCreate()
{
    xshowModalDialog("createbfd.html", RESOURCE["newbfd"], 480, 280, "../../../../../images/");
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("sessionindex", st.getCellCurrentValue(indexes[i], "sessionindex", "sessionindex")));
        rowparams.appendChild(createTagElement("sessionid", st.getCellCurrentValue(indexes[i], "sessionid", "sessionid")));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DELETE_BFD + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObjStr";
    
    var oError = data.getError();
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = oError.getRowKey(i, "nename");
        var tunnelIndex = oError.getRowKey(i, "sessionindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tunnel = st.getCellCurrentValue(indexes[j], "sessionindex", "sessionindex");
            if (tunnelIndex == tunnel) 
            {
                tempErrObjStr += "-" + st.getCellCurrentValue(indexes[j], "sessionid", "sessionid");
                indexes.splice(j, 1);
                break;
            }
        }
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getDataRowLength() > 0) 
    {
        for (var i = 0, m = data.getBErrLength(); i < m; i++) 
        {
            if (st.getModify(i)) 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                break;
            }
        }
        if (st.getSelectedRowCount() <= 0) 
        {
            st.setRowSelect(0);
        }
    }
    rowSelectHandler();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("sessionindex", st.getCellCurrentValue(i, "sessionindex", "sessionindex")));
        row.appendChild(createTagElement("sessionid", st.getCellCurrentValue(i, "sessionid", "sessionid")));
        
        if (st.getCellModify(i, "boundport")) 
        {
            row.appendChild(createTagElement("boundportname", st.getCellShow(i, "boundport").element.innerHTML));
            row.appendChild(createTagElement("boundslot", st.getCellCurrentValue(i, "boundport", "boundslot")));
            row.appendChild(createTagElement("boundport", st.getCellHiddenValue(i, "boundport", "boundport")));
        }
        
        if (st.getCellModify(i, "adminstatus")) 
        {
            row.appendChild(createTagElement("adminstatus", st.getCellCurrentValue(i, "adminstatus", "adminstatus")));
        }
        
        if (st.getCellModify(i, "sendinterval")) 
        {
            row.appendChild(createTagElement("sendinterval", st.getCellCurrentValue(i, "sendinterval", "sendinterval")));
        }
        
        if (st.getCellModify(i, "receiveinterval")) 
        {
            row.appendChild(createTagElement("receiveinterval", st.getCellCurrentValue(i, "receiveinterval", "receiveinterval")));
        }
        
        if (st.getCellModify(i, "detectmultiple")) 
        {
            row.appendChild(createTagElement("detectmultiple", st.getCellCurrentValue(i, "detectmultiple", "detectmultiple")));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
	alert(xml);
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MODIFY_BFD + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (st.getSelectedRowCount() > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "errObjStr";
    
    var oError = data.getError();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = oError.getRowKey(i, "nename");
        var sessionIndex = oError.getRowKey(i, "sessionindex");
        for (var j = 0, n = st.getDataRowLength(); j < n; j++) 
        {
            var session = st.getCellCurrentValue(j, "sessionindex", "sessionindex");
            if (sessionIndex == session) 
            {
                tempErrObjStr += "-" + st.getCellCurrentValue(j, "sessionid", "sessionid");
                break;
            }
        }
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
