var ct = null;
var portRes = null;
var win = getParentWindow();

var neid = win.neid;
var nmUser = win.nmUser;

function init()
{
    initTable();
    initButton();
    
    getPortRes();
    fillAvailableBoard();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["singlehop"], 0);
    atom.element.onchange = changeSessionType;
    ct.addAttrRow("sessiontype", RESOURCE["sessiontype"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = changeSrcBoard;
    ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
    
    atom = new Atom("select");
    ct.addAttrRow("srcport", RESOURCE["srcport"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("0.0.0.0");
    ct.addAttrRow("snkipaddr", RESOURCE["snkipaddr"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue(RESOURCE["autoassign"]);
    ct.addAttrRow("localident", RESOURCE["localident"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue(RESOURCE["autoassign"]);
    ct.addAttrRow("remoteident", RESOURCE["remoteident"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function changeSessionType()
{
    var srcBoardAtom = ct.getAtom("srcboard");
    var srcPortAtom = ct.getAtom("srcport");
    switch (parseInt(ct.getAtom("sessiontype").getValue()))
    {
        case SINGLE_HOP:
            fillAvailableBoard();
            srcBoardAtom.element.disabled = false;
            srcPortAtom.element.disabled = false;
            break;
        case MULTI_HOP:
            srcBoardAtom.element.disabled = true;
            srcBoardAtom.element.options.length = 0;
            srcBoardAtom.addOption("-", "65535");
            
            srcPortAtom.element.disabled = true;
            srcPortAtom.element.options.length = 0;
            srcPortAtom.addOption("-", "65535");
            break;
        default:
            break;
    }
}

function changeSrcBoard()
{
    var atom = ct.getAtom("srcport");
    atom.element.options.length = 0;
    var bdoptions = ct.getAtom("srcboard").element.options;
    var sIndex = bdoptions.selectedIndex;
    if (sIndex < 0) 
    {
        return;
    }
    var slotid = bdoptions[sIndex].text;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
		var tmp = new Array();
		var lastIndex = portRes[i].lastIndexOf("#");
		tmp[0] = portRes[i].substring(0, lastIndex);
		tmp[1] = portRes[i].substring(lastIndex + 1, portRes[i].length);
		
        var portId = parseInt(tmp[1]);
        var bport = tmp[0].split("-");
        var bd = bport[0] + "-" + bport[1];
        var port = tmp[0].substring(tmp[0].indexOf("-", tmp[0].indexOf("-") + 1) + 1, tmp[0].length);
        if (portId >= 0x1000 && portId <= 0x17FF) 
        {
            bd = "ML-PPP";
        }
        else if (portId >= 0x2800 && portId <= 0x2FFF) 
        {
            bd = "Virtual Ethernet";
        }
        if (bd == slotid) 
        {
            atom.addOption(port, tmp[1]);
        }
    }
}

function fillAvailableBoard()
{
    var atom = ct.getAtom("srcboard");
    atom.element.options.length = 0;
    var tmpbd = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
		var tmp = new Array();
		var lastIndex = portRes[i].lastIndexOf("#");
		tmp[0] = portRes[i].substring(0, lastIndex);
		tmp[1] = portRes[i].substring(lastIndex + 1, portRes[i].length);
		
        var portId = parseInt(tmp[1]);
        var bport = tmp[0].split("-");
        var board = bport[0] + "-" + bport[1];
        if (portId >= 0x1000 && portId <= 0x17FF) 
        {
            board = "ML-PPP";
        }
        else if (portId >= 0x2800 && portId <= 0x2FFF) 
        {
            board = "Virtual Ethernet";
        }
        if (!tmpbd.contains(board)) 
        {
            atom.addOption(board, bport[0]);
            tmpbd[tmpbd.length] = board;
        }
    }
    tmpbd.clear();
    
    changeSrcBoard();
}

function getPortRes()
{
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORTRESOURCEINFO + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, getPortResCallBack, null, "inputdata=" + xml);
}

function getPortResCallBack(doc)
{
    portRes = new Array();
    
    var data = EncapsulateData(doc);
    var options = data.getDataRowOptions(0, "portres");
    if (null != options) 
    {
        for (var j = 0, n = options.length; j < n; j++) 
        {
            portRes[portRes.length] = options[j];
        }
    }
}

function validate()
{
    var msgArr = new Array();
    var srcBoard = ct.getAtom("srcboard").getValue();
    if (srcBoard != "-" && srcBoard == "") 
    {
        msgArr[msgArr.length] = RESOURCE["srcboard"];
    }
    
    var srcPort = ct.getAtom("srcport").getValue();
    if (srcPort != "-" && srcPort == "") 
    {
        msgArr[msgArr.length] = RESOURCE["srcport"];
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    else 
    {
        return true;
    }
}

function createBFDXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 1));
    rowparams.appendChild(createTagElement("sessionindex", 0xFFFFFFFF));
    rowparams.appendChild(createTagElement("sessiontype", ct.getAtom("sessiontype").getValue()));
    
    var snkIPAddr = ct.getAtom("snkipaddr").getValue();
    rowparams.appendChild(createTagElement("snkipaddress", snkIPAddr));
    rowparams.appendChild(createTagElement("snkipaddr", parseInt("0x" + convertIpaddrToHexcode(snkIPAddr))));
    
    var atom = ct.getAtom("srcboard");
    rowparams.appendChild(createTagElement("srcboard", atom.element.options[atom.element.options.selectedIndex].text));
    rowparams.appendChild(createTagElement("slotid", atom.getValue()));
    rowparams.appendChild(createTagElement("subslotid", 0xFF));
    atom = ct.getAtom("srcport");
    rowparams.appendChild(createTagElement("srcport", atom.element.options[atom.element.options.selectedIndex].text));
    rowparams.appendChild(createTagElement("port", atom.getValue()));
    
    var localIdent = 0;
    var atom = ct.getAtom("localident");
    if (!atom.element.disabled) 
    {
        localIdent = atom.getValue();
    }
    rowparams.appendChild(createTagElement("localident", localIdent));
    
    var remoteIdent = 0;
    atom = ct.getAtom("remoteident");
    if (!atom.element.disabled) 
    {
        remoteIdent = atom.getValue();
    }
    rowparams.appendChild(createTagElement("remoteident", remoteIdent));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(param)
{
    if (!validate()) 
    {
        return;
    }
    var xml = createBFDXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CREATE_BFD + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrDialog(data)
    
    if (data.getSErrorCode() == 0) 
    {
        win.doQuery();
        if (param) 
        {
            xcloseDialog();
        }
    }
}
